/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.adapters.ITraceabilityInformationModelAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EMFHelper;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.core.helpers.TraceHelper;
import org.eclipse.capra.ui.operations.OperationsHelper;
import org.eclipse.capra.ui.preferences.CapraPreferences;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class CreateTraceOperation
extends AbstractOperation {
    private static final String ERROR_DIALOG_TITLE = "Error creating new trace link";
    private static final String EXCEPTION_MESSAGE_RUNTIME_EXCEPTION = "An exception occured during trace link creation.";
    private static final String EXCEPTION_MESSAGE_CLASS_CAST_EXCEPTION = "The selected trace link type does not support these types of artifacts.";
    private static final String EXCEPTION_MESSAGE_CLASS_CAST_EXCEPTION_REASON = "Selected origin of class %s and targets of class %s are not compatible with the selected trace link type.";
    private static final String CAPRA_INFORMATION = "Capra Information";
    private static final String TRACE_LINK_EXISTS = "The trace link you want to create already exists and will therefore not be created";
    private static final String TRACE_LINK_SUCCESSFULLY_CREATED = "Trace link has been successfully created";
    private static final String DO_NOT_SHOW_DIALOG_AGAIN = "Do not show this dialog again";
    private static final String SELECT_TRACE_LINK_TYPE = "Select the trace type you want to create";
    private static final String SOURCE = "Source:";
    private static final String TARGET = "Target:";
    private Optional<EClass> chosenType;
    private List<EObject> originWrappers;
    private List<EObject> targetWrappers;
    private EObject traceModel;
    private List<?> origins = null;
    private List<?> targets = null;
    private BiFunction<Collection<EClass>, TraceableObjects, Optional<EClass>> chooseTraceType = null;

    public CreateTraceOperation(String label, List<?> origins, List<?> targets) {
        super(label);
        Assert.isNotNull(origins);
        Assert.isNotNull(targets);
        this.origins = origins;
        this.targets = targets;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Shell shell = (Shell)info.getAdapter(Shell.class);
        IStatus executionStatus = null;
        if (this.origins == null || this.targets == null || this.origins.isEmpty() || this.targets.isEmpty()) {
            MessageDialog.openWarning((Shell)shell, (String)"No origins or targets selected", (String)"At least one source artifact (marked by a checkbox) and one target artifact need to be in the list.");
            return Status.CANCEL_STATUS;
        }
        if (this.chooseTraceType == null) {
            this.chooseTraceType = (traceTypes, selection) -> this.getTraceTypeToCreate(shell, (Collection<EClass>)traceTypes, (TraceableObjects)selection);
        }
        try {
            this.createTrace(shell, this.chooseTraceType);
            executionStatus = Status.OK_STATUS;
        }
        catch (IllegalStateException e) {
            executionStatus = new Status(4, "org.eclipse.capra.ui", e.getMessage(), (Throwable)e);
            OperationsHelper.createErrorMessage(shell, executionStatus, ERROR_DIALOG_TITLE, e.getMessage());
        }
        catch (ClassCastException e) {
            executionStatus = new Status(4, "org.eclipse.capra.ui", String.format(EXCEPTION_MESSAGE_CLASS_CAST_EXCEPTION_REASON, CreateTraceOperation.returnElementClasses(this.origins), CreateTraceOperation.returnElementClasses(this.targets)), (Throwable)e);
            OperationsHelper.createErrorMessage(shell, executionStatus, ERROR_DIALOG_TITLE, EXCEPTION_MESSAGE_CLASS_CAST_EXCEPTION);
        }
        catch (RuntimeException e) {
            executionStatus = new Status(4, "org.eclipse.capra.ui", e.getMessage(), (Throwable)e);
            OperationsHelper.createErrorMessage(shell, executionStatus, ERROR_DIALOG_TITLE, EXCEPTION_MESSAGE_RUNTIME_EXCEPTION);
        }
        return executionStatus;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        List connections;
        TraceHelper traceHelper = new TraceHelper(this.traceModel);
        if (this.originWrappers != null && this.targetWrappers != null && this.chosenType != null && this.traceModel != null && !(connections = traceHelper.getTraces(this.originWrappers, this.targetWrappers, this.chosenType.get())).isEmpty()) {
            traceHelper.deleteTraces(connections);
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public void createTrace(Shell shell) {
        Assert.isNotNull(this.chooseTraceType);
        this.createTrace(shell, this.chooseTraceType);
    }

    public void createTrace(Shell shell, BiFunction<Collection<EClass>, TraceableObjects, Optional<EClass>> chooseTraceType) {
        ITraceabilityInformationModelAdapter traceAdapter = (ITraceabilityInformationModelAdapter)ExtensionPointHelper.getTraceabilityInformationModelAdapter().orElseThrow();
        IPersistenceAdapter persistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
        ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
        this.traceModel = persistenceAdapter.getTraceModel(resourceSet);
        EObject artifactModel = persistenceAdapter.getArtifactWrappers(resourceSet);
        EObject metadataModel = persistenceAdapter.getMetadataContainer(resourceSet);
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        TraceHelper traceHelper = new TraceHelper(this.traceModel);
        this.originWrappers = artifactHelper.createWrappers(this.origins);
        this.targetWrappers = artifactHelper.createWrappers(this.targets);
        ArrayList<EObject> allWrappers = new ArrayList<EObject>(this.originWrappers);
        allWrappers.addAll(this.targetWrappers);
        Collection traceTypes = traceAdapter.getAvailableTraceTypes(allWrappers);
        this.chosenType = chooseTraceType.apply(traceTypes, new TraceableObjects(this.originWrappers, this.targetWrappers));
        if (this.chosenType.isPresent()) {
            if (traceHelper.traceExists(this.originWrappers, this.targetWrappers, this.chosenType.get())) {
                MessageDialog.openInformation((Shell)shell, (String)CAPRA_INFORMATION, (String)TRACE_LINK_EXISTS);
            } else {
                traceHelper.createTrace(this.originWrappers, this.targetWrappers, this.chosenType.get());
                persistenceAdapter.saveModels(this.traceModel, artifactModel, metadataModel);
                traceHelper.annotateTrace(allWrappers);
                IPreferenceStore store = CapraPreferences.getPreferences();
                if (store.getBoolean("org.eclipse.capra.preferences.showTraceCreatedConfirmationDialog")) {
                    MessageDialogWithToggle.open((int)2, (Shell)shell, (String)CAPRA_INFORMATION, (String)TRACE_LINK_SUCCESSFULLY_CREATED, (String)DO_NOT_SHOW_DIALOG_AGAIN, (boolean)false, (IPreferenceStore)store, (String)"org.eclipse.capra.preferences.showTraceCreatedConfirmationDialog", (int)0);
                }
            }
        }
    }

    public void setChooseTraceType(BiFunction<Collection<EClass>, TraceableObjects, Optional<EClass>> chooseTraceType) {
        this.chooseTraceType = chooseTraceType;
    }

    private Optional<EClass> getTraceTypeToCreate(Shell shell, Collection<EClass> traceTypes, TraceableObjects traceableObjects) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                EClass eclass = (EClass)element;
                return eclass.getName();
            }
        });
        dialog.setTitle(SELECT_TRACE_LINK_TYPE);
        dialog.setElements(traceTypes.toArray());
        dialog.setMessage("Source:: " + traceableObjects.getOrigins().stream().map(this::getSelectionDisplayName).collect(Collectors.toList()) + "\n" + TARGET + ": " + traceableObjects.getTargets().stream().map(this::getSelectionDisplayName).collect(Collectors.toList()));
        if (dialog.open() == 0) {
            return Optional.of((EClass)dialog.getFirstResult());
        }
        return Optional.empty();
    }

    private String getSelectionDisplayName(EObject element) {
        IPersistenceAdapter persistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
        EObject artifactModel = persistenceAdapter.getArtifactWrappers(EditingDomainHelper.getResourceSet());
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        IArtifactHandler handler = (IArtifactHandler)artifactHelper.getHandler(artifactHelper.unwrapWrapper((Object)element)).orElseThrow();
        return handler.withCastedHandler(artifactHelper.unwrapWrapper((Object)element), (h, o) -> h.getDisplayName(o)).orElse(EMFHelper.getIdentifier((EObject)element));
    }

    private static String returnElementClasses(List<?> elements) {
        HashSet unique = new HashSet();
        elements.forEach(el -> {
            boolean bl = unique.add(el.getClass().getCanonicalName());
        });
        return ((Object)unique).toString().replace("[", "").replace("]", "");
    }

    public class TraceableObjects {
        private List<EObject> origins;
        private List<EObject> targets;

        public TraceableObjects(List<EObject> origins, List<EObject> targets) {
            this.origins = origins;
            this.targets = targets;
        }

        public List<EObject> getOrigins() {
            return this.origins;
        }

        public List<EObject> getTargets() {
            return this.targets;
        }
    }
}

