/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.handlers;

import java.util.List;
import java.util.Optional;
import org.eclipse.capra.ui.operations.CreateTraceOperation;
import org.eclipse.capra.ui.views.SelectionView;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IWorkbenchPartSite;

public class TraceCreationHandler
extends AbstractHandler {
    private IUndoContext undoContext = IOperationHistory.GLOBAL_UNDO_CONTEXT;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPartSite adapter = SelectionView.getOpenedView().getSite();
        IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
        List<Object> sources = SelectionView.getOpenedView().getSources();
        List<Object> targets = SelectionView.getOpenedView().getTargets();
        CreateTraceOperation createTraceOperation = new CreateTraceOperation("Create trace link", sources, targets);
        createTraceOperation.addContext(this.undoContext);
        if (SelectionView.getOpenedView().getSelectedTraceType() != null) {
            createTraceOperation.setChooseTraceType((a, b) -> Optional.of(SelectionView.getOpenedView().getSelectedTraceType()));
        }
        operationHistory.execute((IUndoableOperation)createTraceOperation, null, (IAdaptable)adapter);
        return null;
    }

    public void setUndoContext(IUndoContext undoContext) {
        this.undoContext = undoContext;
    }
}

