/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.adapters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.ui.adapters.PropertySourceExtensionPointHelper;
import org.eclipse.capra.ui.operations.UpdateTraceOperation;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class ConnectionAdapter
implements IPropertySource {
    private static final String CATEGORY_NAME = "General";
    private final Connection connection;
    private final ArtifactHelper artifactHelper;
    private final IPropertySource connectionMetadataPropertySource;

    public ConnectionAdapter(Connection theItem) {
        this.connection = theItem;
        IPersistenceAdapter persistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
        EObject artifactModel = persistenceAdapter.getArtifactWrappers(EditingDomainHelper.getResourceSet());
        this.artifactHelper = new ArtifactHelper(artifactModel);
        IPropertySourceProvider propSourceProvider = PropertySourceExtensionPointHelper.getMetadataPropertySourceProvider().orElse(null);
        this.connectionMetadataPropertySource = Optional.ofNullable(propSourceProvider).map(p -> p.getPropertySource((Object)theItem)).orElse(null);
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<Object> propertyDescriptors = new ArrayList<Object>();
        PropertyDescriptor originDescriptor = new PropertyDescriptor((Object)DescriptorIDs.ORIGINS, DescriptorIDs.ORIGINS.toString());
        originDescriptor.setCategory(CATEGORY_NAME);
        propertyDescriptors.add(originDescriptor);
        PropertyDescriptor targetDescriptor = new PropertyDescriptor((Object)DescriptorIDs.TARGETS, DescriptorIDs.TARGETS.toString());
        targetDescriptor.setCategory(CATEGORY_NAME);
        propertyDescriptors.add(targetDescriptor);
        PropertyDescriptor typeDescriptor = new PropertyDescriptor((Object)DescriptorIDs.TYPE, DescriptorIDs.TYPE.toString());
        typeDescriptor.setCategory(CATEGORY_NAME);
        propertyDescriptors.add(typeDescriptor);
        propertyDescriptors.addAll(this.connection.getTlink().eClass().getEAllAttributes().stream().map(attribute -> new TextPropertyDescriptor((Object)attribute.getName(), attribute.getName())).collect(Collectors.toList()));
        if (this.connectionMetadataPropertySource != null) {
            propertyDescriptors.addAll(Arrays.asList(this.connectionMetadataPropertySource.getPropertyDescriptors()));
        }
        IPropertyDescriptor[] dummyList = new IPropertyDescriptor[propertyDescriptors.size()];
        return propertyDescriptors.toArray(dummyList);
    }

    public Object getPropertyValue(Object id) {
        DescriptorIDs descId = null;
        if (id instanceof DescriptorIDs) {
            descId = (DescriptorIDs)((Object)id);
        } else if (id instanceof String) {
            try {
                descId = DescriptorIDs.fromString((String)id);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (descId != null && descId.equals((Object)DescriptorIDs.ORIGINS)) {
            return this.connection.getOrigins().stream().map(o -> this.artifactHelper.getArtifactLabel(o)).collect(Collectors.toList());
        }
        if (descId != null && descId.equals((Object)DescriptorIDs.TARGETS)) {
            return this.connection.getTargets().stream().map(arg_0 -> ((ArtifactHelper)this.artifactHelper).getArtifactLabel(arg_0)).collect(Collectors.toList());
        }
        if (descId != null && descId.equals((Object)DescriptorIDs.TYPE)) {
            return this.connection.getTlink().eClass().getName();
        }
        if (this.connectionMetadataPropertySource != null && this.connectionMetadataPropertySource.getPropertyValue(id) != null) {
            return this.connectionMetadataPropertySource.getPropertyValue(id);
        }
        if (id instanceof String) {
            EStructuralFeature a = this.connection.getTlink().eClass().getEStructuralFeature((String)id);
            return this.connection.getTlink().eGet(a);
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        if (this.connectionMetadataPropertySource != null && this.connectionMetadataPropertySource.getPropertyValue(id) != null) {
            return this.connectionMetadataPropertySource.isPropertySet(id);
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
        if (this.connectionMetadataPropertySource != null && this.connectionMetadataPropertySource.getPropertyValue(id) != null) {
            this.connectionMetadataPropertySource.resetPropertyValue(id);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (this.connectionMetadataPropertySource != null && this.connectionMetadataPropertySource.getPropertyValue(id) != null) {
            this.connectionMetadataPropertySource.setPropertyValue(id, value);
            return;
        }
        if (id instanceof String) {
            IWorkbenchPartSite adapter = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
            IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
            UpdateTraceOperation updateTraceOperation = new UpdateTraceOperation("Update trace link", this.connection, id, value);
            updateTraceOperation.addContext(IOperationHistory.GLOBAL_UNDO_CONTEXT);
            try {
                operationHistory.execute((IUndoableOperation)updateTraceOperation, null, (IAdaptable)adapter);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    private static enum DescriptorIDs {
        ORIGINS("Origins"),
        TARGETS("Targets"),
        TYPE("Type");

        private final String name;

        private DescriptorIDs(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }

        public static DescriptorIDs fromString(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Provided value must not be null");
            }
            DescriptorIDs[] descriptorIDsArray = DescriptorIDs.values();
            int n = descriptorIDsArray.length;
            int n2 = 0;
            while (n2 < n) {
                DescriptorIDs descId = descriptorIDsArray[n2];
                if (descId.toString().equals(value)) {
                    return descId;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Provided value does not correspond to any enum value");
        }
    }
}

