/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.asciidoc;

import de.jcup.asciidoctoreditor.outline.Item;
import java.util.Objects;
import org.eclipse.capra.core.helpers.ArtifactStatus;
import org.eclipse.capra.ui.asciidoc.internal.AsciiDocArtifactExistenceChecker;

public class AsciiDocArtifact {
    private Item item;
    private String uri;

    public AsciiDocArtifact(String uri, Item item) {
        this.uri = uri;
        this.item = item;
    }

    public Item getItem() {
        return this.item;
    }

    public String getUri() {
        return this.uri;
    }

    public int hashCode() {
        return Objects.hash(this.item, this.uri);
    }

    public boolean exists() {
        return this.getStatus().getStatus() == ArtifactStatus.Status.NORMAL;
    }

    public ArtifactStatus getStatus() {
        return AsciiDocArtifactExistenceChecker.getAsciiDocArtifactStatus(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AsciiDocArtifact other = (AsciiDocArtifact)obj;
        return this.itemEquals(this.item, other.item) && Objects.equals(this.uri, other.uri);
    }

    private boolean itemEquals(Item first, Item second) {
        if (first == second) {
            return true;
        }
        if (first == null && second != null || first != null && second == null) {
            return false;
        }
        if (first.getClass() != second.getClass()) {
            return false;
        }
        return first.getEndOffset() == second.getEndOffset() && Objects.equals(first.getFilePathOrNull(), second.getFilePathOrNull()) && Objects.equals(first.getFullString(), second.getFullString()) && Objects.equals(first.getId(), second.getId()) && first.getLength() == second.getLength() && Objects.equals(first.getName(), second.getName()) && first.getOffset() == second.getOffset() && Objects.equals(first.getPrefix(), second.getPrefix()) && first.getItemType() == second.getItemType();
    }
}

