/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.odaconsumer.Connection;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionTest;
import org.eclipse.birt.data.engine.odaconsumer.ParameterHint;
import org.eclipse.birt.data.engine.odaconsumer.ParameterMetaData;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ParameterHintTest
extends ConnectionTest {
    private DataResourceHandle resourceHandle = DataResourceHandle.getInstance();

    @Test
    public void testNameToPositionInSingleParameterHint() throws Exception {
        PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" = ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Assert.assertNotNull((Object)statement);
        ParameterHint hint = new ParameterHint("ParamName", true, false);
        hint.setPosition(1);
        statement.addParameterHint(hint);
        statement.setParameterValue("ParamName", (Object)new Integer(4));
        Assert.assertTrue((boolean)statement.execute());
        ResultSet resultset = statement.getResultSet();
        int count = 0;
        while (resultset.fetch() != null) {
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testNameToPositionInParameterHints() throws Exception {
        String command = "select \"intColumn\" from \"testtable\" where \"intColumn\" = ? OR \"stringColumn\" = ?";
        PreparedStatement statement = this.getConnection().prepareStatement(command, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Assert.assertNotNull((Object)statement);
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        statement.addParameterHint(hint);
        hint = new ParameterHint("ParamName2", true, false);
        hint.setPosition(2);
        statement.addParameterHint(hint);
        statement.setParameterValue("ParamName1", (Object)new Integer(0));
        statement.setParameterValue("ParamName2", (Object)"blah blah blah");
        Assert.assertTrue((boolean)statement.execute());
        ResultSet resultset = statement.getResultSet();
        int count = 0;
        while (resultset.fetch() != null) {
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testValidateParameterHints1() throws Exception {
        try {
            PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" = ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
            Assert.assertNotNull((Object)statement);
            ParameterHint hint = new ParameterHint("ParamName1", true, false);
            hint.setPosition(1);
            statement.addParameterHint(hint);
            hint = new ParameterHint("ParamName1", true, false);
            hint.setPosition(2);
            statement.addParameterHint(hint);
            Assert.fail();
        }
        catch (DataException ex) {
            String msg = this.resourceHandle.getMessage("odaconsumer.SameParamNameForDifferentHints", new Object[]{"ParamName1"});
            Assert.assertEquals((Object)msg, (Object)ex.getMessage());
        }
    }

    @Test
    public void testValidateInputParameterHints2() throws Exception {
        PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" = ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Assert.assertNotNull((Object)statement);
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        statement.addParameterHint(hint);
        hint = new ParameterHint("PName1", true, false);
        hint.setPosition(1);
        try {
            statement.addParameterHint(hint);
            Assert.fail();
        }
        catch (DataException ex) {
            String msg = this.resourceHandle.getMessage("odaconsumer.DifferentParamNameForSamePosition", new Object[]{"ParamName1", new Integer(1)});
            Assert.assertEquals((Object)msg, (Object)ex.getMessage());
        }
    }

    @Test
    public void testValidateOutputParameterHints() throws Exception {
        PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" = ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Assert.assertNotNull((Object)statement);
        ParameterHint outputHint = new ParameterHint("ParamName1", false, true);
        outputHint.setPosition(2);
        statement.addParameterHint(outputHint);
        ParameterHint hint = new ParameterHint("PName1", true, false);
        hint.setPosition(2);
        try {
            statement.addParameterHint(hint);
            Assert.fail();
        }
        catch (DataException ex) {
            String msg = this.resourceHandle.getMessage("odaconsumer.DifferentParamNameForSamePosition", new Object[]{"ParamName1", new Integer(2)});
            Assert.assertEquals((Object)msg, (Object)ex.getMessage());
        }
    }

    @Test
    public void testValidateInputParameterHintsSucceed() throws Exception {
        PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" = ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Assert.assertNotNull((Object)statement);
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setNativeName("sameNativeName");
        statement.addParameterHint(hint);
        hint = new ParameterHint("ParamName2", true, false);
        hint.setPosition(2);
        hint.setNativeName("sameNativeName");
        try {
            statement.addParameterHint(hint);
            Assert.assertTrue((boolean)true);
        }
        catch (DataException ex) {
            Assert.fail();
        }
    }

    @Test
    public void testGetParameterMetaData1() throws Exception {
        PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" = ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Assert.assertNotNull((Object)statement);
        Collection parameterMetaData = statement.getParameterMetaData();
        Assert.assertNotNull((Object)parameterMetaData);
        Assert.assertEquals((long)1L, (long)parameterMetaData.size());
        for (ParameterMetaData metadata : parameterMetaData) {
            this.checkDefaultMetaData(metadata, 1);
        }
    }

    @Test
    public void testGetParameterMetaData2() throws Exception {
        PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" < ? AND \"intColumn\" > ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Assert.assertNotNull((Object)statement);
        Collection parameterMetaData = statement.getParameterMetaData();
        Assert.assertNotNull((Object)parameterMetaData);
        Assert.assertEquals((long)2L, (long)parameterMetaData.size());
        Iterator iter = parameterMetaData.iterator();
        int count = 1;
        while (iter.hasNext()) {
            ParameterMetaData metadata = (ParameterMetaData)iter.next();
            this.checkDefaultMetaData(metadata, count++);
        }
    }

    private void checkDefaultMetaData(ParameterMetaData metadata, int index) {
        Assert.assertEquals((long)index, (long)metadata.getPosition());
        Assert.assertEquals((long)4L, (long)metadata.getDataType());
        Assert.assertEquals(null, (Object)metadata.getName());
        Assert.assertEquals(null, (Object)metadata.getDefaultValue());
        Assert.assertEquals((Object)"INTEGER", (Object)metadata.getNativeTypeName());
        Assert.assertEquals((long)0L, (long)metadata.getScale());
        Assert.assertEquals((long)10L, (long)metadata.getPrecision());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isInputMode());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOutputMode());
        Assert.assertEquals(null, (Object)metadata.isOptional());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
    }

    @Test
    public void testGetParameterMetaData3() throws Exception {
        PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" = ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Assert.assertNotNull((Object)statement);
        Collection parameterMetaData = statement.getParameterMetaData();
        Assert.assertNotNull((Object)parameterMetaData);
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setNativeName("paramNativeName");
        hint.setDataType(Integer.class);
        hint.setIsInputOptional(false);
        statement.addParameterHint(hint);
        Collection parameterMetaData1 = statement.getParameterMetaData();
        Assert.assertNotNull((Object)parameterMetaData1);
        Assert.assertNotSame((Object)parameterMetaData, (Object)parameterMetaData1);
        for (ParameterMetaData metadata : parameterMetaData1) {
            Assert.assertEquals((long)1L, (long)metadata.getPosition());
            Assert.assertEquals((long)4L, (long)metadata.getDataType());
            Assert.assertEquals((Object)"ParamName1", (Object)metadata.getName());
            Assert.assertEquals((Object)"paramNativeName", (Object)metadata.getNativeName());
            Assert.assertEquals(null, (Object)metadata.getDefaultValue());
            Assert.assertEquals((Object)"INTEGER", (Object)metadata.getNativeTypeName());
            Assert.assertEquals((long)0L, (long)metadata.getScale());
            Assert.assertEquals((long)10L, (long)metadata.getPrecision());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isInputMode());
            Assert.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOutputMode());
            Assert.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOptional());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
        }
    }

    @Ignore(value="Ignore tests that require manual setup")
    @Test
    public void testUnsupportedRuntimeParameterMetaData() throws Exception {
        Connection connection = this.getMySqlConnection();
        PreparedStatement statement = connection.prepareStatement("SELECT \"intColumn\", \"doubleColumn\" FROM \"testtable\" WHERE \"intColumn\" > ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Assert.assertNotNull((Object)statement);
        Collection parameterMetaData = null;
        try {
            parameterMetaData = statement.getParameterMetaData();
        }
        catch (DataException dataException) {
            // empty catch block
        }
        Assert.assertNull((Object)parameterMetaData);
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setDataType(Integer.class);
        hint.setIsInputOptional(false);
        statement.addParameterHint(hint);
        ParameterHint hint2 = new ParameterHint("ParamName2", true, false);
        hint2.setDataType(Double.class);
        statement.addParameterHint(hint2);
        Collection parameterMetaData1 = statement.getParameterMetaData();
        Assert.assertNotNull((Object)parameterMetaData1);
        Iterator iter = parameterMetaData1.iterator();
        int paramNumInCollection = 1;
        while (iter.hasNext()) {
            ParameterMetaData metadata = (ParameterMetaData)iter.next();
            if (paramNumInCollection++ == 1) {
                Assert.assertEquals((long)1L, (long)metadata.getPosition());
                Assert.assertEquals((long)4L, (long)metadata.getDataType());
                Assert.assertEquals((Object)"ParamName1", (Object)metadata.getName());
                Assert.assertEquals(null, (Object)metadata.getDefaultValue());
                Assert.assertEquals(null, (Object)metadata.getNativeTypeName());
                Assert.assertEquals((long)-1L, (long)metadata.getScale());
                Assert.assertEquals((long)-1L, (long)metadata.getPrecision());
                Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isInputMode());
                Assert.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOutputMode());
                Assert.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOptional());
                Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
                continue;
            }
            Assert.assertEquals((long)-1L, (long)metadata.getPosition());
            Assert.assertEquals((long)8L, (long)metadata.getDataType());
            Assert.assertEquals((Object)"ParamName2", (Object)metadata.getName());
            Assert.assertEquals(null, (Object)metadata.getDefaultValue());
            Assert.assertEquals(null, (Object)metadata.getNativeTypeName());
            Assert.assertEquals((long)-1L, (long)metadata.getScale());
            Assert.assertEquals((long)-1L, (long)metadata.getPrecision());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isInputMode());
            Assert.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOutputMode());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOptional());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
        }
    }

    @Ignore(value="Ignore tests that require manual setup")
    @Test
    public void testMultipleHintsOnSameParameterName() throws Exception {
        Connection connection = this.getMySqlConnection();
        PreparedStatement statement = connection.prepareStatement("SELECT \"intColumn\", \"doubleColumn\" FROM \"testtable\" WHERE \"intColumn\" > ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Assert.assertNotNull((Object)statement);
        Collection parameterMetaData = null;
        try {
            parameterMetaData = statement.getParameterMetaData();
        }
        catch (DataException dataException) {
            // empty catch block
        }
        Assert.assertNull((Object)parameterMetaData);
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setNativeName("paramNativeName1");
        hint.setDataType(Integer.class);
        hint.setIsInputOptional(false);
        statement.addParameterHint(hint);
        ParameterHint hint2 = new ParameterHint("ParamName2", false, true);
        hint2.setDataType(Double.class);
        statement.addParameterHint(hint2);
        ParameterHint hint3 = new ParameterHint("ParamName1", false, true);
        hint3.setNativeName("paramNativeName3");
        statement.addParameterHint(hint3);
        Collection parameterMetaData1 = statement.getParameterMetaData();
        Assert.assertNotNull((Object)parameterMetaData1);
        Iterator iter = parameterMetaData1.iterator();
        int paramNumInCollection = 1;
        while (iter.hasNext()) {
            ParameterMetaData metadata = (ParameterMetaData)iter.next();
            if (paramNumInCollection++ == 1) {
                Assert.assertEquals((long)1L, (long)metadata.getPosition());
                Assert.assertEquals((long)4L, (long)metadata.getDataType());
                Assert.assertEquals((Object)"ParamName1", (Object)metadata.getName());
                Assert.assertEquals((Object)"paramNativeName3", (Object)metadata.getNativeName());
                Assert.assertEquals(null, (Object)metadata.getDefaultValue());
                Assert.assertEquals(null, (Object)metadata.getNativeTypeName());
                Assert.assertEquals((long)-1L, (long)metadata.getScale());
                Assert.assertEquals((long)-1L, (long)metadata.getPrecision());
                Assert.assertEquals((Object)Boolean.FALSE, (Object)metadata.isInputMode());
                Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOutputMode());
                Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOptional());
                Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
                continue;
            }
            Assert.assertEquals((long)-1L, (long)metadata.getPosition());
            Assert.assertEquals((long)8L, (long)metadata.getDataType());
            Assert.assertEquals((Object)"ParamName2", (Object)metadata.getName());
            Assert.assertEquals(null, (Object)metadata.getDefaultValue());
            Assert.assertEquals(null, (Object)metadata.getNativeTypeName());
            Assert.assertEquals((long)-1L, (long)metadata.getScale());
            Assert.assertEquals((long)-1L, (long)metadata.getPrecision());
            Assert.assertEquals((Object)Boolean.FALSE, (Object)metadata.isInputMode());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOutputMode());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOptional());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
        }
    }

    @Ignore(value="Ignore tests that require manual setup")
    @Test
    public void testUnsupportedRuntimeParameterMetaData2() throws Exception {
        Connection connection = this.getMySqlConnection();
        PreparedStatement statement = connection.prepareStatement("SELECT \"intColumn\", \"doubleColumn\" FROM \"testtable\" WHERE \"intColumn\" > ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Assert.assertNotNull((Object)statement);
        Collection parameterMetaData = null;
        try {
            parameterMetaData = statement.getParameterMetaData();
        }
        catch (DataException dataException) {
            // empty catch block
        }
        Assert.assertNull((Object)parameterMetaData);
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setDataType(Integer.class);
        hint.setIsInputOptional(false);
        hint.setDefaultInputValue((Object)"123");
        statement.addParameterHint(hint);
        ParameterHint hint2 = new ParameterHint("ParamName2", true, false);
        hint2.setDataType(Double.class);
        hint2.setDefaultInputValue((Object)"456");
        statement.addParameterHint(hint2);
        Collection parameterMetaData1 = statement.getParameterMetaData();
        Assert.assertNotNull((Object)parameterMetaData1);
        Iterator iter = parameterMetaData1.iterator();
        int paramNumInCollection = 1;
        while (iter.hasNext()) {
            ParameterMetaData metadata = (ParameterMetaData)iter.next();
            if (paramNumInCollection++ == 1) {
                Assert.assertEquals((long)1L, (long)metadata.getPosition());
                Assert.assertEquals((long)4L, (long)metadata.getDataType());
                Assert.assertEquals((Object)"ParamName1", (Object)metadata.getName());
                Assert.assertEquals((Object)"123", (Object)metadata.getDefaultValue());
                Assert.assertEquals(null, (Object)metadata.getNativeTypeName());
                Assert.assertEquals((long)-1L, (long)metadata.getScale());
                Assert.assertEquals((long)-1L, (long)metadata.getPrecision());
                Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isInputMode());
                Assert.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOutputMode());
                Assert.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOptional());
                Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
                continue;
            }
            Assert.assertEquals((long)-1L, (long)metadata.getPosition());
            Assert.assertEquals((long)8L, (long)metadata.getDataType());
            Assert.assertEquals((Object)"ParamName2", (Object)metadata.getName());
            Assert.assertEquals((Object)"456", (Object)metadata.getDefaultValue());
            Assert.assertEquals(null, (Object)metadata.getNativeTypeName());
            Assert.assertEquals((long)-1L, (long)metadata.getScale());
            Assert.assertEquals((long)-1L, (long)metadata.getPrecision());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isInputMode());
            Assert.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOutputMode());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOptional());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
        }
    }

    @Test
    public void testUnsupportedParameterDataTypes() throws Exception {
        ParameterHint inputHint = new ParameterHint("InputParameter", true, true);
        boolean isErrorCaught = false;
        try {
            inputHint.setDataType(IBlob.class);
        }
        catch (IllegalArgumentException e) {
            isErrorCaught = true;
        }
        Assert.assertTrue((boolean)isErrorCaught);
        isErrorCaught = false;
        try {
            inputHint.setDataType(IClob.class);
        }
        catch (IllegalArgumentException e) {
            isErrorCaught = true;
        }
        Assert.assertTrue((boolean)isErrorCaught);
    }

    @Ignore(value="Ignore tests that require manual setup")
    @Test
    public void testMergeParamHints() throws Exception {
        Connection connection = this.getMySqlConnection();
        PreparedStatement statement = connection.prepareStatement("SELECT \"intColumn\", \"doubleColumn\" FROM \"testtable\" WHERE \"intColumn\" > ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setDataType(Integer.class);
        hint.setIsInputOptional(false);
        statement.addParameterHint(hint);
        ParameterHint outputHint = new ParameterHint("ParamName1", false, true);
        outputHint.setPosition(1);
        outputHint.setDataType(Integer.class);
        statement.addParameterHint(outputHint);
        Collection parameterMetaData = statement.getParameterMetaData();
        Assert.assertTrue((parameterMetaData != null && parameterMetaData.size() == 1 ? 1 : 0) != 0);
        for (ParameterMetaData metadata : parameterMetaData) {
            Assert.assertEquals((long)1L, (long)metadata.getPosition());
            Assert.assertEquals((long)4L, (long)metadata.getDataType());
            Assert.assertEquals((Object)"ParamName1", (Object)metadata.getName());
            Assert.assertEquals(null, (Object)metadata.getDefaultValue());
            Assert.assertEquals(null, (Object)metadata.getNativeTypeName());
            Assert.assertEquals((long)-1L, (long)metadata.getScale());
            Assert.assertEquals((long)-1L, (long)metadata.getPrecision());
            Assert.assertEquals((Object)Boolean.FALSE, (Object)metadata.isInputMode());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOutputMode());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOptional());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
        }
    }

    @Ignore(value="Ignore tests that require manual setup")
    @Test
    public void testMergeParamHints1() throws Exception {
        Connection connection = this.getMySqlConnection();
        PreparedStatement statement = connection.prepareStatement("SELECT \"intColumn\", \"doubleColumn\" FROM \"testtable\" WHERE \"intColumn\" > ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setDataType(Integer.class);
        hint.setIsInputOptional(false);
        statement.addParameterHint(hint);
        hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setNativeName("paramNativeName");
        hint.setDataType(Integer.class);
        statement.addParameterHint(hint);
        Collection parameterMetaData = statement.getParameterMetaData();
        Assert.assertTrue((parameterMetaData != null && parameterMetaData.size() == 1 ? 1 : 0) != 0);
        for (ParameterMetaData metadata : parameterMetaData) {
            Assert.assertEquals((long)1L, (long)metadata.getPosition());
            Assert.assertEquals((long)4L, (long)metadata.getDataType());
            Assert.assertEquals((Object)"ParamName1", (Object)metadata.getName());
            Assert.assertEquals((Object)"paramNativeName", (Object)metadata.getNativeName());
            Assert.assertEquals(null, (Object)metadata.getDefaultValue());
            Assert.assertEquals(null, (Object)metadata.getNativeTypeName());
            Assert.assertEquals((long)-1L, (long)metadata.getScale());
            Assert.assertEquals((long)-1L, (long)metadata.getPrecision());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isInputMode());
            Assert.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOutputMode());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOptional());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
        }
    }

    @Ignore(value="Ignore tests that require manual setup")
    @Test
    public void testConflictingParamHints() throws Exception {
        try {
            Connection connection = this.getMySqlConnection();
            PreparedStatement statement = connection.prepareStatement("SELECT \"intColumn\", \"doubleColumn\" FROM \"testtable\" WHERE \"intColumn\" > ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
            ParameterHint hint = new ParameterHint("ParamName1", true, false);
            hint.setPosition(1);
            hint.setDataType(Integer.class);
            hint.setIsInputOptional(false);
            statement.addParameterHint(hint);
            ParameterHint outputHint = new ParameterHint("ParamName1", false, true);
            outputHint.setPosition(2);
            outputHint.setDataType(Integer.class);
            statement.addParameterHint(outputHint);
            Assert.fail();
        }
        catch (DataException ex) {
            String msg = this.resourceHandle.getMessage("odaconsumer.SameParamNameForDifferentHints", new Object[]{"ParamName1"});
            Assert.assertEquals((Object)msg, (Object)ex.getMessage());
        }
    }

    @Ignore(value="Ignore tests that require manual setup")
    @Test
    public void testMergeParamHints3() throws Exception {
        Connection connection = this.getMySqlConnection();
        PreparedStatement statement = connection.prepareStatement("SELECT \"intColumn\", \"doubleColumn\" FROM \"testtable\" WHERE \"intColumn\" > ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setDataType(Integer.class);
        hint.setIsInputOptional(false);
        statement.addParameterHint(hint);
        ParameterHint outputHint = new ParameterHint("ParamName1", false, true);
        outputHint.setDataType(Double.class);
        statement.addParameterHint(outputHint);
        Collection parameterMetaData = statement.getParameterMetaData();
        Assert.assertTrue((parameterMetaData != null && parameterMetaData.size() == 1 ? 1 : 0) != 0);
        for (ParameterMetaData metadata : parameterMetaData) {
            Assert.assertEquals((long)1L, (long)metadata.getPosition());
            Assert.assertEquals((long)8L, (long)metadata.getDataType());
            Assert.assertEquals((Object)"ParamName1", (Object)metadata.getName());
            Assert.assertEquals(null, (Object)metadata.getDefaultValue());
            Assert.assertEquals(null, (Object)metadata.getNativeTypeName());
            Assert.assertEquals((long)-1L, (long)metadata.getScale());
            Assert.assertEquals((long)-1L, (long)metadata.getPrecision());
            Assert.assertEquals((Object)Boolean.FALSE, (Object)metadata.isInputMode());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOutputMode());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isOptional());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
        }
    }

    @Test
    public void testMergeParamHintsWithRuntimeMd() throws Exception {
        PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" = ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Assert.assertNotNull((Object)statement);
        Collection parameterMetaData = statement.getParameterMetaData();
        Assert.assertNotNull((Object)parameterMetaData);
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setNativeName("myParam1");
        hint.setDataType(Integer.class);
        hint.setIsInputOptional(false);
        statement.addParameterHint(hint);
        Collection parameterMetaData1 = statement.getParameterMetaData();
        Assert.assertNotNull((Object)parameterMetaData1);
        Assert.assertNotSame((Object)parameterMetaData, (Object)parameterMetaData1);
        for (ParameterMetaData metadata : parameterMetaData1) {
            Assert.assertEquals((long)1L, (long)metadata.getPosition());
            Assert.assertEquals((long)4L, (long)metadata.getDataType());
            Assert.assertEquals((Object)"ParamName1", (Object)metadata.getName());
            Assert.assertEquals((Object)"myParam1", (Object)metadata.getNativeName());
            Assert.assertEquals(null, (Object)metadata.getDefaultValue());
            Assert.assertEquals((Object)"INTEGER", (Object)metadata.getNativeTypeName());
            Assert.assertEquals((long)0L, (long)metadata.getScale());
            Assert.assertEquals((long)10L, (long)metadata.getPrecision());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isInputMode());
            Assert.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOutputMode());
            Assert.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOptional());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
        }
    }

    @Test
    public void testMergeParamHintsWithDefaultValue() throws Exception {
        PreparedStatement statement = this.getConnection().prepareStatement("select \"intColumn\" from \"testtable\" where \"intColumn\" = ?", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Assert.assertNotNull((Object)statement);
        Collection parameterMetaData = statement.getParameterMetaData();
        Assert.assertNotNull((Object)parameterMetaData);
        ParameterHint hint = new ParameterHint("ParamName1", true, false);
        hint.setPosition(1);
        hint.setDataType(Integer.class);
        hint.setIsInputOptional(false);
        hint.setDefaultInputValue((Object)"123");
        statement.addParameterHint(hint);
        Collection parameterMetaData1 = statement.getParameterMetaData();
        Assert.assertNotNull((Object)parameterMetaData1);
        Assert.assertNotSame((Object)parameterMetaData, (Object)parameterMetaData1);
        for (ParameterMetaData metadata : parameterMetaData1) {
            Assert.assertEquals((long)1L, (long)metadata.getPosition());
            Assert.assertEquals((long)4L, (long)metadata.getDataType());
            Assert.assertEquals((Object)"ParamName1", (Object)metadata.getName());
            Assert.assertEquals((Object)"123", (Object)metadata.getDefaultValue());
            Assert.assertEquals((Object)"INTEGER", (Object)metadata.getNativeTypeName());
            Assert.assertEquals((long)0L, (long)metadata.getScale());
            Assert.assertEquals((long)10L, (long)metadata.getPrecision());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isInputMode());
            Assert.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOutputMode());
            Assert.assertEquals((Object)Boolean.FALSE, (Object)metadata.isOptional());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)metadata.isNullable());
        }
    }

    @Test
    public void testMergeParamHintOnLOB() throws Exception {
        String queryText = "select * from \"testtable_lob\" where \"clob1\" like ? ";
        PreparedStatement statement = this.getConnection().prepareStatement(queryText, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Assert.assertNotNull((Object)statement);
        Collection parameterMetaData = statement.getParameterMetaData();
        Assert.assertNotNull((Object)parameterMetaData);
        ParameterHint hint = new ParameterHint("OutParam", false, true);
        hint.setPosition(1);
        hint.setDataType(IClob.class);
        statement.addParameterHint(hint);
        Collection parameterMetaData1 = statement.getParameterMetaData();
        Assert.assertNotNull((Object)parameterMetaData1);
        Assert.assertNotSame((Object)parameterMetaData, (Object)parameterMetaData1);
        for (ParameterMetaData metadata : parameterMetaData1) {
            Assert.assertEquals((long)1L, (long)metadata.getPosition());
            Assert.assertEquals((Object)"OutParam", (Object)metadata.getName());
            Assert.assertEquals((long)2005L, (long)metadata.getDataType());
        }
        statement.close();
    }
}

