/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.binding;

import java.util.ArrayList;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpressionUtil;
import org.eclipse.birt.data.engine.binding.APITestCase;
import org.eclipse.birt.data.engine.core.DataException;
import org.junit.Assert;
import org.junit.Test;
import testutil.ConfigText;

public class FilterByRowTest
extends APITestCase {
    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Impl.TestData1.TableName"), ConfigText.getString("Impl.TestData1.TableSQL"), ConfigText.getString("Impl.TestData1.TestDataFileName"));
    }

    @Test
    public void testAccept1() throws Exception {
        String[] bindingNameFilter = new String[]{"FILTER_COL0", "FILTER_COL1", "FILTER_COL2"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.COL0"), new ScriptExpression("dataSetRow.COL1"), new ScriptExpression("dataSetRow.COL2")};
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ScriptExpression("row.FILTER_COL0 > 0")), new FilterDefinition((IBaseExpression)new ScriptExpression("row.FILTER_COL1 > 1")), new FilterDefinition((IBaseExpression)new ScriptExpression("row.FILTER_COL2 > 0"))};
        IResultIterator resultIterator = this.getResultIterator(filterDefn, bindingNameFilter, bindingExprFilter, false);
        while (resultIterator.next()) {
            Integer value0 = resultIterator.getInteger(this.getBindingExpressionName()[0]);
            Integer value1 = resultIterator.getInteger(this.getBindingExpressionName()[1]);
            Integer value2 = resultIterator.getInteger(this.getBindingExpressionName()[2]);
            Assert.assertTrue((value0 > 0 ? 1 : 0) != 0);
            Assert.assertTrue((value1 > 1 ? 1 : 0) != 0);
            Assert.assertTrue((value2 > 0 ? 1 : 0) != 0);
        }
        resultIterator.close();
    }

    @Test
    public void testAccept1WithCache() throws Exception {
        String[] bindingNameFilter = new String[]{"FILTER_COL0", "FILTER_COL1", "FILTER_COL2"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.COL0"), new ScriptExpression("dataSetRow.COL1"), new ScriptExpression("dataSetRow.COL2")};
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ScriptExpression("row.FILTER_COL0 > 0")), new FilterDefinition((IBaseExpression)new ScriptExpression("row.FILTER_COL1 > 1")), new FilterDefinition((IBaseExpression)new ScriptExpression("row.FILTER_COL2 > 0"))};
        IResultIterator resultIterator = this.getResultIterator(filterDefn, bindingNameFilter, bindingExprFilter, true);
        String queryResultID = resultIterator.getQueryResults().getID();
        resultIterator.close();
        resultIterator = this.getResultIterator(filterDefn, bindingNameFilter, bindingExprFilter, true, queryResultID);
        while (resultIterator.next()) {
            Integer value0 = resultIterator.getInteger(this.getBindingExpressionName()[0]);
            Integer value1 = resultIterator.getInteger(this.getBindingExpressionName()[1]);
            Integer value2 = resultIterator.getInteger(this.getBindingExpressionName()[2]);
            Assert.assertTrue((value0 > 0 ? 1 : 0) != 0);
            Assert.assertTrue((value1 > 1 ? 1 : 0) != 0);
            Assert.assertTrue((value2 > 0 ? 1 : 0) != 0);
        }
        resultIterator.close();
    }

    @Test
    public void testAccept2() throws Exception {
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ScriptExpression("row.ROW_COL0 + row.ROW_COL1 > row.ROW_COL2"))};
        IResultIterator resultIterator = this.getResultIterator(filterDefn, null, null, false);
        while (resultIterator.next()) {
            Integer value0 = resultIterator.getInteger(this.getBindingExpressionName()[0]);
            Integer value1 = resultIterator.getInteger(this.getBindingExpressionName()[1]);
            Integer value2 = resultIterator.getInteger(this.getBindingExpressionName()[2]);
            Assert.assertTrue((value0 + value1 > value2 ? 1 : 0) != 0);
        }
        resultIterator.close();
    }

    @Test
    public void testAccept2WithCache() throws Exception {
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ScriptExpression("row.ROW_COL0 + row.ROW_COL1 > row.ROW_COL2"))};
        IResultIterator resultIterator = this.getResultIterator(filterDefn, null, null, true);
        String queryResultID = resultIterator.getQueryResults().getID();
        resultIterator.close();
        resultIterator = this.getResultIterator(filterDefn, null, null, true, queryResultID);
        while (resultIterator.next()) {
            Integer value0 = resultIterator.getInteger(this.getBindingExpressionName()[0]);
            Integer value1 = resultIterator.getInteger(this.getBindingExpressionName()[1]);
            Integer value2 = resultIterator.getInteger(this.getBindingExpressionName()[2]);
            Assert.assertTrue((value0 + value1 > value2 ? 1 : 0) != 0);
        }
        resultIterator.close();
    }

    @Test
    public void testAccept3() throws Exception {
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ScriptExpression("row.ROW_COL0 * row.ROW_COL1 > row.ROW_COL2"))};
        IResultIterator resultIterator = this.getResultIterator(filterDefn, null, null, false);
        while (resultIterator.next()) {
            Integer value0 = resultIterator.getInteger(this.getBindingExpressionName()[0]);
            Integer value1 = resultIterator.getInteger(this.getBindingExpressionName()[1]);
            Integer value2 = resultIterator.getInteger(this.getBindingExpressionName()[2]);
            Assert.assertTrue((value0 * value1 > value2 ? 1 : 0) != 0);
        }
        resultIterator.close();
    }

    @Test
    public void testAccept3WithCache() throws Exception {
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ScriptExpression("row.ROW_COL0 * row.ROW_COL1 > row.ROW_COL2"))};
        IResultIterator resultIterator = this.getResultIterator(filterDefn, null, null, true);
        String queryResultID = resultIterator.getQueryResults().getID();
        resultIterator.close();
        resultIterator = this.getResultIterator(filterDefn, null, null, true, queryResultID);
        while (resultIterator.next()) {
            Integer value0 = resultIterator.getInteger(this.getBindingExpressionName()[0]);
            Integer value1 = resultIterator.getInteger(this.getBindingExpressionName()[1]);
            Integer value2 = resultIterator.getInteger(this.getBindingExpressionName()[2]);
            Assert.assertTrue((value0 * value1 > value2 ? 1 : 0) != 0);
        }
        resultIterator.close();
    }

    @Test
    public void testAccept4() throws Exception {
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.ROW_COL0 * row.ROW_COL1", 6, "row.ROW_COL2"))};
        IResultIterator resultIterator = this.getResultIterator(filterDefn, null, null, false);
        while (resultIterator.next()) {
            Integer value0 = resultIterator.getInteger(this.getBindingExpressionName()[0]);
            Integer value1 = resultIterator.getInteger(this.getBindingExpressionName()[1]);
            Integer value2 = resultIterator.getInteger(this.getBindingExpressionName()[2]);
            Assert.assertTrue((value0 * value1 > value2 ? 1 : 0) != 0);
        }
        resultIterator.close();
    }

    @Test
    public void testAccept4WithCache() throws Exception {
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.ROW_COL0 * row.ROW_COL1", 6, "row.ROW_COL2"))};
        IResultIterator resultIterator = this.getResultIterator(filterDefn, null, null, true);
        String queryResultID = resultIterator.getQueryResults().getID();
        resultIterator.close();
        resultIterator = this.getResultIterator(filterDefn, null, null, true, queryResultID);
        while (resultIterator.next()) {
            Integer value0 = resultIterator.getInteger(this.getBindingExpressionName()[0]);
            Integer value1 = resultIterator.getInteger(this.getBindingExpressionName()[1]);
            Integer value2 = resultIterator.getInteger(this.getBindingExpressionName()[2]);
            Assert.assertTrue((value0 * value1 > value2 ? 1 : 0) != 0);
        }
        resultIterator.close();
    }

    @Test
    public void testJSFilter() throws Exception {
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0"), new ScriptExpression("dataSetRow.COL1"), new ScriptExpression("dataSetRow.COL2"), new ScriptExpression("dataSetRow.COL3")};
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("Math.log( row[\"ROW_COL0\"])", 5, "Math.log(1)")), new FilterDefinition((IBaseExpression)new ConditionalExpression(" row[\"ROW_COL0\"].toString() ", 1, "2"))};
        QueryDefinition queryDefn1 = this.createQuery(null, null, null, null, null, null, null, null, filterDefn, bindingNameRow, (IBaseExpression[])bindingExprRow);
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)queryDefn1);
        this.outputQueryResult(resultIt, bindingNameRow);
        this.checkOutputFile();
    }

    @Test
    public void testJSFilterWithCache() throws Exception {
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1", "ROW_COL2", "ROW_COL3"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0"), new ScriptExpression("dataSetRow.COL1"), new ScriptExpression("dataSetRow.COL2"), new ScriptExpression("dataSetRow.COL3")};
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("Math.log( row[\"ROW_COL0\"])", 5, "Math.log(1)")), new FilterDefinition((IBaseExpression)new ConditionalExpression(" row[\"ROW_COL0\"].toString() ", 1, "2"))};
        QueryDefinition queryDefn1 = this.createQuery(null, null, null, null, null, null, null, null, filterDefn, bindingNameRow, (IBaseExpression[])bindingExprRow);
        queryDefn1.setCacheQueryResults(true);
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)queryDefn1);
        String queryResultID = resultIt.getQueryResults().getID();
        resultIt.close();
        resultIt = this.getResultIterator(filterDefn, null, null, true, queryResultID);
        this.outputQueryResult(resultIt, bindingNameRow);
        this.checkOutputFile();
    }

    @Test
    public void testBooleanFilterOnDataRows() throws Exception {
        String[] ccName = new String[]{"ccc", "ddd"};
        String[] ccExpr = new String[]{"true", "false"};
        int i = 0;
        while (i < ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(ccName[i], ccExpr[i], 1);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.ROW_ccc", 1, "true"))};
        String[] bindingNameRow = new String[]{"ROW_ccc", "ROW_ddd"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow." + ccName[0], 0), new ScriptExpression("dataSetRow." + ccName[1], 0)};
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, null, null, null, null, null, filterDefn, bindingNameRow, (IBaseExpression[])bindingExprRow));
        this.outputQueryResult(resultIt, bindingNameRow);
        this.checkOutputFile();
    }

    @Test
    public void testTopNFilter() throws Exception {
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0)};
        FilterDefinition[] filterDefn1 = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.ROW_COL0", 14, "10")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.ROW_COL1", 5, "0"))};
        IResultIterator resultIt1 = this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, null, null, null, null, null, filterDefn1, bindingNameRow, (IBaseExpression[])bindingExprRow));
        this.outputQueryResult(resultIt1, bindingNameRow);
        FilterDefinition[] filterDefn2 = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.ROW_COL1", 5, "0")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.ROW_COL0", 14, "10"))};
        IResultIterator resultIt2 = this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, null, null, null, null, null, filterDefn2, bindingNameRow, (IBaseExpression[])bindingExprRow));
        this.outputQueryResult(resultIt2, bindingNameRow);
        this.checkQueryResult(resultIt1, resultIt2, bindingNameRow);
    }

    @Test
    public void testInvalidFilterDefinition() throws Exception {
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0)};
        FilterDefinition[] filterDefn1 = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.ROW_COL0", 1, "abc"))};
        try {
            this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, null, null, null, null, null, filterDefn1, bindingNameRow, (IBaseExpression[])bindingExprRow));
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidFilterDefinition2() throws Exception {
        String[] bindingNameRow = new String[]{"ROW_COL0", "ROW_COL1"};
        ScriptExpression[] bindingExprRow = new ScriptExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0)};
        FilterDefinition[] filterDefn1 = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(row.ROW_COL0)", 1, "100"))};
        try {
            this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, null, null, null, null, null, filterDefn1, bindingNameRow, (IBaseExpression[])bindingExprRow));
            Assert.fail((String)"exception expected");
        }
        catch (DataException e) {
            Assert.assertEquals((Object)"data.engine.BadFilterDefn", (Object)e.getErrorCode());
        }
    }

    protected void checkQueryResult(IResultIterator resultIt1, IResultIterator resultIt2, String[] expressions) throws Exception {
        while (resultIt1.next() && resultIt2.next()) {
            int i = 0;
            while (i < expressions.length) {
                Assert.assertTrue((boolean)this.evalAsString(expressions[i], resultIt1).equals(this.evalAsString(expressions[i], resultIt2)));
                ++i;
            }
        }
    }

    private IResultIterator getResultIterator(FilterDefinition[] filterDefn, String[] bindingNameFilter, IBaseExpression[] bindingExprFilter, boolean needCache, String queryResultID) throws Exception {
        QueryDefinition queryDefn = (QueryDefinition)this.getDefaultQueryDefn(this.dataSet.getName());
        queryDefn.setCacheQueryResults(needCache);
        queryDefn.setQueryResultsID(queryResultID);
        if (filterDefn != null) {
            int i;
            if (bindingNameFilter != null) {
                i = 0;
                while (i < bindingNameFilter.length) {
                    queryDefn.addResultSetExpression(bindingNameFilter[i], bindingExprFilter[i]);
                    ++i;
                }
            }
            i = 0;
            while (i < filterDefn.length) {
                queryDefn.addFilter((IFilterDefinition)filterDefn[i]);
                ++i;
            }
        }
        return this.executeQuery((IQueryDefinition)queryDefn);
    }

    private IResultIterator getResultIterator(FilterDefinition[] filterDefn, String[] bindingNameFilter, IBaseExpression[] bindingExprFilter, boolean needCache) throws Exception {
        return this.getResultIterator(filterDefn, bindingNameFilter, bindingExprFilter, needCache, null);
    }

    @Test
    public void testSCR77518() throws BirtException {
        ScriptDataSourceDesign dsource = new ScriptDataSourceDesign("JUST as place folder");
        ScriptDataSetDesign dset = this.newDataSet();
        dset.setDataSource(dsource.getName());
        this.dataEngine.defineDataSource((IBaseDataSourceDesign)dsource);
        this.dataEngine.defineDataSet((IBaseDataSetDesign)dset);
        QueryDefinition rqDefn = new QueryDefinition();
        rqDefn.setDataSetName("test");
        String bindingNameFilter = "ROW_CH";
        ScriptExpression bindingExprFilter = new ScriptExpression("dataSetRow.CH", 0);
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)new ScriptExpression("row.ROW_CH == null"));
        rqDefn.addResultSetExpression(bindingNameFilter, (IBaseExpression)bindingExprFilter);
        rqDefn.getFilters().add(filterDefn);
        IPreparedQuery pq = this.dataEngine.prepare((IQueryDefinition)rqDefn);
        IQueryResults qr = pq.execute(this.jsScope);
        IResultIterator ri = qr.getResultIterator();
        int rowIndex = 0;
        while (ri.next()) {
            ++rowIndex;
        }
        Assert.assertEquals((long)rowIndex, (long)2L);
        rqDefn.getFilters().clear();
        rqDefn.getFilters().add(new FilterDefinition((IBaseExpression)new ScriptExpression("row.ROW_CH != null")));
        pq = this.dataEngine.prepare((IQueryDefinition)rqDefn);
        qr = pq.execute(this.jsScope);
        ri = qr.getResultIterator();
        rowIndex = 0;
        while (ri.next()) {
            ++rowIndex;
        }
        Assert.assertEquals((long)rowIndex, (long)8L);
        ri.close();
        qr.close();
    }

    @Test
    public void testConstantWithNull() throws BirtException {
        ScriptDataSourceDesign dsource = new ScriptDataSourceDesign("JUST as place folder");
        ScriptDataSetDesign dset = this.newDataSet();
        dset.setDataSource(dsource.getName());
        this.dataEngine.defineDataSource((IBaseDataSourceDesign)dsource);
        this.dataEngine.defineDataSet((IBaseDataSetDesign)dset);
        QueryDefinition rqDefn = new QueryDefinition();
        rqDefn.setDataSetName("test");
        String bindingNameFilter = "ROW_CH";
        ScriptExpression bindingExprFilter = new ScriptExpression("dataSetRow.CH", 0);
        ConditionalExpression expr = new ConditionalExpression(ScriptExpressionUtil.createJavaScriptExpression((String)"row.ROW_CH"), 1, (IBaseExpression)ScriptExpressionUtil.createConstantExpression(null), null);
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)expr);
        rqDefn.addResultSetExpression(bindingNameFilter, (IBaseExpression)bindingExprFilter);
        rqDefn.getFilters().add(filterDefn);
        IPreparedQuery pq = this.dataEngine.prepare((IQueryDefinition)rqDefn);
        IQueryResults qr = pq.execute(this.jsScope);
        IResultIterator ri = qr.getResultIterator();
        int rowIndex = 0;
        while (ri.next()) {
            ++rowIndex;
        }
        Assert.assertEquals((long)rowIndex, (long)2L);
        rqDefn.getFilters().clear();
        ArrayList<IScriptExpression> expression = new ArrayList<IScriptExpression>();
        expression.add(ScriptExpressionUtil.createConstantExpression(null));
        expr = new ConditionalExpression(ScriptExpressionUtil.createJavaScriptExpression((String)"row.ROW_CH"), 22, expression);
        FilterDefinition filterDefn2 = new FilterDefinition((IBaseExpression)expr);
        rqDefn.getFilters().add(filterDefn2);
        pq = this.dataEngine.prepare((IQueryDefinition)rqDefn);
        qr = pq.execute(this.jsScope);
        ri = qr.getResultIterator();
        rowIndex = 0;
        while (ri.next()) {
            ++rowIndex;
        }
        Assert.assertEquals((long)rowIndex, (long)2L);
        ri.close();
        qr.close();
    }

    private ScriptDataSetDesign newDataSet() {
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setOpenScript("count=11;");
        dataSet.setFetchScript("count--;if (count==0) {return false; } else { if(count > 5 && count < 8)row.CH=null;else row.CH = \"HELLO\"; return true; }");
        dataSet.getResultSetHints().add(new ColumnDefinition("CH"));
        return dataSet;
    }
}

