/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.mysql.catalog.loaders;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableIndexLoader;
import org.eclipse.datatools.enablement.mysql.catalog.MySqlCatalogIndex;
import org.eclipse.datatools.enablement.mysql.catalog.MySqlCatalogTable;
import org.eclipse.datatools.modelbase.sql.constraints.IncrementType;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;

public class MySqlTableIndexLoader
extends JDBCTableIndexLoader {
    public MySqlTableIndexLoader() {
        super(null, null);
    }

    protected ResultSet createResultSet() throws SQLException {
        return this.getCatalogObject().getConnection().getMetaData().getIndexInfo(null, null, this.getTable().getName(), false, false);
    }

    protected Schema findSchema(String schemaName) {
        if (schemaName == null) {
            return this.getTable().getSchema();
        }
        Table table = this.getTable();
        if (schemaName.equals(table.getSchema().getName())) {
            return table.getSchema();
        }
        for (Schema schema : table.getSchema().getDatabase().getSchemas()) {
            if (!schemaName.equals(schema.getName())) continue;
            return schema;
        }
        return table.getSchema();
    }

    public void loadIndexes(List containmentList, Collection existingIndexes) throws SQLException {
        ResultSet rs = null;
        try {
            this.initActiveFilter();
            Index index = null;
            PrimaryKey pk = ((MySqlCatalogTable)this.getTable()).getPrimaryKey();
            rs = this.createResultSet();
            while (rs.next()) {
                IndexMember im;
                String indexName = rs.getString("INDEX_NAME");
                if (indexName == null || this.isFiltered(indexName) || rs.getShort("TYPE") == 0) continue;
                String indName = rs.getString(6);
                if (pk != null && indName.equalsIgnoreCase(pk.getName())) continue;
                indexName = indName;
                index = (Index)this.getAndRemoveSQLObject(existingIndexes, indexName);
                if (index == null) {
                    index = this.createIndex();
                    this.initIndex(index, rs);
                } else {
                    this.initIndex(index, rs);
                    index.getMembers().clear();
                    if (index instanceof ICatalogObject) {
                        ((ICatalogObject)index).refresh();
                    }
                }
                index.setName(indName);
                index.setSchema(this.getTable().getSchema());
                boolean isUnqiue = !rs.getBoolean(4);
                index.setUnique(isUnqiue);
                short type = rs.getShort(7);
                if (type == 1) {
                    index.setClustered(true);
                }
                containmentList.add(index);
                String column_name = rs.getString(9);
                Column column = this.findColumn(rs.getString("COLUMN_NAME"));
                if (column == null || (im = this.createIndexMember()) == null) continue;
                this.initIndexMember(im, column, rs);
                im.setColumn(this.findTableColumn(this.getTable(), column_name));
                String order = rs.getString(10);
                if (order.equals("A")) {
                    im.setIncrementType(IncrementType.ASC_LITERAL);
                } else if (order.equals("D")) {
                    im.setIncrementType(IncrementType.DESC_LITERAL);
                }
                index.getMembers().add((Object)im);
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                this.closeResultSet(rs);
            }
            throw throwable;
        }
        if (rs != null) {
            this.closeResultSet(rs);
        }
    }

    protected Index createIndex() {
        return new MySqlCatalogIndex();
    }

    private Column findTableColumn(Table table, String name) {
        EList columns = table.getColumns();
        ListIterator iterator = columns.listIterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (!column.getName().equals(name)) continue;
            return column;
        }
        return null;
    }
}

