/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.commands;

import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.metaabm.SAgent;
import org.metaabm.act.AAct;
import org.metaabm.act.AGroup;
import org.metaabm.act.AInput;
import org.metaabm.act.ARoot;
import org.metaabm.act.ASink;
import org.metaabm.act.MetaABMActPackage;

public class AgentCleanup
extends Job {
    EditingDomain domain;
    SAgent agent;
    CompoundCommand command;

    public AgentCleanup(EditingDomain domain, SAgent agent) {
        super("Import agent");
        this.domain = domain;
        this.agent = agent;
        this.command = new CompoundCommand("Remove Orphans from " + agent.getLabel());
    }

    protected IStatus run(IProgressMonitor monitor) {
        AGroup rootActivity = (AGroup)this.agent.getRootActivity();
        EList acts = rootActivity.getMembers();
        HashSet<AAct> orphans = new HashSet<AAct>();
        for (AAct act : acts) {
            if (act instanceof AGroup || act instanceof ARoot || act.getSources().size() != 0) continue;
            orphans.add(act);
            if (act instanceof ASink) {
                for (AInput input : ((ASink)act).getInputs()) {
                    this.command.appendIfCanExecute(SetCommand.create((EditingDomain)this.domain, (Object)input, (Object)MetaABMActPackage.Literals.AINPUT__VALUE, null));
                    this.command.appendIfCanExecute(SetCommand.create((EditingDomain)this.domain, (Object)input, (Object)MetaABMActPackage.Literals.AINPUT__LITERAL, null));
                    this.command.appendIfCanExecute(SetCommand.create((EditingDomain)this.domain, (Object)input, (Object)MetaABMActPackage.Literals.AINPUT__SELECTED, null));
                }
            }
            this.command.appendIfCanExecute(SetCommand.create((EditingDomain)this.domain, (Object)act, (Object)MetaABMActPackage.Literals.AACT__SELECTED, null));
        }
        this.command.appendIfCanExecute(RemoveCommand.create((EditingDomain)this.domain, (Object)rootActivity, (Object)MetaABMActPackage.Literals.AGROUP__MEMBERS, orphans));
        if (this.command.canExecute()) {
            this.domain.getCommandStack().execute((Command)this.command);
        }
        return Status.OK_STATUS;
    }
}

