/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy;

import java.util.Iterator;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.iterator.TakeIterator;

public class TakeIterable<T>
extends AbstractLazyIterable<T> {
    private final Iterable<T> adapted;
    private final int count;

    public TakeIterable(Iterable<T> newAdapted, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        this.adapted = newAdapted;
        this.count = count;
    }

    public void each(Procedure<? super T> procedure) {
        Iterator<T> iterator = this.adapted.iterator();
        for (int i = 0; i < this.count && iterator.hasNext(); ++i) {
            procedure.value(iterator.next());
        }
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> procedure) {
        Iterator<T> iterator = this.adapted.iterator();
        for (int i = 0; i < this.count && iterator.hasNext(); ++i) {
            procedure.value(iterator.next(), i);
        }
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        Iterator<T> iterator = this.adapted.iterator();
        for (int i = 0; i < this.count && iterator.hasNext(); ++i) {
            procedure.value(iterator.next(), parameter);
        }
    }

    public Iterator<T> iterator() {
        return new TakeIterator<T>(this.adapted, this.count);
    }
}

