/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;

class ViewPaneOrientationAction
extends Action {
    private final MemoryView fView;
    private final int fOrientation;

    ViewPaneOrientationAction(MemoryView view, int orientation) {
        super("", 8);
        this.fView = view;
        this.fOrientation = orientation;
        if (orientation == 0) {
            this.setText(DebugUIMessages.ViewPaneOrientationAction_0);
            this.setToolTipText(DebugUIMessages.ViewPaneOrientationAction_1);
            this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_DETAIL_PANE_RIGHT"));
            this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_DETAIL_PANE_RIGHT"));
            this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_DETAIL_PANE_RIGHT"));
        } else if (orientation == 1) {
            this.setText(DebugUIMessages.ViewPaneOrientationAction_2);
            this.setToolTipText(DebugUIMessages.ViewPaneOrientationAction_3);
            this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_DETAIL_PANE_UNDER"));
            this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_DETAIL_PANE_UNDER"));
            this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_DETAIL_PANE_UNDER"));
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.memory_view_pane_orientation_action_context");
    }

    public void run() {
        this.fView.setViewPanesOrientation(this.fOrientation);
    }

    public int getOrientation() {
        return this.fOrientation;
    }
}

