/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStorageEvent.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDictionary.h"
#include "JSStorage.h"
#include "KURL.h"
#include "Storage.h"
#include "StorageEvent.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSStorageEventTableValues[] =
{
    { "key", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageEventKey), (intptr_t)0, NoIntrinsic },
    { "oldValue", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageEventOldValue), (intptr_t)0, NoIntrinsic },
    { "newValue", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageEventNewValue), (intptr_t)0, NoIntrinsic },
    { "url", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageEventUrl), (intptr_t)0, NoIntrinsic },
    { "storageArea", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageEventStorageArea), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSStorageEventTable = { 16, 15, JSStorageEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSStorageEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSStorageEventConstructorTable = { 1, 0, JSStorageEventConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSStorageEventConstructor::constructJSStorageEvent(ExecState* exec)
{
    JSStorageEventConstructor* jsConstructor = jsCast<JSStorageEventConstructor*>(exec->callee());

    ScriptExecutionContext* executionContext = jsConstructor->scriptExecutionContext();
    if (!executionContext)
        return throwVMError(exec, createReferenceError(exec, "Constructor associated execution context is unavailable"));

    AtomicString eventType = exec->argument(0).toString(exec)->value(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    StorageEventInit eventInit;

    JSValue initializerValue = exec->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(exec);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(exec, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillStorageEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<StorageEvent> event = StorageEvent::create(eventType, eventInit);
    return JSValue::encode(toJS(exec, jsConstructor->globalObject(), event.get()));
}

bool fillStorageEventInit(StorageEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("key", eventInit.key))
        return false;
    if (!dictionary.tryGetProperty("oldValue", eventInit.oldValue))
        return false;
    if (!dictionary.tryGetProperty("newValue", eventInit.newValue))
        return false;
    if (!dictionary.tryGetProperty("url", eventInit.url))
        return false;
    if (!dictionary.tryGetProperty("storageArea", eventInit.storageArea))
        return false;
    return true;
}

const ClassInfo JSStorageEventConstructor::s_info = { "StorageEventConstructor", &Base::s_info, &JSStorageEventConstructorTable, 0, CREATE_METHOD_TABLE(JSStorageEventConstructor) };

JSStorageEventConstructor::JSStorageEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSStorageEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSStorageEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(1), ReadOnly | DontDelete | DontEnum);
}

bool JSStorageEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSStorageEventConstructor, JSDOMWrapper>(exec, &JSStorageEventConstructorTable, jsCast<JSStorageEventConstructor*>(cell), propertyName, slot);
}

bool JSStorageEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSStorageEventConstructor, JSDOMWrapper>(exec, &JSStorageEventConstructorTable, jsCast<JSStorageEventConstructor*>(object), propertyName, descriptor);
}

ConstructType JSStorageEventConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSStorageEvent;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSStorageEventPrototypeTableValues[] =
{
    { "initStorageEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsStorageEventPrototypeFunctionInitStorageEvent), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSStorageEventPrototypeTable = { 2, 1, JSStorageEventPrototypeTableValues, 0 };
const ClassInfo JSStorageEventPrototype::s_info = { "StorageEventPrototype", &Base::s_info, &JSStorageEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSStorageEventPrototype) };

JSObject* JSStorageEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSStorageEvent>(exec, globalObject);
}

bool JSStorageEventPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSStorageEventPrototype* thisObject = jsCast<JSStorageEventPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSStorageEventPrototypeTable, thisObject, propertyName, slot);
}

bool JSStorageEventPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSStorageEventPrototype* thisObject = jsCast<JSStorageEventPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSStorageEventPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSStorageEvent::s_info = { "StorageEvent", &Base::s_info, &JSStorageEventTable, 0 , CREATE_METHOD_TABLE(JSStorageEvent) };

JSStorageEvent::JSStorageEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<StorageEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSStorageEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSStorageEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSStorageEventPrototype::create(exec->vm(), globalObject, JSStorageEventPrototype::createStructure(exec->vm(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSStorageEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSStorageEvent* thisObject = jsCast<JSStorageEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSStorageEvent, Base>(exec, &JSStorageEventTable, thisObject, propertyName, slot);
}

bool JSStorageEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSStorageEvent* thisObject = jsCast<JSStorageEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSStorageEvent, Base>(exec, &JSStorageEventTable, thisObject, propertyName, descriptor);
}

JSValue jsStorageEventKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSStorageEvent* castedThis = jsCast<JSStorageEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    StorageEvent* impl = static_cast<StorageEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->key());
    return result;
}


JSValue jsStorageEventOldValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSStorageEvent* castedThis = jsCast<JSStorageEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    StorageEvent* impl = static_cast<StorageEvent*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->oldValue());
    return result;
}


JSValue jsStorageEventNewValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSStorageEvent* castedThis = jsCast<JSStorageEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    StorageEvent* impl = static_cast<StorageEvent*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->newValue());
    return result;
}


JSValue jsStorageEventUrl(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSStorageEvent* castedThis = jsCast<JSStorageEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    StorageEvent* impl = static_cast<StorageEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->url());
    return result;
}


JSValue jsStorageEventStorageArea(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSStorageEvent* castedThis = jsCast<JSStorageEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    StorageEvent* impl = static_cast<StorageEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->storageArea()));
    return result;
}


JSValue jsStorageEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSStorageEvent* domObject = jsCast<JSStorageEvent*>(asObject(slotBase));
    return JSStorageEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSStorageEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSStorageEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsStorageEventPrototypeFunctionInitStorageEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSStorageEvent::s_info))
        return throwVMTypeError(exec);
    JSStorageEvent* castedThis = jsCast<JSStorageEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSStorageEvent::s_info);
    StorageEvent* impl = static_cast<StorageEvent*>(castedThis->impl());
    const String& typeArg(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool canBubbleArg(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool cancelableArg(exec->argument(2).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& keyArg(exec->argument(3).isEmpty() ? String() : exec->argument(3).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& oldValueArg(valueToStringWithNullCheck(exec, exec->argument(4)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& newValueArg(valueToStringWithNullCheck(exec, exec->argument(5)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& urlArg(exec->argument(6).isEmpty() ? String() : exec->argument(6).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Storage* storageAreaArg(toStorage(exec->argument(7)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->initStorageEvent(typeArg, canBubbleArg, cancelableArg, keyArg, oldValueArg, newValueArg, urlArg, storageAreaArg);
    return JSValue::encode(jsUndefined());
}


}
