/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPathElement.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGPathSegArcAbs.h"
#include "JSSVGPathSegArcRel.h"
#include "JSSVGPathSegClosePath.h"
#include "JSSVGPathSegCurvetoCubicAbs.h"
#include "JSSVGPathSegCurvetoCubicRel.h"
#include "JSSVGPathSegCurvetoCubicSmoothAbs.h"
#include "JSSVGPathSegCurvetoCubicSmoothRel.h"
#include "JSSVGPathSegCurvetoQuadraticAbs.h"
#include "JSSVGPathSegCurvetoQuadraticRel.h"
#include "JSSVGPathSegCurvetoQuadraticSmoothAbs.h"
#include "JSSVGPathSegCurvetoQuadraticSmoothRel.h"
#include "JSSVGPathSegLinetoAbs.h"
#include "JSSVGPathSegLinetoHorizontalAbs.h"
#include "JSSVGPathSegLinetoHorizontalRel.h"
#include "JSSVGPathSegLinetoRel.h"
#include "JSSVGPathSegLinetoVerticalAbs.h"
#include "JSSVGPathSegLinetoVerticalRel.h"
#include "JSSVGPathSegList.h"
#include "JSSVGPathSegMovetoAbs.h"
#include "JSSVGPathSegMovetoRel.h"
#include "JSSVGPoint.h"
#include "SVGPathElement.h"
#include "SVGPathSegArcAbs.h"
#include "SVGPathSegArcRel.h"
#include "SVGPathSegClosePath.h"
#include "SVGPathSegCurvetoCubicAbs.h"
#include "SVGPathSegCurvetoCubicRel.h"
#include "SVGPathSegCurvetoCubicSmoothAbs.h"
#include "SVGPathSegCurvetoCubicSmoothRel.h"
#include "SVGPathSegCurvetoQuadraticAbs.h"
#include "SVGPathSegCurvetoQuadraticRel.h"
#include "SVGPathSegCurvetoQuadraticSmoothAbs.h"
#include "SVGPathSegCurvetoQuadraticSmoothRel.h"
#include "SVGPathSegLinetoAbs.h"
#include "SVGPathSegLinetoHorizontalAbs.h"
#include "SVGPathSegLinetoHorizontalRel.h"
#include "SVGPathSegLinetoRel.h"
#include "SVGPathSegLinetoVerticalAbs.h"
#include "SVGPathSegLinetoVerticalRel.h"
#include "SVGPathSegList.h"
#include "SVGPathSegMovetoAbs.h"
#include "SVGPathSegMovetoRel.h"
#include "SVGPoint.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

#if ENABLE(SVG)
#include "JSSVGAnimatedBoolean.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGPathElementTableValues[] =
{
    { "pathLength", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementPathLength), (intptr_t)0, NoIntrinsic },
    { "pathSegList", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementPathSegList), (intptr_t)0, NoIntrinsic },
    { "normalizedPathSegList", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementNormalizedPathSegList), (intptr_t)0, NoIntrinsic },
    { "animatedPathSegList", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementAnimatedPathSegList), (intptr_t)0, NoIntrinsic },
    { "animatedNormalizedPathSegList", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementAnimatedNormalizedPathSegList), (intptr_t)0, NoIntrinsic },
#if ENABLE(SVG)
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathElementTable = { 18, 15, JSSVGPathElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGPathElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathElementConstructorTable = { 1, 0, JSSVGPathElementConstructorTableValues, 0 };
const ClassInfo JSSVGPathElementConstructor::s_info = { "SVGPathElementConstructor", &Base::s_info, &JSSVGPathElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGPathElementConstructor) };

JSSVGPathElementConstructor::JSSVGPathElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGPathElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGPathElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGPathElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPathElementConstructor, JSDOMWrapper>(exec, &JSSVGPathElementConstructorTable, jsCast<JSSVGPathElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGPathElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPathElementConstructor, JSDOMWrapper>(exec, &JSSVGPathElementConstructorTable, jsCast<JSSVGPathElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPathElementPrototypeTableValues[] =
{
    { "getTotalLength", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionGetTotalLength), (intptr_t)0, NoIntrinsic },
    { "getPointAtLength", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionGetPointAtLength), (intptr_t)0, NoIntrinsic },
    { "getPathSegAtLength", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionGetPathSegAtLength), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegClosePath", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegClosePath), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegMovetoAbs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegMovetoAbs), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegMovetoRel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegMovetoRel), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegLinetoAbs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoAbs), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegLinetoRel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoRel), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegCurvetoCubicAbs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicAbs), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegCurvetoCubicRel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicRel), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegCurvetoQuadraticAbs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticAbs), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegCurvetoQuadraticRel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticRel), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegArcAbs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegArcAbs), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegArcRel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegArcRel), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegLinetoHorizontalAbs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoHorizontalAbs), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegLinetoHorizontalRel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoHorizontalRel), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegLinetoVerticalAbs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoVerticalAbs), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegLinetoVerticalRel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoVerticalRel), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegCurvetoCubicSmoothAbs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicSmoothAbs), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegCurvetoCubicSmoothRel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicSmoothRel), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegCurvetoQuadraticSmoothAbs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticSmoothAbs), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegCurvetoQuadraticSmoothRel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticSmoothRel), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathElementPrototypeTable = { 67, 63, JSSVGPathElementPrototypeTableValues, 0 };
const ClassInfo JSSVGPathElementPrototype::s_info = { "SVGPathElementPrototype", &Base::s_info, &JSSVGPathElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGPathElementPrototype) };

JSObject* JSSVGPathElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPathElement>(exec, globalObject);
}

bool JSSVGPathElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPathElementPrototype* thisObject = jsCast<JSSVGPathElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGPathElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGPathElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPathElementPrototype* thisObject = jsCast<JSSVGPathElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGPathElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGPathElement::s_info = { "SVGPathElement", &Base::s_info, &JSSVGPathElementTable, 0 , CREATE_METHOD_TABLE(JSSVGPathElement) };

JSSVGPathElement::JSSVGPathElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPathElement> impl)
    : JSSVGGraphicsElement(structure, globalObject, impl)
{
}

void JSSVGPathElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGPathElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGPathElementPrototype::create(exec->vm(), globalObject, JSSVGPathElementPrototype::createStructure(exec->vm(), globalObject, JSSVGGraphicsElementPrototype::self(exec, globalObject)));
}

bool JSSVGPathElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPathElement* thisObject = jsCast<JSSVGPathElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGPathElement, Base>(exec, &JSSVGPathElementTable, thisObject, propertyName, slot);
}

bool JSSVGPathElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPathElement* thisObject = jsCast<JSSVGPathElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGPathElement, Base>(exec, &JSSVGPathElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGPathElementPathLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->pathLengthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGPathElementPathSegList(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGPathSegListPropertyTearOff*>(impl->pathSegList().get())));
    return result;
}


JSValue jsSVGPathElementNormalizedPathSegList(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGPathSegListPropertyTearOff*>(impl->normalizedPathSegList().get())));
    return result;
}


JSValue jsSVGPathElementAnimatedPathSegList(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGPathSegListPropertyTearOff*>(impl->animatedPathSegList().get())));
    return result;
}


JSValue jsSVGPathElementAnimatedNormalizedPathSegList(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGPathSegListPropertyTearOff*>(impl->animatedNormalizedPathSegList().get())));
    return result;
}


#if ENABLE(SVG)
JSValue jsSVGPathElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

JSValue jsSVGPathElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* domObject = jsCast<JSSVGPathElement*>(asObject(slotBase));
    return JSSVGPathElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGPathElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionGetTotalLength(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());

    JSC::JSValue result = jsNumber(impl->getTotalLength());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionGetPointAtLength(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float distance(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGPoint>::create(impl->getPointAtLength(distance))));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionGetPathSegAtLength(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float distance(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->getPathSegAtLength(distance));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegClosePath(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegClosePath()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegMovetoAbs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegMovetoAbs(x, y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegMovetoRel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegMovetoRel(x, y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoAbs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegLinetoAbs(x, y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoRel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegLinetoRel(x, y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicAbs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x1(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y1(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x2(exec->argument(4).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y2(exec->argument(5).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegCurvetoCubicAbs(x, y, x1, y1, x2, y2)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicRel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x1(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y1(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x2(exec->argument(4).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y2(exec->argument(5).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegCurvetoCubicRel(x, y, x1, y1, x2, y2)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticAbs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x1(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y1(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegCurvetoQuadraticAbs(x, y, x1, y1)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticRel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x1(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y1(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegCurvetoQuadraticRel(x, y, x1, y1)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegArcAbs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float r1(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float r2(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float angle(exec->argument(4).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool largeArcFlag(exec->argument(5).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool sweepFlag(exec->argument(6).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegArcAbs(x, y, r1, r2, angle, largeArcFlag, sweepFlag)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegArcRel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float r1(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float r2(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float angle(exec->argument(4).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool largeArcFlag(exec->argument(5).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool sweepFlag(exec->argument(6).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegArcRel(x, y, r1, r2, angle, largeArcFlag, sweepFlag)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoHorizontalAbs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegLinetoHorizontalAbs(x)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoHorizontalRel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegLinetoHorizontalRel(x)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoVerticalAbs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float y(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegLinetoVerticalAbs(y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoVerticalRel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float y(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegLinetoVerticalRel(y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicSmoothAbs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x2(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y2(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegCurvetoCubicSmoothAbs(x, y, x2, y2)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicSmoothRel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x2(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y2(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegCurvetoCubicSmoothRel(x, y, x2, y2)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticSmoothAbs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegCurvetoQuadraticSmoothAbs(x, y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticSmoothRel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegCurvetoQuadraticSmoothRel(x, y)));
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
