/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGImageElement.h"

#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "SVGImageElement.h"
#include <wtf/GetPtr.h>

#if ENABLE(SVG)
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedString.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGImageElementTableValues[] =
{
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGImageElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGImageElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGImageElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGImageElementHeight), (intptr_t)0, NoIntrinsic },
    { "preserveAspectRatio", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGImageElementPreserveAspectRatio), (intptr_t)0, NoIntrinsic },
#if ENABLE(SVG)
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGImageElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(SVG)
    { "href", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGImageElementHref), (intptr_t)0, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGImageElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGImageElementTable = { 18, 15, JSSVGImageElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGImageElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGImageElementConstructorTable = { 1, 0, JSSVGImageElementConstructorTableValues, 0 };
const ClassInfo JSSVGImageElementConstructor::s_info = { "SVGImageElementConstructor", &Base::s_info, &JSSVGImageElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGImageElementConstructor) };

JSSVGImageElementConstructor::JSSVGImageElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGImageElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGImageElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGImageElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGImageElementConstructor, JSDOMWrapper>(exec, &JSSVGImageElementConstructorTable, jsCast<JSSVGImageElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGImageElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGImageElementConstructor, JSDOMWrapper>(exec, &JSSVGImageElementConstructorTable, jsCast<JSSVGImageElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGImageElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGImageElementPrototypeTable = { 1, 0, JSSVGImageElementPrototypeTableValues, 0 };
const ClassInfo JSSVGImageElementPrototype::s_info = { "SVGImageElementPrototype", &Base::s_info, &JSSVGImageElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGImageElementPrototype) };

JSObject* JSSVGImageElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGImageElement>(exec, globalObject);
}

const ClassInfo JSSVGImageElement::s_info = { "SVGImageElement", &Base::s_info, &JSSVGImageElementTable, 0 , CREATE_METHOD_TABLE(JSSVGImageElement) };

JSSVGImageElement::JSSVGImageElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGImageElement> impl)
    : JSSVGGraphicsElement(structure, globalObject, impl)
{
}

void JSSVGImageElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGImageElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGImageElementPrototype::create(exec->vm(), globalObject, JSSVGImageElementPrototype::createStructure(exec->vm(), globalObject, JSSVGGraphicsElementPrototype::self(exec, globalObject)));
}

bool JSSVGImageElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGImageElement* thisObject = jsCast<JSSVGImageElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGImageElement, Base>(exec, &JSSVGImageElementTable, thisObject, propertyName, slot);
}

bool JSSVGImageElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGImageElement* thisObject = jsCast<JSSVGImageElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGImageElement, Base>(exec, &JSSVGImageElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGImageElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGImageElement* castedThis = jsCast<JSSVGImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGImageElement* impl = static_cast<SVGImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGImageElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGImageElement* castedThis = jsCast<JSSVGImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGImageElement* impl = static_cast<SVGImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGImageElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGImageElement* castedThis = jsCast<JSSVGImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGImageElement* impl = static_cast<SVGImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGImageElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGImageElement* castedThis = jsCast<JSSVGImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGImageElement* impl = static_cast<SVGImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGImageElementPreserveAspectRatio(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGImageElement* castedThis = jsCast<JSSVGImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGImageElement* impl = static_cast<SVGImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedPreserveAspectRatio> obj = impl->preserveAspectRatioAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


#if ENABLE(SVG)
JSValue jsSVGImageElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGImageElement* castedThis = jsCast<JSSVGImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGImageElement* impl = static_cast<SVGImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

#if ENABLE(SVG)
JSValue jsSVGImageElementHref(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGImageElement* castedThis = jsCast<JSSVGImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGImageElement* impl = static_cast<SVGImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

JSValue jsSVGImageElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGImageElement* domObject = jsCast<JSSVGImageElement*>(asObject(slotBase));
    return JSSVGImageElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGImageElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGImageElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
