/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGAnimatedInteger.h"

#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGAnimatedIntegerTableValues[] =
{
    { "baseVal", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedIntegerBaseVal), (intptr_t)setJSSVGAnimatedIntegerBaseVal, NoIntrinsic },
    { "animVal", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedIntegerAnimVal), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedIntegerConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedIntegerTable = { 8, 7, JSSVGAnimatedIntegerTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGAnimatedIntegerConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedIntegerConstructorTable = { 1, 0, JSSVGAnimatedIntegerConstructorTableValues, 0 };
const ClassInfo JSSVGAnimatedIntegerConstructor::s_info = { "SVGAnimatedIntegerConstructor", &Base::s_info, &JSSVGAnimatedIntegerConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGAnimatedIntegerConstructor) };

JSSVGAnimatedIntegerConstructor::JSSVGAnimatedIntegerConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGAnimatedIntegerConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGAnimatedIntegerPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGAnimatedIntegerConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedIntegerConstructor, JSDOMWrapper>(exec, &JSSVGAnimatedIntegerConstructorTable, jsCast<JSSVGAnimatedIntegerConstructor*>(cell), propertyName, slot);
}

bool JSSVGAnimatedIntegerConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAnimatedIntegerConstructor, JSDOMWrapper>(exec, &JSSVGAnimatedIntegerConstructorTable, jsCast<JSSVGAnimatedIntegerConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedIntegerPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedIntegerPrototypeTable = { 1, 0, JSSVGAnimatedIntegerPrototypeTableValues, 0 };
const ClassInfo JSSVGAnimatedIntegerPrototype::s_info = { "SVGAnimatedIntegerPrototype", &Base::s_info, &JSSVGAnimatedIntegerPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGAnimatedIntegerPrototype) };

JSObject* JSSVGAnimatedIntegerPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimatedInteger>(exec, globalObject);
}

const ClassInfo JSSVGAnimatedInteger::s_info = { "SVGAnimatedInteger", &Base::s_info, &JSSVGAnimatedIntegerTable, 0 , CREATE_METHOD_TABLE(JSSVGAnimatedInteger) };

JSSVGAnimatedInteger::JSSVGAnimatedInteger(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAnimatedInteger> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGAnimatedInteger::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGAnimatedInteger::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGAnimatedIntegerPrototype::create(exec->vm(), globalObject, JSSVGAnimatedIntegerPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSVGAnimatedInteger::destroy(JSC::JSCell* cell)
{
    JSSVGAnimatedInteger* thisObject = static_cast<JSSVGAnimatedInteger*>(cell);
    thisObject->JSSVGAnimatedInteger::~JSSVGAnimatedInteger();
}

JSSVGAnimatedInteger::~JSSVGAnimatedInteger()
{
    releaseImplIfNotNull();
}

bool JSSVGAnimatedInteger::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGAnimatedInteger* thisObject = jsCast<JSSVGAnimatedInteger*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGAnimatedInteger, Base>(exec, &JSSVGAnimatedIntegerTable, thisObject, propertyName, slot);
}

bool JSSVGAnimatedInteger::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGAnimatedInteger* thisObject = jsCast<JSSVGAnimatedInteger*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGAnimatedInteger, Base>(exec, &JSSVGAnimatedIntegerTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGAnimatedIntegerBaseVal(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedInteger* castedThis = jsCast<JSSVGAnimatedInteger*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedInteger* impl = static_cast<SVGAnimatedInteger*>(castedThis->impl());
    JSValue result = jsNumber(impl->baseVal());
    return result;
}


JSValue jsSVGAnimatedIntegerAnimVal(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedInteger* castedThis = jsCast<JSSVGAnimatedInteger*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedInteger* impl = static_cast<SVGAnimatedInteger*>(castedThis->impl());
    JSValue result = jsNumber(impl->animVal());
    return result;
}


JSValue jsSVGAnimatedIntegerConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedInteger* domObject = jsCast<JSSVGAnimatedInteger*>(asObject(slotBase));
    return JSSVGAnimatedInteger::getConstructor(exec, domObject->globalObject());
}

void JSSVGAnimatedInteger::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGAnimatedInteger* thisObject = jsCast<JSSVGAnimatedInteger*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGAnimatedInteger, Base>(exec, propertyName, value, &JSSVGAnimatedIntegerTable, thisObject, slot);
}

void setJSSVGAnimatedIntegerBaseVal(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGAnimatedInteger* castedThis = jsCast<JSSVGAnimatedInteger*>(thisObject);
    SVGAnimatedInteger* impl = static_cast<SVGAnimatedInteger*>(castedThis->impl());
    ExceptionCode ec = 0;
    int nativeValue(toInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setBaseVal(nativeValue, ec);
    setDOMException(exec, ec);
}


JSValue JSSVGAnimatedInteger::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimatedIntegerConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSSVGAnimatedInteger* jsSVGAnimatedInteger)
{
    if (jsSVGAnimatedInteger->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGAnimatedIntegerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGAnimatedInteger* jsSVGAnimatedInteger = jsCast<JSSVGAnimatedInteger*>(handle.get().asCell());
    if (!isObservable(jsSVGAnimatedInteger))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGAnimatedIntegerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGAnimatedInteger* jsSVGAnimatedInteger = jsCast<JSSVGAnimatedInteger*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGAnimatedInteger->impl(), jsSVGAnimatedInteger);
    jsSVGAnimatedInteger->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGAnimatedInteger* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGAnimatedInteger>(exec, impl))
        return result;
    ReportMemoryCost<SVGAnimatedInteger>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSVGAnimatedInteger>(exec, globalObject, impl);
}

SVGAnimatedInteger* toSVGAnimatedInteger(JSC::JSValue value)
{
    return value.inherits(&JSSVGAnimatedInteger::s_info) ? jsCast<JSSVGAnimatedInteger*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
