/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSElement.h"

#include "Attr.h"
#include "CSSStyleDeclaration.h"
#include "ClientRect.h"
#include "ClientRectList.h"
#include "DOMStringMap.h"
#include "DOMTokenList.h"
#include "Element.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSAttr.h"
#include "JSCSSStyleDeclaration.h"
#include "JSClientRect.h"
#include "JSClientRectList.h"
#include "JSDOMBinding.h"
#include "JSDOMStringMap.h"
#include "JSDOMTokenList.h"
#include "JSElement.h"
#include "JSEventListener.h"
#include "JSNamedNodeMap.h"
#include "JSNodeList.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "NamedNodeMap.h"
#include "NodeList.h"
#include "StylePropertySet.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

#if ENABLE(CSS_REGIONS)
#include "JSRange.h"
#include "Range.h"
#include <runtime/JSArray.h>
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSElementTableValues[] =
{
    { "tagName", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementTagName), (intptr_t)0, NoIntrinsic },
    { "attributes", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAttributes), (intptr_t)0, NoIntrinsic },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementStyle), (intptr_t)0, NoIntrinsic },
    { "offsetLeft", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOffsetLeft), (intptr_t)0, NoIntrinsic },
    { "offsetTop", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOffsetTop), (intptr_t)0, NoIntrinsic },
    { "offsetWidth", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOffsetWidth), (intptr_t)0, NoIntrinsic },
    { "offsetHeight", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOffsetHeight), (intptr_t)0, NoIntrinsic },
    { "offsetParent", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOffsetParent), (intptr_t)0, NoIntrinsic },
    { "clientLeft", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementClientLeft), (intptr_t)0, NoIntrinsic },
    { "clientTop", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementClientTop), (intptr_t)0, NoIntrinsic },
    { "clientWidth", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementClientWidth), (intptr_t)0, NoIntrinsic },
    { "clientHeight", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementClientHeight), (intptr_t)0, NoIntrinsic },
    { "scrollLeft", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementScrollLeft), (intptr_t)setJSElementScrollLeft, NoIntrinsic },
    { "scrollTop", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementScrollTop), (intptr_t)setJSElementScrollTop, NoIntrinsic },
    { "scrollWidth", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementScrollWidth), (intptr_t)0, NoIntrinsic },
    { "scrollHeight", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementScrollHeight), (intptr_t)0, NoIntrinsic },
    { "className", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementClassName), (intptr_t)setJSElementClassName, NoIntrinsic },
    { "classList", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementClassList), (intptr_t)0, NoIntrinsic },
    { "dataset", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementDataset), (intptr_t)0, NoIntrinsic },
    { "firstElementChild", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementFirstElementChild), (intptr_t)0, NoIntrinsic },
    { "lastElementChild", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementLastElementChild), (intptr_t)0, NoIntrinsic },
    { "previousElementSibling", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementPreviousElementSibling), (intptr_t)0, NoIntrinsic },
    { "nextElementSibling", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementNextElementSibling), (intptr_t)0, NoIntrinsic },
    { "childElementCount", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementChildElementCount), (intptr_t)0, NoIntrinsic },
#if ENABLE(CSS_REGIONS)
    { "webkitRegionOverset", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementWebkitRegionOverset), (intptr_t)0, NoIntrinsic },
#endif
    { "onabort", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnabort), (intptr_t)setJSElementOnabort, NoIntrinsic },
    { "onblur", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnblur), (intptr_t)setJSElementOnblur, NoIntrinsic },
    { "onchange", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnchange), (intptr_t)setJSElementOnchange, NoIntrinsic },
    { "onclick", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnclick), (intptr_t)setJSElementOnclick, NoIntrinsic },
    { "oncontextmenu", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOncontextmenu), (intptr_t)setJSElementOncontextmenu, NoIntrinsic },
    { "ondblclick", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOndblclick), (intptr_t)setJSElementOndblclick, NoIntrinsic },
    { "ondrag", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOndrag), (intptr_t)setJSElementOndrag, NoIntrinsic },
    { "ondragend", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOndragend), (intptr_t)setJSElementOndragend, NoIntrinsic },
    { "ondragenter", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOndragenter), (intptr_t)setJSElementOndragenter, NoIntrinsic },
    { "ondragleave", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOndragleave), (intptr_t)setJSElementOndragleave, NoIntrinsic },
    { "ondragover", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOndragover), (intptr_t)setJSElementOndragover, NoIntrinsic },
    { "ondragstart", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOndragstart), (intptr_t)setJSElementOndragstart, NoIntrinsic },
    { "ondrop", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOndrop), (intptr_t)setJSElementOndrop, NoIntrinsic },
    { "onerror", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnerror), (intptr_t)setJSElementOnerror, NoIntrinsic },
    { "onfocus", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnfocus), (intptr_t)setJSElementOnfocus, NoIntrinsic },
    { "oninput", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOninput), (intptr_t)setJSElementOninput, NoIntrinsic },
    { "oninvalid", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOninvalid), (intptr_t)setJSElementOninvalid, NoIntrinsic },
    { "onkeydown", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnkeydown), (intptr_t)setJSElementOnkeydown, NoIntrinsic },
    { "onkeypress", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnkeypress), (intptr_t)setJSElementOnkeypress, NoIntrinsic },
    { "onkeyup", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnkeyup), (intptr_t)setJSElementOnkeyup, NoIntrinsic },
    { "onload", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnload), (intptr_t)setJSElementOnload, NoIntrinsic },
    { "onmousedown", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnmousedown), (intptr_t)setJSElementOnmousedown, NoIntrinsic },
    { "onmouseenter", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnmouseenter), (intptr_t)setJSElementOnmouseenter, NoIntrinsic },
    { "onmouseleave", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnmouseleave), (intptr_t)setJSElementOnmouseleave, NoIntrinsic },
    { "onmousemove", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnmousemove), (intptr_t)setJSElementOnmousemove, NoIntrinsic },
    { "onmouseout", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnmouseout), (intptr_t)setJSElementOnmouseout, NoIntrinsic },
    { "onmouseover", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnmouseover), (intptr_t)setJSElementOnmouseover, NoIntrinsic },
    { "onmouseup", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnmouseup), (intptr_t)setJSElementOnmouseup, NoIntrinsic },
    { "onmousewheel", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnmousewheel), (intptr_t)setJSElementOnmousewheel, NoIntrinsic },
    { "onscroll", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnscroll), (intptr_t)setJSElementOnscroll, NoIntrinsic },
    { "onselect", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnselect), (intptr_t)setJSElementOnselect, NoIntrinsic },
    { "onsubmit", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnsubmit), (intptr_t)setJSElementOnsubmit, NoIntrinsic },
    { "onbeforecut", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnbeforecut), (intptr_t)setJSElementOnbeforecut, NoIntrinsic },
    { "oncut", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOncut), (intptr_t)setJSElementOncut, NoIntrinsic },
    { "onbeforecopy", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnbeforecopy), (intptr_t)setJSElementOnbeforecopy, NoIntrinsic },
    { "oncopy", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOncopy), (intptr_t)setJSElementOncopy, NoIntrinsic },
    { "onbeforepaste", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnbeforepaste), (intptr_t)setJSElementOnbeforepaste, NoIntrinsic },
    { "onpaste", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnpaste), (intptr_t)setJSElementOnpaste, NoIntrinsic },
    { "onreset", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnreset), (intptr_t)setJSElementOnreset, NoIntrinsic },
    { "onsearch", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnsearch), (intptr_t)setJSElementOnsearch, NoIntrinsic },
    { "onselectstart", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnselectstart), (intptr_t)setJSElementOnselectstart, NoIntrinsic },
#if ENABLE(TOUCH_EVENTS)
    { "ontouchstart", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOntouchstart), (intptr_t)setJSElementOntouchstart, NoIntrinsic },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchmove", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOntouchmove), (intptr_t)setJSElementOntouchmove, NoIntrinsic },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchend", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOntouchend), (intptr_t)setJSElementOntouchend, NoIntrinsic },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchcancel", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOntouchcancel), (intptr_t)setJSElementOntouchcancel, NoIntrinsic },
#endif
#if ENABLE(FULLSCREEN_API)
    { "onwebkitfullscreenchange", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitfullscreenchange), (intptr_t)setJSElementOnwebkitfullscreenchange, NoIntrinsic },
#endif
#if ENABLE(FULLSCREEN_API)
    { "onwebkitfullscreenerror", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitfullscreenerror), (intptr_t)setJSElementOnwebkitfullscreenerror, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSElementTable = { 266, 255, JSElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSElementConstructorTableValues[] =
{
    { "ALLOW_KEYBOARD_INPUT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementALLOW_KEYBOARD_INPUT), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSElementConstructorTable = { 2, 1, JSElementConstructorTableValues, 0 };

COMPILE_ASSERT(1 == Element::ALLOW_KEYBOARD_INPUT, ElementEnumALLOW_KEYBOARD_INPUTIsWrongUseDoNotCheckConstants);

const ClassInfo JSElementConstructor::s_info = { "ElementConstructor", &Base::s_info, &JSElementConstructorTable, 0, CREATE_METHOD_TABLE(JSElementConstructor) };

JSElementConstructor::JSElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSElementConstructor, JSDOMWrapper>(exec, &JSElementConstructorTable, jsCast<JSElementConstructor*>(cell), propertyName, slot);
}

bool JSElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSElementConstructor, JSDOMWrapper>(exec, &JSElementConstructorTable, jsCast<JSElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSElementPrototypeTableValues[] =
{
    { "ALLOW_KEYBOARD_INPUT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementALLOW_KEYBOARD_INPUT), (intptr_t)0, NoIntrinsic },
    { "getAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionGetAttribute), (intptr_t)0, NoIntrinsic },
    { "setAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionSetAttribute), (intptr_t)0, NoIntrinsic },
    { "removeAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionRemoveAttribute), (intptr_t)0, NoIntrinsic },
    { "getAttributeNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionGetAttributeNode), (intptr_t)0, NoIntrinsic },
    { "setAttributeNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionSetAttributeNode), (intptr_t)0, NoIntrinsic },
    { "removeAttributeNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionRemoveAttributeNode), (intptr_t)0, NoIntrinsic },
    { "getElementsByTagName", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionGetElementsByTagName), (intptr_t)0, NoIntrinsic },
    { "hasAttributes", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionHasAttributes), (intptr_t)0, NoIntrinsic },
    { "getAttributeNS", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionGetAttributeNS), (intptr_t)0, NoIntrinsic },
    { "setAttributeNS", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionSetAttributeNS), (intptr_t)0, NoIntrinsic },
    { "removeAttributeNS", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionRemoveAttributeNS), (intptr_t)2, NoIntrinsic },
    { "getElementsByTagNameNS", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionGetElementsByTagNameNS), (intptr_t)0, NoIntrinsic },
    { "getAttributeNodeNS", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionGetAttributeNodeNS), (intptr_t)0, NoIntrinsic },
    { "setAttributeNodeNS", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionSetAttributeNodeNS), (intptr_t)0, NoIntrinsic },
    { "hasAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionHasAttribute), (intptr_t)1, NoIntrinsic },
    { "hasAttributeNS", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionHasAttributeNS), (intptr_t)0, NoIntrinsic },
    { "focus", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionFocus), (intptr_t)0, NoIntrinsic },
    { "blur", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionBlur), (intptr_t)0, NoIntrinsic },
    { "scrollIntoView", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionScrollIntoView), (intptr_t)0, NoIntrinsic },
    { "scrollIntoViewIfNeeded", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionScrollIntoViewIfNeeded), (intptr_t)0, NoIntrinsic },
    { "scrollByLines", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionScrollByLines), (intptr_t)0, NoIntrinsic },
    { "scrollByPages", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionScrollByPages), (intptr_t)0, NoIntrinsic },
    { "getElementsByClassName", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionGetElementsByClassName), (intptr_t)0, NoIntrinsic },
    { "querySelector", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionQuerySelector), (intptr_t)1, NoIntrinsic },
    { "querySelectorAll", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionQuerySelectorAll), (intptr_t)1, NoIntrinsic },
    { "webkitMatchesSelector", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionWebkitMatchesSelector), (intptr_t)0, NoIntrinsic },
    { "getClientRects", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionGetClientRects), (intptr_t)0, NoIntrinsic },
    { "getBoundingClientRect", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionGetBoundingClientRect), (intptr_t)0, NoIntrinsic },
    { "webkitRequestFullScreen", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionWebkitRequestFullScreen), (intptr_t)0, NoIntrinsic },
    { "webkitRequestFullscreen", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionWebkitRequestFullscreen), (intptr_t)0, NoIntrinsic },
#if ENABLE(POINTER_LOCK)
    { "webkitRequestPointerLock", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionWebkitRequestPointerLock), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(CSS_REGIONS)
    { "webkitGetRegionFlowRanges", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionWebkitGetRegionFlowRanges), (intptr_t)0, NoIntrinsic },
#endif
    { "remove", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionRemove), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSElementPrototypeTable = { 135, 127, JSElementPrototypeTableValues, 0 };
const ClassInfo JSElementPrototype::s_info = { "ElementPrototype", &Base::s_info, &JSElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSElementPrototype) };

JSObject* JSElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSElement>(exec, globalObject);
}

bool JSElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSElementPrototype* thisObject = jsCast<JSElementPrototype*>(cell);
    return getStaticPropertySlot<JSElementPrototype, JSObject>(exec, &JSElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSElementPrototype* thisObject = jsCast<JSElementPrototype*>(object);
    return getStaticPropertyDescriptor<JSElementPrototype, JSObject>(exec, &JSElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSElement::s_info = { "Element", &Base::s_info, &JSElementTable, 0 , CREATE_METHOD_TABLE(JSElement) };

JSElement::JSElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Element> impl)
    : JSNode(structure, globalObject, impl)
{
}

void JSElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSElementPrototype::create(exec->vm(), globalObject, JSElementPrototype::createStructure(exec->vm(), globalObject, JSNodePrototype::self(exec, globalObject)));
}

JSValue jsElementTagName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->tagName());
    return result;
}


JSValue jsElementAttributes(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->attributes()));
    return result;
}


JSValue jsElementStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


JSValue jsElementOffsetLeft(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(impl->offsetLeft());
    return result;
}


JSValue jsElementOffsetTop(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(impl->offsetTop());
    return result;
}


JSValue jsElementOffsetWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(impl->offsetWidth());
    return result;
}


JSValue jsElementOffsetHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(impl->offsetHeight());
    return result;
}


JSValue jsElementOffsetParent(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->bindingsOffsetParent()));
    return result;
}


JSValue jsElementClientLeft(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(impl->clientLeft());
    return result;
}


JSValue jsElementClientTop(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(impl->clientTop());
    return result;
}


JSValue jsElementClientWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(impl->clientWidth());
    return result;
}


JSValue jsElementClientHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(impl->clientHeight());
    return result;
}


JSValue jsElementScrollLeft(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(impl->scrollLeft());
    return result;
}


JSValue jsElementScrollTop(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(impl->scrollTop());
    return result;
}


JSValue jsElementScrollWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(impl->scrollWidth());
    return result;
}


JSValue jsElementScrollHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(impl->scrollHeight());
    return result;
}


JSValue jsElementClassName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::classAttr));
    return result;
}


JSValue jsElementClassList(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->classList()));
    return result;
}


JSValue jsElementDataset(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->dataset()));
    return result;
}


JSValue jsElementFirstElementChild(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->firstElementChild()));
    return result;
}


JSValue jsElementLastElementChild(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->lastElementChild()));
    return result;
}


JSValue jsElementPreviousElementSibling(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->previousElementSibling()));
    return result;
}


JSValue jsElementNextElementSibling(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nextElementSibling()));
    return result;
}


JSValue jsElementChildElementCount(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(impl->childElementCount());
    return result;
}


#if ENABLE(CSS_REGIONS)
JSValue jsElementWebkitRegionOverset(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->webkitRegionOverset());
    return result;
}

#endif

JSValue jsElementOnabort(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onabort()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnblur(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onblur()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnchange(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnclick(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onclick()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOncontextmenu(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->oncontextmenu()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOndblclick(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->ondblclick()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOndrag(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->ondrag()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOndragend(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->ondragend()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOndragenter(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->ondragenter()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOndragleave(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->ondragleave()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOndragover(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->ondragover()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOndragstart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->ondragstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOndrop(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->ondrop()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnerror(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnfocus(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onfocus()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOninput(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->oninput()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOninvalid(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->oninvalid()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnkeydown(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onkeydown()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnkeypress(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onkeypress()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnkeyup(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onkeyup()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnload(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnmousedown(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onmousedown()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnmouseenter(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onmouseenter()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnmouseleave(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onmouseleave()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnmousemove(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onmousemove()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnmouseout(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onmouseout()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnmouseover(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onmouseover()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnmouseup(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onmouseup()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnmousewheel(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onmousewheel()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnscroll(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onscroll()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnselect(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onselect()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnsubmit(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onsubmit()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnbeforecut(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onbeforecut()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOncut(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->oncut()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnbeforecopy(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onbeforecopy()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOncopy(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->oncopy()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnbeforepaste(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onbeforepaste()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnpaste(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onpaste()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnreset(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onreset()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnsearch(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onsearch()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsElementOnselectstart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onselectstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


#if ENABLE(TOUCH_EVENTS)
JSValue jsElementOntouchstart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->ontouchstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

#endif

#if ENABLE(TOUCH_EVENTS)
JSValue jsElementOntouchmove(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->ontouchmove()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

#endif

#if ENABLE(TOUCH_EVENTS)
JSValue jsElementOntouchend(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->ontouchend()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

#endif

#if ENABLE(TOUCH_EVENTS)
JSValue jsElementOntouchcancel(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->ontouchcancel()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

#endif

#if ENABLE(FULLSCREEN_API)
JSValue jsElementOnwebkitfullscreenchange(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onwebkitfullscreenchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

#endif

#if ENABLE(FULLSCREEN_API)
JSValue jsElementOnwebkitfullscreenerror(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* castedThis = jsCast<JSElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = impl->onwebkitfullscreenerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

#endif

JSValue jsElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSElement* domObject = jsCast<JSElement*>(asObject(slotBase));
    return JSElement::getConstructor(exec, domObject->globalObject());
}

void JSElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSElement* thisObject = jsCast<JSElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSElement, Base>(exec, propertyName, value, &JSElementTable, thisObject, slot);
}

void setJSElementScrollLeft(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    int nativeValue(toInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setScrollLeft(nativeValue);
}


void setJSElementScrollTop(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    int nativeValue(toInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setScrollTop(nativeValue);
}


void setJSElementClassName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::classAttr, nativeValue);
}


void setJSElementOnabort(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnabort(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnblur(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnblur(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnchange(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnclick(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnclick(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOncontextmenu(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOncontextmenu(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOndblclick(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOndblclick(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOndrag(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOndrag(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOndragend(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOndragend(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOndragenter(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOndragenter(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOndragleave(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOndragleave(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOndragover(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOndragover(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOndragstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOndragstart(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOndrop(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOndrop(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnfocus(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnfocus(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOninput(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOninput(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOninvalid(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOninvalid(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnkeydown(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnkeydown(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnkeypress(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnkeypress(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnkeyup(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnkeyup(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnload(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnmousedown(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnmousedown(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnmouseenter(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnmouseenter(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnmouseleave(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnmouseleave(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnmousemove(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnmousemove(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnmouseout(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnmouseout(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnmouseover(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnmouseover(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnmouseup(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnmouseup(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnmousewheel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnmousewheel(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnscroll(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnscroll(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnselect(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnselect(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnsubmit(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnsubmit(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnbeforecut(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnbeforecut(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOncut(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOncut(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnbeforecopy(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnbeforecopy(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOncopy(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOncopy(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnbeforepaste(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnbeforepaste(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnpaste(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnpaste(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnreset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnreset(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnsearch(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnsearch(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSElementOnselectstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnselectstart(createJSAttributeEventListener(exec, value, thisObject));
}


#if ENABLE(TOUCH_EVENTS)
void setJSElementOntouchstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOntouchstart(createJSAttributeEventListener(exec, value, thisObject));
}

#endif

#if ENABLE(TOUCH_EVENTS)
void setJSElementOntouchmove(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOntouchmove(createJSAttributeEventListener(exec, value, thisObject));
}

#endif

#if ENABLE(TOUCH_EVENTS)
void setJSElementOntouchend(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOntouchend(createJSAttributeEventListener(exec, value, thisObject));
}

#endif

#if ENABLE(TOUCH_EVENTS)
void setJSElementOntouchcancel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOntouchcancel(createJSAttributeEventListener(exec, value, thisObject));
}

#endif

#if ENABLE(FULLSCREEN_API)
void setJSElementOnwebkitfullscreenchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnwebkitfullscreenchange(createJSAttributeEventListener(exec, value, thisObject));
}

#endif

#if ENABLE(FULLSCREEN_API)
void setJSElementOnwebkitfullscreenerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSElement* castedThis = jsCast<JSElement*>(thisObject);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->setOnwebkitfullscreenerror(createJSAttributeEventListener(exec, value, thisObject));
}

#endif

JSValue JSElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringOrNull(exec, impl->getAttribute(name));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& value(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAttribute(name, value, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemoveAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->removeAttribute(name);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getAttributeNode(name)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttributeNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    ExceptionCode ec = 0;
    Attr* newAttr(toAttr(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->setAttributeNode(newAttr, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemoveAttributeNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    ExceptionCode ec = 0;
    Attr* oldAttr(toAttr(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->removeAttributeNode(oldAttr, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetElementsByTagName(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getElementsByTagName(name)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionHasAttributes(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());

    JSC::JSValue result = jsBoolean(impl->hasAttributes());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNS(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    const String& namespaceURI(valueToStringWithNullCheck(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& localName(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->getAttributeNS(namespaceURI, localName));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttributeNS(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& namespaceURI(valueToStringWithNullCheck(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& qualifiedName(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& value(exec->argument(2).isEmpty() ? String() : exec->argument(2).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAttributeNS(namespaceURI, qualifiedName, value, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemoveAttributeNS(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& namespaceURI(valueToStringWithNullCheck(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& localName(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->removeAttributeNS(namespaceURI, localName);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetElementsByTagNameNS(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    const String& namespaceURI(valueToStringWithNullCheck(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& localName(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getElementsByTagNameNS(namespaceURI, localName)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNodeNS(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    const String& namespaceURI(valueToStringWithNullCheck(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& localName(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getAttributeNodeNS(namespaceURI, localName)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttributeNodeNS(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    ExceptionCode ec = 0;
    Attr* newAttr(toAttr(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->setAttributeNodeNS(newAttr, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionHasAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasAttribute(name));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionHasAttributeNS(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    const String& namespaceURI(valueToStringWithNullCheck(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& localName(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasAttributeNS(namespaceURI, localName));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionFocus(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->focus();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionBlur(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->blur();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollIntoView(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 0) {
        impl->scrollIntoView();
        return JSValue::encode(jsUndefined());
    }

    bool alignWithTop(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->scrollIntoView(alignWithTop);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollIntoViewIfNeeded(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 0) {
        impl->scrollIntoViewIfNeeded();
        return JSValue::encode(jsUndefined());
    }

    bool centerIfNeeded(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->scrollIntoViewIfNeeded(centerIfNeeded);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollByLines(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    int lines(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->scrollByLines(lines);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollByPages(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    int pages(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->scrollByPages(pages);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetElementsByClassName(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getElementsByClassName(name)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionQuerySelector(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& selectors(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->querySelector(selectors, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionQuerySelectorAll(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& selectors(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->querySelectorAll(selectors, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitMatchesSelector(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& selectors(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->webkitMatchesSelector(selectors, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetClientRects(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getClientRects()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetBoundingClientRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getBoundingClientRect()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitRequestFullScreen(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    unsigned short flags(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->webkitRequestFullScreen(flags);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitRequestFullscreen(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->webkitRequestFullscreen();
    return JSValue::encode(jsUndefined());
}

#if ENABLE(POINTER_LOCK)
EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitRequestPointerLock(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    impl->webkitRequestPointerLock();
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(CSS_REGIONS)
EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitGetRegionFlowRanges(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());

    JSC::JSValue result = jsArray(exec, castedThis->globalObject(), impl->webkitGetRegionFlowRanges());
    return JSValue::encode(result);
}

#endif

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemove(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElement::s_info))
        return throwVMTypeError(exec);
    JSElement* castedThis = jsCast<JSElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElement::s_info);
    Element* impl = static_cast<Element*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->remove(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

// Constant getters

JSValue jsElementALLOW_KEYBOARD_INPUT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

Element* toElement(JSC::JSValue value)
{
    return value.inherits(&JSElement::s_info) ? jsCast<JSElement*>(asObject(value))->impl() : 0;
}

}
