/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXMLHttpRequestUpload.h"

#include "Event.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "XMLHttpRequestUpload.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSXMLHttpRequestUploadTableValues[] =
{
    { "onabort", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestUploadOnabort), (intptr_t)setJSXMLHttpRequestUploadOnabort, NoIntrinsic },
    { "onerror", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestUploadOnerror), (intptr_t)setJSXMLHttpRequestUploadOnerror, NoIntrinsic },
    { "onload", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestUploadOnload), (intptr_t)setJSXMLHttpRequestUploadOnload, NoIntrinsic },
    { "onloadend", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestUploadOnloadend), (intptr_t)setJSXMLHttpRequestUploadOnloadend, NoIntrinsic },
    { "onloadstart", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestUploadOnloadstart), (intptr_t)setJSXMLHttpRequestUploadOnloadstart, NoIntrinsic },
    { "onprogress", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestUploadOnprogress), (intptr_t)setJSXMLHttpRequestUploadOnprogress, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestUploadConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXMLHttpRequestUploadTable = { 17, 15, JSXMLHttpRequestUploadTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSXMLHttpRequestUploadConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXMLHttpRequestUploadConstructorTable = { 1, 0, JSXMLHttpRequestUploadConstructorTableValues, 0 };
static const HashTable* getJSXMLHttpRequestUploadConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSXMLHttpRequestUploadConstructorTable);
}

const ClassInfo JSXMLHttpRequestUploadConstructor::s_info = { "XMLHttpRequestUploadConstructor", &Base::s_info, 0, getJSXMLHttpRequestUploadConstructorTable, CREATE_METHOD_TABLE(JSXMLHttpRequestUploadConstructor) };

JSXMLHttpRequestUploadConstructor::JSXMLHttpRequestUploadConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSXMLHttpRequestUploadConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSXMLHttpRequestUploadPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSXMLHttpRequestUploadConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXMLHttpRequestUploadConstructor, JSDOMWrapper>(exec, getJSXMLHttpRequestUploadConstructorTable(exec), jsCast<JSXMLHttpRequestUploadConstructor*>(cell), propertyName, slot);
}

bool JSXMLHttpRequestUploadConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSXMLHttpRequestUploadConstructor, JSDOMWrapper>(exec, getJSXMLHttpRequestUploadConstructorTable(exec), jsCast<JSXMLHttpRequestUploadConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSXMLHttpRequestUploadPrototypeTableValues[] =
{
    { "addEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestUploadPrototypeFunctionAddEventListener), (intptr_t)3, NoIntrinsic },
    { "removeEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestUploadPrototypeFunctionRemoveEventListener), (intptr_t)3, NoIntrinsic },
    { "dispatchEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestUploadPrototypeFunctionDispatchEvent), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXMLHttpRequestUploadPrototypeTable = { 8, 7, JSXMLHttpRequestUploadPrototypeTableValues, 0 };
static const HashTable* getJSXMLHttpRequestUploadPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSXMLHttpRequestUploadPrototypeTable);
}

const ClassInfo JSXMLHttpRequestUploadPrototype::s_info = { "XMLHttpRequestUploadPrototype", &Base::s_info, 0, getJSXMLHttpRequestUploadPrototypeTable, CREATE_METHOD_TABLE(JSXMLHttpRequestUploadPrototype) };

JSObject* JSXMLHttpRequestUploadPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSXMLHttpRequestUpload>(exec, globalObject);
}

bool JSXMLHttpRequestUploadPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSXMLHttpRequestUploadPrototype* thisObject = jsCast<JSXMLHttpRequestUploadPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSXMLHttpRequestUploadPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSXMLHttpRequestUploadPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSXMLHttpRequestUploadPrototype* thisObject = jsCast<JSXMLHttpRequestUploadPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSXMLHttpRequestUploadPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSXMLHttpRequestUploadTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSXMLHttpRequestUploadTable);
}

const ClassInfo JSXMLHttpRequestUpload::s_info = { "XMLHttpRequestUpload", &Base::s_info, 0, getJSXMLHttpRequestUploadTable , CREATE_METHOD_TABLE(JSXMLHttpRequestUpload) };

JSXMLHttpRequestUpload::JSXMLHttpRequestUpload(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<XMLHttpRequestUpload> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSXMLHttpRequestUpload::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSXMLHttpRequestUpload::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSXMLHttpRequestUploadPrototype::create(exec->globalData(), globalObject, JSXMLHttpRequestUploadPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSXMLHttpRequestUpload::destroy(JSC::JSCell* cell)
{
    JSXMLHttpRequestUpload* thisObject = static_cast<JSXMLHttpRequestUpload*>(cell);
    thisObject->JSXMLHttpRequestUpload::~JSXMLHttpRequestUpload();
}

JSXMLHttpRequestUpload::~JSXMLHttpRequestUpload()
{
    releaseImplIfNotNull();
}

bool JSXMLHttpRequestUpload::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSXMLHttpRequestUpload* thisObject = jsCast<JSXMLHttpRequestUpload*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSXMLHttpRequestUpload, Base>(exec, getJSXMLHttpRequestUploadTable(exec), thisObject, propertyName, slot);
}

bool JSXMLHttpRequestUpload::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSXMLHttpRequestUpload* thisObject = jsCast<JSXMLHttpRequestUpload*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSXMLHttpRequestUpload, Base>(exec, getJSXMLHttpRequestUploadTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsXMLHttpRequestUploadOnabort(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXMLHttpRequestUpload* castedThis = jsCast<JSXMLHttpRequestUpload*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XMLHttpRequestUpload* impl = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    if (EventListener* listener = impl->onabort()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsXMLHttpRequestUploadOnerror(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXMLHttpRequestUpload* castedThis = jsCast<JSXMLHttpRequestUpload*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XMLHttpRequestUpload* impl = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    if (EventListener* listener = impl->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsXMLHttpRequestUploadOnload(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXMLHttpRequestUpload* castedThis = jsCast<JSXMLHttpRequestUpload*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XMLHttpRequestUpload* impl = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    if (EventListener* listener = impl->onload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsXMLHttpRequestUploadOnloadend(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXMLHttpRequestUpload* castedThis = jsCast<JSXMLHttpRequestUpload*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XMLHttpRequestUpload* impl = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    if (EventListener* listener = impl->onloadend()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsXMLHttpRequestUploadOnloadstart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXMLHttpRequestUpload* castedThis = jsCast<JSXMLHttpRequestUpload*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XMLHttpRequestUpload* impl = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    if (EventListener* listener = impl->onloadstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsXMLHttpRequestUploadOnprogress(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXMLHttpRequestUpload* castedThis = jsCast<JSXMLHttpRequestUpload*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XMLHttpRequestUpload* impl = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    if (EventListener* listener = impl->onprogress()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsXMLHttpRequestUploadConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXMLHttpRequestUpload* domObject = jsCast<JSXMLHttpRequestUpload*>(asObject(slotBase));
    return JSXMLHttpRequestUpload::getConstructor(exec, domObject->globalObject());
}

void JSXMLHttpRequestUpload::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSXMLHttpRequestUpload* thisObject = jsCast<JSXMLHttpRequestUpload*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSXMLHttpRequestUpload, Base>(exec, propertyName, value, getJSXMLHttpRequestUploadTable(exec), thisObject, slot);
}

void setJSXMLHttpRequestUploadOnabort(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSXMLHttpRequestUpload* castedThis = jsCast<JSXMLHttpRequestUpload*>(thisObject);
    XMLHttpRequestUpload* impl = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    impl->setOnabort(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSXMLHttpRequestUploadOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSXMLHttpRequestUpload* castedThis = jsCast<JSXMLHttpRequestUpload*>(thisObject);
    XMLHttpRequestUpload* impl = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    impl->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSXMLHttpRequestUploadOnload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSXMLHttpRequestUpload* castedThis = jsCast<JSXMLHttpRequestUpload*>(thisObject);
    XMLHttpRequestUpload* impl = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    impl->setOnload(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSXMLHttpRequestUploadOnloadend(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSXMLHttpRequestUpload* castedThis = jsCast<JSXMLHttpRequestUpload*>(thisObject);
    XMLHttpRequestUpload* impl = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    impl->setOnloadend(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSXMLHttpRequestUploadOnloadstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSXMLHttpRequestUpload* castedThis = jsCast<JSXMLHttpRequestUpload*>(thisObject);
    XMLHttpRequestUpload* impl = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    impl->setOnloadstart(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSXMLHttpRequestUploadOnprogress(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSXMLHttpRequestUpload* castedThis = jsCast<JSXMLHttpRequestUpload*>(thisObject);
    XMLHttpRequestUpload* impl = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    impl->setOnprogress(createJSAttributeEventListener(exec, value, thisObject));
}


JSValue JSXMLHttpRequestUpload::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXMLHttpRequestUploadConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestUploadPrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSXMLHttpRequestUpload::s_info))
        return throwVMTypeError(exec);
    JSXMLHttpRequestUpload* castedThis = jsCast<JSXMLHttpRequestUpload*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSXMLHttpRequestUpload::s_info);
    XMLHttpRequestUpload* impl = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->addEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestUploadPrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSXMLHttpRequestUpload::s_info))
        return throwVMTypeError(exec);
    JSXMLHttpRequestUpload* castedThis = jsCast<JSXMLHttpRequestUpload*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSXMLHttpRequestUpload::s_info);
    XMLHttpRequestUpload* impl = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->removeEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestUploadPrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSXMLHttpRequestUpload::s_info))
        return throwVMTypeError(exec);
    JSXMLHttpRequestUpload* castedThis = jsCast<JSXMLHttpRequestUpload*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSXMLHttpRequestUpload::s_info);
    XMLHttpRequestUpload* impl = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Event* evt(toEvent(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

void JSXMLHttpRequestUpload::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    JSXMLHttpRequestUpload* thisObject = jsCast<JSXMLHttpRequestUpload*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(thisObject->structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(thisObject, visitor);
    thisObject->impl()->visitJSEventListeners(visitor);
}

static inline bool isObservable(JSXMLHttpRequestUpload* jsXMLHttpRequestUpload)
{
    if (jsXMLHttpRequestUpload->hasCustomProperties())
        return true;
    if (jsXMLHttpRequestUpload->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSXMLHttpRequestUploadOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSXMLHttpRequestUpload* jsXMLHttpRequestUpload = jsCast<JSXMLHttpRequestUpload*>(handle.get().asCell());
    if (!isObservable(jsXMLHttpRequestUpload))
        return false;
    XMLHttpRequestUpload* root = jsXMLHttpRequestUpload->impl();
    return visitor.containsOpaqueRoot(root);
}

void JSXMLHttpRequestUploadOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSXMLHttpRequestUpload* jsXMLHttpRequestUpload = jsCast<JSXMLHttpRequestUpload*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsXMLHttpRequestUpload->impl(), jsXMLHttpRequestUpload);
    jsXMLHttpRequestUpload->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, XMLHttpRequestUpload* impl)
{
    return wrap<JSXMLHttpRequestUpload>(exec, globalObject, impl);
}

XMLHttpRequestUpload* toXMLHttpRequestUpload(JSC::JSValue value)
{
    return value.inherits(&JSXMLHttpRequestUpload::s_info) ? jsCast<JSXMLHttpRequestUpload*>(asObject(value))->impl() : 0;
}

}
