/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPopStateEvent.h"

#include "JSDictionary.h"
#include "PopStateEvent.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSPopStateEventTableValues[] =
{
    { "state", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPopStateEventState), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPopStateEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPopStateEventTable = { 5, 3, JSPopStateEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSPopStateEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPopStateEventConstructorTable = { 1, 0, JSPopStateEventConstructorTableValues, 0 };
const ClassInfo JSPopStateEventConstructor::s_info = { "PopStateEventConstructor", &Base::s_info, &JSPopStateEventConstructorTable, 0, CREATE_METHOD_TABLE(JSPopStateEventConstructor) };

JSPopStateEventConstructor::JSPopStateEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSPopStateEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSPopStateEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(2), ReadOnly | DontDelete | DontEnum);
}

bool JSPopStateEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPopStateEventConstructor, JSDOMWrapper>(exec, &JSPopStateEventConstructorTable, jsCast<JSPopStateEventConstructor*>(cell), propertyName, slot);
}

bool JSPopStateEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSPopStateEventConstructor, JSDOMWrapper>(exec, &JSPopStateEventConstructorTable, jsCast<JSPopStateEventConstructor*>(object), propertyName, descriptor);
}

EncodedJSValue JSC_HOST_CALL JSPopStateEventConstructor::constructJSPopStateEvent(ExecState* exec)
{
    JSPopStateEventConstructor* jsConstructor = jsCast<JSPopStateEventConstructor*>(exec->callee());

    ScriptExecutionContext* executionContext = jsConstructor->scriptExecutionContext();
    if (!executionContext)
        return throwVMError(exec, createReferenceError(exec, "Constructor associated execution context is unavailable"));

    AtomicString eventType = exec->argument(0).toString(exec)->value(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    PopStateEventInit eventInit;

    JSValue initializerValue = exec->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(exec);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(exec, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillPopStateEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<PopStateEvent> event = PopStateEvent::create(eventType, eventInit);
    return JSValue::encode(toJS(exec, jsConstructor->globalObject(), event.get()));
}

bool fillPopStateEventInit(PopStateEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("state", eventInit.state))
        return false;
    return true;
}

ConstructType JSPopStateEventConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSPopStateEvent;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSPopStateEventPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPopStateEventPrototypeTable = { 1, 0, JSPopStateEventPrototypeTableValues, 0 };
const ClassInfo JSPopStateEventPrototype::s_info = { "PopStateEventPrototype", &Base::s_info, &JSPopStateEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSPopStateEventPrototype) };

JSObject* JSPopStateEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPopStateEvent>(exec, globalObject);
}

const ClassInfo JSPopStateEvent::s_info = { "PopStateEvent", &Base::s_info, &JSPopStateEventTable, 0 , CREATE_METHOD_TABLE(JSPopStateEvent) };

JSPopStateEvent::JSPopStateEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<PopStateEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSPopStateEvent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSPopStateEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSPopStateEventPrototype::create(exec->globalData(), globalObject, JSPopStateEventPrototype::createStructure(exec->globalData(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSPopStateEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSPopStateEvent* thisObject = jsCast<JSPopStateEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSPopStateEvent, Base>(exec, &JSPopStateEventTable, thisObject, propertyName, slot);
}

bool JSPopStateEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSPopStateEvent* thisObject = jsCast<JSPopStateEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSPopStateEvent, Base>(exec, &JSPopStateEventTable, thisObject, propertyName, descriptor);
}

JSValue jsPopStateEventState(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPopStateEvent* castedThis = jsCast<JSPopStateEvent*>(asObject(slotBase));
    return castedThis->state(exec);
}


JSValue jsPopStateEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPopStateEvent* domObject = jsCast<JSPopStateEvent*>(asObject(slotBase));
    return JSPopStateEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSPopStateEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPopStateEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

void JSPopStateEvent::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    JSPopStateEvent* thisObject = jsCast<JSPopStateEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(thisObject->structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(thisObject, visitor);
    visitor.append(&thisObject->m_state);
}


}
