/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_TIMING)

#include "JSPerformance.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSMemoryInfo.h"
#include "JSPerformanceNavigation.h"
#include "JSPerformanceTiming.h"
#include "MemoryInfo.h"
#include "Performance.h"
#include "PerformanceNavigation.h"
#include "PerformanceTiming.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSPerformanceTableValues[] =
{
    { "navigation", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigation), (intptr_t)0, NoIntrinsic },
    { "timing", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTiming), (intptr_t)0, NoIntrinsic },
    { "memory", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceMemory), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPerformanceTable = { 8, 7, JSPerformanceTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSPerformancePrototypeTableValues[] =
{
    { "now", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsPerformancePrototypeFunctionNow), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPerformancePrototypeTable = { 2, 1, JSPerformancePrototypeTableValues, 0 };
const ClassInfo JSPerformancePrototype::s_info = { "PerformancePrototype", &Base::s_info, &JSPerformancePrototypeTable, 0, CREATE_METHOD_TABLE(JSPerformancePrototype) };

JSObject* JSPerformancePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPerformance>(exec, globalObject);
}

bool JSPerformancePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSPerformancePrototype* thisObject = jsCast<JSPerformancePrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSPerformancePrototypeTable, thisObject, propertyName, slot);
}

bool JSPerformancePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSPerformancePrototype* thisObject = jsCast<JSPerformancePrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSPerformancePrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSPerformance::s_info = { "Performance", &Base::s_info, &JSPerformanceTable, 0 , CREATE_METHOD_TABLE(JSPerformance) };

JSPerformance::JSPerformance(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Performance> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSPerformance::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSPerformance::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSPerformancePrototype::create(exec->globalData(), globalObject, JSPerformancePrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSPerformance::destroy(JSC::JSCell* cell)
{
    JSPerformance* thisObject = static_cast<JSPerformance*>(cell);
    thisObject->JSPerformance::~JSPerformance();
}

JSPerformance::~JSPerformance()
{
    releaseImplIfNotNull();
}

bool JSPerformance::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSPerformance* thisObject = jsCast<JSPerformance*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSPerformance, Base>(exec, &JSPerformanceTable, thisObject, propertyName, slot);
}

bool JSPerformance::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSPerformance* thisObject = jsCast<JSPerformance*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSPerformance, Base>(exec, &JSPerformanceTable, thisObject, propertyName, descriptor);
}

JSValue jsPerformanceNavigation(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformance* castedThis = jsCast<JSPerformance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Performance* impl = static_cast<Performance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->navigation()));
    return result;
}


JSValue jsPerformanceTiming(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformance* castedThis = jsCast<JSPerformance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Performance* impl = static_cast<Performance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->timing()));
    return result;
}


JSValue jsPerformanceMemory(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformance* castedThis = jsCast<JSPerformance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Performance* impl = static_cast<Performance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->memory()));
    return result;
}


EncodedJSValue JSC_HOST_CALL jsPerformancePrototypeFunctionNow(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSPerformance::s_info))
        return throwVMTypeError(exec);
    JSPerformance* castedThis = jsCast<JSPerformance*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSPerformance::s_info);
    Performance* impl = static_cast<Performance*>(castedThis->impl());

    JSC::JSValue result = jsNumber(impl->now());
    return JSValue::encode(result);
}

void JSPerformance::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    JSPerformance* thisObject = jsCast<JSPerformance*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(thisObject->structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(thisObject, visitor);
    thisObject->impl()->visitJSEventListeners(visitor);
}

static inline bool isObservable(JSPerformance* jsPerformance)
{
    if (jsPerformance->hasCustomProperties())
        return true;
    if (jsPerformance->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSPerformanceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSPerformance* jsPerformance = jsCast<JSPerformance*>(handle.get().asCell());
    if (!isObservable(jsPerformance))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSPerformanceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSPerformance* jsPerformance = jsCast<JSPerformance*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsPerformance->impl(), jsPerformance);
    jsPerformance->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Performance* impl)
{
    return wrap<JSPerformance>(exec, globalObject, impl);
}

Performance* toPerformance(JSC::JSValue value)
{
    return value.inherits(&JSPerformance::s_info) ? jsCast<JSPerformance*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEB_TIMING)
