/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMSettableTokenList.h"

#include "DOMSettableTokenList.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDOMSettableTokenListTableValues[] =
{
    { "value", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSettableTokenListValue), (intptr_t)setJSDOMSettableTokenListValue, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSettableTokenListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMSettableTokenListTable = { 4, 3, JSDOMSettableTokenListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSDOMSettableTokenListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMSettableTokenListConstructorTable = { 1, 0, JSDOMSettableTokenListConstructorTableValues, 0 };
const ClassInfo JSDOMSettableTokenListConstructor::s_info = { "DOMSettableTokenListConstructor", &Base::s_info, &JSDOMSettableTokenListConstructorTable, 0, CREATE_METHOD_TABLE(JSDOMSettableTokenListConstructor) };

JSDOMSettableTokenListConstructor::JSDOMSettableTokenListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSDOMSettableTokenListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSDOMSettableTokenListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSDOMSettableTokenListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMSettableTokenListConstructor, JSDOMWrapper>(exec, &JSDOMSettableTokenListConstructorTable, jsCast<JSDOMSettableTokenListConstructor*>(cell), propertyName, slot);
}

bool JSDOMSettableTokenListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMSettableTokenListConstructor, JSDOMWrapper>(exec, &JSDOMSettableTokenListConstructorTable, jsCast<JSDOMSettableTokenListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSDOMSettableTokenListPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMSettableTokenListPrototypeTable = { 1, 0, JSDOMSettableTokenListPrototypeTableValues, 0 };
const ClassInfo JSDOMSettableTokenListPrototype::s_info = { "DOMSettableTokenListPrototype", &Base::s_info, &JSDOMSettableTokenListPrototypeTable, 0, CREATE_METHOD_TABLE(JSDOMSettableTokenListPrototype) };

JSObject* JSDOMSettableTokenListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMSettableTokenList>(exec, globalObject);
}

const ClassInfo JSDOMSettableTokenList::s_info = { "DOMSettableTokenList", &Base::s_info, &JSDOMSettableTokenListTable, 0 , CREATE_METHOD_TABLE(JSDOMSettableTokenList) };

JSDOMSettableTokenList::JSDOMSettableTokenList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMSettableTokenList> impl)
    : JSDOMTokenList(structure, globalObject, impl)
{
}

void JSDOMSettableTokenList::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSDOMSettableTokenList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDOMSettableTokenListPrototype::create(exec->globalData(), globalObject, JSDOMSettableTokenListPrototype::createStructure(exec->globalData(), globalObject, JSDOMTokenListPrototype::self(exec, globalObject)));
}

bool JSDOMSettableTokenList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDOMSettableTokenList* thisObject = jsCast<JSDOMSettableTokenList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSDOMSettableTokenList>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSDOMSettableTokenList, Base>(exec, &JSDOMSettableTokenListTable, thisObject, propertyName, slot);
}

bool JSDOMSettableTokenList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDOMSettableTokenList* thisObject = jsCast<JSDOMSettableTokenList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSDOMSettableTokenListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<DOMSettableTokenList*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSDOMSettableTokenList, Base>(exec, &JSDOMSettableTokenListTable, thisObject, propertyName, descriptor);
}

bool JSDOMSettableTokenList::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSDOMSettableTokenList* thisObject = jsCast<JSDOMSettableTokenList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index <= MAX_ARRAY_INDEX) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsDOMSettableTokenListValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMSettableTokenList* castedThis = jsCast<JSDOMSettableTokenList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMSettableTokenList* impl = static_cast<DOMSettableTokenList*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->value());
    return result;
}


JSValue jsDOMSettableTokenListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMSettableTokenList* domObject = jsCast<JSDOMSettableTokenList*>(asObject(slotBase));
    return JSDOMSettableTokenList::getConstructor(exec, domObject->globalObject());
}

void JSDOMSettableTokenList::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSDOMSettableTokenList* thisObject = jsCast<JSDOMSettableTokenList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSDOMSettableTokenList, Base>(exec, propertyName, value, &JSDOMSettableTokenListTable, thisObject, slot);
}

void setJSDOMSettableTokenListValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSDOMSettableTokenList* castedThis = jsCast<JSDOMSettableTokenList*>(thisObject);
    DOMSettableTokenList* impl = static_cast<DOMSettableTokenList*>(castedThis->impl());
    impl->setValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void JSDOMSettableTokenList::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSDOMSettableTokenList* thisObject = jsCast<JSDOMSettableTokenList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<DOMSettableTokenList*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSDOMSettableTokenList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMSettableTokenListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


JSValue JSDOMSettableTokenList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSDOMSettableTokenList* thisObj = jsCast<JSDOMSettableTokenList*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return jsStringOrUndefined(exec, thisObj->impl()->item(index));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMSettableTokenList* impl)
{
    return wrap<JSDOMSettableTokenList>(exec, globalObject, impl);
}


}
