/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNotation.h"

#include "KURL.h"
#include "Notation.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSNotationTableValues[] =
{
    { "publicId", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotationPublicId), (intptr_t)0, NoIntrinsic },
    { "systemId", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotationSystemId), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotationConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNotationTable = { 9, 7, JSNotationTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSNotationConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNotationConstructorTable = { 1, 0, JSNotationConstructorTableValues, 0 };
const ClassInfo JSNotationConstructor::s_info = { "NotationConstructor", &Base::s_info, &JSNotationConstructorTable, 0, CREATE_METHOD_TABLE(JSNotationConstructor) };

JSNotationConstructor::JSNotationConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSNotationConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSNotationPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSNotationConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNotationConstructor, JSDOMWrapper>(exec, &JSNotationConstructorTable, jsCast<JSNotationConstructor*>(cell), propertyName, slot);
}

bool JSNotationConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSNotationConstructor, JSDOMWrapper>(exec, &JSNotationConstructorTable, jsCast<JSNotationConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSNotationPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNotationPrototypeTable = { 1, 0, JSNotationPrototypeTableValues, 0 };
const ClassInfo JSNotationPrototype::s_info = { "NotationPrototype", &Base::s_info, &JSNotationPrototypeTable, 0, CREATE_METHOD_TABLE(JSNotationPrototype) };

JSObject* JSNotationPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSNotation>(exec, globalObject);
}

const ClassInfo JSNotation::s_info = { "Notation", &Base::s_info, &JSNotationTable, 0 , CREATE_METHOD_TABLE(JSNotation) };

JSNotation::JSNotation(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Notation> impl)
    : JSNode(structure, globalObject, impl)
{
}

void JSNotation::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSNotation::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSNotationPrototype::create(exec->globalData(), globalObject, JSNotationPrototype::createStructure(exec->globalData(), globalObject, JSNodePrototype::self(exec, globalObject)));
}

bool JSNotation::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSNotation* thisObject = jsCast<JSNotation*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSNotation, Base>(exec, &JSNotationTable, thisObject, propertyName, slot);
}

bool JSNotation::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSNotation* thisObject = jsCast<JSNotation*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSNotation, Base>(exec, &JSNotationTable, thisObject, propertyName, descriptor);
}

JSValue jsNotationPublicId(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNotation* castedThis = jsCast<JSNotation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Notation* impl = static_cast<Notation*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->publicId());
    return result;
}


JSValue jsNotationSystemId(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNotation* castedThis = jsCast<JSNotation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Notation* impl = static_cast<Notation*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->systemId());
    return result;
}


JSValue jsNotationConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNotation* domObject = jsCast<JSNotation*>(asObject(slotBase));
    return JSNotation::getConstructor(exec, domObject->globalObject());
}

JSValue JSNotation::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNotationConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
