/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.16
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/event.h>

        #include <wx/event.h>
        #include <wx/gdicmn.h>
        #include <wx/dc.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/mousestate.h>
    void _wxMouseEvent_SetWheelAxis(wxMouseEvent* self, wxMouseWheelAxis wheelAxis)
    {
        self->m_wheelAxis = wheelAxis;
    }
    void _wxMouseEvent_SetWheelRotation(wxMouseEvent* self, int wheelRotation)
    {
        self->m_wheelRotation = wheelRotation;
    }
    void _wxMouseEvent_SetWheelDelta(wxMouseEvent* self, int wheelDelta)
    {
        self->m_wheelDelta = wheelDelta;
    }
    void _wxMouseEvent_SetLinesPerAction(wxMouseEvent* self, int linesPerAction)
    {
        self->m_linesPerAction = linesPerAction;
    }
    void _wxMouseEvent_SetColumnsPerAction(wxMouseEvent* self, int columnsPerAction)
    {
        self->m_columnsPerAction = columnsPerAction;
    }


class sipwxMouseEvent : public  ::wxMouseEvent
{
public:
    sipwxMouseEvent( ::wxEventType);
    sipwxMouseEvent(const  ::wxMouseEvent&);
    virtual ~sipwxMouseEvent();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
     ::wxEvent* Clone() const SIP_OVERRIDE;
     ::wxEventCategory GetEventCategory() const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxMouseEvent(const sipwxMouseEvent &);
    sipwxMouseEvent &operator = (const sipwxMouseEvent &);

    char sipPyMethods[2];
};

sipwxMouseEvent::sipwxMouseEvent( ::wxEventType mouseEventType):  ::wxMouseEvent(mouseEventType), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxMouseEvent::sipwxMouseEvent(const  ::wxMouseEvent& a0):  ::wxMouseEvent(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxMouseEvent::~sipwxMouseEvent()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

 ::wxEvent* sipwxMouseEvent::Clone() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[0]),sipPySelf,SIP_NULLPTR,sipName_Clone);

    if (!sipMeth)
        return  ::wxMouseEvent::Clone();

    extern  ::wxEvent* sipVH__core_91(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_91(sipGILState, 0, sipPySelf, sipMeth);
}

 ::wxEventCategory sipwxMouseEvent::GetEventCategory() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[1]),sipPySelf,SIP_NULLPTR,sipName_GetEventCategory);

    if (!sipMeth)
        return  ::wxMouseEvent::GetEventCategory();

    extern  ::wxEventCategory sipVH__core_92(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_92(sipGILState, 0, sipPySelf, sipMeth);
}


PyDoc_STRVAR(doc_wxMouseEvent_Aux1DClick, "Aux1DClick() -> bool\n"
"\n"
"Returns true if the event was a first extra button double click.");

extern "C" {static PyObject *meth_wxMouseEvent_Aux1DClick(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_Aux1DClick(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Aux1DClick();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_Aux1DClick, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_Aux1Down, "Aux1Down() -> bool\n"
"\n"
"Returns true if the first extra button mouse button changed to down.");

extern "C" {static PyObject *meth_wxMouseEvent_Aux1Down(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_Aux1Down(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Aux1Down();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_Aux1Down, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_Aux1Up, "Aux1Up() -> bool\n"
"\n"
"Returns true if the first extra button mouse button changed to up.");

extern "C" {static PyObject *meth_wxMouseEvent_Aux1Up(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_Aux1Up(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Aux1Up();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_Aux1Up, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_Aux2DClick, "Aux2DClick() -> bool\n"
"\n"
"Returns true if the event was a second extra button double click.");

extern "C" {static PyObject *meth_wxMouseEvent_Aux2DClick(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_Aux2DClick(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Aux2DClick();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_Aux2DClick, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_Aux2Down, "Aux2Down() -> bool\n"
"\n"
"Returns true if the second extra button mouse button changed to down.");

extern "C" {static PyObject *meth_wxMouseEvent_Aux2Down(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_Aux2Down(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Aux2Down();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_Aux2Down, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_Aux2Up, "Aux2Up() -> bool\n"
"\n"
"Returns true if the second extra button mouse button changed to up.");

extern "C" {static PyObject *meth_wxMouseEvent_Aux2Up(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_Aux2Up(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Aux2Up();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_Aux2Up, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_Button, "Button(but) -> bool\n"
"\n"
"Returns true if the event was generated by the specified button.");

extern "C" {static PyObject *meth_wxMouseEvent_Button(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_Button(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxMouseButton but;
        const  ::wxMouseEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_but,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxMouseEvent, &sipCpp, sipType_wxMouseButton, &but))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Button(but);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_Button, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_ButtonDClick, "ButtonDClick(but=MOUSE_BTN_ANY) -> bool\n"
"\n"
"If the argument is omitted, this returns true if the event was a mouse\n"
"double click event.");

extern "C" {static PyObject *meth_wxMouseEvent_ButtonDClick(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_ButtonDClick(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxMouseButton but = wxMOUSE_BTN_ANY;
        const  ::wxMouseEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_but,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|E", &sipSelf, sipType_wxMouseEvent, &sipCpp, sipType_wxMouseButton, &but))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ButtonDClick(but);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_ButtonDClick, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_ButtonDown, "ButtonDown(but=MOUSE_BTN_ANY) -> bool\n"
"\n"
"If the argument is omitted, this returns true if the event was a mouse\n"
"button down event.");

extern "C" {static PyObject *meth_wxMouseEvent_ButtonDown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_ButtonDown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxMouseButton but = wxMOUSE_BTN_ANY;
        const  ::wxMouseEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_but,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|E", &sipSelf, sipType_wxMouseEvent, &sipCpp, sipType_wxMouseButton, &but))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ButtonDown(but);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_ButtonDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_ButtonUp, "ButtonUp(but=MOUSE_BTN_ANY) -> bool\n"
"\n"
"If the argument is omitted, this returns true if the event was a mouse\n"
"button up event.");

extern "C" {static PyObject *meth_wxMouseEvent_ButtonUp(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_ButtonUp(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxMouseButton but = wxMOUSE_BTN_ANY;
        const  ::wxMouseEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_but,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|E", &sipSelf, sipType_wxMouseEvent, &sipCpp, sipType_wxMouseButton, &but))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ButtonUp(but);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_ButtonUp, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_Dragging, "Dragging() -> bool\n"
"\n"
"Returns true if this was a dragging event (motion while a button is\n"
"depressed).");

extern "C" {static PyObject *meth_wxMouseEvent_Dragging(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_Dragging(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Dragging();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_Dragging, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_Entering, "Entering() -> bool\n"
"\n"
"Returns true if the mouse was entering the window.");

extern "C" {static PyObject *meth_wxMouseEvent_Entering(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_Entering(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Entering();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_Entering, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_GetButton, "GetButton() -> int\n"
"\n"
"Returns the mouse button which generated this event or\n"
"wxMOUSE_BTN_NONE if no button is involved (for mouse move, enter or\n"
"leave event, for example).");

extern "C" {static PyObject *meth_wxMouseEvent_GetButton(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_GetButton(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetButton();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_GetButton, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_GetClickCount, "GetClickCount() -> int\n"
"\n"
"Returns the number of mouse clicks for this event: 1 for a simple\n"
"click, 2 for a double-click, 3 for a triple-click and so on.");

extern "C" {static PyObject *meth_wxMouseEvent_GetClickCount(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_GetClickCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetClickCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_GetClickCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_GetLinesPerAction, "GetLinesPerAction() -> int\n"
"\n"
"Returns the configured number of lines (or whatever) to be scrolled\n"
"per wheel action.");

extern "C" {static PyObject *meth_wxMouseEvent_GetLinesPerAction(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_GetLinesPerAction(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLinesPerAction();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_GetLinesPerAction, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_GetColumnsPerAction, "GetColumnsPerAction() -> int\n"
"\n"
"Returns the configured number of columns (or whatever) to be scrolled\n"
"per wheel action.");

extern "C" {static PyObject *meth_wxMouseEvent_GetColumnsPerAction(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_GetColumnsPerAction(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetColumnsPerAction();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_GetColumnsPerAction, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_GetLogicalPosition, "GetLogicalPosition(dc) -> Point\n"
"\n"
"Returns the logical mouse position in pixels (i.e. translated\n"
"according to the translation set for the DC, which usually indicates\n"
"that the window has been scrolled).");

extern "C" {static PyObject *meth_wxMouseEvent_GetLogicalPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_GetLogicalPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDC* dc;
        const  ::wxMouseEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxMouseEvent, &sipCpp, sipType_wxDC, &dc))
        {
             ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPoint(sipCpp->GetLogicalPosition(*dc));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPoint,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_GetLogicalPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_GetWheelDelta, "GetWheelDelta() -> int\n"
"\n"
"Get wheel delta, normally 120.");

extern "C" {static PyObject *meth_wxMouseEvent_GetWheelDelta(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_GetWheelDelta(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWheelDelta();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_GetWheelDelta, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_GetWheelRotation, "GetWheelRotation() -> int\n"
"\n"
"Get wheel rotation, positive or negative indicates direction of\n"
"rotation.");

extern "C" {static PyObject *meth_wxMouseEvent_GetWheelRotation(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_GetWheelRotation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWheelRotation();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_GetWheelRotation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_GetWheelAxis, "GetWheelAxis() -> MouseWheelAxis\n"
"\n"
"Gets the axis the wheel operation concerns.");

extern "C" {static PyObject *meth_wxMouseEvent_GetWheelAxis(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_GetWheelAxis(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
             ::wxMouseWheelAxis sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWheelAxis();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxMouseWheelAxis);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_GetWheelAxis, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_IsButton, "IsButton() -> bool\n"
"\n"
"Returns true if the event was a mouse button event (not necessarily a\n"
"button down event - that may be tested using ButtonDown()).");

extern "C" {static PyObject *meth_wxMouseEvent_IsButton(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_IsButton(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsButton();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_IsButton, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_IsPageScroll, "IsPageScroll() -> bool\n"
"\n"
"Returns true if the system has been setup to do page scrolling with\n"
"the mouse wheel instead of line scrolling.");

extern "C" {static PyObject *meth_wxMouseEvent_IsPageScroll(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_IsPageScroll(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsPageScroll();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_IsPageScroll, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_Leaving, "Leaving() -> bool\n"
"\n"
"Returns true if the mouse was leaving the window.");

extern "C" {static PyObject *meth_wxMouseEvent_Leaving(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_Leaving(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Leaving();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_Leaving, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_LeftDClick, "LeftDClick() -> bool\n"
"\n"
"Returns true if the event was a left double click.");

extern "C" {static PyObject *meth_wxMouseEvent_LeftDClick(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_LeftDClick(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LeftDClick();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_LeftDClick, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_LeftDown, "LeftDown() -> bool\n"
"\n"
"Returns true if the left mouse button changed to down.");

extern "C" {static PyObject *meth_wxMouseEvent_LeftDown(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_LeftDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LeftDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_LeftDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_LeftUp, "LeftUp() -> bool\n"
"\n"
"Returns true if the left mouse button changed to up.");

extern "C" {static PyObject *meth_wxMouseEvent_LeftUp(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_LeftUp(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LeftUp();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_LeftUp, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_MetaDown, "MetaDown() -> bool\n"
"\n"
"Returns true if the Meta key was down at the time of the event.");

extern "C" {static PyObject *meth_wxMouseEvent_MetaDown(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_MetaDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MetaDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_MetaDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_MiddleDClick, "MiddleDClick() -> bool\n"
"\n"
"Returns true if the event was a middle double click.");

extern "C" {static PyObject *meth_wxMouseEvent_MiddleDClick(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_MiddleDClick(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MiddleDClick();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_MiddleDClick, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_MiddleDown, "MiddleDown() -> bool\n"
"\n"
"Returns true if the middle mouse button changed to down.");

extern "C" {static PyObject *meth_wxMouseEvent_MiddleDown(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_MiddleDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MiddleDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_MiddleDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_MiddleUp, "MiddleUp() -> bool\n"
"\n"
"Returns true if the middle mouse button changed to up.");

extern "C" {static PyObject *meth_wxMouseEvent_MiddleUp(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_MiddleUp(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MiddleUp();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_MiddleUp, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_Moving, "Moving() -> bool\n"
"\n"
"Returns true if this was a motion event and no mouse buttons were\n"
"pressed.");

extern "C" {static PyObject *meth_wxMouseEvent_Moving(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_Moving(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Moving();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_Moving, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_RightDClick, "RightDClick() -> bool\n"
"\n"
"Returns true if the event was a right double click.");

extern "C" {static PyObject *meth_wxMouseEvent_RightDClick(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_RightDClick(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RightDClick();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_RightDClick, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_RightDown, "RightDown() -> bool\n"
"\n"
"Returns true if the right mouse button changed to down.");

extern "C" {static PyObject *meth_wxMouseEvent_RightDown(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_RightDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RightDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_RightDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_RightUp, "RightUp() -> bool\n"
"\n"
"Returns true if the right mouse button changed to up.");

extern "C" {static PyObject *meth_wxMouseEvent_RightUp(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_RightUp(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RightUp();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_RightUp, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_SetWheelAxis, "SetWheelAxis(wheelAxis)");

extern "C" {static PyObject *meth_wxMouseEvent_SetWheelAxis(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_SetWheelAxis(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxMouseWheelAxis wheelAxis;
         ::wxMouseEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_wheelAxis,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxMouseEvent, &sipCpp, sipType_wxMouseWheelAxis, &wheelAxis))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxMouseEvent_SetWheelAxis(sipCpp, wheelAxis);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_SetWheelAxis, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_SetWheelRotation, "SetWheelRotation(wheelRotation)");

extern "C" {static PyObject *meth_wxMouseEvent_SetWheelRotation(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_SetWheelRotation(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int wheelRotation;
         ::wxMouseEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_wheelRotation,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxMouseEvent, &sipCpp, &wheelRotation))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxMouseEvent_SetWheelRotation(sipCpp, wheelRotation);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_SetWheelRotation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_SetWheelDelta, "SetWheelDelta(wheelDelta)");

extern "C" {static PyObject *meth_wxMouseEvent_SetWheelDelta(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_SetWheelDelta(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int wheelDelta;
         ::wxMouseEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_wheelDelta,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxMouseEvent, &sipCpp, &wheelDelta))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxMouseEvent_SetWheelDelta(sipCpp, wheelDelta);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_SetWheelDelta, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_SetLinesPerAction, "SetLinesPerAction(linesPerAction)");

extern "C" {static PyObject *meth_wxMouseEvent_SetLinesPerAction(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_SetLinesPerAction(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int linesPerAction;
         ::wxMouseEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_linesPerAction,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxMouseEvent, &sipCpp, &linesPerAction))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxMouseEvent_SetLinesPerAction(sipCpp, linesPerAction);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_SetLinesPerAction, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_SetColumnsPerAction, "SetColumnsPerAction(columnsPerAction)");

extern "C" {static PyObject *meth_wxMouseEvent_SetColumnsPerAction(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_SetColumnsPerAction(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int columnsPerAction;
         ::wxMouseEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_columnsPerAction,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxMouseEvent, &sipCpp, &columnsPerAction))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxMouseEvent_SetColumnsPerAction(sipCpp, columnsPerAction);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_SetColumnsPerAction, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMouseEvent_Clone, "Clone(self) -> Event");

extern "C" {static PyObject *meth_wxMouseEvent_Clone(PyObject *, PyObject *);}
static PyObject *meth_wxMouseEvent_Clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxMouseEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMouseEvent, &sipCpp))
        {
             ::wxEvent*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxMouseEvent::Clone() : sipCpp->Clone());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxEvent,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MouseEvent, sipName_Clone, doc_wxMouseEvent_Clone);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxMouseEvent(void *, const sipTypeDef *);}
static void *cast_wxMouseEvent(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxMouseEvent *sipCpp = reinterpret_cast< ::wxMouseEvent *>(sipCppV);

    if (targetType == sipType_wxEvent)
        return static_cast< ::wxEvent *>(sipCpp);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    if (targetType == sipType_wxMouseState)
        return static_cast< ::wxMouseState *>(sipCpp);

    if (targetType == sipType_wxKeyboardState)
        return static_cast< ::wxKeyboardState *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxMouseEvent(void *, int);}
static void release_wxMouseEvent(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxMouseEvent *>(sipCppV);
    else
        delete reinterpret_cast< ::wxMouseEvent *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxMouseEvent(sipSimpleWrapper *);}
static void dealloc_wxMouseEvent(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxMouseEvent *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxMouseEvent(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxMouseEvent(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxMouseEvent(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxMouseEvent *sipCpp = SIP_NULLPTR;

    {
         ::wxEventType mouseEventType = wxEVT_NULL;

        static const char *sipKwdList[] = {
            sipName_mouseEventType,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|i", &mouseEventType))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxMouseEvent(mouseEventType);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxMouseEvent* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxMouseEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxMouseEvent(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxMouseEvent[] = {{140, 255, 0}, {343, 255, 1}};


static PyMethodDef methods_wxMouseEvent[] = {
    {SIP_MLNAME_CAST(sipName_Aux1DClick), meth_wxMouseEvent_Aux1DClick, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_Aux1DClick)},
    {SIP_MLNAME_CAST(sipName_Aux1Down), meth_wxMouseEvent_Aux1Down, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_Aux1Down)},
    {SIP_MLNAME_CAST(sipName_Aux1Up), meth_wxMouseEvent_Aux1Up, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_Aux1Up)},
    {SIP_MLNAME_CAST(sipName_Aux2DClick), meth_wxMouseEvent_Aux2DClick, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_Aux2DClick)},
    {SIP_MLNAME_CAST(sipName_Aux2Down), meth_wxMouseEvent_Aux2Down, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_Aux2Down)},
    {SIP_MLNAME_CAST(sipName_Aux2Up), meth_wxMouseEvent_Aux2Up, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_Aux2Up)},
    {SIP_MLNAME_CAST(sipName_Button), SIP_MLMETH_CAST(meth_wxMouseEvent_Button), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMouseEvent_Button)},
    {SIP_MLNAME_CAST(sipName_ButtonDClick), SIP_MLMETH_CAST(meth_wxMouseEvent_ButtonDClick), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMouseEvent_ButtonDClick)},
    {SIP_MLNAME_CAST(sipName_ButtonDown), SIP_MLMETH_CAST(meth_wxMouseEvent_ButtonDown), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMouseEvent_ButtonDown)},
    {SIP_MLNAME_CAST(sipName_ButtonUp), SIP_MLMETH_CAST(meth_wxMouseEvent_ButtonUp), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMouseEvent_ButtonUp)},
    {SIP_MLNAME_CAST(sipName_Clone), meth_wxMouseEvent_Clone, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_Clone)},
    {SIP_MLNAME_CAST(sipName_Dragging), meth_wxMouseEvent_Dragging, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_Dragging)},
    {SIP_MLNAME_CAST(sipName_Entering), meth_wxMouseEvent_Entering, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_Entering)},
    {SIP_MLNAME_CAST(sipName_GetButton), meth_wxMouseEvent_GetButton, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_GetButton)},
    {SIP_MLNAME_CAST(sipName_GetClickCount), meth_wxMouseEvent_GetClickCount, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_GetClickCount)},
    {SIP_MLNAME_CAST(sipName_GetColumnsPerAction), meth_wxMouseEvent_GetColumnsPerAction, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_GetColumnsPerAction)},
    {SIP_MLNAME_CAST(sipName_GetLinesPerAction), meth_wxMouseEvent_GetLinesPerAction, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_GetLinesPerAction)},
    {SIP_MLNAME_CAST(sipName_GetLogicalPosition), SIP_MLMETH_CAST(meth_wxMouseEvent_GetLogicalPosition), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMouseEvent_GetLogicalPosition)},
    {SIP_MLNAME_CAST(sipName_GetWheelAxis), meth_wxMouseEvent_GetWheelAxis, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_GetWheelAxis)},
    {SIP_MLNAME_CAST(sipName_GetWheelDelta), meth_wxMouseEvent_GetWheelDelta, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_GetWheelDelta)},
    {SIP_MLNAME_CAST(sipName_GetWheelRotation), meth_wxMouseEvent_GetWheelRotation, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_GetWheelRotation)},
    {SIP_MLNAME_CAST(sipName_IsButton), meth_wxMouseEvent_IsButton, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_IsButton)},
    {SIP_MLNAME_CAST(sipName_IsPageScroll), meth_wxMouseEvent_IsPageScroll, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_IsPageScroll)},
    {SIP_MLNAME_CAST(sipName_Leaving), meth_wxMouseEvent_Leaving, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_Leaving)},
    {SIP_MLNAME_CAST(sipName_LeftDClick), meth_wxMouseEvent_LeftDClick, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_LeftDClick)},
    {SIP_MLNAME_CAST(sipName_LeftDown), meth_wxMouseEvent_LeftDown, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_LeftDown)},
    {SIP_MLNAME_CAST(sipName_LeftUp), meth_wxMouseEvent_LeftUp, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_LeftUp)},
    {SIP_MLNAME_CAST(sipName_MetaDown), meth_wxMouseEvent_MetaDown, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_MetaDown)},
    {SIP_MLNAME_CAST(sipName_MiddleDClick), meth_wxMouseEvent_MiddleDClick, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_MiddleDClick)},
    {SIP_MLNAME_CAST(sipName_MiddleDown), meth_wxMouseEvent_MiddleDown, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_MiddleDown)},
    {SIP_MLNAME_CAST(sipName_MiddleUp), meth_wxMouseEvent_MiddleUp, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_MiddleUp)},
    {SIP_MLNAME_CAST(sipName_Moving), meth_wxMouseEvent_Moving, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_Moving)},
    {SIP_MLNAME_CAST(sipName_RightDClick), meth_wxMouseEvent_RightDClick, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_RightDClick)},
    {SIP_MLNAME_CAST(sipName_RightDown), meth_wxMouseEvent_RightDown, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_RightDown)},
    {SIP_MLNAME_CAST(sipName_RightUp), meth_wxMouseEvent_RightUp, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMouseEvent_RightUp)},
    {SIP_MLNAME_CAST(sipName_SetColumnsPerAction), SIP_MLMETH_CAST(meth_wxMouseEvent_SetColumnsPerAction), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMouseEvent_SetColumnsPerAction)},
    {SIP_MLNAME_CAST(sipName_SetLinesPerAction), SIP_MLMETH_CAST(meth_wxMouseEvent_SetLinesPerAction), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMouseEvent_SetLinesPerAction)},
    {SIP_MLNAME_CAST(sipName_SetWheelAxis), SIP_MLMETH_CAST(meth_wxMouseEvent_SetWheelAxis), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMouseEvent_SetWheelAxis)},
    {SIP_MLNAME_CAST(sipName_SetWheelDelta), SIP_MLMETH_CAST(meth_wxMouseEvent_SetWheelDelta), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMouseEvent_SetWheelDelta)},
    {SIP_MLNAME_CAST(sipName_SetWheelRotation), SIP_MLMETH_CAST(meth_wxMouseEvent_SetWheelRotation), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMouseEvent_SetWheelRotation)}
};

sipVariableDef variables_wxMouseEvent[] = {
    {PropertyVariable, sipName_ColumnsPerAction, &methods_wxMouseEvent[15], &methods_wxMouseEvent[35], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LinesPerAction, &methods_wxMouseEvent[16], &methods_wxMouseEvent[36], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_WheelDelta, &methods_wxMouseEvent[19], &methods_wxMouseEvent[38], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_WheelRotation, &methods_wxMouseEvent[20], &methods_wxMouseEvent[39], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_WheelAxis, &methods_wxMouseEvent[18], &methods_wxMouseEvent[37], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxMouseEvent, "MouseEvent(mouseEventType=wxEVT_NULL)\n"
"\n"
"This event class contains information about the events generated by\n"
"the mouse: they include mouse buttons press and release events and\n"
"mouse move events.");


sipClassTypeDef sipTypeDef__core_wxMouseEvent = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxMouseEvent,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_MouseEvent,
        {0, 0, 1},
        40, methods_wxMouseEvent,
        0, SIP_NULLPTR,
        5, variables_wxMouseEvent,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxMouseEvent,
    -1,
    -1,
    supers_wxMouseEvent,
    SIP_NULLPTR,
    init_type_wxMouseEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxMouseEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxMouseEvent,
    cast_wxMouseEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
