
#include <octave/oct.h>
#include <octave/oct-map.h>
#include <octave/parse.h>
#include "Permute_random_fcn.h"

bool Permute_random_fcn::prepare_exclude ()
{
  // Make unique indexes
  octave_value_list in;
  in(0) = this->exclude;
  octave_value_list out = feval ("unique", in, 1);
  this->exclude = out(0).octave_idx_type_vector_value ();

  // Check if indexes are within boundaries
  octave_idx_type *exclude_ptr = this->exclude.fortran_vec ();
  for (octave_idx_type i = 0; i < this->exclude.numel () 
                             && error_state == false; i++)
    if (exclude_ptr[i] < 0 || exclude_ptr[i] >= this->series->rows ())
      {
        error_with_id ("Octave:tisean",
                       "Permute_random_fcn: the exclusion set goes out of "
                       "bounds of the time series");
      }

  // Verify exclude does not exclude too many indexes
  // (then the program runs long or ad infinitum)
  if (this->exclude.numel () > 0.75 * this->series->numel ())
    {
      error_with_id ("Octave:tisean", "Permute_random_fcn: "
                                      "Number of exclusions is greater "
                                      "than 3/4 of the number of elements "
                                      "in series, program will run forever "
                                      "or very long");
    }
  return !error_state;
}
