# ==== Usage ====
#
# [--let $shutdown_timeout= 30]
# [--let $allow_rpl_inited= 1]
# --source include/restart_mysqld.inc

--source include/not_embedded.inc

if ($rpl_inited)
{
  if (!$allow_rpl_inited)
  {
    --die ERROR IN TEST: When using the replication test framework (master-slave.inc, rpl_init.inc etc), use rpl_restart_server.inc instead of restart_mysqld.inc. If you know what you are doing and you really have to use restart_mysqld.inc, set allow_rpl_inited=1 before you source restart_mysqld.inc
  }
}

--let $server_shutdown_timeout= 60
if ($shutdown_timeout) 
{
  --let $server_shutdown_timeout= $shutdown_timeout
}
if ($shutdown_timeout == 0)
{
  --let $server_shutdown_timeout= 0
}

# Write file to make mysql-test-run.pl expect the "crash", but don't start
# it until it's told to
--let $_server_id= `SELECT @@server_id`
--let $_expect_file_name= $MYSQLTEST_VARDIR/tmp/mysqld.$_server_id.expect
--exec echo "wait" > $_expect_file_name

# Send shutdown to the connected server and give
# it 10 seconds to die before zapping it
shutdown_server $server_shutdown_timeout;

# Write file to make mysql-test-run.pl start up the server again
if ($restart_parameters)
{
  --exec echo "restart: $restart_parameters" > $_expect_file_name
}
if (!$restart_parameters)
{
  --exec echo "restart" > $_expect_file_name
}

# Turn on reconnect
--enable_reconnect

# Call script that will poll the server waiting for it to be back online again
--source include/wait_until_connected_again.inc

# Turn off reconnect again
--disable_reconnect

