# Config file for the ecbuild package
# Defines the following variables:
#
#  ecbuild_FEATURES       - list of enabled features
#  ecbuild_VERSION        - version of the package
#  ecbuild_GIT_SHA1       - Git revision of the package
#  ecbuild_GIT_SHA1_SHORT - short Git revision of the package
#


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was project-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/ecbuild" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

### computed paths
set_and_check(ecbuild_CMAKE_DIR "${PACKAGE_PREFIX_DIR}/lib/cmake/ecbuild")
set_and_check(ecbuild_BASE_DIR "${PACKAGE_PREFIX_DIR}/.")
if(DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT)
  set(ECBUILD_CMAKE_DIR ${ecbuild_CMAKE_DIR})
  set(ECBUILD_BASE_DIR ${ecbuild_BASE_DIR})
endif()

### export version info
set(ecbuild_VERSION           "3.8.2")
set(ecbuild_GIT_SHA1          "")
set(ecbuild_GIT_SHA1_SHORT    "")

if(DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT)
  set(ECBUILD_VERSION           "3.8.2" )
  set(ECBUILD_GIT_SHA1          "" )
  set(ECBUILD_GIT_SHA1_SHORT    "" )
endif()

### has this configuration been exported from a build tree?
set(ecbuild_IS_BUILD_DIR_EXPORT OFF)
if(DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT)
  set(ECBUILD_IS_BUILD_DIR_EXPORT ${ecbuild_IS_BUILD_DIR_EXPORT})
endif()

### include the <project>-import.cmake file if there is one
if(EXISTS ${ecbuild_CMAKE_DIR}/ecbuild-import.cmake)
  set(ecbuild_IMPORT_FILE "${ecbuild_CMAKE_DIR}/ecbuild-import.cmake")
  include(${ecbuild_IMPORT_FILE})
endif()

### insert definitions for IMPORTED targets
if(NOT ecbuild_BINARY_DIR)
  find_file(ecbuild_TARGETS_FILE
    NAMES ecbuild-targets.cmake
    HINTS ${ecbuild_CMAKE_DIR}
    NO_DEFAULT_PATH)
  if(ecbuild_TARGETS_FILE)
    include(${ecbuild_TARGETS_FILE})
  endif()
endif()

### include the <project>-post-import.cmake file if there is one
if(EXISTS ${ecbuild_CMAKE_DIR}/ecbuild-post-import.cmake)
  set(ecbuild_POST_IMPORT_FILE "${ecbuild_CMAKE_DIR}/ecbuild-post-import.cmake")
  include(${ecbuild_POST_IMPORT_FILE})
endif()

### handle third-party dependencies
if(DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT)
  set(ECBUILD_LIBRARIES         "")
  set(ECBUILD_TPLS              "" )

  include(${CMAKE_CURRENT_LIST_FILE}.tpls OPTIONAL)
endif()

### publish this file as imported
if( DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT )
  set(ecbuild_IMPORT_FILE ${CMAKE_CURRENT_LIST_FILE})
  mark_as_advanced(ecbuild_IMPORT_FILE)
  set(ECBUILD_IMPORT_FILE ${CMAKE_CURRENT_LIST_FILE})
  mark_as_advanced(ECBUILD_IMPORT_FILE)
endif()

### export features and check requirements
set(ecbuild_FEATURES "TESTS;PKGCONFIG")
if(DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT)
  set(ECBUILD_FEATURES ${ecbuild_FEATURES})
endif()
foreach(_f ${ecbuild_FEATURES})
  set(ecbuild_${_f}_FOUND 1)
  set(ecbuild_HAVE_${_f} 1)
  if(DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT)
    set(ECBUILD_HAVE_${_f} 1)
  endif()
endforeach()
check_required_components(ecbuild)
