; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; Make sure we still form mad even when unsafe math or fp-contract is allowed instead of fma.
; RUN: llc -mtriple=amdgcn -mcpu=tahiti -denormal-fp-math-f32=preserve-sign -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=SI,SI-STD %s
; Make sure we don't form mad with denormals
; RUN: llc -mtriple=amdgcn -mcpu=tahiti -denormal-fp-math-f32=ieee -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=SI,SI-DENORM,SI-DENORM-FASTFMAF %s
; RUN: llc -mtriple=amdgcn -mcpu=verde -denormal-fp-math-f32=ieee -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=SI,SI-DENORM,SI-DENORM-SLOWFMAF %s

declare i32 @llvm.amdgcn.workitem.id.x() #0
declare float @llvm.fabs.f32(float) #0
declare float @llvm.fma.f32(float, float, float) #0
declare float @llvm.fmuladd.f32(float, float, float) #0

; (fadd (fmul x, y), z) -> (fma x, y, z)
define amdgpu_kernel void @combine_to_mad_f32_0(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) #1 {
; SI-STD-LABEL: combine_to_mad_f32_0:
; SI-STD:       ; %bb.0:
; SI-STD-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-STD-NEXT:    s_mov_b32 s7, 0xf000
; SI-STD-NEXT:    s_mov_b32 s6, 0
; SI-STD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-STD-NEXT:    v_mov_b32_e32 v1, 0
; SI-STD-NEXT:    s_waitcnt lgkmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-STD-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-STD-NEXT:    v_mac_f32_e32 v4, v2, v3
; SI-STD-NEXT:    buffer_store_dword v4, v[0:1], s[0:3], 0 addr64
; SI-STD-NEXT:    s_endpgm
;
; SI-DENORM-FASTFMAF-LABEL: combine_to_mad_f32_0:
; SI-DENORM-FASTFMAF:       ; %bb.0:
; SI-DENORM-FASTFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-FASTFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-FASTFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v2, v2, v3, v4
; SI-DENORM-FASTFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-DENORM-FASTFMAF-NEXT:    s_endpgm
;
; SI-DENORM-SLOWFMAF-LABEL: combine_to_mad_f32_0:
; SI-DENORM-SLOWFMAF:       ; %bb.0:
; SI-DENORM-SLOWFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-SLOWFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-SLOWFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-SLOWFMAF-NEXT:    v_mul_f32_e32 v2, v2, v3
; SI-DENORM-SLOWFMAF-NEXT:    v_add_f32_e32 v2, v2, v4
; SI-DENORM-SLOWFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-DENORM-SLOWFMAF-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep.0 = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %gep.1 = getelementptr float, ptr addrspace(1) %gep.0, i32 1
  %gep.2 = getelementptr float, ptr addrspace(1) %gep.0, i32 2
  %gep.out = getelementptr float, ptr addrspace(1) %out, i32 %tid

  %a = load volatile float, ptr addrspace(1) %gep.0
  %b = load volatile float, ptr addrspace(1) %gep.1
  %c = load volatile float, ptr addrspace(1) %gep.2


  %mul = fmul contract float %a, %b
  %fma = fadd contract float %mul, %c
  store float %fma, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @no_combine_to_mad_f32_0(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) #1 {
; SI-STD-LABEL: no_combine_to_mad_f32_0:
; SI-STD:       ; %bb.0:
; SI-STD-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-STD-NEXT:    s_mov_b32 s7, 0xf000
; SI-STD-NEXT:    s_mov_b32 s6, 0
; SI-STD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-STD-NEXT:    v_mov_b32_e32 v1, 0
; SI-STD-NEXT:    s_waitcnt lgkmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-STD-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-STD-NEXT:    v_mac_f32_e32 v4, v2, v3
; SI-STD-NEXT:    buffer_store_dword v4, v[0:1], s[0:3], 0 addr64
; SI-STD-NEXT:    s_endpgm
;
; SI-DENORM-LABEL: no_combine_to_mad_f32_0:
; SI-DENORM:       ; %bb.0:
; SI-DENORM-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-NEXT:    v_mul_f32_e32 v2, v2, v3
; SI-DENORM-NEXT:    v_add_f32_e32 v2, v2, v4
; SI-DENORM-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-DENORM-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep.0 = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %gep.1 = getelementptr float, ptr addrspace(1) %gep.0, i32 1
  %gep.2 = getelementptr float, ptr addrspace(1) %gep.0, i32 2
  %gep.out = getelementptr float, ptr addrspace(1) %out, i32 %tid

  %a = load volatile float, ptr addrspace(1) %gep.0
  %b = load volatile float, ptr addrspace(1) %gep.1
  %c = load volatile float, ptr addrspace(1) %gep.2

  %mul = fmul float %a, %b
  %fma = fadd float %mul, %c
  store float %fma, ptr addrspace(1) %gep.out
  ret void
}

; (fadd (fmul x, y), z) -> (fma x, y, z)
define amdgpu_kernel void @combine_to_mad_f32_0_2use(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in, i1 %is_fast) #1 {
; SI-STD-LABEL: combine_to_mad_f32_0_2use:
; SI-STD:       ; %bb.0:
; SI-STD-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-STD-NEXT:    s_mov_b32 s7, 0xf000
; SI-STD-NEXT:    s_mov_b32 s6, 0
; SI-STD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-STD-NEXT:    v_mov_b32_e32 v1, 0
; SI-STD-NEXT:    s_waitcnt lgkmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-STD-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-STD-NEXT:    v_mac_f32_e32 v4, v2, v3
; SI-STD-NEXT:    v_mac_f32_e32 v5, v2, v3
; SI-STD-NEXT:    buffer_store_dword v4, v[0:1], s[0:3], 0 addr64
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_store_dword v5, v[0:1], s[0:3], 0 addr64 offset:4
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_endpgm
;
; SI-DENORM-FASTFMAF-LABEL: combine_to_mad_f32_0_2use:
; SI-DENORM-FASTFMAF:       ; %bb.0:
; SI-DENORM-FASTFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-FASTFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-FASTFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v4, v2, v3, v4
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v2, v2, v3, v5
; SI-DENORM-FASTFMAF-NEXT:    buffer_store_dword v4, v[0:1], s[0:3], 0 addr64
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64 offset:4
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_endpgm
;
; SI-DENORM-SLOWFMAF-LABEL: combine_to_mad_f32_0_2use:
; SI-DENORM-SLOWFMAF:       ; %bb.0:
; SI-DENORM-SLOWFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-SLOWFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-SLOWFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-SLOWFMAF-NEXT:    v_mul_f32_e32 v2, v2, v3
; SI-DENORM-SLOWFMAF-NEXT:    v_add_f32_e32 v3, v2, v4
; SI-DENORM-SLOWFMAF-NEXT:    v_add_f32_e32 v2, v2, v5
; SI-DENORM-SLOWFMAF-NEXT:    buffer_store_dword v3, v[0:1], s[0:3], 0 addr64
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64 offset:4
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep.0 = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %gep.1 = getelementptr float, ptr addrspace(1) %gep.0, i32 1
  %gep.2 = getelementptr float, ptr addrspace(1) %gep.0, i32 2
  %gep.3 = getelementptr float, ptr addrspace(1) %gep.0, i32 3
  %gep.out.0 = getelementptr float, ptr addrspace(1) %out, i32 %tid
  %gep.out.1 = getelementptr float, ptr addrspace(1) %gep.out.0, i32 1

  %a = load volatile float, ptr addrspace(1) %gep.0
  %b = load volatile float, ptr addrspace(1) %gep.1
  %c = load volatile float, ptr addrspace(1) %gep.2
  %d = load volatile float, ptr addrspace(1) %gep.3

  %mul = fmul contract fast float %a, %b
  %fma0 = fadd contract fast float %mul, %c
  %fma1 = fadd contract fast float %mul, %d
  store volatile float %fma0, ptr addrspace(1) %gep.out.0
  store volatile float %fma1, ptr addrspace(1) %gep.out.1
  ret void
}

define amdgpu_kernel void @no_combine_to_mad_f32_0_2use(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in, i1 %is_fast) #1 {
; SI-STD-LABEL: no_combine_to_mad_f32_0_2use:
; SI-STD:       ; %bb.0:
; SI-STD-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-STD-NEXT:    s_mov_b32 s7, 0xf000
; SI-STD-NEXT:    s_mov_b32 s6, 0
; SI-STD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-STD-NEXT:    v_mov_b32_e32 v1, 0
; SI-STD-NEXT:    s_waitcnt lgkmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-STD-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-STD-NEXT:    v_mac_f32_e32 v4, v2, v3
; SI-STD-NEXT:    v_mac_f32_e32 v5, v2, v3
; SI-STD-NEXT:    buffer_store_dword v4, v[0:1], s[0:3], 0 addr64
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_store_dword v5, v[0:1], s[0:3], 0 addr64 offset:4
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_endpgm
;
; SI-DENORM-LABEL: no_combine_to_mad_f32_0_2use:
; SI-DENORM:       ; %bb.0:
; SI-DENORM-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-NEXT:    v_mul_f32_e32 v2, v2, v3
; SI-DENORM-NEXT:    v_add_f32_e32 v3, v2, v4
; SI-DENORM-NEXT:    v_add_f32_e32 v2, v2, v5
; SI-DENORM-NEXT:    buffer_store_dword v3, v[0:1], s[0:3], 0 addr64
; SI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64 offset:4
; SI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep.0 = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %gep.1 = getelementptr float, ptr addrspace(1) %gep.0, i32 1
  %gep.2 = getelementptr float, ptr addrspace(1) %gep.0, i32 2
  %gep.3 = getelementptr float, ptr addrspace(1) %gep.0, i32 3
  %gep.out.0 = getelementptr float, ptr addrspace(1) %out, i32 %tid
  %gep.out.1 = getelementptr float, ptr addrspace(1) %gep.out.0, i32 1

  %a = load volatile float, ptr addrspace(1) %gep.0
  %b = load volatile float, ptr addrspace(1) %gep.1
  %c = load volatile float, ptr addrspace(1) %gep.2
  %d = load volatile float, ptr addrspace(1) %gep.3

  %mul = fmul float %a, %b
  %fma0 = fadd float %mul, %c
  %fma1 = fadd float %mul, %d
  store volatile float %fma0, ptr addrspace(1) %gep.out.0
  store volatile float %fma1, ptr addrspace(1) %gep.out.1
  ret void
}

; (fadd x, (fmul y, z)) -> (fma y, z, x)
define amdgpu_kernel void @combine_to_mad_f32_1(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) #1 {
; SI-STD-LABEL: combine_to_mad_f32_1:
; SI-STD:       ; %bb.0:
; SI-STD-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-STD-NEXT:    s_mov_b32 s7, 0xf000
; SI-STD-NEXT:    s_mov_b32 s6, 0
; SI-STD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-STD-NEXT:    v_mov_b32_e32 v1, 0
; SI-STD-NEXT:    s_waitcnt lgkmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-STD-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-STD-NEXT:    v_mac_f32_e32 v4, v2, v3
; SI-STD-NEXT:    buffer_store_dword v4, v[0:1], s[0:3], 0 addr64
; SI-STD-NEXT:    s_endpgm
;
; SI-DENORM-FASTFMAF-LABEL: combine_to_mad_f32_1:
; SI-DENORM-FASTFMAF:       ; %bb.0:
; SI-DENORM-FASTFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-FASTFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-FASTFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v2, v2, v3, v4
; SI-DENORM-FASTFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-DENORM-FASTFMAF-NEXT:    s_endpgm
;
; SI-DENORM-SLOWFMAF-LABEL: combine_to_mad_f32_1:
; SI-DENORM-SLOWFMAF:       ; %bb.0:
; SI-DENORM-SLOWFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-SLOWFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-SLOWFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-SLOWFMAF-NEXT:    v_mul_f32_e32 v2, v2, v3
; SI-DENORM-SLOWFMAF-NEXT:    v_add_f32_e32 v2, v4, v2
; SI-DENORM-SLOWFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-DENORM-SLOWFMAF-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep.0 = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %gep.1 = getelementptr float, ptr addrspace(1) %gep.0, i32 1
  %gep.2 = getelementptr float, ptr addrspace(1) %gep.0, i32 2
  %gep.out = getelementptr float, ptr addrspace(1) %out, i32 %tid

  %a = load volatile float, ptr addrspace(1) %gep.0
  %b = load volatile float, ptr addrspace(1) %gep.1
  %c = load volatile float, ptr addrspace(1) %gep.2

  %mul = fmul contract float %a, %b
  %fma = fadd contract float %c, %mul
  store float %fma, ptr addrspace(1) %gep.out
  ret void
}

; (fsub (fmul x, y), z) -> (fma x, y, (fneg z))
define amdgpu_kernel void @combine_to_mad_fsub_0_f32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) #1 {
; SI-STD-LABEL: combine_to_mad_fsub_0_f32:
; SI-STD:       ; %bb.0:
; SI-STD-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-STD-NEXT:    s_mov_b32 s7, 0xf000
; SI-STD-NEXT:    s_mov_b32 s6, 0
; SI-STD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-STD-NEXT:    v_mov_b32_e32 v1, 0
; SI-STD-NEXT:    s_waitcnt lgkmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-STD-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-STD-NEXT:    v_mad_f32 v2, v2, v3, -v4
; SI-STD-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-STD-NEXT:    s_endpgm
;
; SI-DENORM-FASTFMAF-LABEL: combine_to_mad_fsub_0_f32:
; SI-DENORM-FASTFMAF:       ; %bb.0:
; SI-DENORM-FASTFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-FASTFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-FASTFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v2, v2, v3, -v4
; SI-DENORM-FASTFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-DENORM-FASTFMAF-NEXT:    s_endpgm
;
; SI-DENORM-SLOWFMAF-LABEL: combine_to_mad_fsub_0_f32:
; SI-DENORM-SLOWFMAF:       ; %bb.0:
; SI-DENORM-SLOWFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-SLOWFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-SLOWFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-SLOWFMAF-NEXT:    v_mul_f32_e32 v2, v2, v3
; SI-DENORM-SLOWFMAF-NEXT:    v_sub_f32_e32 v2, v2, v4
; SI-DENORM-SLOWFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-DENORM-SLOWFMAF-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep.0 = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %gep.1 = getelementptr float, ptr addrspace(1) %gep.0, i32 1
  %gep.2 = getelementptr float, ptr addrspace(1) %gep.0, i32 2
  %gep.out = getelementptr float, ptr addrspace(1) %out, i32 %tid

  %a = load volatile float, ptr addrspace(1) %gep.0
  %b = load volatile float, ptr addrspace(1) %gep.1
  %c = load volatile float, ptr addrspace(1) %gep.2

  %mul = fmul contract float %a, %b
  %fma = fsub contract float %mul, %c
  store float %fma, ptr addrspace(1) %gep.out
  ret void
}

; (fsub (fmul x, y), z) -> (fma x, y, (fneg z))
define amdgpu_kernel void @combine_to_mad_fsub_0_f32_2use(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) #1 {
; SI-STD-LABEL: combine_to_mad_fsub_0_f32_2use:
; SI-STD:       ; %bb.0:
; SI-STD-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-STD-NEXT:    s_mov_b32 s7, 0xf000
; SI-STD-NEXT:    s_mov_b32 s6, 0
; SI-STD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-STD-NEXT:    v_mov_b32_e32 v1, 0
; SI-STD-NEXT:    s_waitcnt lgkmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-STD-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-STD-NEXT:    v_mad_f32 v4, v2, v3, -v4
; SI-STD-NEXT:    v_mad_f32 v2, v2, v3, -v5
; SI-STD-NEXT:    buffer_store_dword v4, v[0:1], s[0:3], 0 addr64
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64 offset:4
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_endpgm
;
; SI-DENORM-FASTFMAF-LABEL: combine_to_mad_fsub_0_f32_2use:
; SI-DENORM-FASTFMAF:       ; %bb.0:
; SI-DENORM-FASTFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-FASTFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-FASTFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v4, v2, v3, -v4
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v2, v2, v3, -v5
; SI-DENORM-FASTFMAF-NEXT:    buffer_store_dword v4, v[0:1], s[0:3], 0 addr64
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64 offset:4
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_endpgm
;
; SI-DENORM-SLOWFMAF-LABEL: combine_to_mad_fsub_0_f32_2use:
; SI-DENORM-SLOWFMAF:       ; %bb.0:
; SI-DENORM-SLOWFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-SLOWFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-SLOWFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-SLOWFMAF-NEXT:    v_mul_f32_e32 v2, v2, v3
; SI-DENORM-SLOWFMAF-NEXT:    v_sub_f32_e32 v3, v2, v4
; SI-DENORM-SLOWFMAF-NEXT:    v_sub_f32_e32 v2, v2, v5
; SI-DENORM-SLOWFMAF-NEXT:    buffer_store_dword v3, v[0:1], s[0:3], 0 addr64
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64 offset:4
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep.0 = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %gep.1 = getelementptr float, ptr addrspace(1) %gep.0, i32 1
  %gep.2 = getelementptr float, ptr addrspace(1) %gep.0, i32 2
  %gep.3 = getelementptr float, ptr addrspace(1) %gep.0, i32 3
  %gep.out.0 = getelementptr float, ptr addrspace(1) %out, i32 %tid
  %gep.out.1 = getelementptr float, ptr addrspace(1) %gep.out.0, i32 1

  %a = load volatile float, ptr addrspace(1) %gep.0
  %b = load volatile float, ptr addrspace(1) %gep.1
  %c = load volatile float, ptr addrspace(1) %gep.2
  %d = load volatile float, ptr addrspace(1) %gep.3

  %mul = fmul contract float %a, %b
  %fma0 = fsub contract float %mul, %c
  %fma1 = fsub contract float %mul, %d
  store volatile float %fma0, ptr addrspace(1) %gep.out.0
  store volatile float %fma1, ptr addrspace(1) %gep.out.1
  ret void
}

; (fsub x, (fmul y, z)) -> (fma (fneg y), z, x)
define amdgpu_kernel void @combine_to_mad_fsub_1_f32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) #1 {
; SI-STD-LABEL: combine_to_mad_fsub_1_f32:
; SI-STD:       ; %bb.0:
; SI-STD-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-STD-NEXT:    s_mov_b32 s7, 0xf000
; SI-STD-NEXT:    s_mov_b32 s6, 0
; SI-STD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-STD-NEXT:    v_mov_b32_e32 v1, 0
; SI-STD-NEXT:    s_waitcnt lgkmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-STD-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-STD-NEXT:    v_mad_f32 v2, -v2, v3, v4
; SI-STD-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-STD-NEXT:    s_endpgm
;
; SI-DENORM-FASTFMAF-LABEL: combine_to_mad_fsub_1_f32:
; SI-DENORM-FASTFMAF:       ; %bb.0:
; SI-DENORM-FASTFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-FASTFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-FASTFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v2, -v2, v3, v4
; SI-DENORM-FASTFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-DENORM-FASTFMAF-NEXT:    s_endpgm
;
; SI-DENORM-SLOWFMAF-LABEL: combine_to_mad_fsub_1_f32:
; SI-DENORM-SLOWFMAF:       ; %bb.0:
; SI-DENORM-SLOWFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-SLOWFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-SLOWFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-SLOWFMAF-NEXT:    v_mul_f32_e32 v2, v2, v3
; SI-DENORM-SLOWFMAF-NEXT:    v_sub_f32_e32 v2, v4, v2
; SI-DENORM-SLOWFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-DENORM-SLOWFMAF-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep.0 = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %gep.1 = getelementptr float, ptr addrspace(1) %gep.0, i32 1
  %gep.2 = getelementptr float, ptr addrspace(1) %gep.0, i32 2
  %gep.out = getelementptr float, ptr addrspace(1) %out, i32 %tid

  %a = load volatile float, ptr addrspace(1) %gep.0
  %b = load volatile float, ptr addrspace(1) %gep.1
  %c = load volatile float, ptr addrspace(1) %gep.2

  %mul = fmul contract float %a, %b
  %fma = fsub contract float %c, %mul
  store float %fma, ptr addrspace(1) %gep.out
  ret void
}

; (fsub x, (fmul y, z)) -> (fma (fneg y), z, x)
define amdgpu_kernel void @combine_to_mad_fsub_1_f32_2use(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) #1 {
; SI-STD-LABEL: combine_to_mad_fsub_1_f32_2use:
; SI-STD:       ; %bb.0:
; SI-STD-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-STD-NEXT:    s_mov_b32 s7, 0xf000
; SI-STD-NEXT:    s_mov_b32 s6, 0
; SI-STD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-STD-NEXT:    v_mov_b32_e32 v1, 0
; SI-STD-NEXT:    s_waitcnt lgkmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-STD-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-STD-NEXT:    v_mad_f32 v4, -v2, v3, v4
; SI-STD-NEXT:    v_mad_f32 v2, -v2, v3, v5
; SI-STD-NEXT:    buffer_store_dword v4, v[0:1], s[0:3], 0 addr64
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64 offset:4
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_endpgm
;
; SI-DENORM-FASTFMAF-LABEL: combine_to_mad_fsub_1_f32_2use:
; SI-DENORM-FASTFMAF:       ; %bb.0:
; SI-DENORM-FASTFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-FASTFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-FASTFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v4, -v2, v3, v4
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v2, -v2, v3, v5
; SI-DENORM-FASTFMAF-NEXT:    buffer_store_dword v4, v[0:1], s[0:3], 0 addr64
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64 offset:4
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_endpgm
;
; SI-DENORM-SLOWFMAF-LABEL: combine_to_mad_fsub_1_f32_2use:
; SI-DENORM-SLOWFMAF:       ; %bb.0:
; SI-DENORM-SLOWFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-SLOWFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-SLOWFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-SLOWFMAF-NEXT:    v_mul_f32_e32 v2, v2, v3
; SI-DENORM-SLOWFMAF-NEXT:    v_sub_f32_e32 v3, v4, v2
; SI-DENORM-SLOWFMAF-NEXT:    v_sub_f32_e32 v2, v5, v2
; SI-DENORM-SLOWFMAF-NEXT:    buffer_store_dword v3, v[0:1], s[0:3], 0 addr64
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64 offset:4
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep.0 = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %gep.1 = getelementptr float, ptr addrspace(1) %gep.0, i32 1
  %gep.2 = getelementptr float, ptr addrspace(1) %gep.0, i32 2
  %gep.3 = getelementptr float, ptr addrspace(1) %gep.0, i32 3
  %gep.out.0 = getelementptr float, ptr addrspace(1) %out, i32 %tid
  %gep.out.1 = getelementptr float, ptr addrspace(1) %gep.out.0, i32 1

  %a = load volatile float, ptr addrspace(1) %gep.0
  %b = load volatile float, ptr addrspace(1) %gep.1
  %c = load volatile float, ptr addrspace(1) %gep.2
  %d = load volatile float, ptr addrspace(1) %gep.3

  %mul = fmul contract float %a, %b
  %fma0 = fsub contract float %c, %mul
  %fma1 = fsub contract float %d, %mul
  store volatile float %fma0, ptr addrspace(1) %gep.out.0
  store volatile float %fma1, ptr addrspace(1) %gep.out.1
  ret void
}

; (fsub (fneg (fmul x, y)), z) -> (fma (fneg x), y, (fneg z))
define amdgpu_kernel void @combine_to_mad_fsub_2_f32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) #1 {
; SI-STD-LABEL: combine_to_mad_fsub_2_f32:
; SI-STD:       ; %bb.0:
; SI-STD-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-STD-NEXT:    s_mov_b32 s7, 0xf000
; SI-STD-NEXT:    s_mov_b32 s6, 0
; SI-STD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-STD-NEXT:    v_mov_b32_e32 v1, 0
; SI-STD-NEXT:    s_waitcnt lgkmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-STD-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-STD-NEXT:    v_mad_f32 v2, v2, -v3, -v4
; SI-STD-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-STD-NEXT:    s_endpgm
;
; SI-DENORM-FASTFMAF-LABEL: combine_to_mad_fsub_2_f32:
; SI-DENORM-FASTFMAF:       ; %bb.0:
; SI-DENORM-FASTFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-FASTFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-FASTFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v2, -v2, v3, -v4
; SI-DENORM-FASTFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-DENORM-FASTFMAF-NEXT:    s_endpgm
;
; SI-DENORM-SLOWFMAF-LABEL: combine_to_mad_fsub_2_f32:
; SI-DENORM-SLOWFMAF:       ; %bb.0:
; SI-DENORM-SLOWFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-SLOWFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-SLOWFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-SLOWFMAF-NEXT:    v_mul_f32_e64 v2, v2, -v3
; SI-DENORM-SLOWFMAF-NEXT:    v_sub_f32_e32 v2, v2, v4
; SI-DENORM-SLOWFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-DENORM-SLOWFMAF-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep.0 = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %gep.1 = getelementptr float, ptr addrspace(1) %gep.0, i32 1
  %gep.2 = getelementptr float, ptr addrspace(1) %gep.0, i32 2
  %gep.out = getelementptr float, ptr addrspace(1) %out, i32 %tid

  %a = load volatile float, ptr addrspace(1) %gep.0
  %b = load volatile float, ptr addrspace(1) %gep.1
  %c = load volatile float, ptr addrspace(1) %gep.2

  %mul = fmul contract float %a, %b
  %mul.neg = fneg contract float %mul
  %fma = fsub contract float %mul.neg, %c

  store float %fma, ptr addrspace(1) %gep.out
  ret void
}

; (fsub (fneg (fmul x, y)), z) -> (fma (fneg x), y, (fneg z))
define amdgpu_kernel void @combine_to_mad_fsub_2_f32_2uses_neg(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) #1 {
; SI-STD-LABEL: combine_to_mad_fsub_2_f32_2uses_neg:
; SI-STD:       ; %bb.0:
; SI-STD-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-STD-NEXT:    s_mov_b32 s7, 0xf000
; SI-STD-NEXT:    s_mov_b32 s6, 0
; SI-STD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-STD-NEXT:    v_mov_b32_e32 v1, 0
; SI-STD-NEXT:    s_waitcnt lgkmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-STD-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-STD-NEXT:    v_mad_f32 v4, v2, -v3, -v4
; SI-STD-NEXT:    v_mad_f32 v2, v2, -v3, -v5
; SI-STD-NEXT:    buffer_store_dword v4, v[0:1], s[0:3], 0 addr64
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64 offset:4
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_endpgm
;
; SI-DENORM-FASTFMAF-LABEL: combine_to_mad_fsub_2_f32_2uses_neg:
; SI-DENORM-FASTFMAF:       ; %bb.0:
; SI-DENORM-FASTFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-FASTFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-FASTFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v4, -v2, v3, -v4
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v2, -v2, v3, -v5
; SI-DENORM-FASTFMAF-NEXT:    buffer_store_dword v4, v[0:1], s[0:3], 0 addr64
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64 offset:4
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_endpgm
;
; SI-DENORM-SLOWFMAF-LABEL: combine_to_mad_fsub_2_f32_2uses_neg:
; SI-DENORM-SLOWFMAF:       ; %bb.0:
; SI-DENORM-SLOWFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-SLOWFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-SLOWFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-SLOWFMAF-NEXT:    v_mul_f32_e64 v2, v2, -v3
; SI-DENORM-SLOWFMAF-NEXT:    v_sub_f32_e32 v3, v2, v4
; SI-DENORM-SLOWFMAF-NEXT:    v_sub_f32_e32 v2, v2, v5
; SI-DENORM-SLOWFMAF-NEXT:    buffer_store_dword v3, v[0:1], s[0:3], 0 addr64
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64 offset:4
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep.0 = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %gep.1 = getelementptr float, ptr addrspace(1) %gep.0, i32 1
  %gep.2 = getelementptr float, ptr addrspace(1) %gep.0, i32 2
  %gep.3 = getelementptr float, ptr addrspace(1) %gep.0, i32 3
  %gep.out.0 = getelementptr float, ptr addrspace(1) %out, i32 %tid
  %gep.out.1 = getelementptr float, ptr addrspace(1) %gep.out.0, i32 1

  %a = load volatile float, ptr addrspace(1) %gep.0
  %b = load volatile float, ptr addrspace(1) %gep.1
  %c = load volatile float, ptr addrspace(1) %gep.2
  %d = load volatile float, ptr addrspace(1) %gep.3

  %mul = fmul contract float %a, %b
  %mul.neg = fneg contract float %mul
  %fma0 = fsub contract float %mul.neg, %c
  %fma1 = fsub contract float %mul.neg, %d

  store volatile float %fma0, ptr addrspace(1) %gep.out.0
  store volatile float %fma1, ptr addrspace(1) %gep.out.1
  ret void
}

; (fsub (fneg (fmul x, y)), z) -> (fma (fneg x), y, (fneg z))
define amdgpu_kernel void @combine_to_mad_fsub_2_f32_2uses_mul(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) #1 {
; SI-STD-LABEL: combine_to_mad_fsub_2_f32_2uses_mul:
; SI-STD:       ; %bb.0:
; SI-STD-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-STD-NEXT:    s_mov_b32 s7, 0xf000
; SI-STD-NEXT:    s_mov_b32 s6, 0
; SI-STD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-STD-NEXT:    v_mov_b32_e32 v1, 0
; SI-STD-NEXT:    s_waitcnt lgkmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-STD-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-STD-NEXT:    v_mad_f32 v4, -v2, v3, -v4
; SI-STD-NEXT:    v_mad_f32 v2, v2, v3, -v5
; SI-STD-NEXT:    buffer_store_dword v4, v[0:1], s[0:3], 0 addr64
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64 offset:4
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_endpgm
;
; SI-DENORM-FASTFMAF-LABEL: combine_to_mad_fsub_2_f32_2uses_mul:
; SI-DENORM-FASTFMAF:       ; %bb.0:
; SI-DENORM-FASTFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-FASTFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-FASTFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v4, -v2, v3, -v4
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v2, v2, v3, -v5
; SI-DENORM-FASTFMAF-NEXT:    buffer_store_dword v4, v[0:1], s[0:3], 0 addr64
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64 offset:4
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_endpgm
;
; SI-DENORM-SLOWFMAF-LABEL: combine_to_mad_fsub_2_f32_2uses_mul:
; SI-DENORM-SLOWFMAF:       ; %bb.0:
; SI-DENORM-SLOWFMAF-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s7, 0xf000
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s6, 0
; SI-DENORM-SLOWFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-SLOWFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-DENORM-SLOWFMAF-NEXT:    v_mul_f32_e32 v2, v2, v3
; SI-DENORM-SLOWFMAF-NEXT:    v_sub_f32_e64 v3, -v2, v4
; SI-DENORM-SLOWFMAF-NEXT:    v_sub_f32_e32 v2, v2, v5
; SI-DENORM-SLOWFMAF-NEXT:    buffer_store_dword v3, v[0:1], s[0:3], 0 addr64
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64 offset:4
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep.0 = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %gep.1 = getelementptr float, ptr addrspace(1) %gep.0, i32 1
  %gep.2 = getelementptr float, ptr addrspace(1) %gep.0, i32 2
  %gep.3 = getelementptr float, ptr addrspace(1) %gep.0, i32 3
  %gep.out.0 = getelementptr float, ptr addrspace(1) %out, i32 %tid
  %gep.out.1 = getelementptr float, ptr addrspace(1) %gep.out.0, i32 1

  %a = load volatile float, ptr addrspace(1) %gep.0
  %b = load volatile float, ptr addrspace(1) %gep.1
  %c = load volatile float, ptr addrspace(1) %gep.2
  %d = load volatile float, ptr addrspace(1) %gep.3

  %mul = fmul contract float %a, %b
  %mul.neg = fneg contract float %mul
  %fma0 = fsub contract float %mul.neg, %c
  %fma1 = fsub contract float %mul, %d

  store volatile float %fma0, ptr addrspace(1) %gep.out.0
  store volatile float %fma1, ptr addrspace(1) %gep.out.1
  ret void
}

; fold (fsub (fma x, y, (fmul u, v)), z) -> (fma x, y (fma u, v, (fneg z)))
define amdgpu_kernel void @aggressive_combine_to_mad_fsub_0_f32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in, i1 %is_aggressive) #1 {
; SI-STD-LABEL: aggressive_combine_to_mad_fsub_0_f32:
; SI-STD:       ; %bb.0:
; SI-STD-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xb
; SI-STD-NEXT:    s_load_dword s6, s[4:5], 0xd
; SI-STD-NEXT:    s_mov_b32 s2, 0
; SI-STD-NEXT:    v_mov_b32_e32 v1, 0
; SI-STD-NEXT:    s_mov_b32 s3, 0xf000
; SI-STD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-STD-NEXT:    s_waitcnt lgkmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v2, v[0:1], s[0:3], 0 addr64 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v3, v[0:1], s[0:3], 0 addr64 offset:4 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v5, v[0:1], s[0:3], 0 addr64 offset:8 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v6, v[0:1], s[0:3], 0 addr64 offset:12 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v1, v[0:1], s[0:3], 0 addr64 offset:16 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_bitcmp1_b32 s6, 0
; SI-STD-NEXT:    s_cselect_b64 s[0:1], -1, 0
; SI-STD-NEXT:    s_and_b64 vcc, exec, s[0:1]
; SI-STD-NEXT:    s_cbranch_vccnz .LBB12_2
; SI-STD-NEXT:  ; %bb.1: ; %normal
; SI-STD-NEXT:    v_mul_f32_e32 v4, v6, v1
; SI-STD-NEXT:    v_fma_f32 v4, v2, v3, v4
; SI-STD-NEXT:    v_sub_f32_e32 v4, v4, v5
; SI-STD-NEXT:    s_mov_b64 s[2:3], 0
; SI-STD-NEXT:    s_branch .LBB12_3
; SI-STD-NEXT:  .LBB12_2:
; SI-STD-NEXT:    s_mov_b64 s[2:3], -1
; SI-STD-NEXT:    ; implicit-def: $vgpr4
; SI-STD-NEXT:  .LBB12_3: ; %Flow
; SI-STD-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-STD-NEXT:    s_andn2_b64 vcc, exec, s[2:3]
; SI-STD-NEXT:    s_waitcnt lgkmcnt(0)
; SI-STD-NEXT:    s_mov_b64 vcc, vcc
; SI-STD-NEXT:    s_cbranch_vccnz .LBB12_5
; SI-STD-NEXT:  ; %bb.4: ; %aggressive
; SI-STD-NEXT:    v_mad_f32 v4, v6, v1, -v5
; SI-STD-NEXT:    v_mac_f32_e32 v4, v2, v3
; SI-STD-NEXT:  .LBB12_5: ; %exit
; SI-STD-NEXT:    s_mov_b32 s3, 0xf000
; SI-STD-NEXT:    s_mov_b32 s2, 0
; SI-STD-NEXT:    v_mov_b32_e32 v1, 0
; SI-STD-NEXT:    buffer_store_dword v4, v[0:1], s[0:3], 0 addr64
; SI-STD-NEXT:    s_endpgm
;
; SI-DENORM-FASTFMAF-LABEL: aggressive_combine_to_mad_fsub_0_f32:
; SI-DENORM-FASTFMAF:       ; %bb.0:
; SI-DENORM-FASTFMAF-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xb
; SI-DENORM-FASTFMAF-NEXT:    s_load_dword s6, s[4:5], 0xd
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s2, 0
; SI-DENORM-FASTFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s3, 0xf000
; SI-DENORM-FASTFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[0:3], 0 addr64 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[0:3], 0 addr64 offset:4 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[0:3], 0 addr64 offset:8 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v5, v[0:1], s[0:3], 0 addr64 offset:12 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v1, v[0:1], s[0:3], 0 addr64 offset:16 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_bitcmp1_b32 s6, 0
; SI-DENORM-FASTFMAF-NEXT:    s_cselect_b64 s[0:1], -1, 0
; SI-DENORM-FASTFMAF-NEXT:    s_and_b64 vcc, exec, s[0:1]
; SI-DENORM-FASTFMAF-NEXT:    s_cbranch_vccnz .LBB12_2
; SI-DENORM-FASTFMAF-NEXT:  ; %bb.1: ; %normal
; SI-DENORM-FASTFMAF-NEXT:    v_mul_f32_e32 v6, v5, v1
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v6, v2, v3, v6
; SI-DENORM-FASTFMAF-NEXT:    v_sub_f32_e32 v6, v6, v4
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[2:3], 0
; SI-DENORM-FASTFMAF-NEXT:    s_branch .LBB12_3
; SI-DENORM-FASTFMAF-NEXT:  .LBB12_2:
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[2:3], -1
; SI-DENORM-FASTFMAF-NEXT:    ; implicit-def: $vgpr6
; SI-DENORM-FASTFMAF-NEXT:  .LBB12_3: ; %Flow
; SI-DENORM-FASTFMAF-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-DENORM-FASTFMAF-NEXT:    s_andn2_b64 vcc, exec, s[2:3]
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 vcc, vcc
; SI-DENORM-FASTFMAF-NEXT:    s_cbranch_vccnz .LBB12_5
; SI-DENORM-FASTFMAF-NEXT:  ; %bb.4: ; %aggressive
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v1, v5, v1, -v4
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v6, v2, v3, v1
; SI-DENORM-FASTFMAF-NEXT:  .LBB12_5: ; %exit
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s3, 0xf000
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s2, 0
; SI-DENORM-FASTFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-FASTFMAF-NEXT:    buffer_store_dword v6, v[0:1], s[0:3], 0 addr64
; SI-DENORM-FASTFMAF-NEXT:    s_endpgm
;
; SI-DENORM-SLOWFMAF-LABEL: aggressive_combine_to_mad_fsub_0_f32:
; SI-DENORM-SLOWFMAF:       ; %bb.0:
; SI-DENORM-SLOWFMAF-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xb
; SI-DENORM-SLOWFMAF-NEXT:    s_load_dword s6, s[4:5], 0xd
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s2, 0
; SI-DENORM-SLOWFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s3, 0xf000
; SI-DENORM-SLOWFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[0:3], 0 addr64 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[0:3], 0 addr64 offset:4 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[0:3], 0 addr64 offset:8 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v5, v[0:1], s[0:3], 0 addr64 offset:12 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v1, v[0:1], s[0:3], 0 addr64 offset:16 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_bitcmp1_b32 s6, 0
; SI-DENORM-SLOWFMAF-NEXT:    s_cselect_b64 s[0:1], -1, 0
; SI-DENORM-SLOWFMAF-NEXT:    s_and_b64 vcc, exec, s[0:1]
; SI-DENORM-SLOWFMAF-NEXT:    v_mul_f32_e32 v1, v5, v1
; SI-DENORM-SLOWFMAF-NEXT:    v_fma_f32 v1, v3, v4, v1
; SI-DENORM-SLOWFMAF-NEXT:    s_cbranch_vccnz .LBB12_2
; SI-DENORM-SLOWFMAF-NEXT:  ; %bb.1: ; %normal
; SI-DENORM-SLOWFMAF-NEXT:    v_sub_f32_e32 v3, v1, v2
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[2:3], 0
; SI-DENORM-SLOWFMAF-NEXT:    s_branch .LBB12_3
; SI-DENORM-SLOWFMAF-NEXT:  .LBB12_2:
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[2:3], -1
; SI-DENORM-SLOWFMAF-NEXT:    ; implicit-def: $vgpr3
; SI-DENORM-SLOWFMAF-NEXT:  .LBB12_3: ; %Flow
; SI-DENORM-SLOWFMAF-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-DENORM-SLOWFMAF-NEXT:    s_andn2_b64 vcc, exec, s[2:3]
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 vcc, vcc
; SI-DENORM-SLOWFMAF-NEXT:    s_cbranch_vccnz .LBB12_5
; SI-DENORM-SLOWFMAF-NEXT:  ; %bb.4: ; %aggressive
; SI-DENORM-SLOWFMAF-NEXT:    v_sub_f32_e32 v3, v1, v2
; SI-DENORM-SLOWFMAF-NEXT:  .LBB12_5: ; %exit
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s3, 0xf000
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s2, 0
; SI-DENORM-SLOWFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-SLOWFMAF-NEXT:    buffer_store_dword v3, v[0:1], s[0:3], 0 addr64
; SI-DENORM-SLOWFMAF-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep.0 = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %gep.1 = getelementptr float, ptr addrspace(1) %gep.0, i32 1
  %gep.2 = getelementptr float, ptr addrspace(1) %gep.0, i32 2
  %gep.3 = getelementptr float, ptr addrspace(1) %gep.0, i32 3
  %gep.4 = getelementptr float, ptr addrspace(1) %gep.0, i32 4
  %gep.out = getelementptr float, ptr addrspace(1) %out, i32 %tid

  %x = load volatile float, ptr addrspace(1) %gep.0
  %y = load volatile float, ptr addrspace(1) %gep.1
  %z = load volatile float, ptr addrspace(1) %gep.2
  %u = load volatile float, ptr addrspace(1) %gep.3
  %v = load volatile float, ptr addrspace(1) %gep.4

  br i1 %is_aggressive, label %aggressive, label %normal

normal:
  %tmp0_normal = fmul float %u, %v
  %tmp1_normal = call float @llvm.fma.f32(float %x, float %y, float %tmp0_normal) #0
  %tmp2_normal = fsub float %tmp1_normal, %z
  br label %exit

aggressive:
  %tmp0_aggressive = fmul contract reassoc float %u, %v
  %tmp1_aggressive = call contract reassoc float @llvm.fma.f32(float %x, float %y, float %tmp0_aggressive) #0
  %tmp2_aggressive = fsub contract reassoc float %tmp1_aggressive, %z
  br label %exit

exit:
  %tmp2 = phi float [%tmp2_normal, %normal], [%tmp2_aggressive, %aggressive]
  store float %tmp2, ptr addrspace(1) %gep.out
  ret void
}

; fold (fsub x, (fma y, z, (fmul u, v)))
;   -> (fma (fneg y), z, (fma (fneg u), v, x))
define amdgpu_kernel void @aggressive_combine_to_mad_fsub_1_f32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) #1 {
; SI-LABEL: aggressive_combine_to_mad_fsub_1_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_dword v6, v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-NEXT:    v_mul_f32_e32 v5, v5, v6
; SI-NEXT:    v_fma_f32 v3, v3, v4, v5
; SI-NEXT:    v_sub_f32_e32 v2, v2, v3
; SI-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep.0 = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %gep.1 = getelementptr float, ptr addrspace(1) %gep.0, i32 1
  %gep.2 = getelementptr float, ptr addrspace(1) %gep.0, i32 2
  %gep.3 = getelementptr float, ptr addrspace(1) %gep.0, i32 3
  %gep.4 = getelementptr float, ptr addrspace(1) %gep.0, i32 4
  %gep.out = getelementptr float, ptr addrspace(1) %out, i32 %tid

  %x = load volatile float, ptr addrspace(1) %gep.0
  %y = load volatile float, ptr addrspace(1) %gep.1
  %z = load volatile float, ptr addrspace(1) %gep.2
  %u = load volatile float, ptr addrspace(1) %gep.3
  %v = load volatile float, ptr addrspace(1) %gep.4

  %tmp0 = fmul float %u, %v
  %tmp1 = call float @llvm.fma.f32(float %y, float %z, float %tmp0) #0
  %tmp2 = fsub float %x, %tmp1

  store float %tmp2, ptr addrspace(1) %gep.out
  ret void
}

; fold (fsub (fma x, y, (fmul u, v)), z) -> (fma x, y (fma u, v, (fneg z)))
define amdgpu_kernel void @aggressive_combine_to_mad_fsub_2_f32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in, i1 %is_aggressive) #1 {
; SI-STD-LABEL: aggressive_combine_to_mad_fsub_2_f32:
; SI-STD:       ; %bb.0:
; SI-STD-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xb
; SI-STD-NEXT:    s_load_dword s6, s[4:5], 0xd
; SI-STD-NEXT:    s_mov_b32 s2, 0
; SI-STD-NEXT:    v_mov_b32_e32 v1, 0
; SI-STD-NEXT:    s_mov_b32 s3, 0xf000
; SI-STD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-STD-NEXT:    s_waitcnt lgkmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v2, v[0:1], s[0:3], 0 addr64 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v3, v[0:1], s[0:3], 0 addr64 offset:4 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v4, v[0:1], s[0:3], 0 addr64 offset:8 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v6, v[0:1], s[0:3], 0 addr64 offset:12 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v1, v[0:1], s[0:3], 0 addr64 offset:16 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_bitcmp1_b32 s6, 0
; SI-STD-NEXT:    s_cselect_b64 s[0:1], -1, 0
; SI-STD-NEXT:    s_and_b64 vcc, exec, s[0:1]
; SI-STD-NEXT:    s_cbranch_vccnz .LBB14_2
; SI-STD-NEXT:  ; %bb.1: ; %normal
; SI-STD-NEXT:    v_mul_f32_e32 v5, v6, v1
; SI-STD-NEXT:    v_mac_f32_e32 v5, v2, v3
; SI-STD-NEXT:    v_sub_f32_e32 v5, v5, v4
; SI-STD-NEXT:    s_mov_b64 s[2:3], 0
; SI-STD-NEXT:    s_branch .LBB14_3
; SI-STD-NEXT:  .LBB14_2:
; SI-STD-NEXT:    s_mov_b64 s[2:3], -1
; SI-STD-NEXT:    ; implicit-def: $vgpr5
; SI-STD-NEXT:  .LBB14_3: ; %Flow
; SI-STD-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-STD-NEXT:    s_andn2_b64 vcc, exec, s[2:3]
; SI-STD-NEXT:    s_waitcnt lgkmcnt(0)
; SI-STD-NEXT:    s_mov_b64 vcc, vcc
; SI-STD-NEXT:    s_cbranch_vccnz .LBB14_5
; SI-STD-NEXT:  ; %bb.4: ; %aggressive
; SI-STD-NEXT:    v_mad_f32 v5, v6, v1, -v4
; SI-STD-NEXT:    v_mac_f32_e32 v5, v2, v3
; SI-STD-NEXT:  .LBB14_5: ; %exit
; SI-STD-NEXT:    s_mov_b32 s3, 0xf000
; SI-STD-NEXT:    s_mov_b32 s2, 0
; SI-STD-NEXT:    v_mov_b32_e32 v1, 0
; SI-STD-NEXT:    buffer_store_dword v5, v[0:1], s[0:3], 0 addr64
; SI-STD-NEXT:    s_endpgm
;
; SI-DENORM-FASTFMAF-LABEL: aggressive_combine_to_mad_fsub_2_f32:
; SI-DENORM-FASTFMAF:       ; %bb.0:
; SI-DENORM-FASTFMAF-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xb
; SI-DENORM-FASTFMAF-NEXT:    s_load_dword s6, s[4:5], 0xd
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s2, 0
; SI-DENORM-FASTFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s3, 0xf000
; SI-DENORM-FASTFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[0:3], 0 addr64 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[0:3], 0 addr64 offset:4 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[0:3], 0 addr64 offset:8 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v5, v[0:1], s[0:3], 0 addr64 offset:12 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v1, v[0:1], s[0:3], 0 addr64 offset:16 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_bitcmp1_b32 s6, 0
; SI-DENORM-FASTFMAF-NEXT:    s_cselect_b64 s[0:1], -1, 0
; SI-DENORM-FASTFMAF-NEXT:    s_and_b64 vcc, exec, s[0:1]
; SI-DENORM-FASTFMAF-NEXT:    s_cbranch_vccnz .LBB14_2
; SI-DENORM-FASTFMAF-NEXT:  ; %bb.1: ; %normal
; SI-DENORM-FASTFMAF-NEXT:    v_mul_f32_e32 v6, v5, v1
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v6, v2, v3, v6
; SI-DENORM-FASTFMAF-NEXT:    v_sub_f32_e32 v6, v6, v4
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[2:3], 0
; SI-DENORM-FASTFMAF-NEXT:    s_branch .LBB14_3
; SI-DENORM-FASTFMAF-NEXT:  .LBB14_2:
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[2:3], -1
; SI-DENORM-FASTFMAF-NEXT:    ; implicit-def: $vgpr6
; SI-DENORM-FASTFMAF-NEXT:  .LBB14_3: ; %Flow
; SI-DENORM-FASTFMAF-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-DENORM-FASTFMAF-NEXT:    s_andn2_b64 vcc, exec, s[2:3]
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 vcc, vcc
; SI-DENORM-FASTFMAF-NEXT:    s_cbranch_vccnz .LBB14_5
; SI-DENORM-FASTFMAF-NEXT:  ; %bb.4: ; %aggressive
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v1, v5, v1, -v4
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v6, v2, v3, v1
; SI-DENORM-FASTFMAF-NEXT:  .LBB14_5: ; %exit
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s3, 0xf000
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s2, 0
; SI-DENORM-FASTFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-FASTFMAF-NEXT:    buffer_store_dword v6, v[0:1], s[0:3], 0 addr64
; SI-DENORM-FASTFMAF-NEXT:    s_endpgm
;
; SI-DENORM-SLOWFMAF-LABEL: aggressive_combine_to_mad_fsub_2_f32:
; SI-DENORM-SLOWFMAF:       ; %bb.0:
; SI-DENORM-SLOWFMAF-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xb
; SI-DENORM-SLOWFMAF-NEXT:    s_load_dword s6, s[4:5], 0xd
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s2, 0
; SI-DENORM-SLOWFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s3, 0xf000
; SI-DENORM-SLOWFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[0:3], 0 addr64 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[0:3], 0 addr64 offset:4 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[0:3], 0 addr64 offset:8 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v5, v[0:1], s[0:3], 0 addr64 offset:12 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v1, v[0:1], s[0:3], 0 addr64 offset:16 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_bitcmp1_b32 s6, 0
; SI-DENORM-SLOWFMAF-NEXT:    s_cselect_b64 s[0:1], -1, 0
; SI-DENORM-SLOWFMAF-NEXT:    s_and_b64 vcc, exec, s[0:1]
; SI-DENORM-SLOWFMAF-NEXT:    v_mul_f32_e32 v3, v3, v4
; SI-DENORM-SLOWFMAF-NEXT:    v_mul_f32_e32 v1, v5, v1
; SI-DENORM-SLOWFMAF-NEXT:    v_add_f32_e32 v1, v3, v1
; SI-DENORM-SLOWFMAF-NEXT:    s_cbranch_vccnz .LBB14_2
; SI-DENORM-SLOWFMAF-NEXT:  ; %bb.1: ; %normal
; SI-DENORM-SLOWFMAF-NEXT:    v_sub_f32_e32 v3, v1, v2
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[2:3], 0
; SI-DENORM-SLOWFMAF-NEXT:    s_branch .LBB14_3
; SI-DENORM-SLOWFMAF-NEXT:  .LBB14_2:
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[2:3], -1
; SI-DENORM-SLOWFMAF-NEXT:    ; implicit-def: $vgpr3
; SI-DENORM-SLOWFMAF-NEXT:  .LBB14_3: ; %Flow
; SI-DENORM-SLOWFMAF-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-DENORM-SLOWFMAF-NEXT:    s_andn2_b64 vcc, exec, s[2:3]
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 vcc, vcc
; SI-DENORM-SLOWFMAF-NEXT:    s_cbranch_vccnz .LBB14_5
; SI-DENORM-SLOWFMAF-NEXT:  ; %bb.4: ; %aggressive
; SI-DENORM-SLOWFMAF-NEXT:    v_sub_f32_e32 v3, v1, v2
; SI-DENORM-SLOWFMAF-NEXT:  .LBB14_5: ; %exit
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s3, 0xf000
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s2, 0
; SI-DENORM-SLOWFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-SLOWFMAF-NEXT:    buffer_store_dword v3, v[0:1], s[0:3], 0 addr64
; SI-DENORM-SLOWFMAF-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep.0 = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %gep.1 = getelementptr float, ptr addrspace(1) %gep.0, i32 1
  %gep.2 = getelementptr float, ptr addrspace(1) %gep.0, i32 2
  %gep.3 = getelementptr float, ptr addrspace(1) %gep.0, i32 3
  %gep.4 = getelementptr float, ptr addrspace(1) %gep.0, i32 4
  %gep.out = getelementptr float, ptr addrspace(1) %out, i32 %tid

  %x = load volatile float, ptr addrspace(1) %gep.0
  %y = load volatile float, ptr addrspace(1) %gep.1
  %z = load volatile float, ptr addrspace(1) %gep.2
  %u = load volatile float, ptr addrspace(1) %gep.3
  %v = load volatile float, ptr addrspace(1) %gep.4

  br i1 %is_aggressive, label %aggressive, label %normal

normal:
  %tmp0_normal = fmul float %u, %v
  %tmp1_normal = call float @llvm.fmuladd.f32(float %x, float %y, float %tmp0_normal) #0
  %tmp2_normal = fsub float %tmp1_normal, %z
  br label %exit

aggressive:
  %tmp0_aggressive = fmul contract reassoc float %u, %v
  %tmp1_aggressive = call contract reassoc float @llvm.fmuladd.f32(float %x, float %y, float %tmp0_aggressive) #0
  %tmp2_aggressive = fsub contract reassoc float %tmp1_aggressive, %z
  br label %exit

exit:
  %tmp2 = phi float [%tmp2_normal, %normal], [%tmp2_aggressive, %aggressive]
  store float %tmp2, ptr addrspace(1) %gep.out
  ret void
}

; fold (fsub x, (fmuladd y, z, (fmul u, v)))
;   -> (fmuladd (fneg y), z, (fmuladd (fneg u), v, x))
define amdgpu_kernel void @aggressive_combine_to_mad_fsub_3_f32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in, i1 %is_aggressive) #1 {
; SI-STD-LABEL: aggressive_combine_to_mad_fsub_3_f32:
; SI-STD:       ; %bb.0:
; SI-STD-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xb
; SI-STD-NEXT:    s_load_dword s6, s[4:5], 0xd
; SI-STD-NEXT:    s_mov_b32 s2, 0
; SI-STD-NEXT:    v_mov_b32_e32 v1, 0
; SI-STD-NEXT:    s_mov_b32 s3, 0xf000
; SI-STD-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-STD-NEXT:    s_waitcnt lgkmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v2, v[0:1], s[0:3], 0 addr64 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v3, v[0:1], s[0:3], 0 addr64 offset:4 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v4, v[0:1], s[0:3], 0 addr64 offset:8 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v5, v[0:1], s[0:3], 0 addr64 offset:12 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    buffer_load_dword v1, v[0:1], s[0:3], 0 addr64 offset:16 glc
; SI-STD-NEXT:    s_waitcnt vmcnt(0)
; SI-STD-NEXT:    s_bitcmp1_b32 s6, 0
; SI-STD-NEXT:    s_cselect_b64 s[0:1], -1, 0
; SI-STD-NEXT:    s_and_b64 vcc, exec, s[0:1]
; SI-STD-NEXT:    s_cbranch_vccnz .LBB15_2
; SI-STD-NEXT:  ; %bb.1: ; %normal
; SI-STD-NEXT:    v_mul_f32_e32 v6, v5, v1
; SI-STD-NEXT:    v_mac_f32_e32 v6, v3, v4
; SI-STD-NEXT:    v_sub_f32_e32 v6, v2, v6
; SI-STD-NEXT:    s_mov_b64 s[2:3], 0
; SI-STD-NEXT:    s_branch .LBB15_3
; SI-STD-NEXT:  .LBB15_2:
; SI-STD-NEXT:    s_mov_b64 s[2:3], -1
; SI-STD-NEXT:    ; implicit-def: $vgpr6
; SI-STD-NEXT:  .LBB15_3: ; %Flow
; SI-STD-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-STD-NEXT:    s_andn2_b64 vcc, exec, s[2:3]
; SI-STD-NEXT:    s_waitcnt lgkmcnt(0)
; SI-STD-NEXT:    s_mov_b64 vcc, vcc
; SI-STD-NEXT:    s_cbranch_vccnz .LBB15_5
; SI-STD-NEXT:  ; %bb.4: ; %aggressive
; SI-STD-NEXT:    v_mad_f32 v1, -v5, v1, v2
; SI-STD-NEXT:    v_mad_f32 v6, -v3, v4, v1
; SI-STD-NEXT:  .LBB15_5: ; %exit
; SI-STD-NEXT:    s_mov_b32 s3, 0xf000
; SI-STD-NEXT:    s_mov_b32 s2, 0
; SI-STD-NEXT:    v_mov_b32_e32 v1, 0
; SI-STD-NEXT:    buffer_store_dword v6, v[0:1], s[0:3], 0 addr64
; SI-STD-NEXT:    s_endpgm
;
; SI-DENORM-FASTFMAF-LABEL: aggressive_combine_to_mad_fsub_3_f32:
; SI-DENORM-FASTFMAF:       ; %bb.0:
; SI-DENORM-FASTFMAF-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xb
; SI-DENORM-FASTFMAF-NEXT:    s_load_dword s6, s[4:5], 0xd
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s2, 0
; SI-DENORM-FASTFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s3, 0xf000
; SI-DENORM-FASTFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[0:3], 0 addr64 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[0:3], 0 addr64 offset:4 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[0:3], 0 addr64 offset:8 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v5, v[0:1], s[0:3], 0 addr64 offset:12 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    buffer_load_dword v1, v[0:1], s[0:3], 0 addr64 offset:16 glc
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_bitcmp1_b32 s6, 0
; SI-DENORM-FASTFMAF-NEXT:    s_cselect_b64 s[0:1], -1, 0
; SI-DENORM-FASTFMAF-NEXT:    s_and_b64 vcc, exec, s[0:1]
; SI-DENORM-FASTFMAF-NEXT:    s_cbranch_vccnz .LBB15_2
; SI-DENORM-FASTFMAF-NEXT:  ; %bb.1: ; %normal
; SI-DENORM-FASTFMAF-NEXT:    v_mul_f32_e32 v6, v5, v1
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v6, v3, v4, v6
; SI-DENORM-FASTFMAF-NEXT:    v_sub_f32_e32 v6, v2, v6
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[2:3], 0
; SI-DENORM-FASTFMAF-NEXT:    s_branch .LBB15_3
; SI-DENORM-FASTFMAF-NEXT:  .LBB15_2:
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 s[2:3], -1
; SI-DENORM-FASTFMAF-NEXT:    ; implicit-def: $vgpr6
; SI-DENORM-FASTFMAF-NEXT:  .LBB15_3: ; %Flow
; SI-DENORM-FASTFMAF-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-DENORM-FASTFMAF-NEXT:    s_andn2_b64 vcc, exec, s[2:3]
; SI-DENORM-FASTFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b64 vcc, vcc
; SI-DENORM-FASTFMAF-NEXT:    s_cbranch_vccnz .LBB15_5
; SI-DENORM-FASTFMAF-NEXT:  ; %bb.4: ; %aggressive
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v1, -v5, v1, v2
; SI-DENORM-FASTFMAF-NEXT:    v_fma_f32 v6, -v3, v4, v1
; SI-DENORM-FASTFMAF-NEXT:  .LBB15_5: ; %exit
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s3, 0xf000
; SI-DENORM-FASTFMAF-NEXT:    s_mov_b32 s2, 0
; SI-DENORM-FASTFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-FASTFMAF-NEXT:    buffer_store_dword v6, v[0:1], s[0:3], 0 addr64
; SI-DENORM-FASTFMAF-NEXT:    s_endpgm
;
; SI-DENORM-SLOWFMAF-LABEL: aggressive_combine_to_mad_fsub_3_f32:
; SI-DENORM-SLOWFMAF:       ; %bb.0:
; SI-DENORM-SLOWFMAF-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xb
; SI-DENORM-SLOWFMAF-NEXT:    s_load_dword s6, s[4:5], 0xd
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s2, 0
; SI-DENORM-SLOWFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s3, 0xf000
; SI-DENORM-SLOWFMAF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v2, v[0:1], s[0:3], 0 addr64 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v3, v[0:1], s[0:3], 0 addr64 offset:4 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v4, v[0:1], s[0:3], 0 addr64 offset:8 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v5, v[0:1], s[0:3], 0 addr64 offset:12 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    buffer_load_dword v1, v[0:1], s[0:3], 0 addr64 offset:16 glc
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt vmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_bitcmp1_b32 s6, 0
; SI-DENORM-SLOWFMAF-NEXT:    s_cselect_b64 s[0:1], -1, 0
; SI-DENORM-SLOWFMAF-NEXT:    s_and_b64 vcc, exec, s[0:1]
; SI-DENORM-SLOWFMAF-NEXT:    v_mul_f32_e32 v3, v3, v4
; SI-DENORM-SLOWFMAF-NEXT:    v_mul_f32_e32 v1, v5, v1
; SI-DENORM-SLOWFMAF-NEXT:    v_add_f32_e32 v1, v3, v1
; SI-DENORM-SLOWFMAF-NEXT:    s_cbranch_vccnz .LBB15_2
; SI-DENORM-SLOWFMAF-NEXT:  ; %bb.1: ; %normal
; SI-DENORM-SLOWFMAF-NEXT:    v_sub_f32_e32 v3, v2, v1
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[2:3], 0
; SI-DENORM-SLOWFMAF-NEXT:    s_branch .LBB15_3
; SI-DENORM-SLOWFMAF-NEXT:  .LBB15_2:
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 s[2:3], -1
; SI-DENORM-SLOWFMAF-NEXT:    ; implicit-def: $vgpr3
; SI-DENORM-SLOWFMAF-NEXT:  .LBB15_3: ; %Flow
; SI-DENORM-SLOWFMAF-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-DENORM-SLOWFMAF-NEXT:    s_andn2_b64 vcc, exec, s[2:3]
; SI-DENORM-SLOWFMAF-NEXT:    s_waitcnt lgkmcnt(0)
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b64 vcc, vcc
; SI-DENORM-SLOWFMAF-NEXT:    s_cbranch_vccnz .LBB15_5
; SI-DENORM-SLOWFMAF-NEXT:  ; %bb.4: ; %aggressive
; SI-DENORM-SLOWFMAF-NEXT:    v_sub_f32_e32 v3, v2, v1
; SI-DENORM-SLOWFMAF-NEXT:  .LBB15_5: ; %exit
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s3, 0xf000
; SI-DENORM-SLOWFMAF-NEXT:    s_mov_b32 s2, 0
; SI-DENORM-SLOWFMAF-NEXT:    v_mov_b32_e32 v1, 0
; SI-DENORM-SLOWFMAF-NEXT:    buffer_store_dword v3, v[0:1], s[0:3], 0 addr64
; SI-DENORM-SLOWFMAF-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep.0 = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %gep.1 = getelementptr float, ptr addrspace(1) %gep.0, i32 1
  %gep.2 = getelementptr float, ptr addrspace(1) %gep.0, i32 2
  %gep.3 = getelementptr float, ptr addrspace(1) %gep.0, i32 3
  %gep.4 = getelementptr float, ptr addrspace(1) %gep.0, i32 4
  %gep.out = getelementptr float, ptr addrspace(1) %out, i32 %tid

  %x = load volatile float, ptr addrspace(1) %gep.0
  %y = load volatile float, ptr addrspace(1) %gep.1
  %z = load volatile float, ptr addrspace(1) %gep.2
  %u = load volatile float, ptr addrspace(1) %gep.3
  %v = load volatile float, ptr addrspace(1) %gep.4

  br i1 %is_aggressive, label %aggressive, label %normal

normal:
  ; nsz flag is needed since this combine may change sign of zero
  %tmp0_normal = fmul nsz float %u, %v
  %tmp1_normal = call nsz float @llvm.fmuladd.f32(float %y, float %z, float %tmp0_normal) #0
  %tmp2_normal = fsub nsz float %x, %tmp1_normal
  br label %exit

aggressive:
  %tmp0_aggressive = fmul contract reassoc nsz float %u, %v
  %tmp1_aggressive = call contract reassoc nsz float @llvm.fmuladd.f32(float %y, float %z, float %tmp0_aggressive) #0
  %tmp2_aggressive = fsub contract reassoc nsz float %x, %tmp1_aggressive
  br label %exit

exit:
  %tmp2 = phi float [%tmp2_normal, %normal], [%tmp2_aggressive, %aggressive]
  store float %tmp2, ptr addrspace(1) %gep.out
  ret void
}

attributes #0 = { nounwind readnone }
attributes #1 = { nounwind }
