use strict;
use warnings;
use Test::More tests => 8;
use MIME::Words qw(:all);

is(encode_mimeword('wookie', 'Q', 'ISO-8859-1'),
    '=?ISO-8859-1?Q?wookie?=');
is(encode_mimeword('Franois', 'Q', 'ISO-8859-1'),
    '=?ISO-8859-1?Q?Fran=E7ois?=');
is(encode_mimewords('Me and Franois'), 'Me and =?ISO-8859-1?Q?Fran=E7ois?=');
is(decode_mimewords('Me and =?ISO-8859-1?Q?Fran=E7ois?='),
   'Me and Franois');

is(encode_mimewords('Me and Franois and Franois    and Franois       and Franois               and Franois                      and Franois'),
   'Me and =?ISO-8859-1?Q?Fran=E7ois=20?=and =?ISO-8859-1?Q?Fran=E7ois=20=20=20=20?=and =?ISO-8859-1?Q?Fran=E7ois=20=20=20=20=20=20=20?=and =?ISO-8859-1?Q?Fran=E7ois=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20?=and =?ISO-8859-1?Q?Fran=E7ois=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20?=and =?ISO-8859-1?Q?Fran=E7ois?=');


is(decode_mimewords('Me and =?ISO-8859-1?Q?Fran=E7ois=20?=and =?ISO-8859-1?Q?Fran=E7ois=20=20=20=20?=and =?ISO-8859-1?Q?Fran=E7ois=20=20=20=20=20=20=20?=and =?ISO-8859-1?Q?Fran=E7ois=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20?=and =?ISO-8859-1?Q?Fran=E7ois=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20?=and =?ISO-8859-1?Q?Fran=E7ois?='),
   'Me and Franois and Franois    and Franois       and Franois               and Franois                      and Franois');


is(encode_mimewords('Me and Franois and Franois    and Franois       and Franois               and Franois                      and Franois and wookie and wookie and wookie and wookie and wookie and wookie'),
   'Me and =?ISO-8859-1?Q?Fran=E7ois=20?=and =?ISO-8859-1?Q?Fran=E7ois=20=20=20=20?=and =?ISO-8859-1?Q?Fran=E7ois=20=20=20=20=20=20=20?=and =?ISO-8859-1?Q?Fran=E7ois=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20?=and =?ISO-8859-1?Q?Fran=E7ois=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20?=and =?ISO-8859-1?Q?Fran=E7ois=20?=and wookie and wookie and wookie and wookie and wookie and wookie');

is(decode_mimewords('Me and =?ISO-8859-1?Q?Fran=E7ois=20?=and =?ISO-8859-1?Q?Fran=E7ois=20=20=20=20?=and =?ISO-8859-1?Q?Fran=E7ois=20=20=20=20=20=20=20?=and =?ISO-8859-1?Q?Fran=E7ois=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20?=and =?ISO-8859-1?Q?Fran=E7ois=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20=20?=and =?ISO-8859-1?Q?Fran=E7ois=20?=and wookie and wookie and wookie and wookie and wookie and wookie'),
   'Me and Franois and Franois    and Franois       and Franois               and Franois                      and Franois and wookie and wookie and wookie and wookie and wookie and wookie');
