#!/usr/bin/perl

package eBay::API::XML::DataType::ItemListCustomizationType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ItemListCustomizationType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ItemListCustomizationType

=head1 DESCRIPTION

Defines how a list of items should be returned.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ItemListCustomizationType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::PaginationType;
use eBay::API::XML::DataType::Enum::ItemSortTypeCodeType;
use eBay::API::XML::DataType::Enum::ListingTypeCodeType;


my @gaProperties = ( [ 'DurationInDays', 'xs:int', '', '', '' ]
	, [ 'Include', 'xs:boolean', '', '', '' ]
	, [ 'IncludeNotes', 'xs:boolean', '', '', '' ]
	, [ 'ListingType', 'ns:ListingTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ListingTypeCodeType', '' ]
	, [ 'Pagination', 'ns:PaginationType', ''
	     ,'eBay::API::XML::DataType::PaginationType', '1' ]
	, [ 'Sort', 'ns:ItemSortTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ItemSortTypeCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDurationInDays()

Specifies the time period during which an item was
won or lost. Similar to the period drop-down menu
in the My eBay user interface. Valid for WonList, 
DeletedFromWonList, LostList, DeletedFromLostList, SoldList, 
DeletedFromSoldList, UnsoldList, DeletedFromUnsoldList,
BestOfferList, BuyingReminders, and SellingReminders.

Max: 60
Min: 0

  Calls: GetMyeBayBuying
  RequiredInput: No
  Context: BestOfferList
           LostList
           DeletedFromLostList
           WonList
           DeletedFromWonList

  Calls: GetMyeBaySelling
  RequiredInput: No
  Context: SoldList
           DeletedFromSoldList
           DeletedFromUnsoldList
           UnsoldList

#    Argument: 'xs:int'

=cut

sub setDurationInDays {
  my $self = shift;
  $self->{'DurationInDays'} = shift
}

=head2 getDurationInDays()

#    Returns: 'xs:int'

=cut

sub getDurationInDays {
  my $self = shift;
  return $self->{'DurationInDays'};
}


=head2 setInclude()

Returns the list using the default settings.

  Calls: GetMyeBayBuying
  RequiredInput: No
  Context: BestOfferList

#    Argument: 'xs:boolean'

=cut

sub setInclude {
  my $self = shift;
  $self->{'Include'} = shift
}

=head2 isInclude()

#    Returns: 'xs:boolean'

=cut

sub isInclude {
  my $self = shift;
  return $self->{'Include'};
}


=head2 setIncludeNotes()

Specifies whether to include Item.PrivateNotes and Item.eBayNotes
in the response. Valid for WatchList, BidList, WonList, DeletedFromWonList,
LostList, DeletedFromLostList, ScheduledList, ActiveList, SoldList, 
and UnsoldList.

  Calls: GetMyeBayBuying
  RequiredInput: No
  Context: BestOfferList
           BidList
           LostList
           WatchList
           WonList
           DeletedFromWonList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  RequiredInput: No
  Context: BidList
           SoldList
           UnsoldList
           DeletedFromSoldList
           DeletedFromUnsoldList
           ScheduledList
           ActiveList

#    Argument: 'xs:boolean'

=cut

sub setIncludeNotes {
  my $self = shift;
  $self->{'IncludeNotes'} = shift
}

=head2 isIncludeNotes()

#    Returns: 'xs:boolean'

=cut

sub isIncludeNotes {
  my $self = shift;
  return $self->{'IncludeNotes'};
}


=head2 setListingType()

Specifies the listing type of items in the returned list.
In GetMyeBaySelling, valid only for ActiveList.

  Calls: GetMyeBayBuying
  RequiredInput: No
  OnlyTheseValues: Auction, FixedPriceItem, StoresFixedPrice,
							AdType
  Context: BestOfferList

  Calls: GetMyeBaySelling
  RequiredInput: No
  OnlyTheseValues: Auction, FixedPriceItem, StoresFixedPrice,
							AdType
  Context: ActiveList

#    Argument: 'ns:ListingTypeCodeType'

=cut

sub setListingType {
  my $self = shift;
  $self->{'ListingType'} = shift
}

=head2 getListingType()

#    Returns: 'ns:ListingTypeCodeType'

=cut

sub getListingType {
  my $self = shift;
  return $self->{'ListingType'};
}


=head2 setPagination()

Specifies how to create virtual pages in the returned list.
Valid for BidList, WonList, LostList, ScheduledList, ActiveList, 
SoldList, DeleteFromSoldList, UnsoldList, DeleteFromUnsoldList, and 
GetItemsAwaitingFeedback. Default for EntriesPerPage with GetMyeBayBuying is 200.

  Calls: GetMyeBaySelling
  RequiredInput: No
  Context: BidList
           ActiveList
           ScheduledList
           SoldList
           UnsoldList
           DeleteFromSoldList
           DeleteFromUnsoldList

  Calls: GetMyeBayBuying
  RequiredInput: No
  Context: BestOfferList
           BidList
           LostList
           DeletedFromLostList
           WonList
           DeletedFromWonList

#    Argument: 'ns:PaginationType'

=cut

sub setPagination {
  my $self = shift;
  $self->{'Pagination'} = shift
}

=head2 getPagination()

#    Returns: 'ns:PaginationType'

=cut

sub getPagination {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Pagination'
		,'eBay::API::XML::DataType::PaginationType');
}


=head2 setSort()

Specifies how the items returned should be sorted.
Valid for BestOfferList, BidList, LostList, DeleteFromLostList, 
WatchList, WonList, and DeleteFromWonList for GetMyeBayBuying. 
Valid for BidList, ScheduledList, ActiveList, SoldList, DeletedFromSoldList,
UnsoldList, and DeletedFromUnsoldList for GetMyeBaySelling. Also 
valid for GetItemsAwaitingFeedback.

  Calls: GetMyeBayBuying
  RequiredInput: No
  Context: BestOfferList
           BidList
           DeletedFromLostList
           DeletedFromWonList
           LostList
           WatchList
           WonList

  Calls: GetMyeBaySelling
  RequiredInput: No
  Context: BidList
           ScheduledList
           ActiveList
           SoldList
           DeletedFromSoldList
           UnsoldList
           DeletedFromUnsoldList

  Calls: GetItemsAwaitingFeedback
  RequiredInput: No

#    Argument: 'ns:ItemSortTypeCodeType'

=cut

sub setSort {
  my $self = shift;
  $self->{'Sort'} = shift
}

=head2 getSort()

#    Returns: 'ns:ItemSortTypeCodeType'

=cut

sub getSort {
  my $self = shift;
  return $self->{'Sort'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
