#!/usr/bin/perl

package eBay::API::XML::DataType::UserIdPasswordType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. UserIdPasswordType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::UserIdPasswordType

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::UserIdPasswordType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'AppId', 'xs:string', '', '', '' ]
	, [ 'AuthCert', 'xs:string', '', '', '' ]
	, [ 'DevId', 'xs:string', '', '', '' ]
	, [ 'Password', 'xs:string', '', '', '' ]
	, [ 'Username', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAppId()

The application ID that is unique to each application you (or your company)
has registered with the eBay Developers Program. If you are executing a call
in the Sandbox, this is the "AppId" value that eBay issued to you when you
received your Sandbox keys. If you are executing a call in Production, this is
the "AppId" value that eBay issued to you when you received your Production
keys.

  Calls: FetchToken
  RequiredInput: Yes

#    Argument: 'xs:string'

=cut

sub setAppId {
  my $self = shift;
  $self->{'AppId'} = shift
}

=head2 getAppId()

#    Returns: 'xs:string'

=cut

sub getAppId {
  my $self = shift;
  return $self->{'AppId'};
}


=head2 setAuthCert()

Authentication certificate that authenticates the application when making API
calls. If you are executing a call in the Sandbox, this is the "CertId" value
that eBay issued to you when you received your Sandbox keys. If you are
executing a call in Production, this is the "CertId" value that eBay issued to
you when you received your Production keys. This is unrelated to auth tokens.

  Calls: FetchToken
  RequiredInput: Yes

#    Argument: 'xs:string'

=cut

sub setAuthCert {
  my $self = shift;
  $self->{'AuthCert'} = shift
}

=head2 getAuthCert()

#    Returns: 'xs:string'

=cut

sub getAuthCert {
  my $self = shift;
  return $self->{'AuthCert'};
}


=head2 setDevId()

The unique developer ID that the eBay Developers Program issued to you (or
your company). If you are executing a call in the Sandbox, this is the "DevId"
value that eBay issued to you when you received your Sandbox keys. Typically,
you receive your Sandbox keys when you register as a new developer. If you are
executing a call in Production, this is the "DevId" value that eBay issued to
you when you received your Production keys. Typically, you receive your
Production keys when you certify an application.

  Calls: FetchToken
  RequiredInput: Yes

#    Argument: 'xs:string'

=cut

sub setDevId {
  my $self = shift;
  $self->{'DevId'} = shift
}

=head2 getDevId()

#    Returns: 'xs:string'

=cut

sub getDevId {
  my $self = shift;
  return $self->{'DevId'};
}


=head2 setPassword()

Password for the user specified in Username.

#    Argument: 'xs:string'

=cut

sub setPassword {
  my $self = shift;
  $self->{'Password'} = shift
}

=head2 getPassword()

#    Returns: 'xs:string'

=cut

sub getPassword {
  my $self = shift;
  return $self->{'Password'};
}


=head2 setUsername()

eBay user ID (i.e., eBay.com Web site login name) for the user the application
is retrieving a token for. This is typically the application's end-user (not
the developer).

MaxLength: 64

  Calls: FetchToken
  RequiredInput: Yes

#    Argument: 'xs:string'

=cut

sub setUsername {
  my $self = shift;
  $self->{'Username'} = shift
}

=head2 getUsername()

#    Returns: 'xs:string'

=cut

sub getUsername {
  my $self = shift;
  return $self->{'Username'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
