#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::DaysCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. DaysCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::DaysCodeType

=head1 DESCRIPTION

Specifies the range of days the seller can be contacted.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 None

Seller does not want to be contacted. Contact hours will not be supported for 
any days. If contact hours are specified, they will be ignored.



=cut


use constant None => scalar('None');


=head2 EveryDay

Seller can be contacted any day during the specified contact hours.



=cut


use constant EveryDay => scalar('EveryDay');


=head2 Weekdays

Seller can be contacted Monday through Friday during the specified 
contact hours.



=cut


use constant Weekdays => scalar('Weekdays');


=head2 Weekends

Seller can  be contacted Saturday or Sunday during the specified 
contact hours.



=cut


use constant Weekends => scalar('Weekends');


=head2 CustomCode

(out) Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
