/*
**  mod_twepl.c -- Apache sample twepl module
**  [Autogenerated via ``apxs -n twepl -g'']
**
**  To play with this sample module first compile it into a
**  DSO file and install it into Apache's modules directory
**  by running:
**
**    $ apxs -c -i mod_twepl.c
**
**  Then activate it in Apache's httpd.conf file for instance
**  for the URL /twepl in as follows:
**
**    #   httpd.conf
**    LoadModule twepl_module modules/mod_twepl.so
**    <Location /twepl>
**    SetHandler twepl
**    </Location>
**
**  Then after restarting Apache via
**
**    $ apachectl restart
**
**  you immediately can request the URL /twepl and watch for the
**  output of this module. This can be achieved for instance via:
**
**    $ lynx -mime_header http://localhost/twepl
**
**  The output should be similar to the following one:
**
**    HTTP/1.1 200 OK
**    Date: Tue, 31 Mar 1998 14:42:22 GMT
**    Server: Apache/1.3.4 (Unix)
**    Connection: close
**    Content-Type: text/html
**
**    The sample page from mod_twepl.c
*/

#include "mod_twepl.h"

/* Another Sources */
#include "twepl_xcore.c"

static const char *twepl_set_option_epl(cmd_parms *cmd, void *_conf, int flag){
  TWEPL_CONFIG *conf = (TWEPL_CONFIG *)ap_get_module_config(cmd->server->module_config, &twepl_module);
  if(flag != 0){ conf->ParserFlag |= OPT_TAG_EPL; }
  else{ conf->ParserFlag = conf->ParserFlag & ~OPT_TAG_EPL; }
  return NULL;
}

static const char *twepl_set_option_dol(cmd_parms *cmd, void *_conf, int flag){
  TWEPL_CONFIG *conf = (TWEPL_CONFIG *)ap_get_module_config(cmd->server->module_config, &twepl_module);
  if(flag != 0){ conf->ParserFlag |= OPT_TAG_DOL; }
  else{ conf->ParserFlag = conf->ParserFlag & ~OPT_TAG_DOL; }
  return NULL;
}

static const char *twepl_set_option_php(cmd_parms *cmd, void *_conf, int flag){
  TWEPL_CONFIG *conf = (TWEPL_CONFIG *)ap_get_module_config(cmd->server->module_config, &twepl_module);
  if(flag != 0){ conf->ParserFlag |= OPT_TAG_PHP; }
  else{ conf->ParserFlag = conf->ParserFlag & ~OPT_TAG_PHP; }
  return NULL;
}

static const char *twepl_set_option_asp(cmd_parms *cmd, void *_conf, int flag){
  TWEPL_CONFIG *conf = (TWEPL_CONFIG *)ap_get_module_config(cmd->server->module_config, &twepl_module);
  if(flag != 0){ conf->ParserFlag |= OPT_TAG_ASP; }
  else{ conf->ParserFlag = conf->ParserFlag & ~OPT_TAG_ASP; }
  return NULL;
}

static const char *twepl_set_option_send_length(cmd_parms *cmd, void *_conf, int flag){
  TWEPL_CONFIG *conf = (TWEPL_CONFIG *)ap_get_module_config(cmd->server->module_config, &twepl_module);
  conf->SendLength = (flag)? 1: 0;
  return NULL;
}

static const char *twepl_set_option_applepie(cmd_parms *cmd, void *_conf, int flag){
  TWEPL_CONFIG *conf = (TWEPL_CONFIG *)ap_get_module_config(cmd->server->module_config, &twepl_module);
  conf->MyApplePie = (flag)? 1: 0;
  return NULL;
}

static const command_rec twepl_config_options[] ={
  AP_INIT_FLAG("TweplTagsEPL",
               twepl_set_option_epl,
               NULL,
               (EXEC_ON_READ | RSRC_CONF | ACCESS_CONF | OR_OPTIONS | OR_ALL),
               "Allow ePerl <: code :> Tags."
               ),
  AP_INIT_FLAG("TweplTagsDOL",
               twepl_set_option_dol,
               NULL,
               (EXEC_ON_READ | RSRC_CONF | ACCESS_CONF | OR_OPTIONS | OR_ALL),
               "Allow old <$ code $> Tags."
               ),
  AP_INIT_FLAG("TweplTagsPHP",
               twepl_set_option_php,
               NULL,
               (EXEC_ON_READ | RSRC_CONF | ACCESS_CONF | OR_OPTIONS | OR_ALL),
               "Allow PHP <? code ?> Tags."
               ),
  AP_INIT_FLAG("TweplTagsASP",
               twepl_set_option_asp,
               NULL,
               (EXEC_ON_READ | RSRC_CONF | ACCESS_CONF | OR_OPTIONS | OR_ALL),
               "Allow ASP <% code %> Tags."
               ),
  AP_INIT_FLAG("TweplSendLength",
               twepl_set_option_send_length,
               NULL,
               (EXEC_ON_READ | RSRC_CONF | ACCESS_CONF | OR_OPTIONS | OR_ALL),
               "Send forcing Content-Length header."
               ),
  AP_INIT_FLAG("TweplMyApplePie",
               twepl_set_option_applepie,
               NULL,
               (EXEC_ON_READ | RSRC_CONF | ACCESS_CONF | OR_OPTIONS | OR_ALL),
               "Attempted avoid KCF 303 Error. bake apple pie."
               ),
  {NULL}
};

static void *twepl_create_svr_config(apr_pool_t *p, server_rec *s){
  TWEPL_CONFIG *conf = (TWEPL_CONFIG *)apr_palloc(p,sizeof(TWEPL_CONFIG));
  conf->ParserFlag = OPT_TAG_NON;
  conf->SendLength = 0;
  conf->MyApplePie = 0;
  return conf;
}

/* The sample content handler */
static int twepl_handler(request_rec *r)
{
        TWEPL_CONFIG  *twepl_conf;

                char **twepl_envp;
                char  *twepl_args[] = { "mod_" EPL_XS_NAME "\0", r->filename, NULL };
                char **twepl_argv = (char **)twepl_args;
                 int   twepl_argc = 2;

          apr_proc_t   twepl_proc;
                 int   twepl_stat;
                 int   twepl_apst;
                 int   twepl_awst;
                 int   twepl_pret;
      apr_exit_why_e   twepl_pwhy;

  apr_bucket_brigade  *obr;
          apr_bucket  *obk;

  if(strcmp(r->handler, "twepl-script") != 0)
    return DECLINED;
  if(access(r->filename, F_OK) == -1)
    return HTTP_NOT_FOUND;

  ap_set_content_type(r, "text/html");

  twepl_conf = (TWEPL_CONFIG *)ap_get_module_config(r->server->module_config, &twepl_module);

  ap_add_common_vars(r);
  ap_add_cgi_vars(r);

  apr_table_set(r->subprocess_env, "PERL_SELF", apr_table_get(r->subprocess_env, "SCRIPT_NAME"));

  apr_table_set(r->headers_out, EPL_POW_KEY, EPL_POW_VAL);

  twepl_envp = ap_create_environment(r->pool, r->subprocess_env);

  switch(twepl_apst = apr_proc_fork(&twepl_proc , r->pool)){
    case APR_INCHILD:
      twepl_stat = twepl_script_handler(r, r->filename, twepl_argc, twepl_argv, twepl_envp, twepl_conf);
      exit(twepl_stat);
      break;
    case APR_INPARENT:
      if((twepl_awst = apr_proc_wait(&twepl_proc, &twepl_pret, &twepl_pwhy, APR_WAIT)) != APR_CHILD_DONE){
        ap_log_rerror(APLOG_MARK, APLOG_ERR, APR_EGENERAL, r, "%s - apr_proc_wait() failed.", EPL_XS_NAME "\0");
        return HTTP_INTERNAL_SERVER_ERROR;
      }
      break;
    default:
      ap_log_rerror(APLOG_MARK, APLOG_ERR, twepl_apst, r, "%s: apr_proc_fork() failed.", EPL_XS_NAME "\0");
      return HTTP_INTERNAL_SERVER_ERROR;
      break;
  }

  switch(twepl_pwhy){
    case APR_PROC_EXIT:
      break;
    case APR_PROC_SIGNAL:
      ap_log_rerror(APLOG_MARK, APLOG_ERR, APR_EGENERAL, r, "%s - apr_proc_child exited signal.", EPL_XS_NAME "\0");
      return HTTP_INTERNAL_SERVER_ERROR;
    case APR_PROC_SIGNAL_CORE:
      ap_log_rerror(APLOG_MARK, APLOG_ERR, APR_EGENERAL, r, "%s - apr_proc_child exited segfault.", EPL_XS_NAME "\0");
      return HTTP_INTERNAL_SERVER_ERROR;
    default:
      ap_log_rerror(APLOG_MARK, APLOG_ERR, APR_EGENERAL, r, "%s - apr_proc_child exited unknown code exit_why_e is%d, child process exited status by %d, parent status is %d.", EPL_XS_NAME "\0", (int)twepl_pwhy, twepl_pret, twepl_stat);
      return HTTP_INTERNAL_SERVER_ERROR;
  }

  /*  Apple  */
  if(twepl_conf->MyApplePie && r->chunked){
    obr = apr_brigade_create(r->pool, r->output_filters->c->bucket_alloc);
    obk = apr_bucket_immortal_create(EPL_CRLF, 2, r->output_filters->c->bucket_alloc);
    APR_BRIGADE_INSERT_TAIL(obr, obk);
  }

  return twepl_pret;

}

static int twepl_first(apr_pool_t *pconf, apr_pool_t *plog, apr_pool_t *ptemp, server_rec *s){
  ap_add_version_component(pconf, " mod_twepl/" EPL_VERSION "\0");
  return OK;
}

static void twepl_register_hooks(apr_pool_t *p){
  ap_hook_handler(twepl_handler, NULL, NULL, APR_HOOK_MIDDLE);
  ap_hook_post_config(twepl_first, NULL,NULL, APR_HOOK_LAST);
}

/* Dispatch list for API hooks */
module AP_MODULE_DECLARE_DATA twepl_module = {
  STANDARD20_MODULE_STUFF,
  NULL,                    /* create per-dir    config structures */
  NULL,                    /* merge  per-dir    config structures */
  twepl_create_svr_config, /* create per-server config structures */
  NULL,                    /* merge  per-server config structures */
  twepl_config_options,    /* table of config file commands       */
  twepl_register_hooks     /* register hooks                      */
};
