/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.mdat;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CastUtils;
import com.coremedia.iso.boxes.ChunkOffsetBox;
import com.coremedia.iso.boxes.SampleSizeBox;
import com.coremedia.iso.boxes.SampleToChunkBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.fragment.MovieExtendsBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackExtendsBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackRunBox;
import com.coremedia.iso.boxes.mdat.DummyMap;
import com.coremedia.iso.boxes.mdat.MediaDataBox;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleList
extends AbstractList<ByteBuffer> {
    Map<Long, Long> offsets2Sizes;
    List<Long> offsetKeys = null;
    IsoFile isoFile;
    HashMap<MediaDataBox, Long> mdatStartCache = new HashMap();
    HashMap<MediaDataBox, Long> mdatEndCache = new HashMap();
    ArrayList<MediaDataBox> mdats = new ArrayList(1);

    public List<Long> getOffsetKeys() {
        if (this.offsetKeys == null) {
            ArrayList<Long> offsetKeys = new ArrayList<Long>(this.offsets2Sizes.size());
            for (Long aLong : this.offsets2Sizes.keySet()) {
                offsetKeys.add(aLong);
            }
            Collections.sort(offsetKeys);
            this.offsetKeys = offsetKeys;
        }
        return this.offsetKeys;
    }

    public SampleList(TrackBox trackBox) {
        List<MovieExtendsBox> movieExtendsBoxes;
        this.isoFile = trackBox.getIsoFile();
        this.offsets2Sizes = new HashMap<Long, Long>();
        long currentOffset = 0L;
        for (Box b : this.isoFile.getBoxes()) {
            long currentSize = b.getSize();
            if ("mdat".equals(b.getType())) {
                if (b instanceof MediaDataBox) {
                    long contentOffset = currentOffset + (long)((MediaDataBox)b).getHeader().limit();
                    this.mdatStartCache.put((MediaDataBox)b, contentOffset);
                    this.mdatEndCache.put((MediaDataBox)b, contentOffset + currentSize);
                    this.mdats.add((MediaDataBox)b);
                } else {
                    throw new RuntimeException("Sample need to be in mdats and mdats need to be instanceof MediaDataBox");
                }
            }
            currentOffset += currentSize;
        }
        SampleSizeBox sampleSizeBox = trackBox.getSampleTableBox().getSampleSizeBox();
        ChunkOffsetBox chunkOffsetBox = trackBox.getSampleTableBox().getChunkOffsetBox();
        SampleToChunkBox sampleToChunkBox = trackBox.getSampleTableBox().getSampleToChunkBox();
        if (sampleToChunkBox != null && sampleToChunkBox.getEntries().size() > 0 && chunkOffsetBox != null && chunkOffsetBox.getChunkOffsets().length > 0 && sampleSizeBox != null && sampleSizeBox.getSampleCount() > 0L) {
            int j;
            long sampleOffset;
            long thisChunksNumberOfSamples;
            int i;
            long[] numberOfSamplesInChunk = sampleToChunkBox.blowup(chunkOffsetBox.getChunkOffsets().length);
            if (sampleSizeBox.getSampleSize() > 0L) {
                this.offsets2Sizes = new DummyMap<Long, Long>(sampleSizeBox.getSampleSize());
                long sampleSize = sampleSizeBox.getSampleSize();
                i = 0;
                while (i < numberOfSamplesInChunk.length) {
                    thisChunksNumberOfSamples = numberOfSamplesInChunk[i];
                    sampleOffset = chunkOffsetBox.getChunkOffsets()[i];
                    j = 0;
                    while ((long)j < thisChunksNumberOfSamples) {
                        this.offsets2Sizes.put(sampleOffset, sampleSize);
                        sampleOffset += sampleSize;
                        ++j;
                    }
                    ++i;
                }
            } else {
                int sampleIndex = 0;
                long[] sampleSizes = sampleSizeBox.getSampleSizes();
                i = 0;
                while (i < numberOfSamplesInChunk.length) {
                    thisChunksNumberOfSamples = numberOfSamplesInChunk[i];
                    sampleOffset = chunkOffsetBox.getChunkOffsets()[i];
                    j = 0;
                    while ((long)j < thisChunksNumberOfSamples) {
                        long sampleSize = sampleSizes[sampleIndex];
                        this.offsets2Sizes.put(sampleOffset, sampleSize);
                        sampleOffset += sampleSize;
                        ++sampleIndex;
                        ++j;
                    }
                    ++i;
                }
            }
        }
        if ((movieExtendsBoxes = trackBox.getParent().getBoxes(MovieExtendsBox.class)).size() > 0) {
            List<TrackExtendsBox> trackExtendsBoxes = movieExtendsBoxes.get(0).getBoxes(TrackExtendsBox.class);
            for (TrackExtendsBox trackExtendsBox : trackExtendsBoxes) {
                if (trackExtendsBox.getTrackId() != trackBox.getTrackHeaderBox().getTrackId()) continue;
                for (MovieFragmentBox movieFragmentBox : trackBox.getIsoFile().getBoxes(MovieFragmentBox.class)) {
                    this.offsets2Sizes.putAll(this.getOffsets(movieFragmentBox, trackBox.getTrackHeaderBox().getTrackId()));
                }
            }
        }
    }

    @Override
    public int size() {
        return this.offsets2Sizes.size();
    }

    @Override
    public ByteBuffer get(int index) {
        Long offset = this.getOffsetKeys().get(index);
        int sampleSize = CastUtils.l2i(this.offsets2Sizes.get(offset));
        for (MediaDataBox mediaDataBox : this.mdats) {
            long start = this.mdatStartCache.get(mediaDataBox);
            long end = this.mdatEndCache.get(mediaDataBox);
            if (start > offset || offset + (long)sampleSize > end) continue;
            ByteBuffer bb = mediaDataBox.getContent();
            bb.position(CastUtils.l2i(offset - start));
            ByteBuffer sample = bb.slice();
            sample.limit(sampleSize);
            return sample;
        }
        throw new RuntimeException("The sample with offset " + offset + " and size " + sampleSize + " is NOT located within an mdat");
    }

    Map<Long, Long> getOffsets(MovieFragmentBox moof, long trackId) {
        HashMap<Long, Long> offsets2Sizes = new HashMap<Long, Long>();
        List<TrackFragmentBox> traf = moof.getBoxes(TrackFragmentBox.class);
        for (TrackFragmentBox trackFragmentBox : traf) {
            if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != trackId) continue;
            long baseDataOffset = trackFragmentBox.getTrackFragmentHeaderBox().hasBaseDataOffset() ? trackFragmentBox.getTrackFragmentHeaderBox().getBaseDataOffset() : moof.getOffset();
            for (TrackRunBox trun : trackFragmentBox.getBoxes(TrackRunBox.class)) {
                long sampleBaseOffset = baseDataOffset + (long)trun.getDataOffset();
                long[] sampleOffsets = trun.getSampleOffsets();
                long[] sampleSizes = trun.getSampleSizes();
                int i = 0;
                while (i < sampleSizes.length) {
                    offsets2Sizes.put(sampleOffsets[i] + sampleBaseOffset, sampleSizes[i]);
                    ++i;
                }
            }
        }
        return offsets2Sizes;
    }
}

