/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class BandCombineOpImage
extends PointOpImage {
    private double[][] matrix;

    public BandCombineOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, double[][] dArray) {
        super(renderedImage, imageLayout, map, true);
        this.matrix = dArray;
        int n = dArray.length;
        if (this.getSampleModel().getNumBands() != n) {
            this.sampleModel = RasterFactory.createComponentSampleModel(this.sampleModel, this.sampleModel.getDataType(), this.tileWidth, this.tileHeight, n);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor, rasterAccessor2);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getNumBands();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getNumBands();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n5) {
            int n12 = n9;
            int n13 = n10;
            int n14 = 0;
            while (n14 < n4) {
                int n15 = 0;
                while (n15 < n6) {
                    float f = 0.0f;
                    double[] dArray = this.matrix[n15];
                    int n16 = 0;
                    while (n16 < n3) {
                        f += (float)dArray[n16] * (float)(byArray[n16][n12 + nArray[n16]] & 0xFF);
                        ++n16;
                    }
                    byArray2[n15][n13 + nArray2[n15]] = ImageUtil.clampRoundByte(f + (float)dArray[n3]);
                    ++n15;
                }
                n12 += n2;
                n13 += n8;
                ++n14;
            }
            n9 += n;
            n10 += n7;
            ++n11;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getNumBands();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getNumBands();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n5) {
            int n12 = n9;
            int n13 = n10;
            int n14 = 0;
            while (n14 < n4) {
                int n15 = 0;
                while (n15 < n6) {
                    float f = 0.0f;
                    double[] dArray = this.matrix[n15];
                    int n16 = 0;
                    while (n16 < n3) {
                        f += (float)dArray[n16] * (float)(sArray[n16][n12 + nArray[n16]] & 0xFFFF);
                        ++n16;
                    }
                    sArray2[n15][n13 + nArray2[n15]] = ImageUtil.clampRoundUShort(f + (float)this.matrix[n15][n3]);
                    ++n15;
                }
                n12 += n2;
                n13 += n8;
                ++n14;
            }
            n9 += n;
            n10 += n7;
            ++n11;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getNumBands();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getNumBands();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n5) {
            int n12 = n9;
            int n13 = n10;
            int n14 = 0;
            while (n14 < n4) {
                int n15 = 0;
                while (n15 < n6) {
                    float f = 0.0f;
                    double[] dArray = this.matrix[n15];
                    int n16 = 0;
                    while (n16 < n3) {
                        f += (float)dArray[n16] * (float)sArray[n16][n12 + nArray[n16]];
                        ++n16;
                    }
                    sArray2[n15][n13 + nArray2[n15]] = ImageUtil.clampRoundUShort(f + (float)this.matrix[n15][n3]);
                    ++n15;
                }
                n12 += n2;
                n13 += n8;
                ++n14;
            }
            n9 += n;
            n10 += n7;
            ++n11;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getNumBands();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getNumBands();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int[][] nArray4 = rasterAccessor2.getIntDataArrays();
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n5) {
            int n12 = n9;
            int n13 = n10;
            int n14 = 0;
            while (n14 < n4) {
                int n15 = 0;
                while (n15 < n6) {
                    float f = 0.0f;
                    double[] dArray = this.matrix[n15];
                    int n16 = 0;
                    while (n16 < n3) {
                        f += (float)dArray[n16] * (float)nArray2[n16][n12 + nArray[n16]];
                        ++n16;
                    }
                    nArray4[n15][n13 + nArray3[n15]] = ImageUtil.clampRoundInt(f + (float)this.matrix[n15][n3]);
                    ++n15;
                }
                n12 += n2;
                n13 += n8;
                ++n14;
            }
            n9 += n;
            n10 += n7;
            ++n11;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getNumBands();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getNumBands();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n5) {
            int n12 = n9;
            int n13 = n10;
            int n14 = 0;
            while (n14 < n4) {
                int n15 = 0;
                while (n15 < n6) {
                    float f = 0.0f;
                    double[] dArray = this.matrix[n15];
                    int n16 = 0;
                    while (n16 < n3) {
                        f += (float)dArray[n16] * fArray[n16][n12 + nArray[n16]];
                        ++n16;
                    }
                    fArray2[n15][n13 + nArray2[n15]] = f + (float)this.matrix[n15][n3];
                    ++n15;
                }
                n12 += n2;
                n13 += n8;
                ++n14;
            }
            n9 += n;
            n10 += n7;
            ++n11;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getNumBands();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getNumBands();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n5) {
            int n12 = n9;
            int n13 = n10;
            int n14 = 0;
            while (n14 < n4) {
                int n15 = 0;
                while (n15 < n6) {
                    double d = 0.0;
                    double[] dArray3 = this.matrix[n15];
                    int n16 = 0;
                    while (n16 < n3) {
                        d += dArray3[n16] * dArray[n16][n12 + nArray[n16]];
                        ++n16;
                    }
                    dArray2[n15][n13 + nArray2[n15]] = d + this.matrix[n15][n3];
                    ++n15;
                }
                n12 += n2;
                n13 += n8;
                ++n14;
            }
            n9 += n;
            n10 += n7;
            ++n11;
        }
    }
}

