/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.gui;

import java.awt.Frame;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.UIManager;
import net.sourceforge.javaocr.gui.MainFrame;
import net.sourceforge.javaocr.gui.characterTracer.TracerFrame;
import net.sourceforge.javaocr.gui.handwritingRecognizer.ConfigPanel;
import net.sourceforge.javaocr.gui.handwritingRecognizer.HandWritingFormProcessor;
import net.sourceforge.javaocr.gui.handwritingRecognizer.ProcessPanel;
import net.sourceforge.javaocr.gui.handwritingRecognizer.TrainingPanel;
import net.sourceforge.javaocr.gui.meanSquareOCR.TrainingImageSpec;
import net.sourceforge.javaocr.ocrPlugins.CharacterExtractor;
import net.sourceforge.javaocr.ocrPlugins.CharacterTracer;
import net.sourceforge.javaocr.ocrPlugins.LineExtractor;
import net.sourceforge.javaocr.ocrPlugins.handWriting.HandwritingOCR;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.CharacterRange;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.OCRScanner;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.TrainingImage;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.TrainingImageLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUIController {
    private MainFrame mainFrame;
    private TrainingPanel handWriteTrainingPanel;
    private ConfigPanel handWriteConfigPanel;
    private ProcessPanel handWriteProcess;
    private static final Logger LOG = Logger.getLogger(GUIController.class.getName());

    public GUIController() {
        this.setLookandFeel();
        this.handWriteTrainingPanel = new TrainingPanel(this);
        this.handWriteConfigPanel = new ConfigPanel(this);
        this.handWriteProcess = new ProcessPanel(this);
        this.mainFrame = new MainFrame(this);
    }

    public void showGUI() {
        this.mainFrame.setVisible(true);
    }

    public void extractChars(File inputImage, File outputDir, int std_width, int std_height) {
        CharacterExtractor slicer = new CharacterExtractor();
        slicer.slice(inputImage, outputDir, std_width, std_height);
    }

    public TrainingPanel getHandWriteTrainingPanel() {
        return this.handWriteTrainingPanel;
    }

    public ConfigPanel getHandWriteConfigPanel() {
        return this.handWriteConfigPanel;
    }

    public ProcessPanel getHandWriteProcess() {
        return this.handWriteProcess;
    }

    private void setLookandFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            Logger.getLogger(GUIController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void repaint() {
        this.mainFrame.repaint();
    }

    public String performMSEOCR(ArrayList<TrainingImageSpec> imgs, String targImageLoc) throws Exception {
        OCRScanner ocrScanner = new OCRScanner();
        HashMap<Character, ArrayList<TrainingImage>> trainingImages = this.getTrainingImageHashMap(imgs);
        ocrScanner.addTrainingImages(trainingImages);
        BufferedImage targetImage = ImageIO.read(new File(targImageLoc));
        String text = ocrScanner.scan(targetImage, 0, 0, 0, 0, null);
        return text;
    }

    public String processHandwriting(File sourceImage, File targetImage, HandWritingFormProcessor form) throws Exception {
        TrainingImageSpec trainImage;
        File tempDir = new File("./temp");
        if (!tempDir.mkdir()) {
            this.removeAllFiles(tempDir.listFiles());
        }
        LineExtractor lineExtractor = new LineExtractor();
        lineExtractor.slice(sourceImage, tempDir);
        ArrayList<TrainingImageSpec> imgs = new ArrayList<TrainingImageSpec>();
        File[] files = this.sortFiles(tempDir.listFiles());
        int linesUsed = 0;
        if (form.isLearnZeroToNine()) {
            trainImage = new TrainingImageSpec();
            trainImage.setFileLocation(files[linesUsed].getAbsolutePath());
            trainImage.setCharRange(new CharacterRange(48, 57));
            imgs.add(trainImage);
            ++linesUsed;
        }
        if (form.isLearnLowerAtoZ()) {
            trainImage = new TrainingImageSpec();
            trainImage.setFileLocation(files[linesUsed].getAbsolutePath());
            trainImage.setCharRange(new CharacterRange(97, 122));
            imgs.add(trainImage);
            ++linesUsed;
        }
        if (form.isLearnUpperAtoZ()) {
            trainImage = new TrainingImageSpec();
            trainImage.setFileLocation(files[linesUsed].getAbsolutePath());
            trainImage.setCharRange(new CharacterRange(65, 90));
            imgs.add(trainImage);
            ++linesUsed;
        }
        HashMap<Character, ArrayList<TrainingImage>> trainingImages = this.getTrainingImageHashMap(imgs);
        HandwritingOCR handwritingOCR = new HandwritingOCR(trainingImages);
        handwritingOCR.setEnableMSEOCR(form.isMSEOCR());
        handwritingOCR.setEnableAspectOCR(form.isAspectOCR());
        BufferedImage targetBfImage = ImageIO.read(targetImage);
        String text = handwritingOCR.scan(targetBfImage);
        this.removeAllFiles(files);
        tempDir.delete();
        return text;
    }

    public void traceChars(File imageFile) {
        CharacterTracer tracer = new CharacterTracer();
        BufferedImage img = tracer.getTracedImage(imageFile);
        int width = img.getWidth();
        if (width > 1000) {
            double scaleAmount = 1000.0 / (double)width;
            AffineTransform tx = new AffineTransform();
            tx.scale(scaleAmount, scaleAmount);
            AffineTransformOp op = new AffineTransformOp(tx, 2);
            img = op.filter(img, null);
        }
        TracerFrame tFrame = new TracerFrame(img);
        tFrame.showFrame();
    }

    private HashMap<Character, ArrayList<TrainingImage>> getTrainingImageHashMap(ArrayList<TrainingImageSpec> imgs) throws Exception {
        TrainingImageLoader loader = new TrainingImageLoader();
        HashMap<Character, ArrayList<TrainingImage>> trainingImages = new HashMap<Character, ArrayList<TrainingImage>>();
        Frame frame = new Frame();
        for (int i = 0; i < imgs.size(); ++i) {
            loader.load(frame, imgs.get(i).getFileLocation(), imgs.get(i).getCharRange(), trainingImages);
        }
        return trainingImages;
    }

    public void extractLines(File imageFile, File outDir) {
        LineExtractor slicer = new LineExtractor();
        slicer.slice(imageFile, outDir);
    }

    private File[] sortFiles(File[] files) {
        ArrayList<File> fileList = new ArrayList<File>();
        fileList.addAll(Arrays.asList(files));
        Collections.sort(fileList, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                String fileName1 = f1.getName();
                String fileName2 = f2.getName();
                return fileName1.compareTo(fileName2);
            }
        });
        for (int i = 0; i < files.length; ++i) {
            files[i] = (File)fileList.get(i);
        }
        return files;
    }

    private void removeAllFiles(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            files[i].delete();
        }
    }
}

