/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.html;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.detect.EncodingDetector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.utils.CharsetUtils;

public class HtmlEncodingDetector
implements EncodingDetector {
    private static final int META_TAG_BUFFER_SIZE = 8192;
    private static final Pattern HTTP_EQUIV_PATTERN = Pattern.compile("(?is)<meta\\s+http-equiv\\s*=\\s*['\\\"]\\s*Content-Type['\\\"]\\s+content\\s*=\\s*['\\\"]([^'\\\"]+)['\\\"]");
    private static final Pattern META_CHARSET_PATTERN = Pattern.compile("(?is)<meta\\s+charset\\s*=\\s*['\\\"]([^'\\\"]+)['\\\"]");
    private static final Charset ASCII = Charset.forName("US-ASCII");

    public Charset detect(InputStream input, Metadata metadata) throws IOException {
        Matcher meta;
        MediaType type;
        if (input == null) {
            return null;
        }
        input.mark(8192);
        byte[] buffer = new byte[8192];
        int n = 0;
        int m = input.read(buffer);
        while (m != -1 && n < buffer.length) {
            m = input.read(buffer, n += m, buffer.length - n);
        }
        input.reset();
        String charset = null;
        String head = ASCII.decode(ByteBuffer.wrap(buffer, 0, n)).toString();
        Matcher equiv = HTTP_EQUIV_PATTERN.matcher(head);
        if (equiv.find() && (type = MediaType.parse(equiv.group(1))) != null) {
            charset = type.getParameters().get("charset");
        }
        if (charset == null && (meta = META_CHARSET_PATTERN.matcher(head)).find()) {
            charset = meta.group(1);
        }
        if (charset != null) {
            try {
                return CharsetUtils.forName(charset);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }
}

