/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.ExifThumbnailDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExifThumbnailDescriptor
extends TagDescriptor<ExifThumbnailDirectory> {
    private final boolean _allowDecimalRepresentationOfRationals = true;

    public ExifThumbnailDescriptor(@NotNull ExifThumbnailDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 274: {
                return this.getOrientationDescription();
            }
            case 296: {
                return this.getResolutionDescription();
            }
            case 531: {
                return this.getYCbCrPositioningDescription();
            }
            case 282: {
                return this.getXResolutionDescription();
            }
            case 283: {
                return this.getYResolutionDescription();
            }
            case 513: {
                return this.getThumbnailOffsetDescription();
            }
            case 514: {
                return this.getThumbnailLengthDescription();
            }
            case 256: {
                return this.getThumbnailImageWidthDescription();
            }
            case 257: {
                return this.getThumbnailImageHeightDescription();
            }
            case 258: {
                return this.getBitsPerSampleDescription();
            }
            case 259: {
                return this.getCompressionDescription();
            }
            case 262: {
                return this.getPhotometricInterpretationDescription();
            }
            case 278: {
                return this.getRowsPerStripDescription();
            }
            case 279: {
                return this.getStripByteCountsDescription();
            }
            case 277: {
                return this.getSamplesPerPixelDescription();
            }
            case 284: {
                return this.getPlanarConfigurationDescription();
            }
            case 530: {
                return this.getYCbCrSubsamplingDescription();
            }
            case 532: {
                return this.getReferenceBlackWhiteDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getReferenceBlackWhiteDescription() {
        int[] ints = ((ExifThumbnailDirectory)this._directory).getIntArray(532);
        if (ints == null) {
            return null;
        }
        int blackR = ints[0];
        int whiteR = ints[1];
        int blackG = ints[2];
        int whiteG = ints[3];
        int blackB = ints[4];
        int whiteB = ints[5];
        return "[" + blackR + "," + blackG + "," + blackB + "] " + "[" + whiteR + "," + whiteG + "," + whiteB + "]";
    }

    @Nullable
    public String getYCbCrSubsamplingDescription() {
        int[] positions = ((ExifThumbnailDirectory)this._directory).getIntArray(530);
        if (positions == null || positions.length < 2) {
            return null;
        }
        if (positions[0] == 2 && positions[1] == 1) {
            return "YCbCr4:2:2";
        }
        if (positions[0] == 2 && positions[1] == 2) {
            return "YCbCr4:2:0";
        }
        return "(Unknown)";
    }

    @Nullable
    public String getPlanarConfigurationDescription() {
        Integer value = ((ExifThumbnailDirectory)this._directory).getInteger(284);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Chunky (contiguous for each subsampling pixel)";
            }
            case 2: {
                return "Separate (Y-plane/Cb-plane/Cr-plane format)";
            }
        }
        return "Unknown configuration";
    }

    @Nullable
    public String getSamplesPerPixelDescription() {
        String value = ((ExifThumbnailDirectory)this._directory).getString(277);
        return value == null ? null : value + " samples/pixel";
    }

    @Nullable
    public String getRowsPerStripDescription() {
        String value = ((ExifThumbnailDirectory)this._directory).getString(278);
        return value == null ? null : value + " rows/strip";
    }

    @Nullable
    public String getStripByteCountsDescription() {
        String value = ((ExifThumbnailDirectory)this._directory).getString(279);
        return value == null ? null : value + " bytes";
    }

    @Nullable
    public String getPhotometricInterpretationDescription() {
        Integer value = ((ExifThumbnailDirectory)this._directory).getInteger(262);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "WhiteIsZero";
            }
            case 1: {
                return "BlackIsZero";
            }
            case 2: {
                return "RGB";
            }
            case 3: {
                return "RGB Palette";
            }
            case 4: {
                return "Transparency Mask";
            }
            case 5: {
                return "CMYK";
            }
            case 6: {
                return "YCbCr";
            }
            case 8: {
                return "CIELab";
            }
            case 9: {
                return "ICCLab";
            }
            case 10: {
                return "ITULab";
            }
            case 32803: {
                return "Color Filter Array";
            }
            case 32844: {
                return "Pixar LogL";
            }
            case 32845: {
                return "Pixar LogLuv";
            }
            case 32892: {
                return "Linear Raw";
            }
        }
        return "Unknown colour space";
    }

    @Nullable
    public String getCompressionDescription() {
        Integer value = ((ExifThumbnailDirectory)this._directory).getInteger(259);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Uncompressed";
            }
            case 2: {
                return "CCITT 1D";
            }
            case 3: {
                return "T4/Group 3 Fax";
            }
            case 4: {
                return "T6/Group 4 Fax";
            }
            case 5: {
                return "LZW";
            }
            case 6: {
                return "JPEG (old-style)";
            }
            case 7: {
                return "JPEG";
            }
            case 8: {
                return "Adobe Deflate";
            }
            case 9: {
                return "JBIG B&W";
            }
            case 10: {
                return "JBIG Color";
            }
            case 32766: {
                return "Next";
            }
            case 32771: {
                return "CCIRLEW";
            }
            case 32773: {
                return "PackBits";
            }
            case 32809: {
                return "Thunderscan";
            }
            case 32895: {
                return "IT8CTPAD";
            }
            case 32896: {
                return "IT8LW";
            }
            case 32897: {
                return "IT8MP";
            }
            case 32898: {
                return "IT8BL";
            }
            case 32908: {
                return "PixarFilm";
            }
            case 32909: {
                return "PixarLog";
            }
            case 32946: {
                return "Deflate";
            }
            case 32947: {
                return "DCS";
            }
            case 32661: {
                return "JBIG";
            }
            case 32676: {
                return "SGILog";
            }
            case 32677: {
                return "SGILog24";
            }
            case 32712: {
                return "JPEG 2000";
            }
            case 32713: {
                return "Nikon NEF Compressed";
            }
        }
        return "Unknown compression";
    }

    @Nullable
    public String getBitsPerSampleDescription() {
        String value = ((ExifThumbnailDirectory)this._directory).getString(258);
        return value == null ? null : value + " bits/component/pixel";
    }

    @Nullable
    public String getThumbnailImageWidthDescription() {
        String value = ((ExifThumbnailDirectory)this._directory).getString(256);
        return value == null ? null : value + " pixels";
    }

    @Nullable
    public String getThumbnailImageHeightDescription() {
        String value = ((ExifThumbnailDirectory)this._directory).getString(257);
        return value == null ? null : value + " pixels";
    }

    @Nullable
    public String getThumbnailLengthDescription() {
        String value = ((ExifThumbnailDirectory)this._directory).getString(514);
        return value == null ? null : value + " bytes";
    }

    @Nullable
    public String getThumbnailOffsetDescription() {
        String value = ((ExifThumbnailDirectory)this._directory).getString(513);
        return value == null ? null : value + " bytes";
    }

    @Nullable
    public String getYResolutionDescription() {
        Rational value = ((ExifThumbnailDirectory)this._directory).getRational(283);
        if (value == null) {
            return null;
        }
        String unit = this.getResolutionDescription();
        return value.toSimpleString(true) + " dots per " + (unit == null ? "unit" : unit.toLowerCase());
    }

    @Nullable
    public String getXResolutionDescription() {
        Rational value = ((ExifThumbnailDirectory)this._directory).getRational(282);
        if (value == null) {
            return null;
        }
        String unit = this.getResolutionDescription();
        return value.toSimpleString(true) + " dots per " + (unit == null ? "unit" : unit.toLowerCase());
    }

    @Nullable
    public String getYCbCrPositioningDescription() {
        Integer value = ((ExifThumbnailDirectory)this._directory).getInteger(531);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Center of pixel array";
            }
            case 2: {
                return "Datum point";
            }
        }
        return String.valueOf(value);
    }

    @Nullable
    public String getOrientationDescription() {
        Integer value = ((ExifThumbnailDirectory)this._directory).getInteger(274);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Top, left side (Horizontal / normal)";
            }
            case 2: {
                return "Top, right side (Mirror horizontal)";
            }
            case 3: {
                return "Bottom, right side (Rotate 180)";
            }
            case 4: {
                return "Bottom, left side (Mirror vertical)";
            }
            case 5: {
                return "Left side, top (Mirror horizontal and rotate 270 CW)";
            }
            case 6: {
                return "Right side, top (Rotate 90 CW)";
            }
            case 7: {
                return "Right side, bottom (Mirror horizontal and rotate 90 CW)";
            }
            case 8: {
                return "Left side, bottom (Rotate 270 CW)";
            }
        }
        return String.valueOf(value);
    }

    @Nullable
    public String getResolutionDescription() {
        Integer value = ((ExifThumbnailDirectory)this._directory).getInteger(296);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "(No unit)";
            }
            case 2: {
                return "Inch";
            }
            case 3: {
                return "cm";
            }
        }
        return "";
    }
}

