## no critic: TestingAndDebugging::RequireStrict
package Sah::SchemaR::re_from_str;

our $DATE = '2023-12-20'; # DATE
our $VERSION = '0.006'; # VERSION

our $rschema = do{my$var={base=>"re",clsets_after_base=>[{description=>"\nThis schema accepts Regexp object or string which will be coerced to Regexp object\nusing <pm:Regexp::From::String>'s `str_to_re()` function.\n\nBasically, if string is of the form of `/.../` or `qr(...)`, then you could\nspecify metacharacters as if you are writing a literal regexp pattern in Perl.\nOtherwise, your string will be `quotemeta()`-ed first then compiled to Regexp\nobject. This means in the second case you cannot specify metacharacters.\n\nWhat's the difference between this schema and `str_or_re` (from\n<pm:Sah::Schemas::Str>)? Both this schema and `str_or_re` accept string, but\nthis schema will still coerce strings not in the form of `/.../` or `qr(...)` to\nregexp object, while `str_or_re` will leave the string as-is. In other words,\nthis schema always converts input to Regexp object while `str_or_re` does not.\n\n",examples=>[],prefilters=>[["Re::re_from_str",{}]],summary=>"Regexp object from string using Regexp::From::String's str_to_re()"}],clsets_after_type=>['$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_base}[0]'],resolve_path=>["re"],type=>"re",v=>2};$var->{clsets_after_type}[0]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: Regexp object from string using Regexp::From::String's str_to_re()

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::re_from_str - Regexp object from string using Regexp::From::String's str_to_re()

=head1 VERSION

This document describes version 0.006 of Sah::SchemaR::re_from_str (from Perl distribution Sah-Schemas-Re), released on 2023-12-20.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Re>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Re>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023, 2022 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Re>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
