# Generated by default/object.tt
package Paws::GuardDuty::UsageStatistics;
  use Moose;
  has SumByAccount => (is => 'ro', isa => 'ArrayRef[Paws::GuardDuty::UsageAccountResult]', request_name => 'sumByAccount', traits => ['NameInRequest']);
  has SumByDataSource => (is => 'ro', isa => 'ArrayRef[Paws::GuardDuty::UsageDataSourceResult]', request_name => 'sumByDataSource', traits => ['NameInRequest']);
  has SumByResource => (is => 'ro', isa => 'ArrayRef[Paws::GuardDuty::UsageResourceResult]', request_name => 'sumByResource', traits => ['NameInRequest']);
  has TopResources => (is => 'ro', isa => 'ArrayRef[Paws::GuardDuty::UsageResourceResult]', request_name => 'topResources', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GuardDuty::UsageStatistics

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GuardDuty::UsageStatistics object:

  $service_obj->Method(Att1 => { SumByAccount => $value, ..., TopResources => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GuardDuty::UsageStatistics object:

  $result = $service_obj->Method(...);
  $result->Att1->SumByAccount

=head1 DESCRIPTION

Contains the result of GuardDuty usage. If a UsageStatisticType is
provided the result for other types will be null.

=head1 ATTRIBUTES


=head2 SumByAccount => ArrayRef[L<Paws::GuardDuty::UsageAccountResult>]

The usage statistic sum organized by account ID.


=head2 SumByDataSource => ArrayRef[L<Paws::GuardDuty::UsageDataSourceResult>]

The usage statistic sum organized by on data source.


=head2 SumByResource => ArrayRef[L<Paws::GuardDuty::UsageResourceResult>]

The usage statistic sum organized by resource.


=head2 TopResources => ArrayRef[L<Paws::GuardDuty::UsageResourceResult>]

Lists the top 50 resources that have generated the most GuardDuty
usage, in order from most to least expensive.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GuardDuty>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

