package Bundle::Math::Interface;
use strict;
use warnings;

$VERSION = '1.00';

1;

__END__

=head1 NAME

Bundle::Math::Interface - Bundle of modules interfacing with math libraries

=head1 SYNOPSIS

 perl -MCPAN -e 'install Bundle::Math::Interface'

=head1 CONTENTS

Math::BigInt::GMP

Math::BigInt::Pari

Math::CDF

Math::Cephes

Math::Geometry::GPC

Math::GMP

Math::GSL

Math::Libm

Math::Matlab

Math::Matlab::Engine

Math::Pari

Math::ematica

=head1 DESCRIPTION

Bundle of modules interfacing with math libraries.

Please have a look at L<Bundle::Math>.

If you would like to see a specific module included in a future version of
this bundle, please send me an email or use rt.cpan.org.

=head1 AUTHOR

Steffen Mueller E<lt>bundlemath-module at steffen-mueller dot netE<gt>

=cut 
