# Generated by default/object.tt
package Paws::GlueDataBrew::RecipeStep;
  use Moose;
  has Action => (is => 'ro', isa => 'Paws::GlueDataBrew::RecipeAction', required => 1);
  has ConditionExpressions => (is => 'ro', isa => 'ArrayRef[Paws::GlueDataBrew::ConditionExpression]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::RecipeStep

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlueDataBrew::RecipeStep object:

  $service_obj->Method(Att1 => { Action => $value, ..., ConditionExpressions => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlueDataBrew::RecipeStep object:

  $result = $service_obj->Method(...);
  $result->Att1->Action

=head1 DESCRIPTION

Represents a single step from a DataBrew recipe to be performed.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Action => L<Paws::GlueDataBrew::RecipeAction>

The particular action to be performed in the recipe step.


=head2 ConditionExpressions => ArrayRef[L<Paws::GlueDataBrew::ConditionExpression>]

One or more conditions that must be met for the recipe step to succeed.

All of the conditions in the array must be met. In other words, all of
the conditions must be combined using a logical AND operation.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

