package Daje::Workflow::Checks::Mandatory;
use Mojo::Base 'Daje::Workflow::Common::Checks::Base', -base, -signatures;

# NAME
# ====
#
# Daje::Workflow::Checks::Mandatory  - Checks for mandatory fields
#
# SYNOPSIS
# ========
#
#    check($self)
#
#    Assumed format $self->context->{context}->{payload}->{field to be checked for existence)
#
#
# DESCRIPTION
# ===========
#
# Daje::Workflow::Checks::Mandatory is used to check and make sure
# mandatory fields are included in the context
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

sub check($self) {
    my $result = 1;
    if (length($self->checks()) > 0) {
        my @fields = split(',', $self->checks());
        my $length = scalar @fields;
        for (my $i = 0; $i < $length; $i++) {
            if (!exists $self->context->{context}->{payload}->{$fields[$i]}) {
                $result = 0;
                $self->error->add_error("Mandatory field '$fields[$i]' is missing")
            }
        }
    }
    return $result;
}

1;






#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::Checks::Mandatory  - Checks for mandatory fields



=head1 SYNOPSIS


   check($self)

   Assumed format $self->context->{context}->{payload}->{field to be checked for existence)




=head1 DESCRIPTION


Daje::Workflow::Checks::Mandatory is used to check and make sure
mandatory fields are included in the context



=head1 REQUIRES

L<Mojo::Base> 


=head1 METHODS

=head2 check($self)

 check($self)();

NAME
====

Daje::Workflow::Checks::Mandatory  - Checks for mandatory fields

SYNOPSIS
========

   check($self)

   Assumed format $self->context->{context}->{payload}->{field to be checked for existence)


DESCRIPTION
===========

Daje::Workflow::Checks::Mandatory is used to check and make sure
mandatory fields are included in the context

LICENSE
=======

Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

AUTHOR
======
janeskil1525 E<lt>janeskil1525@gmail.comE<gt>




=head1 AUTHOR

janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

