#define PERL_NO_GET_CONTEXT // we'll define thread context if necessary (faster)
#include "EXTERN.h"         // globals/constant import locations
#include "perl.h"           // Perl symbols, structures and constants definition
#include "XSUB.h"           // xsubpp functions and macros

static SV * _new (SV * type) {
	dTHX;
	return sv_bless(newRV_noinc(type), gv_stashsv(newSVpv("Basic::Types::XS", 16), 0));
}

int _sv_contains_numbers (SV * param) {
	dTHX;
	STRLEN retlen;
	char * str = SvPV(param, retlen);
	int i = 0, dec = 0;
	for (i = 0; i < retlen; i++) {
		if (!isdigit(str[i])) {
			if ( !dec && str[i] == '.' ) {
				dec = 1;
			} else {
				return 0;
			}
		}
	}
	return 1;
}

MODULE = Basic::Types::XS  PACKAGE = Basic::Types::XS
PROTOTYPES: ENABLE


SV *
Str()
	CODE:
		RETVAL = _new(newSVpv("Str", 3));
	OUTPUT:
		RETVAL

SV *
_Str(param)
	SV * param
	CODE:
		int type = SvTYPE(param);
		if (SvROK(param) || !SvOK(param) || (type > SVt_PV)) {
			croak("value did not pass type constraint \"Str\"");
		}
		SvREFCNT_inc(param);
		RETVAL = param;
	OUTPUT:
		RETVAL

SV *
Num()
	CODE:
		RETVAL = _new(newSVpv("Num", 3));
	OUTPUT:
		RETVAL

SV *
_Num(param)
	SV * param
	CODE:
		int type = SvTYPE(param);
		if (SvROK(param) || !SvOK(param) || (type != SVt_IV && type != SVt_NV)) {
			if ( type != SVt_PV || ! _sv_contains_numbers(param) ) {
				croak("value did not pass type constraint \"Num\"");
			}
		}
		SvREFCNT_inc(param);
		RETVAL = param;
	OUTPUT:
		RETVAL



CV *
cb(...)
	OVERLOAD: &{}
	CODE:
		STRLEN retlen;
		char * type = SvPV(SvRV(ST(0)), retlen);
		char class[16 + 3 + retlen];
		sprintf(class, "Basic::Types::XS::_%s", type);
		CV * cv = get_cv(class, 0);
		RETVAL = cv;
	OUTPUT:
		RETVAL

void
install(pkg, ...)
	char * pkg
	CODE:
		STRLEN retlen;
		int i = 1;
		for (i = 1; i < items; i++) {
			char * ex = SvPV(ST(i), retlen);
			char name [strlen(pkg) + 2 + retlen];
			sprintf(name, "%s::%s", pkg, ex);
			if (strcmp(ex, "Str") == 0)  {
				newXS(name, XS_Basic__Types__XS_Str, __FILE__);
			} else if (strcmp(ex, "Num") == 0) {
				newXS(name, XS_Basic__Types__XS_Num, __FILE__);
			}
		}
