/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_grid_PropertyColumnModel({"alternateClassNames":[],"aliases":{},"enum":null,"parentMixins":[],"tagname":"class","subclasses":[],"extends":"Ext.grid.ColumnModel","uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='docClass'>Ext.util.Observable</a><div class='subclass '><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='docClass'>Ext.grid.ColumnModel</a><div class='subclass '><strong>Ext.grid.PropertyColumnModel</strong></div></div></div><h4>Files</h4><div class='dependency'><a href='source/PropertyGrid.html#Ext-grid-PropertyColumnModel' target='_blank'>PropertyGrid.js</a></div></pre><div class='doc-contents'><p>A custom column model for the <a href=\"#!/api/Ext.grid.PropertyGrid\" rel=\"Ext.grid.PropertyGrid\" class=\"docClass\">Ext.grid.PropertyGrid</a>.  Generally it should not need to be used directly.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-columns' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-cfg-columns' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-cfg-columns' class='name expandable'>columns</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An Array of object literals. ...</div><div class='long'><p>An Array of object literals.  The config options defined by\n<b><a href=\"#!/api/Ext.grid.Column\" rel=\"Ext.grid.Column\" class=\"docClass\">Ext.grid.Column</a></b> are the options which may appear in the object literal for each\nindividual column definition.</p>\n</div></div></div><div id='cfg-defaultSortable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-cfg-defaultSortable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-cfg-defaultSortable' class='name expandable'>defaultSortable</a><span> : Boolean</span></div><div class='description'><div class='short'>(optional) Default sortable of columns which have no\nsortable specified (defaults to false). ...</div><div class='long'><p>(optional) Default sortable of columns which have no\nsortable specified (defaults to <tt>false</tt>).  This property shall preferably be configured\nthrough the <tt><b><a href=\"#!/api/Ext.grid.ColumnModel-cfg-defaults\" rel=\"Ext.grid.ColumnModel-cfg-defaults\" class=\"docClass\">defaults</a></b></tt> config property.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-defaultWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-cfg-defaultWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-cfg-defaultWidth' class='name expandable'>defaultWidth</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>(optional) The width of columns which have no width\nspecified (defaults to 100). ...</div><div class='long'><p>(optional) The width of columns which have no <tt>width</tt>\nspecified (defaults to <tt>100</tt>).  This property shall preferably be configured through the\n<tt><b><a href=\"#!/api/Ext.grid.ColumnModel-cfg-defaults\" rel=\"Ext.grid.ColumnModel-cfg-defaults\" class=\"docClass\">defaults</a></b></tt> config property.</p>\n<p>Defaults to: <code>100</code></p></div></div></div><div id='cfg-defaults' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-cfg-defaults' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-cfg-defaults' class='name expandable'>defaults</a><span> : Object</span></div><div class='description'><div class='short'>Object literal which will be used to apply Ext.grid.Column\nconfiguration options to all columns. ...</div><div class='long'><p>Object literal which will be used to apply <a href=\"#!/api/Ext.grid.Column\" rel=\"Ext.grid.Column\" class=\"docClass\">Ext.grid.Column</a>\nconfiguration options to all <tt><b><a href=\"#!/api/Ext.grid.ColumnModel-cfg-columns\" rel=\"Ext.grid.ColumnModel-cfg-columns\" class=\"docClass\">columns</a></b></tt>.  Configuration options specified with\nindividual <a href=\"#!/api/Ext.grid.Column\" rel=\"Ext.grid.Column\" class=\"docClass\">column</a> configs will supersede these <tt><b><a href=\"#!/api/Ext.grid.ColumnModel-cfg-defaults\" rel=\"Ext.grid.ColumnModel-cfg-defaults\" class=\"docClass\">defaults</a></b></tt>.</p>\n</div></div></div><div id='cfg-listeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-cfg-listeners' class='name expandable'>listeners</a><span> : Object</span></div><div class='description'><div class='short'>(optional) A config object containing one or more event handlers to be added to this\nobject during initialization. ...</div><div class='long'><p>(optional) <p>A config object containing one or more event handlers to be added to this\nobject during initialization.  This should be a valid listeners config object as specified in the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching multiple handlers at once.</p></p>\n\n<br><p><b><u>DOM events from ExtJs <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a></u></b></p>\n\n\n<br><p>While <i>some</i> ExtJs Component classes export selected DOM events (e.g. \"click\", \"mouseover\" etc), this\n\n\n<p>is usually only done when extra value can be added. For example the <a href=\"#!/api/Ext.DataView\" rel=\"Ext.DataView\" class=\"docClass\">DataView</a>'s\n<b><code><a href=\"#!/api/Ext.DataView-event-click\" rel=\"Ext.DataView-event-click\" class=\"docClass\">click</a></code></b> event passing the node clicked on. To access DOM\nevents directly from a Component's HTMLElement, listeners must be added to the <i><a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a></i> after the Component\nhas been rendered. A plugin can simplify this step:</p>\n\n<pre><code>// Plugin is configured with a listeners config object.\n// The Component is appended to the argument list of all handler functions.\nExt.DomObserver = <a href=\"#!/api/Ext-method-extend\" rel=\"Ext-method-extend\" class=\"docClass\">Ext.extend</a>(Object, {\n    constructor: function(config) {\n        this.listeners = config.listeners ? config.listeners : config;\n    },\n\n    // Component passes itself into plugin&#39;s init method\n    init: function(c) {\n        var p, l = this.listeners;\n        for (p in l) {\n            if (<a href=\"#!/api/Ext-method-isFunction\" rel=\"Ext-method-isFunction\" class=\"docClass\">Ext.isFunction</a>(l[p])) {\n                l[p] = this.createHandler(l[p], c);\n            } else {\n                l[p].fn = this.createHandler(l[p].fn, c);\n            }\n        }\n\n        // Add the listeners to the Element immediately following the render call\n        c.render = c.render.<a href=\"#!/api/Function-method-createSequence\" rel=\"Function-method-createSequence\" class=\"docClass\">createSequence</a>(function() {\n            var e = c.getEl();\n            if (e) {\n                e.on(l);\n            }\n        });\n    },\n\n    createHandler: function(fn, c) {\n        return function(e) {\n            fn.call(this, e, c);\n        };\n    }\n});\n\nvar combo = new <a href=\"#!/api/Ext.form.ComboBox\" rel=\"Ext.form.ComboBox\" class=\"docClass\">Ext.form.ComboBox</a>({\n\n    // Collapse combo when its element is clicked on\n    plugins: [ new Ext.DomObserver({\n        click: function(evt, comp) {\n            comp.collapse();\n        }\n    })],\n    store: myStore,\n    typeAhead: true,\n    mode: 'local',\n    triggerAction: 'all'\n});\n</code></pre>\n\n\n<p></p></p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-config' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-property-config' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-property-config' class='name expandable'>config</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An Array of Column definition objects representing the configuration\nof this ColumnModel. ...</div><div class='long'><p>An Array of <a href=\"#!/api/Ext.grid.Column\" rel=\"Ext.grid.Column\" class=\"docClass\">Column definition</a> objects representing the configuration\nof this ColumnModel.  See <a href=\"#!/api/Ext.grid.Column\" rel=\"Ext.grid.Column\" class=\"docClass\">Ext.grid.Column</a> for the configuration properties that may\nbe specified.</p>\n</div></div></div><div id='property-dateFormat' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.PropertyColumnModel'>Ext.grid.PropertyColumnModel</span><br/><a href='source/PropertyGrid.html#Ext-grid-PropertyColumnModel-property-dateFormat' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.PropertyColumnModel-property-dateFormat' class='name expandable'>dateFormat</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>'m/j/Y'</code></p></div></div></div><div id='property-falseText' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.PropertyColumnModel'>Ext.grid.PropertyColumnModel</span><br/><a href='source/PropertyGrid.html#Ext-grid-PropertyColumnModel-property-falseText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.PropertyColumnModel-property-falseText' class='name expandable'>falseText</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>'false'</code></p></div></div></div><div id='property-nameText' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.PropertyColumnModel'>Ext.grid.PropertyColumnModel</span><br/><a href='source/PropertyGrid.html#Ext-grid-PropertyColumnModel-property-nameText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.PropertyColumnModel-property-nameText' class='name expandable'>nameText</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private - strings used for locale support ...</div><div class='long'><p>private - strings used for locale support</p>\n<p>Defaults to: <code>'Name'</code></p></div></div></div><div id='property-trueText' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.PropertyColumnModel'>Ext.grid.PropertyColumnModel</span><br/><a href='source/PropertyGrid.html#Ext-grid-PropertyColumnModel-property-trueText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.PropertyColumnModel-property-trueText' class='name expandable'>trueText</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>'true'</code></p></div></div></div><div id='property-valueText' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.PropertyColumnModel'>Ext.grid.PropertyColumnModel</span><br/><a href='source/PropertyGrid.html#Ext-grid-PropertyColumnModel-property-valueText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.PropertyColumnModel-property-valueText' class='name expandable'>valueText</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>'Value'</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.PropertyColumnModel'>Ext.grid.PropertyColumnModel</span><br/><a href='source/PropertyGrid.html#Ext-grid-PropertyColumnModel-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.grid.PropertyColumnModel-method-constructor' class='name expandable'>Ext.grid.PropertyColumnModel</a>( <span class='pre'>grid, source</span> ) : <a href=\"#!/api/Ext.grid.PropertyColumnModel\" rel=\"Ext.grid.PropertyColumnModel\" class=\"docClass\">Ext.grid.PropertyColumnModel</a></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>grid</span> : Ext.grid.Grid<div class='sub-desc'><p>The grid this store will be bound to</p>\n</div></li><li><span class='pre'>source</span> : Object<div class='sub-desc'><p>The source data config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.grid.PropertyColumnModel\" rel=\"Ext.grid.PropertyColumnModel\" class=\"docClass\">Ext.grid.PropertyColumnModel</a></span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.grid.ColumnModel-method-constructor' rel='Ext.grid.ColumnModel-method-constructor' class='docClass'>Ext.grid.ColumnModel.constructor</a></p></div></div></div><div id='method-addEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addEvents' class='name expandable'>addEvents</a>( <span class='pre'>o, Optional</span> )</div><div class='description'><div class='short'>Adds the specified events to the list of events which this Observable may fire. ...</div><div class='long'><p>Adds the specified events to the list of events which this Observable may fire.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either an object with event names as properties with a value of <code>true</code>\nor the first event name string if multiple event names are being passed as separate parameters.</p>\n</div></li><li><span class='pre'>Optional</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>. Event name if multiple event names are being passed as separate parameters.\nUsage:</p>\n\n<pre><code>this.addEvents('storeloaded', 'storecleared');\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-addListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addListener' class='name expandable'>addListener</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object. ...</div><div class='long'><p>Appends an event handler to this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to listen for.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.\nproperties. This may contain any of the following properties:<ul>\n<li><b>scope</b> : Object<div class=\"sub-desc\">The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></div></li>\n<li><b>delay</b> : Number<div class=\"sub-desc\">The number of milliseconds to delay the invocation of the handler after the event fires.</div></li>\n<li><b>single</b> : Boolean<div class=\"sub-desc\">True to add a handler to handle just the next firing of the event, and then remove itself.</div></li>\n<li><b>buffer</b> : Number<div class=\"sub-desc\">Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed\nby the specified number of milliseconds. If the event fires again within that time, the original\nhandler is <em>not</em> invoked, but the new handler is scheduled in its place.</div></li>\n<li><b>target</b> : Observable<div class=\"sub-desc\">Only call the handler if the event was fired on the target Observable, <i>not</i>\nif the event was bubbled up from a child Observable.</div></li>\n</ul><br></p>\n\n<p>\n<b>Combining Options</b><br>\nUsing the options argument, it is possible to combine different types of listeners:<br>\n<br>\nA delayed, one-time listener.\n<pre><code>myDataView.on('click', this.onClick, this, {\nsingle: true,\ndelay: 100\n});</code></pre>\n<p>\n<b>Attaching multiple handlers in 1 call</b><br>\nThe method also allows for a single argument to be passed which is a config object containing properties\nwhich specify multiple handlers.\n<p>\n<pre><code>myGridPanel.on({\n'click' : {\n    fn: this.onClick,\n    scope: this,\n    delay: 100\n},\n'mouseover' : {\n    fn: this.onMouseOver,\n    scope: this\n},\n'mouseout' : {\n    fn: this.onMouseOut,\n    scope: this\n}\n});</code></pre>\n<p>\nOr a shorthand syntax:<br>\n<pre><code>myGridPanel.on({\n'click' : this.onClick,\n'mouseover' : this.onMouseOver,\n'mouseout' : this.onMouseOut,\n scope: this\n});</code></pre>\n\n</p></p></p></p></div></li></ul></div></div></div><div id='method-destroy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.PropertyColumnModel'>Ext.grid.PropertyColumnModel</span><br/><a href='source/PropertyGrid.html#Ext-grid-PropertyColumnModel-method-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.PropertyColumnModel-method-destroy' class='name expandable'>destroy</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>inherit docs\n\nDestroys this column model by purging any event listeners. ...</div><div class='long'><p>inherit docs</p>\n\n<p>Destroys this column model by purging any event listeners. Destroys and dereferences all Columns.</p>\n<p>Overrides: <a href='#!/api/Ext.grid.ColumnModel-method-destroy' rel='Ext.grid.ColumnModel-method-destroy' class='docClass'>Ext.grid.ColumnModel.destroy</a></p></div></div></div><div id='method-destroyEditors' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.PropertyColumnModel'>Ext.grid.PropertyColumnModel</span><br/><a href='source/PropertyGrid.html#Ext-grid-PropertyColumnModel-method-destroyEditors' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.PropertyColumnModel-method-destroyEditors' class='name expandable'>destroyEditors</a>( <span class='pre'>editors</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>editors</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-enableBubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-enableBubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-enableBubble' class='name expandable'>enableBubble</a>( <span class='pre'>events</span> )</div><div class='description'><div class='short'>Enables events fired by this Observable to bubble up an owner hierarchy by calling\nthis.getBubbleTarget() if present. ...</div><div class='long'><p>Enables events fired by this Observable to bubble up an owner hierarchy by calling\n<code>this.getBubbleTarget()</code> if present. There is no implementation in the Observable base class.</p>\n\n\n<p>This is commonly used by Ext.Components to bubble events to owner Containers. See Ext.Component.getBubbleTarget. The default\nimplementation in <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> returns the Component's immediate owner. But if a known target is required, this can be overridden to\naccess the required target more quickly.</p>\n\n\n<p>Example:</p>\n\n\n<pre><code><a href=\"#!/api/Ext-method-override\" rel=\"Ext-method-override\" class=\"docClass\">Ext.override</a>(<a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a>, {\n    //  Add functionality to Field&#39;s initComponent to enable the change event to bubble\n    initComponent : Ext.form.Field.prototype.initComponent.createSequence(function() {\n        this.enableBubble('change');\n    }),\n\n    //  We know that we want Field&#39;s events to bubble directly to the FormPanel.\n    getBubbleTarget : function() {\n        if (!this.formPanel) {\n            this.formPanel = this.findParentByType('form');\n        }\n        return this.formPanel;\n    }\n});\n\nvar myForm = new Ext.formPanel({\n    title: 'User Details',\n    items: [{\n        ...\n    }],\n    listeners: {\n        change: function() {\n            // Title goes red if form has been modified.\n            myForm.header.setStyle('color', 'red');\n        }\n    }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The event name to bubble, or an Array of event names.</p>\n</div></li></ul></div></div></div><div id='method-findColumnIndex' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-findColumnIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-findColumnIndex' class='name expandable'>findColumnIndex</a>( <span class='pre'>col</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Finds the index of the first matching column for the given dataIndex. ...</div><div class='long'><p>Finds the index of the first matching column for the given dataIndex.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>col</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The dataIndex to find</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The column index, or -1 if no match was found</p>\n</div></li></ul></div></div></div><div id='method-fireEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-fireEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-fireEvent' class='name expandable'>fireEvent</a>( <span class='pre'>eventName, args</span> ) : Boolean</div><div class='description'><div class='short'>Fires the specified event with the passed parameters (minus the event name). ...</div><div class='long'><p>Fires the specified event with the passed parameters (minus the event name).</p>\n\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>)\nby calling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : Object...<div class='sub-desc'><p>Variable number of parameters are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul></div></div></div><div id='method-getCellEditor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.PropertyColumnModel'>Ext.grid.PropertyColumnModel</span><br/><a href='source/PropertyGrid.html#Ext-grid-PropertyColumnModel-method-getCellEditor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.PropertyColumnModel-method-getCellEditor' class='name expandable'>getCellEditor</a>( <span class='pre'>colIndex, rowIndex</span> ) : <a href=\"#!/api/Ext.Editor\" rel=\"Ext.Editor\" class=\"docClass\">Ext.Editor</a></div><div class='description'><div class='short'>private\n\nReturns the editor defined for the cell/column. ...</div><div class='long'><p>private</p>\n\n<p>Returns the editor defined for the cell/column.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>colIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li><li><span class='pre'>rowIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The row index</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Editor\" rel=\"Ext.Editor\" class=\"docClass\">Ext.Editor</a></span><div class='sub-desc'><p>The <a href=\"#!/api/Ext.Editor\" rel=\"Ext.Editor\" class=\"docClass\">Editor</a> that was created to wrap\nthe <a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Field</a> used to edit the cell.</p>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.grid.ColumnModel-method-getCellEditor' rel='Ext.grid.ColumnModel-method-getCellEditor' class='docClass'>Ext.grid.ColumnModel.getCellEditor</a></p></div></div></div><div id='method-getColumnAt' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-getColumnAt' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-getColumnAt' class='name expandable'>getColumnAt</a>( <span class='pre'>index</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>index</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getColumnById' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-getColumnById' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-getColumnById' class='name expandable'>getColumnById</a>( <span class='pre'>id</span> ) : Object</div><div class='description'><div class='short'>Returns the column for a specified id. ...</div><div class='long'><p>Returns the column for a specified id.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The column id</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>the column</p>\n</div></li></ul></div></div></div><div id='method-getColumnCount' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-getColumnCount' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-getColumnCount' class='name expandable'>getColumnCount</a>( <span class='pre'>visibleOnly</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the number of columns. ...</div><div class='long'><p>Returns the number of columns.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>visibleOnly</span> : Boolean<div class='sub-desc'><p>Optional. Pass as true to only include visible columns.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getColumnHeader' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-getColumnHeader' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-getColumnHeader' class='name expandable'>getColumnHeader</a>( <span class='pre'>col</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the header for the specified column. ...</div><div class='long'><p>Returns the header for the specified column.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>col</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getColumnId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-getColumnId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-getColumnId' class='name expandable'>getColumnId</a>( <span class='pre'>index</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the id of the column at the specified index. ...</div><div class='long'><p>Returns the id of the column at the specified index.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>the id</p>\n</div></li></ul></div></div></div><div id='method-getColumnTooltip' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-getColumnTooltip' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-getColumnTooltip' class='name expandable'>getColumnTooltip</a>( <span class='pre'>col</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the tooltip for the specified column. ...</div><div class='long'><p>Returns the tooltip for the specified column.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>col</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getColumnWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-getColumnWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-getColumnWidth' class='name expandable'>getColumnWidth</a>( <span class='pre'>col</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the width for the specified column. ...</div><div class='long'><p>Returns the width for the specified column.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>col</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getColumnsBy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-getColumnsBy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-getColumnsBy' class='name expandable'>getColumnsBy</a>( <span class='pre'>fn, [scope]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Returns the column configs that return true by the passed function that is called\nwith (columnConfig, index)\n\n// retu...</div><div class='long'><p>Returns the column configs that return true by the passed function that is called\nwith (columnConfig, index)</p>\n\n<pre><code>// returns an array of column config objects for all hidden columns\nvar columns = grid.getColumnModel().getColumnsBy(function(c){\n  return c.hidden;\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>A function which, when passed a <a href=\"#!/api/Ext.grid.Column\" rel=\"Ext.grid.Column\" class=\"docClass\">Column</a> object, must\nreturn <code>true</code> if the column is to be included in the returned Array.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function\nis executed. Defaults to this ColumnModel.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>result</p>\n</div></li></ul></div></div></div><div id='method-getDataIndex' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-getDataIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-getDataIndex' class='name expandable'>getDataIndex</a>( <span class='pre'>col</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the dataIndex for the specified column. ...</div><div class='long'><p>Returns the dataIndex for the specified column.</p>\n\n<pre><code>// Get field name for the column\nvar fieldName = grid.getColumnModel().getDataIndex(columnIndex);\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>col</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The column's dataIndex</p>\n</div></li></ul></div></div></div><div id='method-getIndexById' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-getIndexById' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-getIndexById' class='name expandable'>getIndexById</a>( <span class='pre'>id</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the index for a specified column id. ...</div><div class='long'><p>Returns the index for a specified column id.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The column id</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>the index, or -1 if not found</p>\n</div></li></ul></div></div></div><div id='method-getPropertyName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.PropertyColumnModel'>Ext.grid.PropertyColumnModel</span><br/><a href='source/PropertyGrid.html#Ext-grid-PropertyColumnModel-method-getPropertyName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.PropertyColumnModel-method-getPropertyName' class='name expandable'>getPropertyName</a>( <span class='pre'>name</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getRenderer' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.PropertyColumnModel'>Ext.grid.PropertyColumnModel</span><br/><a href='source/PropertyGrid.html#Ext-grid-PropertyColumnModel-method-getRenderer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.PropertyColumnModel-method-getRenderer' class='name expandable'>getRenderer</a>( <span class='pre'>col</span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></div><div class='description'><div class='short'>private\n\nReturns the rendering (formatting) function defined for the column. ...</div><div class='long'><p>private</p>\n\n<p>Returns the rendering (formatting) function defined for the column.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>col</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'><p>The function used to render the cell. See <a href=\"#!/api/Ext.grid.PropertyColumnModel-method-setRenderer\" rel=\"Ext.grid.PropertyColumnModel-method-setRenderer\" class=\"docClass\">setRenderer</a>.</p>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.grid.ColumnModel-method-getRenderer' rel='Ext.grid.ColumnModel-method-getRenderer' class='docClass'>Ext.grid.ColumnModel.getRenderer</a></p></div></div></div><div id='method-getRendererScope' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-getRendererScope' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-getRendererScope' class='name expandable'>getRendererScope</a>( <span class='pre'>col</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>col</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTotalWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-getTotalWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-getTotalWidth' class='name expandable'>getTotalWidth</a>( <span class='pre'>includeHidden</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the total width of all columns. ...</div><div class='long'><p>Returns the total width of all columns.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>includeHidden</span> : Boolean<div class='sub-desc'><p>True to include hidden column widths</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-hasListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-hasListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-hasListener' class='name expandable'>hasListener</a>( <span class='pre'>eventName</span> ) : Boolean</div><div class='description'><div class='short'>Checks to see if this object has any listeners for a specified event ...</div><div class='long'><p>Checks to see if this object has any listeners for a specified event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the event is being listened for, else false</p>\n</div></li></ul></div></div></div><div id='method-isCellEditable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.PropertyColumnModel'>Ext.grid.PropertyColumnModel</span><br/><a href='source/PropertyGrid.html#Ext-grid-PropertyColumnModel-method-isCellEditable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.PropertyColumnModel-method-isCellEditable' class='name expandable'>isCellEditable</a>( <span class='pre'>colIndex, rowIndex</span> ) : Boolean</div><div class='description'><div class='short'>private\n\nReturns true if the cell is editable. ...</div><div class='long'><p>private</p>\n\n<p>Returns true if the cell is editable.</p>\n\n<pre><code>var store = new <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>({...});\nvar colModel = new <a href=\"#!/api/Ext.grid.ColumnModel\" rel=\"Ext.grid.ColumnModel\" class=\"docClass\">Ext.grid.ColumnModel</a>({\n  columns: [...],\n  isCellEditable: function(col, row) {\n    var record = store.getAt(row);\n    if (record.get('readonly')) { // replace with your condition\n      return false;\n    }\n    return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);\n  }\n});\nvar grid = new <a href=\"#!/api/Ext.grid.GridPanel\" rel=\"Ext.grid.GridPanel\" class=\"docClass\">Ext.grid.GridPanel</a>({\n  store: store,\n  colModel: colModel,\n  ...\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>colIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li><li><span class='pre'>rowIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The row index</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.grid.ColumnModel-method-isCellEditable' rel='Ext.grid.ColumnModel-method-isCellEditable' class='docClass'>Ext.grid.ColumnModel.isCellEditable</a></p></div></div></div><div id='method-isFixed' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-isFixed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-isFixed' class='name expandable'>isFixed</a>( <span class='pre'>colIndex</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the column is fixed,\nfalse otherwise. ...</div><div class='long'><p>Returns <tt>true</tt> if the column is <code><a href=\"#!/api/Ext.grid.Column-cfg-fixed\" rel=\"Ext.grid.Column-cfg-fixed\" class=\"docClass\">fixed</a></code>,\n<tt>false</tt> otherwise.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>colIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isHidden' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-isHidden' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-isHidden' class='name expandable'>isHidden</a>( <span class='pre'>colIndex</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the column is hidden,\nfalse otherwise. ...</div><div class='long'><p>Returns <tt>true</tt> if the column is <code><a href=\"#!/api/Ext.grid.Column-cfg-hidden\" rel=\"Ext.grid.Column-cfg-hidden\" class=\"docClass\">hidden</a></code>,\n<tt>false</tt> otherwise.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>colIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isMenuDisabled' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-isMenuDisabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-isMenuDisabled' class='name expandable'>isMenuDisabled</a>( <span class='pre'>col</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the specified column menu is disabled. ...</div><div class='long'><p>Returns true if the specified column menu is disabled.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>col</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isResizable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-isResizable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-isResizable' class='name expandable'>isResizable</a>( <span class='pre'>colIndex</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the column can be resized ...</div><div class='long'><p>Returns true if the column can be resized</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>colIndex</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isSortable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-isSortable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-isSortable' class='name expandable'>isSortable</a>( <span class='pre'>col</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the specified column is sortable. ...</div><div class='long'><p>Returns true if the specified column is sortable.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>col</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-moveColumn' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-moveColumn' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-moveColumn' class='name expandable'>moveColumn</a>( <span class='pre'>oldIndex, newIndex</span> )</div><div class='description'><div class='short'>Moves a column from one position to another. ...</div><div class='long'><p>Moves a column from one position to another.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>oldIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index of the column to move.</p>\n</div></li><li><span class='pre'>newIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The position at which to reinsert the coolumn.</p>\n</div></li></ul></div></div></div><div id='method-on' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-on' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-on' class='name expandable'>on</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object (shorthand for addListener.) ...</div><div class='long'><p>Appends an event handler to this object (shorthand for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event to listen for</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n</div></li></ul></div></div></div><div id='method-purgeListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-purgeListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-purgeListeners' class='name expandable'>purgeListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all listeners for this object ...</div><div class='long'><p>Removes all listeners for this object</p>\n</div></div></div><div id='method-relayEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-relayEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-relayEvents' class='name expandable'>relayEvents</a>( <span class='pre'>o, events</span> )</div><div class='description'><div class='short'>Relays selected events from the specified Observable as if the events were fired by this. ...</div><div class='long'><p>Relays selected events from the specified Observable as if the events were fired by <tt><b>this</b></tt>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The Observable whose events this object is to relay.</p>\n</div></li><li><span class='pre'>events</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Array of event names to relay.</p>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler. ...</div><div class='long'><p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-renderBool' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.PropertyColumnModel'>Ext.grid.PropertyColumnModel</span><br/><a href='source/PropertyGrid.html#Ext-grid-PropertyColumnModel-method-renderBool' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.PropertyColumnModel-method-renderBool' class='name expandable'>renderBool</a>( <span class='pre'>bVal</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>bVal</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-renderCell' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.PropertyColumnModel'>Ext.grid.PropertyColumnModel</span><br/><a href='source/PropertyGrid.html#Ext-grid-PropertyColumnModel-method-renderCell' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.PropertyColumnModel-method-renderCell' class='name expandable'>renderCell</a>( <span class='pre'>val, meta, rec</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>val</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>meta</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>rec</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-renderDate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.PropertyColumnModel'>Ext.grid.PropertyColumnModel</span><br/><a href='source/PropertyGrid.html#Ext-grid-PropertyColumnModel-method-renderDate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.PropertyColumnModel-method-renderDate' class='name expandable'>renderDate</a>( <span class='pre'>dateVal</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>dateVal</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-renderProp' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.PropertyColumnModel'>Ext.grid.PropertyColumnModel</span><br/><a href='source/PropertyGrid.html#Ext-grid-PropertyColumnModel-method-renderProp' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.PropertyColumnModel-method-renderProp' class='name expandable'>renderProp</a>( <span class='pre'>v</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>v</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-resumeEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-resumeEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-resumeEvents' class='name expandable'>resumeEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resume firing events. ...</div><div class='long'><p>Resume firing events. (see <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>)\nIf events were suspended using the <tt><b>queueSuspended</b></tt> parameter, then all\nevents fired during event suspension will be sent to any listeners now.</p>\n</div></div></div><div id='method-setColumnHeader' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-setColumnHeader' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-setColumnHeader' class='name expandable'>setColumnHeader</a>( <span class='pre'>col, header</span> )</div><div class='description'><div class='short'>Sets the header for a column. ...</div><div class='long'><p>Sets the header for a column.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>col</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li><li><span class='pre'>header</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The new header</p>\n</div></li></ul></div></div></div><div id='method-setColumnTooltip' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-setColumnTooltip' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-setColumnTooltip' class='name expandable'>setColumnTooltip</a>( <span class='pre'>col, tooltip</span> )</div><div class='description'><div class='short'>Sets the tooltip for a column. ...</div><div class='long'><p>Sets the tooltip for a column.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>col</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li><li><span class='pre'>tooltip</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The new tooltip</p>\n</div></li></ul></div></div></div><div id='method-setColumnWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-setColumnWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-setColumnWidth' class='name expandable'>setColumnWidth</a>( <span class='pre'>col, width, suppressEvent</span> )</div><div class='description'><div class='short'>Sets the width for a column. ...</div><div class='long'><p>Sets the width for a column.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>col</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li><li><span class='pre'>width</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new width</p>\n</div></li><li><span class='pre'>suppressEvent</span> : Boolean<div class='sub-desc'><p>True to suppress firing the <code><a href=\"#!/api/Ext.grid.ColumnModel-event-widthchange\" rel=\"Ext.grid.ColumnModel-event-widthchange\" class=\"docClass\">widthchange</a></code>\nevent. Defaults to false.</p>\n</div></li></ul></div></div></div><div id='method-setConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-setConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-setConfig' class='name expandable'>setConfig</a>( <span class='pre'>config, initial</span> )</div><div class='description'><div class='short'>Reconfigures this column model according to the passed Array of column definition objects. ...</div><div class='long'><p>Reconfigures this column model according to the passed Array of column definition objects.\nFor a description of the individual properties of a column definition object, see the\n<a href=\"#Ext.grid.ColumnModel-configs\">Config Options</a>.</p>\n\n\n<p>Causes the <a href=\"#!/api/Ext.grid.ColumnModel-event-configchange\" rel=\"Ext.grid.ColumnModel-event-configchange\" class=\"docClass\">configchange</a> event to be fired. A <a href=\"#!/api/Ext.grid.GridPanel\" rel=\"Ext.grid.GridPanel\" class=\"docClass\">GridPanel</a>\nusing this ColumnModel will listen for this event and refresh its UI automatically.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Array of Column definition objects.</p>\n</div></li><li><span class='pre'>initial</span> : Boolean<div class='sub-desc'><p>Specify <tt>true</tt> to bypass cleanup which deletes the <tt>totalWidth</tt>\nand destroys existing editors.</p>\n</div></li></ul></div></div></div><div id='method-setDataIndex' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-setDataIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-setDataIndex' class='name expandable'>setDataIndex</a>( <span class='pre'>col, dataIndex</span> )</div><div class='description'><div class='short'>Sets the dataIndex for a column. ...</div><div class='long'><p>Sets the dataIndex for a column.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>col</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li><li><span class='pre'>dataIndex</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The new dataIndex</p>\n</div></li></ul></div></div></div><div id='method-setEditable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-setEditable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-setEditable' class='name expandable'>setEditable</a>( <span class='pre'>col, editable</span> )</div><div class='description'><div class='short'>Sets if a column is editable. ...</div><div class='long'><p>Sets if a column is editable.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>col</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li><li><span class='pre'>editable</span> : Boolean<div class='sub-desc'><p>True if the column is editable</p>\n</div></li></ul></div></div></div><div id='method-setEditor' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-setEditor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-setEditor' class='name expandable'>setEditor</a>( <span class='pre'>col, editor</span> )</div><div class='description'><div class='short'>Sets the editor for a column and destroys the prior editor. ...</div><div class='long'><p>Sets the editor for a column and destroys the prior editor.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>col</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li><li><span class='pre'>editor</span> : Object<div class='sub-desc'><p>The editor object</p>\n</div></li></ul></div></div></div><div id='method-setHidden' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-setHidden' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-setHidden' class='name expandable'>setHidden</a>( <span class='pre'>colIndex, hidden</span> )</div><div class='description'><div class='short'>Sets if a column is hidden. ...</div><div class='long'><p>Sets if a column is hidden.</p>\n\n<pre><code>myGrid.getColumnModel().setHidden(0, true); // hide column 0 (0 = the first column).\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>colIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li><li><span class='pre'>hidden</span> : Boolean<div class='sub-desc'><p>True if the column is hidden</p>\n</div></li></ul></div></div></div><div id='method-setRenderer' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-setRenderer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-setRenderer' class='name expandable'>setRenderer</a>( <span class='pre'>col, fn</span> )</div><div class='description'><div class='short'>Sets the rendering (formatting) function for a column. ...</div><div class='long'><p>Sets the rendering (formatting) function for a column.  See <a href=\"#!/api/Ext.util.Format\" rel=\"Ext.util.Format\" class=\"docClass\">Ext.util.Format</a> for some\ndefault formatting functions.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>col</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to use to process the cell's raw data\nto return HTML markup for the grid view. The render function is called with\nthe following parameters:<ul>\n<li><b>value</b> : Object<p class=\"sub-desc\">The data value for the cell.</p></li>\n<li><b>metadata</b> : Object<p class=\"sub-desc\">An object in which you may set the following attributes:<ul>\n<li><b>css</b> : String<p class=\"sub-desc\">A CSS class name to add to the cell's TD element.</p></li>\n<li><b>attr</b> : String<p class=\"sub-desc\">An HTML attribute definition string to apply to the data container element <i>within</i> the table cell\n(e.g. 'style=\"color:red;\"').</p></li></ul></p></li>\n<li><b>record</b> : Ext.data.record<p class=\"sub-desc\">The <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a> from which the data was extracted.</p></li>\n<li><b>rowIndex</b> : Number<p class=\"sub-desc\">Row index</p></li>\n<li><b>colIndex</b> : Number<p class=\"sub-desc\">Column index</p></li>\n<li><b>store</b> : <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a><p class=\"sub-desc\">The <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> object from which the Record was extracted.</p></li></ul></p>\n</div></li></ul></div></div></div><div id='method-setState' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-method-setState' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-method-setState' class='name expandable'>setState</a>( <span class='pre'>col, state</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Setup any saved state for the column, ensures that defaults are applied. ...</div><div class='long'><p>Setup any saved state for the column, ensures that defaults are applied.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>col</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-suspendEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-suspendEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-suspendEvents' class='name expandable'>suspendEvents</a>( <span class='pre'>queueSuspended</span> )</div><div class='description'><div class='short'>Suspend the firing of all events. ...</div><div class='long'><p>Suspend the firing of all events. (see <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queueSuspended</span> : Boolean<div class='sub-desc'><p>Pass as true to queue up suspended events to be fired\nafter the <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> call instead of discarding all suspended events;</p>\n</div></li></ul></div></div></div><div id='method-un' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-un' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-un' class='name expandable'>un</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler (shorthand for removeListener.) ...</div><div class='long'><p>Removes an event handler (shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeListener\" rel=\"Ext.util.Observable-method-removeListener\" class=\"docClass\">removeListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-event'>Events</h3><div class='subsection'><div id='event-columnmoved' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-event-columnmoved' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-event-columnmoved' class='name expandable'>columnmoved</a>( <span class='pre'>this, oldIndex, newIndex</span> )</div><div class='description'><div class='short'>Fires when a column is moved. ...</div><div class='long'><p>Fires when a column is moved.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : ColumnModel<div class='sub-desc'>\n</div></li><li><span class='pre'>oldIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'>\n</div></li><li><span class='pre'>newIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-configchange' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-event-configchange' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-event-configchange' class='name expandable'>configchange</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires when the configuration is changed ...</div><div class='long'><p>Fires when the configuration is changed</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : ColumnModel<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-headerchange' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-event-headerchange' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-event-headerchange' class='name expandable'>headerchange</a>( <span class='pre'>this, columnIndex, newText</span> )</div><div class='description'><div class='short'>Fires when the text of a header changes. ...</div><div class='long'><p>Fires when the text of a header changes.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : ColumnModel<div class='sub-desc'>\n</div></li><li><span class='pre'>columnIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li><li><span class='pre'>newText</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The new header text</p>\n</div></li></ul></div></div></div><div id='event-hiddenchange' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-event-hiddenchange' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-event-hiddenchange' class='name expandable'>hiddenchange</a>( <span class='pre'>this, columnIndex, hidden</span> )</div><div class='description'><div class='short'>Fires when a column is hidden or \"unhidden\". ...</div><div class='long'><p>Fires when a column is hidden or \"unhidden\".</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : ColumnModel<div class='sub-desc'>\n</div></li><li><span class='pre'>columnIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li><li><span class='pre'>hidden</span> : Boolean<div class='sub-desc'><p>true if hidden, false otherwise</p>\n</div></li></ul></div></div></div><div id='event-widthchange' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.ColumnModel' rel='Ext.grid.ColumnModel' class='defined-in docClass'>Ext.grid.ColumnModel</a><br/><a href='source/ColumnModel.html#Ext-grid-ColumnModel-event-widthchange' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.ColumnModel-event-widthchange' class='name expandable'>widthchange</a>( <span class='pre'>this, columnIndex, newWidth</span> )</div><div class='description'><div class='short'>Fires when the width of a column is programmaticially changed using\nsetColumnWidth. ...</div><div class='long'><p>Fires when the width of a column is programmaticially changed using\n<code><a href=\"#!/api/Ext.grid.ColumnModel-method-setColumnWidth\" rel=\"Ext.grid.ColumnModel-method-setColumnWidth\" class=\"docClass\">setColumnWidth</a></code>.\nNote internal resizing suppresses the event from firing. See also\n<a href=\"#!/api/Ext.grid.GridPanel\" rel=\"Ext.grid.GridPanel\" class=\"docClass\">Ext.grid.GridPanel</a>.<code>columnresize</code>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : ColumnModel<div class='sub-desc'>\n</div></li><li><span class='pre'>columnIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The column index</p>\n</div></li><li><span class='pre'>newWidth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new width</p>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":["Ext.util.Observable","Ext.grid.ColumnModel"],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[],"event":[],"css_mixin":[]},"files":[{"href":"PropertyGrid.html#Ext-grid-PropertyColumnModel","filename":"PropertyGrid.js"}],"linenr":122,"members":{"property":[{"tagname":"property","owner":"Ext.grid.ColumnModel","meta":{},"name":"config","id":"property-config"},{"tagname":"property","owner":"Ext.grid.PropertyColumnModel","meta":{"private":true},"name":"dateFormat","id":"property-dateFormat"},{"tagname":"property","owner":"Ext.grid.PropertyColumnModel","meta":{"private":true},"name":"falseText","id":"property-falseText"},{"tagname":"property","owner":"Ext.grid.PropertyColumnModel","meta":{"private":true},"name":"nameText","id":"property-nameText"},{"tagname":"property","owner":"Ext.grid.PropertyColumnModel","meta":{"private":true},"name":"trueText","id":"property-trueText"},{"tagname":"property","owner":"Ext.grid.PropertyColumnModel","meta":{"private":true},"name":"valueText","id":"property-valueText"}],"cfg":[{"tagname":"cfg","owner":"Ext.grid.ColumnModel","meta":{},"name":"columns","id":"cfg-columns"},{"tagname":"cfg","owner":"Ext.grid.ColumnModel","meta":{},"name":"defaultSortable","id":"cfg-defaultSortable"},{"tagname":"cfg","owner":"Ext.grid.ColumnModel","meta":{},"name":"defaultWidth","id":"cfg-defaultWidth"},{"tagname":"cfg","owner":"Ext.grid.ColumnModel","meta":{},"name":"defaults","id":"cfg-defaults"},{"tagname":"cfg","owner":"Ext.util.Observable","meta":{},"name":"listeners","id":"cfg-listeners"}],"css_var":[],"method":[{"tagname":"method","owner":"Ext.grid.PropertyColumnModel","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addEvents","id":"method-addEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addListener","id":"method-addListener"},{"tagname":"method","owner":"Ext.grid.PropertyColumnModel","meta":{},"name":"destroy","id":"method-destroy"},{"tagname":"method","owner":"Ext.grid.PropertyColumnModel","meta":{"private":true},"name":"destroyEditors","id":"method-destroyEditors"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"enableBubble","id":"method-enableBubble"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"findColumnIndex","id":"method-findColumnIndex"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"fireEvent","id":"method-fireEvent"},{"tagname":"method","owner":"Ext.grid.PropertyColumnModel","meta":{},"name":"getCellEditor","id":"method-getCellEditor"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{"private":true},"name":"getColumnAt","id":"method-getColumnAt"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"getColumnById","id":"method-getColumnById"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"getColumnCount","id":"method-getColumnCount"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"getColumnHeader","id":"method-getColumnHeader"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"getColumnId","id":"method-getColumnId"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"getColumnTooltip","id":"method-getColumnTooltip"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"getColumnWidth","id":"method-getColumnWidth"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"getColumnsBy","id":"method-getColumnsBy"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"getDataIndex","id":"method-getDataIndex"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"getIndexById","id":"method-getIndexById"},{"tagname":"method","owner":"Ext.grid.PropertyColumnModel","meta":{"private":true},"name":"getPropertyName","id":"method-getPropertyName"},{"tagname":"method","owner":"Ext.grid.PropertyColumnModel","meta":{},"name":"getRenderer","id":"method-getRenderer"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{"private":true},"name":"getRendererScope","id":"method-getRendererScope"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"getTotalWidth","id":"method-getTotalWidth"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"hasListener","id":"method-hasListener"},{"tagname":"method","owner":"Ext.grid.PropertyColumnModel","meta":{},"name":"isCellEditable","id":"method-isCellEditable"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"isFixed","id":"method-isFixed"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"isHidden","id":"method-isHidden"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"isMenuDisabled","id":"method-isMenuDisabled"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"isResizable","id":"method-isResizable"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"isSortable","id":"method-isSortable"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"moveColumn","id":"method-moveColumn"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"on","id":"method-on"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"purgeListeners","id":"method-purgeListeners"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"relayEvents","id":"method-relayEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"removeListener","id":"method-removeListener"},{"tagname":"method","owner":"Ext.grid.PropertyColumnModel","meta":{"private":true},"name":"renderBool","id":"method-renderBool"},{"tagname":"method","owner":"Ext.grid.PropertyColumnModel","meta":{"private":true},"name":"renderCell","id":"method-renderCell"},{"tagname":"method","owner":"Ext.grid.PropertyColumnModel","meta":{"private":true},"name":"renderDate","id":"method-renderDate"},{"tagname":"method","owner":"Ext.grid.PropertyColumnModel","meta":{"private":true},"name":"renderProp","id":"method-renderProp"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"resumeEvents","id":"method-resumeEvents"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"setColumnHeader","id":"method-setColumnHeader"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"setColumnTooltip","id":"method-setColumnTooltip"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"setColumnWidth","id":"method-setColumnWidth"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"setConfig","id":"method-setConfig"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"setDataIndex","id":"method-setDataIndex"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"setEditable","id":"method-setEditable"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"setEditor","id":"method-setEditor"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"setHidden","id":"method-setHidden"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{},"name":"setRenderer","id":"method-setRenderer"},{"tagname":"method","owner":"Ext.grid.ColumnModel","meta":{"private":true},"name":"setState","id":"method-setState"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"suspendEvents","id":"method-suspendEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"un","id":"method-un"}],"event":[{"tagname":"event","owner":"Ext.grid.ColumnModel","meta":{},"name":"columnmoved","id":"event-columnmoved"},{"tagname":"event","owner":"Ext.grid.ColumnModel","meta":{},"name":"configchange","id":"event-configchange"},{"tagname":"event","owner":"Ext.grid.ColumnModel","meta":{},"name":"headerchange","id":"event-headerchange"},{"tagname":"event","owner":"Ext.grid.ColumnModel","meta":{},"name":"hiddenchange","id":"event-hiddenchange"},{"tagname":"event","owner":"Ext.grid.ColumnModel","meta":{},"name":"widthchange","id":"event-widthchange"}],"css_mixin":[]},"inheritable":null,"private":null,"component":false,"name":"Ext.grid.PropertyColumnModel","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.grid.PropertyColumnModel","mixins":[],"mixedInto":[]});