#!/usr/bin/env perl
package Data::Resolver::RoleComplain;
use v5.24;
use warnings;
use experimental 'signatures';
use Carp;
use Moo::Role;
no warnings 'experimental::signatures';
use namespace::clean;

has _ouch => (is => 'lazy', init_arg => 'ouch');

has use_ouch => (is => 'lazy', init_arg => undef);

sub _build__ouch ($self) { $Data::Resolver::RoleComplain::use_ouch // 0 }

sub _build_use_ouch ($self) {
   my $ouch = $self->_ouch or return 0;
   require Ouch;
   Ouch->import($ouch->@*) if ref($ouch) eq 'ARRAY';
   return 1;
} ## end sub _build_use_ouch

sub complain ($self, $code, $message, $data = undef) {    # Ouch-compatible
   return Ouch::ouch($code, $message, $data) if $self->use_ouch;
   croak "[$code] $message";
}

sub not_found ($self, $key) { $self->complain(404, "Not Found: <$key>") }

1;
