/*
 * Decompiled with CFR 0.152.
 */
package jcckit.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jcckit.graphic.BasicGraphicalElement;
import jcckit.graphic.ClippingRectangle;
import jcckit.graphic.ClippingShape;
import jcckit.graphic.FillAttributes;
import jcckit.graphic.FontStyle;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.GraphicalComposite;
import jcckit.graphic.GraphicalCompositeRenderer;
import jcckit.graphic.LineAttributes;
import jcckit.graphic.Oval;
import jcckit.graphic.OvalRenderer;
import jcckit.graphic.Polygon;
import jcckit.graphic.PolygonRenderer;
import jcckit.graphic.Rectangle;
import jcckit.graphic.RectangleRenderer;
import jcckit.graphic.Text;
import jcckit.graphic.TextAttributes;
import jcckit.graphic.TextRenderer;

public class Graphics2DRenderer
implements GraphicalCompositeRenderer,
PolygonRenderer,
OvalRenderer,
TextRenderer,
RectangleRenderer {
    private static final int FS = 1;
    private static final String DEFAULT_FONT_NAME = "SansSerif";
    private static final FontStyle DEFAULT_FONT_STYLE = FontStyle.NORMAL;
    private static final int DEFAULT_FONT_SIZE = 12;
    private Color _defaultColor;
    private Graphics2D _graphics;

    public Graphics2DRenderer init(Graphics2D graphics2D) {
        this._graphics = graphics2D;
        this._defaultColor = graphics2D.getColor();
        return this;
    }

    public void startRendering(GraphicalComposite graphicalComposite) {
        ClippingShape clippingShape = graphicalComposite.getClippingShape();
        if (clippingShape != null) {
            ClippingRectangle clippingRectangle = clippingShape.getBoundingBox();
            this._graphics.clip(new Rectangle2D.Double(clippingRectangle.getMinX(), clippingRectangle.getMinY(), clippingRectangle.getMaxX() - clippingRectangle.getMinX(), clippingRectangle.getMaxY() - clippingRectangle.getMinY()));
        }
    }

    public void finishRendering(GraphicalComposite graphicalComposite) {
        this._graphics.setClip(null);
    }

    public void render(Polygon polygon) {
        int n = polygon.getNumberOfPoints();
        if (n > 0) {
            Color color = this._graphics.getColor();
            GeneralPath generalPath = new GeneralPath(0, n);
            generalPath.moveTo((float)polygon.getPoint(0).getX(), (float)polygon.getPoint(0).getY());
            for (int i = 1; i < n; ++i) {
                generalPath.lineTo((float)polygon.getPoint(i).getX(), (float)polygon.getPoint(i).getY());
            }
            if (polygon.isClosed()) {
                generalPath.closePath();
            }
            this.drawShape(generalPath, polygon, color);
        }
    }

    public void render(Rectangle rectangle) {
        Color color = this._graphics.getColor();
        GraphPoint graphPoint = rectangle.getCenter();
        double d = rectangle.getWidth();
        double d2 = rectangle.getHeight();
        Rectangle2D.Double double_ = new Rectangle2D.Double(graphPoint.getX() - 0.5 * d, graphPoint.getY() - 0.5 * d2, d, d2);
        this.drawShape(double_, rectangle, color);
    }

    public void render(Oval oval) {
        Color color = this._graphics.getColor();
        GraphPoint graphPoint = oval.getCenter();
        double d = oval.getWidth();
        double d2 = oval.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double(graphPoint.getX() - 0.5 * d, graphPoint.getY() - 0.5 * d2, d, d2);
        this.drawShape(double_, oval, color);
    }

    private void drawShape(Shape shape, BasicGraphicalElement basicGraphicalElement, Color color) {
        GraphicAttributes graphicAttributes = basicGraphicalElement.getGraphicAttributes();
        Color color2 = null;
        if (basicGraphicalElement.isClosed() && graphicAttributes instanceof FillAttributes) {
            color2 = ((FillAttributes)graphicAttributes).getFillColor();
        }
        if (color2 != null) {
            this._graphics.setColor(color2);
            this._graphics.fill(shape);
        }
        Color color3 = this._defaultColor;
        if (graphicAttributes instanceof LineAttributes) {
            LineAttributes lineAttributes = (LineAttributes)graphicAttributes;
            BasicStroke basicStroke = new BasicStroke((float)lineAttributes.getLineThickness());
            double[] dArray = lineAttributes.getLinePattern();
            if (dArray != null) {
                float[] fArray = new float[dArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = (float)lineAttributes.getLinePattern()[i];
                }
                basicStroke = new BasicStroke(basicStroke.getLineWidth(), 0, 0, 10.0f, fArray, 0.0f);
            }
            this._graphics.setStroke(basicStroke);
            if (lineAttributes.getLineColor() != null || color2 != null) {
                color3 = lineAttributes.getLineColor();
            }
        }
        if (color3 != null) {
            this._graphics.setColor(color3);
            this._graphics.draw(shape);
        }
        this._graphics.setColor(color);
    }

    public void render(Text text) {
        GraphicAttributes graphicAttributes = text.getGraphicAttributes();
        if (graphicAttributes instanceof TextAttributes) {
            TextAttributes textAttributes = (TextAttributes)graphicAttributes;
            Color color = this._graphics.getColor();
            Color color2 = textAttributes.getTextColor();
            if (color2 == null) {
                color2 = this._defaultColor;
            }
            this._graphics.setColor(color2);
            double d = this._graphics.getTransform().getScaleX();
            String string = text.getText();
            AffineTransform affineTransform = this._graphics.getTransform();
            this._graphics.setTransform(new AffineTransform());
            double d2 = textAttributes.getFontSize();
            d2 = d2 == 0.0 ? 1.0 : d2 * d / 12.0;
            Font font = Graphics2DRenderer.createFont(textAttributes, 0);
            AffineTransform affineTransform2 = new AffineTransform();
            affineTransform2.scale(d2, d2);
            affineTransform2.rotate(-textAttributes.getOrientationAngle() * Math.PI / 180.0);
            font = font.deriveFont(affineTransform2);
            this._graphics.setFont(font);
            Rectangle2D rectangle2D = this._graphics.getFontMetrics().getStringBounds(string, this._graphics);
            affineTransform2.rotate(-textAttributes.getOrientationAngle() * Math.PI / 180.0);
            double d3 = rectangle2D.getHeight() + rectangle2D.getY();
            Point2D.Double double_ = new Point2D.Double(text.getPosition().getX(), text.getPosition().getY());
            affineTransform.transform(double_, double_);
            double d4 = 0.0;
            double d5 = 0.0;
            if (textAttributes.getOrientationAngle() == 0.0) {
                d4 = -0.5 * (double)textAttributes.getHorizontalAnchor().getFactor() * rectangle2D.getWidth();
                d5 = 0.5 * (double)textAttributes.getVerticalAnchor().getFactor() * rectangle2D.getHeight() - d3;
                d4 = double_.x + d4;
                d5 = double_.y + d5;
            } else {
                d4 = 0.5 * (double)textAttributes.getVerticalAnchor().getFactor() * rectangle2D.getHeight();
                d5 = 0.5 * (double)textAttributes.getHorizontalAnchor().getFactor() * rectangle2D.getWidth();
                d4 = double_.x + d4;
                d5 = double_.y + d5;
            }
            this._graphics.drawString(string, (float)d4, (float)d5);
            this._graphics.setTransform(affineTransform);
            this._graphics.setColor(color);
        }
    }

    static Font createFont(TextAttributes textAttributes, int n) {
        FontStyle fontStyle;
        String string = textAttributes.getFontName();
        if (string == null) {
            string = DEFAULT_FONT_NAME;
        }
        if ((fontStyle = textAttributes.getFontStyle()) == null) {
            fontStyle = DEFAULT_FONT_STYLE;
        }
        int n2 = 0;
        if (fontStyle == FontStyle.BOLD) {
            n2 = 1;
        } else if (fontStyle == FontStyle.ITALIC) {
            n2 = 2;
        } else if (fontStyle == FontStyle.BOLD_ITALIC) {
            n2 = 3;
        }
        if (n == 0) {
            n = 12;
        }
        return new Font(string, n2, n);
    }
}

