/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import net.sourceforge.plantuml.project.Expression;
import net.sourceforge.plantuml.project.Numeric;
import net.sourceforge.plantuml.project.NumericType;

class FreeVariable
implements Expression {
    private Expression value;
    private final String name;
    private final NumericType type;

    public FreeVariable(String string, NumericType numericType) {
        this.name = string;
        this.type = numericType;
    }

    public String getDescription() {
        return "$" + this.name + "=" + (this.value == null ? "null" : this.value.getDescription());
    }

    public NumericType getNumericType() {
        return this.type;
    }

    public Numeric getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.getValue();
    }

    public void setValue(Expression expression) {
        if (expression.getNumericType() != this.type) {
            throw new IllegalArgumentException("Bad type");
        }
        this.value = expression;
    }
}

