/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_Button({"alternateClassNames":[],"aliases":{"widget":["button"]},"enum":null,"parentMixins":[],"tagname":"class","subclasses":["Ext.SplitButton"],"extends":"Ext.BoxComponent","uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='docClass'>Ext.util.Observable</a><div class='subclass '><a href='#!/api/Ext.Component' rel='Ext.Component' class='docClass'>Ext.Component</a><div class='subclass '><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='docClass'>Ext.BoxComponent</a><div class='subclass '><strong>Ext.Button</strong></div></div></div></div><h4>Subclasses</h4><div class='dependency'><a href='#!/api/Ext.SplitButton' rel='Ext.SplitButton' class='docClass'>Ext.SplitButton</a></div><h4>Files</h4><div class='dependency'><a href='source/Button.html#Ext-Button' target='_blank'>Button.js</a></div></pre><div class='doc-contents'><p>Simple Button class</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-allowDepress' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-allowDepress' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-allowDepress' class='name expandable'>allowDepress</a><span> : Boolean</span></div><div class='description'><div class='short'>False to not allow a pressed Button to be depressed (defaults to undefined). ...</div><div class='long'><p>False to not allow a pressed Button to be depressed (defaults to undefined). Only valid when <a href=\"#!/api/Ext.Button-cfg-enableToggle\" rel=\"Ext.Button-cfg-enableToggle\" class=\"docClass\">enableToggle</a> is true.</p>\n</div></div></div><div id='cfg-allowDomMove' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-allowDomMove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-allowDomMove' class='name expandable'>allowDomMove</a><span> : Boolean</span></div><div class='description'><div class='short'>Whether the component can move the Dom node when rendering (defaults to true). ...</div><div class='long'><p>Whether the component can move the Dom node when rendering (defaults to true).</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-anchor' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-anchor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-anchor' class='name expandable'>anchor</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Note: this config is only used when this Component is rendered\nby a Container which has been configured to use an Anc...</div><div class='long'><p><b>Note</b>: this config is only used when this Component is rendered\nby a Container which has been configured to use an <b><a href=\"#!/api/Ext.layout.AnchorLayout\" rel=\"Ext.layout.AnchorLayout\" class=\"docClass\">AnchorLayout</a> (or subclass thereof).</b>\nbased layout manager, for example:<div class=\"mdetail-params\"><ul>\n<li><a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">Ext.form.FormPanel</a></li>\n<li>specifying <code>layout: 'anchor' // or 'form', or 'absolute'</code></li>\n</ul></div></p>\n\n\n<p>See <a href=\"#!/api/Ext.layout.AnchorLayout\" rel=\"Ext.layout.AnchorLayout\" class=\"docClass\">Ext.layout.AnchorLayout</a>.<a href=\"#!/api/Ext.layout.AnchorLayout-cfg-anchor\" rel=\"Ext.layout.AnchorLayout-cfg-anchor\" class=\"docClass\">anchor</a> also.</p>\n\n</div></div></div><div id='cfg-applyTo' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-applyTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-applyTo' class='name expandable'>applyTo</a><span> : Mixed</span></div><div class='description'><div class='short'>Specify the id of the element, a DOM element or an existing Element corresponding to a DIV\nthat is already present in...</div><div class='long'><p>Specify the id of the element, a DOM element or an existing Element corresponding to a DIV\nthat is already present in the document that specifies some structural markup for this\ncomponent.</p>\n\n\n<div><ul>\n<li><b>Description</b> : <ul>\n<div class=\"sub-desc\">When <tt>applyTo</tt> is used, constituent parts of the component can also be specified\nby id or CSS class name within the main element, and the component being created may attempt\nto create its subcomponents from that markup if applicable.</div>\n</ul></li>\n<li><b>Notes</b> : <ul>\n<div class=\"sub-desc\">When using this config, a call to render() is not required.</div>\n<div class=\"sub-desc\">If applyTo is specified, any value passed for <a href=\"#!/api/Ext.Component-cfg-renderTo\" rel=\"Ext.Component-cfg-renderTo\" class=\"docClass\">renderTo</a> will be ignored and the target\nelement's parent node will automatically be used as the component's container.</div>\n</ul></li>\n</ul></div>\n\n</div></div></div><div id='cfg-arrowAlign' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-arrowAlign' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-arrowAlign' class='name expandable'>arrowAlign</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>(Optional) The side of the Button box to render the arrow if the button has an associated menu. ...</div><div class='long'><p>(Optional) The side of the Button box to render the arrow if the button has an associated <a href=\"#!/api/Ext.Button-cfg-menu\" rel=\"Ext.Button-cfg-menu\" class=\"docClass\">menu</a>.\nTwo values are allowed:</p>\n\n\n<ul class=\"mdetail-params\">\n<li>'right'<div class=\"sub-desc\"></div></li>\n<li>'bottom'<div class=\"sub-desc\"></div></li>\n</ul>\n\n\n<p>Defaults to <b><tt>'right'</tt></b>.</p>\n\n<p>Defaults to: <code>'right'</code></p></div></div></div><div id='cfg-autoHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-autoHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-autoHeight' class='name expandable'>autoHeight</a><span> : Boolean</span></div><div class='description'><div class='short'>True to use height:'auto', false to use fixed height (or allow it to be managed by its parent\nContainer's layout mana...</div><div class='long'><p>True to use height:'auto', false to use fixed height (or allow it to be managed by its parent\nContainer's <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout manager</a>. Defaults to false.</p>\n\n\n<p><b>Note</b>: Although many components inherit this config option, not all will\nfunction as expected with a height of 'auto'. Setting autoHeight:true means that the\nbrowser will manage height based on the element's contents, and that Ext will not manage it at all.</p>\n\n\n<p>If the <i>browser</i> is managing the height, be aware that resizes performed by the browser in response\nto changes within the structure of the Component cannot be detected. Therefore changes to the height might\nresult in elements needing to be synchronized with the new height. Example:</p>\n\n\n<pre><code>var w = new <a href=\"#!/api/Ext.Window\" rel=\"Ext.Window\" class=\"docClass\">Ext.Window</a>({\n    title: 'Window',\n    width: 600,\n    autoHeight: true,\n    items: {\n        title: 'Collapse Me',\n        height: 400,\n        collapsible: true,\n        border: false,\n        listeners: {\n            beforecollapse: function() {\n                w.el.shadow.hide();\n            },\n            beforeexpand: function() {\n                w.el.shadow.hide();\n            },\n            collapse: function() {\n                w.syncShadow();\n            },\n            expand: function() {\n                w.syncShadow();\n            }\n        }\n    }\n}).show();\n</code></pre>\n\n</div></div></div><div id='cfg-autoScroll' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-autoScroll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-autoScroll' class='name expandable'>autoScroll</a><span> : Boolean</span></div><div class='description'><div class='short'>true to use overflow:'auto' on the components layout element and show scroll bars automatically when\nnecessary, false...</div><div class='long'><p><code>true</code> to use overflow:'auto' on the components layout element and show scroll bars automatically when\nnecessary, <code>false</code> to clip any overflowing content (defaults to <code>false</code>).</p>\n</div></div></div><div id='cfg-autoShow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-autoShow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-autoShow' class='name expandable'>autoShow</a><span> : Boolean</span></div><div class='description'><div class='short'>True if the component should check for hidden classes (e.g. ...</div><div class='long'><p>True if the component should check for hidden classes (e.g. 'x-hidden' or 'x-hide-display') and remove\nthem on render (defaults to false).</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-autoWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-autoWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-autoWidth' class='name expandable'>autoWidth</a><span> : Boolean</span></div><div class='description'><div class='short'>By default, if a width is not specified the button will attempt to stretch horizontally to fit its content. ...</div><div class='long'><p>By default, if a width is not specified the button will attempt to stretch horizontally to fit its content.\nIf the button is being managed by a width sizing layout (hbox, fit, anchor), set this to false to prevent\nthe button from doing this automatic sizing.\nDefaults to <tt>undefined</tt>.</p>\n<p>Overrides: <a href='#!/api/Ext.BoxComponent-cfg-autoWidth' rel='Ext.BoxComponent-cfg-autoWidth' class='docClass'>Ext.BoxComponent.autoWidth</a></p></div></div></div><div id='cfg-boxMaxHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-boxMaxHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-boxMaxHeight' class='name expandable'>boxMaxHeight</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The maximum value in pixels which this BoxComponent will set its height to. ...</div><div class='long'><p>The maximum value in pixels which this BoxComponent will set its height to.</p>\n\n\n<p><b>Warning:</b> This will override any size management applied by layout managers.</p>\n\n</div></div></div><div id='cfg-boxMaxWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-boxMaxWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-boxMaxWidth' class='name expandable'>boxMaxWidth</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The maximum value in pixels which this BoxComponent will set its width to. ...</div><div class='long'><p>The maximum value in pixels which this BoxComponent will set its width to.</p>\n\n\n<p><b>Warning:</b> This will override any size management applied by layout managers.</p>\n\n</div></div></div><div id='cfg-boxMinHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-boxMinHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-boxMinHeight' class='name expandable'>boxMinHeight</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The minimum value in pixels which this BoxComponent will set its height to. ...</div><div class='long'><p>The minimum value in pixels which this BoxComponent will set its height to.</p>\n\n\n<p><b>Warning:</b> This will override any size management applied by layout managers.</p>\n\n</div></div></div><div id='cfg-boxMinWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-boxMinWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-boxMinWidth' class='name expandable'>boxMinWidth</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The minimum value in pixels which this BoxComponent will set its width to. ...</div><div class='long'><p>The minimum value in pixels which this BoxComponent will set its width to.</p>\n\n\n<p><b>Warning:</b> This will override any size management applied by layout managers.</p>\n\n</div></div></div><div id='cfg-bubbleEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-bubbleEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-bubbleEvents' class='name expandable'>bubbleEvents</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An array of events that, when fired, should be bubbled to any parent container. ...</div><div class='long'><p>An array of events that, when fired, should be bubbled to any parent container.\nSee <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">Ext.util.Observable.enableBubble</a>.\nDefaults to <tt>[]</tt>.\n\n</p><p>Defaults to: <code>[]</code></p></div></div></div><div id='cfg-buttonSelector' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-buttonSelector' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-buttonSelector' class='name expandable'>buttonSelector</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>(Optional) A DomQuery selector which is used to extract the active, clickable element from the\nDOM structure created. ...</div><div class='long'><p>(Optional) A <a href=\"#!/api/Ext.DomQuery\" rel=\"Ext.DomQuery\" class=\"docClass\">DomQuery</a> selector which is used to extract the active, clickable element from the\nDOM structure created.</p>\n\n\n<p>When a custom <a href=\"#!/api/Ext.Button-property-template\" rel=\"Ext.Button-property-template\" class=\"docClass\">template</a> is used, you  must ensure that this selector results in the selection of\na focussable element.</p>\n\n\n<p>Defaults to <b><tt>'button:first-child'</tt></b>.</p>\n\n<p>Defaults to: <code>'button:first-child'</code></p></div></div></div><div id='cfg-clearCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-clearCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-clearCls' class='name expandable'>clearCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The CSS class used to to apply to the special clearing div rendered\ndirectly after each form field wrapper to provide...</div><div class='long'><p>The CSS class used to to apply to the special clearing div rendered\ndirectly after each form field wrapper to provide field clearing (defaults to\n<tt>'x-form-clear-left'</tt>).</p>\n\n\n<br><p><b>Note</b>: this config is only used when this Component is rendered by a Container\n\n\n<p>which has been configured to use the <b><a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">FormLayout</a></b> layout\nmanager (e.g. <a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">Ext.form.FormPanel</a> or specifying <tt>layout:'form'</tt>) and either a\n<tt><a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a></tt> is specified or <tt>isFormField=true</tt> is specified.</p><br></p>\n\n<p>See <a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a> also.</p>\n\n</div></div></div><div id='cfg-clickEvent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-clickEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-clickEvent' class='name expandable'>clickEvent</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The DOM event that will fire the handler of the button. ...</div><div class='long'><p>The DOM event that will fire the handler of the button. This can be any valid event name (dblclick, contextmenu).\nDefaults to <tt>'click'</tt>.</p>\n<p>Defaults to: <code>'click'</code></p></div></div></div><div id='cfg-cls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-cls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-cls' class='name not-expandable'>cls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>A CSS class string to apply to the button's main element.</p>\n</div><div class='long'><p>A CSS class string to apply to the button's main element.</p>\n<p>Overrides: <a href='#!/api/Ext.Component-cfg-cls' rel='Ext.Component-cfg-cls' class='docClass'>Ext.Component.cls</a></p></div></div></div><div id='cfg-ctCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-ctCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-ctCls' class='name expandable'>ctCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An optional extra CSS class that will be added to this component's container. ...</div><div class='long'><p>An optional extra CSS class that will be added to this component's container. This can be useful for\nadding customized styles to the container or any of its children using standard CSS rules.  See\n<a href=\"#!/api/Ext.layout.ContainerLayout\" rel=\"Ext.layout.ContainerLayout\" class=\"docClass\">Ext.layout.ContainerLayout</a>.<a href=\"#!/api/Ext.layout.ContainerLayout-cfg-extraCls\" rel=\"Ext.layout.ContainerLayout-cfg-extraCls\" class=\"docClass\">extraCls</a> also.</p>\n\n\n<p><b>Note</b>: <tt>ctCls</tt> defaults to <tt>''</tt> except for the following class\nwhich assigns a value by default:\n<div class=\"mdetail-params\"><ul>\n<li>Box Layout : <tt>'x-box-layout-ct'</tt></li>\n</ul></div>\nTo configure the above Class with an extra CSS class append to the default.  For example,\nfor BoxLayout (Hbox and Vbox):\n<pre><code>ctCls: 'x-box-layout-ct custom-class'\n</code></pre>\n</p>\n\n</div></div></div><div id='cfg-disabled' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-disabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-disabled' class='name not-expandable'>disabled</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True to start disabled (defaults to false)</p>\n</div><div class='long'><p>True to start disabled (defaults to false)</p>\n<p>Overrides: <a href='#!/api/Ext.Component-cfg-disabled' rel='Ext.Component-cfg-disabled' class='docClass'>Ext.Component.disabled</a></p></div></div></div><div id='cfg-disabledClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-disabledClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-disabledClass' class='name expandable'>disabledClass</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>CSS class added to the component when it is disabled (defaults to 'x-item-disabled'). ...</div><div class='long'><p>CSS class added to the component when it is disabled (defaults to 'x-item-disabled').</p>\n<p>Defaults to: <code>'x-item-disabled'</code></p></div></div></div><div id='cfg-enableToggle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-enableToggle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-enableToggle' class='name expandable'>enableToggle</a><span> : Boolean</span></div><div class='description'><div class='short'>True to enable pressed/not pressed toggling (defaults to false) ...</div><div class='long'><p>True to enable pressed/not pressed toggling (defaults to false)</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-fieldLabel' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-fieldLabel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-fieldLabel' class='name expandable'>fieldLabel</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The label text to display next to this Component (defaults to ''). ...</div><div class='long'><p>The label text to display next to this Component (defaults to '').</p>\n\n\n<br><p><b>Note</b>: this config is only used when this Component is rendered by a Container which\n\n\n<p>has been configured to use the <b><a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">FormLayout</a></b> layout manager (e.g.\n<a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">Ext.form.FormPanel</a> or specifying <tt>layout:'form'</tt>).</p><br></p>\n\n<p>Also see <tt><a href=\"#!/api/Ext.Component-cfg-hideLabel\" rel=\"Ext.Component-cfg-hideLabel\" class=\"docClass\">hideLabel</a></tt> and\n<a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a>.</p>\n\n\n<p>Example use:</p>\n\n<pre><code>new Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    items: [{\n        xtype: 'textfield',\n        fieldLabel: 'Name'\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-flex' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-flex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-flex' class='name expandable'>flex</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>Note: this config is only used when this Component is rendered\nby a Container which has been configured to use a BoxL...</div><div class='long'><p><b>Note</b>: this config is only used when this Component is rendered\nby a Container which has been configured to use a <b><a href=\"#!/api/Ext.layout.BoxLayout\" rel=\"Ext.layout.BoxLayout\" class=\"docClass\">BoxLayout</a>.</b>\nEach child Component with a <code>flex</code> property will be flexed either vertically (by a VBoxLayout)\nor horizontally (by an HBoxLayout) according to the item's <b>relative</b> <code>flex</code> value\ncompared to the sum of all Components with <code>flex</code> value specified. Any child items that have\neither a <code>flex = 0</code> or <code>flex = undefined</code> will not be 'flexed' (the initial size will not be changed).\n\n</p></div></div></div><div id='cfg-handleMouseEvents' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-handleMouseEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-handleMouseEvents' class='name expandable'>handleMouseEvents</a><span> : Boolean</span></div><div class='description'><div class='short'>False to disable visual cues on mouseover, mouseout and mousedown (defaults to true) ...</div><div class='long'><p>False to disable visual cues on mouseover, mouseout and mousedown (defaults to true)</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-handler' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-handler' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-handler' class='name expandable'>handler</a><span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'>A function called when the button is clicked (can be used instead of click event). ...</div><div class='long'><p>A function called when the button is clicked (can be used instead of click event).\nThe handler is passed the following parameters:<div class=\"mdetail-params\"><ul>\n<li><code>b</code> : Button<div class=\"sub-desc\">This Button.</div></li>\n<li><code>e</code> : EventObject<div class=\"sub-desc\">The click event.</div></li>\n</ul></div></p>\n</div></div></div><div id='cfg-height' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-height' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-height' class='name expandable'>height</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The height of this component in pixels (defaults to auto). ...</div><div class='long'><p>The height of this component in pixels (defaults to auto).\n<b>Note</b> to express this dimension as a percentage or offset see Ext.Component.anchor.</p>\n</div></div></div><div id='cfg-hidden' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-hidden' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-hidden' class='name not-expandable'>hidden</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True to start hidden (defaults to false)</p>\n</div><div class='long'><p>True to start hidden (defaults to false)</p>\n<p>Overrides: <a href='#!/api/Ext.Component-cfg-hidden' rel='Ext.Component-cfg-hidden' class='docClass'>Ext.Component.hidden</a></p></div></div></div><div id='cfg-hideLabel' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-hideLabel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-hideLabel' class='name expandable'>hideLabel</a><span> : Boolean</span></div><div class='description'><div class='short'>true to completely hide the label element\n(label and separator). ...</div><div class='long'><p><tt>true</tt> to completely hide the label element\n(<a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">label</a> and <a href=\"#!/api/Ext.Component-cfg-labelSeparator\" rel=\"Ext.Component-cfg-labelSeparator\" class=\"docClass\">separator</a>). Defaults to <tt>false</tt>.\nBy default, even if you do not specify a <tt><a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a></tt> the space will still be\nreserved so that the field will line up with other fields that do have labels.\nSetting this to <tt>true</tt> will cause the field to not reserve that space.</p>\n\n\n<br><p><b>Note</b>: see the note for <tt><a href=\"#!/api/Ext.Component-cfg-clearCls\" rel=\"Ext.Component-cfg-clearCls\" class=\"docClass\">clearCls</a></tt>.</p><br>\n\n\n<p>Example use:</p>\n\n<pre><code>new Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    items: [{\n        xtype: 'textfield'\n        hideLabel: true\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-hideMode' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-hideMode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-hideMode' class='name expandable'>hideMode</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>How this component should be hidden. ...</div><div class='long'><p>How this component should be hidden. Supported values are <tt>'visibility'</tt>\n(css visibility), <tt>'offsets'</tt> (negative offset position) and <tt>'display'</tt>\n(css display).</p>\n\n\n<br><p><b>Note</b>: the default of <tt>'display'</tt> is generally preferred\n\n\n<p>since items are automatically laid out when they are first shown (no sizing\nis done while hidden).</p></p>\n<p>Defaults to: <code>'display'</code></p></div></div></div><div id='cfg-hideParent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-hideParent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-hideParent' class='name expandable'>hideParent</a><span> : Boolean</span></div><div class='description'><div class='short'>True to hide and show the component's container when hide/show is called on the component, false to hide\nand show the...</div><div class='long'><p>True to hide and show the component's container when hide/show is called on the component, false to hide\nand show the component itself (defaults to false).  For example, this can be used as a shortcut for a hide\nbutton on a window by setting hide:true on the button when adding it to its parent container.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-icon' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-icon' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-icon' class='name expandable'>icon</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The path to an image to display in the button (the image will be set as the background-image\nCSS property of the butt...</div><div class='long'><p>The path to an image to display in the button (the image will be set as the background-image\nCSS property of the button by default, so if you want a mixed icon/text button, set cls:'x-btn-text-icon')</p>\n</div></div></div><div id='cfg-iconAlign' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-iconAlign' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-iconAlign' class='name expandable'>iconAlign</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>(Optional) The side of the Button box to render the icon. ...</div><div class='long'><p>(Optional) The side of the Button box to render the icon. Four values are allowed:</p>\n\n\n<ul class=\"mdetail-params\">\n<li>'top'<div class=\"sub-desc\"></div></li>\n<li>'right'<div class=\"sub-desc\"></div></li>\n<li>'bottom'<div class=\"sub-desc\"></div></li>\n<li>'left'<div class=\"sub-desc\"></div></li>\n</ul>\n\n\n<p>Defaults to <b><tt>'left'</tt></b>.</p>\n\n<p>Defaults to: <code>'left'</code></p></div></div></div><div id='cfg-iconCls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-iconCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-iconCls' class='name not-expandable'>iconCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>A css class which sets a background image to be used as the icon for this button</p>\n</div><div class='long'><p>A css class which sets a background image to be used as the icon for this button</p>\n</div></div></div><div id='cfg-id' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-id' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-id' class='name expandable'>id</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The unique id of this component (defaults to an auto-assigned id). ...</div><div class='long'><p>The <b>unique</b> id of this component (defaults to an <a href=\"#!/api/Ext.Component-method-getId\" rel=\"Ext.Component-method-getId\" class=\"docClass\">auto-assigned id</a>).\nYou should assign an id if you need to be able to access the component later and you do\nnot have an object reference available (e.g., using <a href=\"#!/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a>.<a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">getCmp</a>).</p>\n\n\n<p>Note that this id will also be used as the element id for the containing HTML element\nthat is rendered to the page for this component. This allows you to write id-based CSS\nrules to style the specific instance of this component uniquely, and also to select\nsub-elements using this component's id as the parent.</p>\n\n\n<p><b>Note</b>: to avoid complications imposed by a unique <tt>id</tt> also see\n<code><a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a></code> and <code><a href=\"#!/api/Ext.Component-cfg-ref\" rel=\"Ext.Component-cfg-ref\" class=\"docClass\">ref</a></code>.</p>\n\n\n<p><b>Note</b>: to access the container of an item see <code><a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a></code>.</p>\n\n</div></div></div><div id='cfg-itemCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-itemCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-itemCls' class='name expandable'>itemCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Note: this config is only used when this Component is rendered by a Container which\nhas been configured to use the Fo...</div><div class='long'><p><b>Note</b>: this config is only used when this Component is rendered by a Container which\nhas been configured to use the <b><a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">FormLayout</a></b> layout manager (e.g.\n<a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">Ext.form.FormPanel</a> or specifying <tt>layout:'form'</tt>).</p>\n\n\n<br>\n\n\n<p>An additional CSS class to apply to the div wrapping the form item\nelement of this field.  If supplied, <tt>itemCls</tt> at the <b>field</b> level will override\nthe default <tt>itemCls</tt> supplied at the <b>container</b> level. The value specified for\n<tt>itemCls</tt> will be added to the default class (<tt>'x-form-item'</tt>).</p>\n\n\n<p>Since it is applied to the item wrapper (see\n<a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a>), it allows\nyou to write standard CSS rules that can apply to the field, the label (if specified), or\nany other element within the markup for the field.</p>\n\n\n<br><p><b>Note</b>: see the note for <tt><a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a></tt>.</p><br>\n\n\n<p>Example use:</p>\n\n<pre><code>// Apply a style to the field&#39;s label:\n&lt;style>\n    .required .x-form-item-label {font-weight:bold;color:red;}\n&lt;/style>\n\nnew Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    items: [{\n        xtype: 'textfield',\n        fieldLabel: 'Name',\n        itemCls: 'required' //this label will be styled\n    },{\n        xtype: 'textfield',\n        fieldLabel: 'Favorite Color'\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-itemId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-itemId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-itemId' class='name expandable'>itemId</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An itemId can be used as an alternative way to get a reference to a component\nwhen no object reference is available. ...</div><div class='long'><p>An <tt>itemId</tt> can be used as an alternative way to get a reference to a component\nwhen no object reference is available.  Instead of using an <code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code> with\n<a href=\"#!/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a>.<a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">getCmp</a>, use <code>itemId</code> with\n<a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a>.<a href=\"#!/api/Ext.Container-method-getComponent\" rel=\"Ext.Container-method-getComponent\" class=\"docClass\">getComponent</a> which will retrieve\n<code>itemId</code>'s or <tt><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></tt>'s. Since <code>itemId</code>'s are an index to the\ncontainer's internal MixedCollection, the <code>itemId</code> is scoped locally to the container --\navoiding potential conflicts with <a href=\"#!/api/Ext.ComponentMgr\" rel=\"Ext.ComponentMgr\" class=\"docClass\">Ext.ComponentMgr</a> which requires a <b>unique</b>\n<code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code>.</p>\n\n\n<pre><code>var c = new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({ //\n    <a href=\"#!/api/Ext.BoxComponent-cfg-height\" rel=\"Ext.BoxComponent-cfg-height\" class=\"docClass\">height</a>: 300,\n    <a href=\"#!/api/Ext.Component-cfg-renderTo\" rel=\"Ext.Component-cfg-renderTo\" class=\"docClass\">renderTo</a>: document.body,\n    <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a>: 'auto',\n    <a href=\"#!/api/Ext.Container-property-items\" rel=\"Ext.Container-property-items\" class=\"docClass\">items</a>: [\n        {\n            itemId: 'p1',\n            <a href=\"#!/api/Ext.Panel-cfg-title\" rel=\"Ext.Panel-cfg-title\" class=\"docClass\">title</a>: 'Panel 1',\n            <a href=\"#!/api/Ext.BoxComponent-cfg-height\" rel=\"Ext.BoxComponent-cfg-height\" class=\"docClass\">height</a>: 150\n        },\n        {\n            itemId: 'p2',\n            <a href=\"#!/api/Ext.Panel-cfg-title\" rel=\"Ext.Panel-cfg-title\" class=\"docClass\">title</a>: 'Panel 2',\n            <a href=\"#!/api/Ext.BoxComponent-cfg-height\" rel=\"Ext.BoxComponent-cfg-height\" class=\"docClass\">height</a>: 150\n        }\n    ]\n})\np1 = c.<a href=\"#!/api/Ext.Container-method-getComponent\" rel=\"Ext.Container-method-getComponent\" class=\"docClass\">getComponent</a>('p1'); // not the same as <a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">Ext.getCmp()</a>\np2 = p1.<a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a>.<a href=\"#!/api/Ext.Container-method-getComponent\" rel=\"Ext.Container-method-getComponent\" class=\"docClass\">getComponent</a>('p2'); // reference via a sibling\n</code></pre>\n\n\n<p>Also see <tt><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></tt> and <code><a href=\"#!/api/Ext.Component-cfg-ref\" rel=\"Ext.Component-cfg-ref\" class=\"docClass\">ref</a></code>.</p>\n\n\n<p><b>Note</b>: to access the container of an item see <tt><a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a></tt>.</p>\n\n</div></div></div><div id='cfg-labelSeparator' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-labelSeparator' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-labelSeparator' class='name expandable'>labelSeparator</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The separator to display after the text of each\nfieldLabel. ...</div><div class='long'><p>The separator to display after the text of each\n<tt><a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a></tt>.  This property may be configured at various levels.\nThe order of precedence is:\n<div class=\"mdetail-params\"><ul>\n<li>field / component level</li>\n<li>container level</li>\n<li><a href=\"#!/api/Ext.layout.FormLayout-cfg-labelSeparator\" rel=\"Ext.layout.FormLayout-cfg-labelSeparator\" class=\"docClass\">layout level</a> (defaults to colon <tt>':'</tt>)</li>\n</ul></div>\nTo display no separator for this field's label specify empty string ''.</p>\n\n\n<br><p><b>Note</b>: see the note for <tt><a href=\"#!/api/Ext.Component-cfg-clearCls\" rel=\"Ext.Component-cfg-clearCls\" class=\"docClass\">clearCls</a></tt>.</p><br>\n\n\n<p>Also see <tt><a href=\"#!/api/Ext.Component-cfg-hideLabel\" rel=\"Ext.Component-cfg-hideLabel\" class=\"docClass\">hideLabel</a></tt> and\n<a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a>.</p>\n\n\n<p>Example use:</p>\n\n<pre><code>new Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    layoutConfig: {\n        labelSeparator: '~'   // layout config has lowest priority (defaults to ':')\n    },\n    <a href=\"#!/api/Ext.layout.FormLayout-cfg-labelSeparator\" rel=\"Ext.layout.FormLayout-cfg-labelSeparator\" class=\"docClass\">labelSeparator</a>: '>>',     // config at container level\n    items: [{\n        xtype: 'textfield',\n        fieldLabel: 'Field 1',\n        labelSeparator: '...' // field/component level config supersedes others\n    },{\n        xtype: 'textfield',\n        fieldLabel: 'Field 2' // labelSeparator will be '='\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-labelStyle' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-labelStyle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-labelStyle' class='name expandable'>labelStyle</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A CSS style specification string to apply directly to this field's\nlabel. ...</div><div class='long'><p>A CSS style specification string to apply directly to this field's\nlabel.  Defaults to the container's labelStyle value if set (e.g.,\n<tt><a href=\"#!/api/Ext.layout.FormLayout-property-labelStyle\" rel=\"Ext.layout.FormLayout-property-labelStyle\" class=\"docClass\">Ext.layout.FormLayout.labelStyle</a></tt> , or '').</p>\n\n\n<br><p><b>Note</b>: see the note for <code><a href=\"#!/api/Ext.Component-cfg-clearCls\" rel=\"Ext.Component-cfg-clearCls\" class=\"docClass\">clearCls</a></code>.</p><br>\n\n\n<p>Also see <code><a href=\"#!/api/Ext.Component-cfg-hideLabel\" rel=\"Ext.Component-cfg-hideLabel\" class=\"docClass\">hideLabel</a></code> and\n<code><a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a>.</code></p>\n\n\n<p>Example use:</p>\n\n<pre><code>new Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    items: [{\n        xtype: 'textfield',\n        fieldLabel: 'Name',\n        labelStyle: 'font-weight:bold;'\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-listeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-cfg-listeners' class='name expandable'>listeners</a><span> : Object</span></div><div class='description'><div class='short'>(optional) A config object containing one or more event handlers to be added to this\nobject during initialization. ...</div><div class='long'><p>(optional) <p>A config object containing one or more event handlers to be added to this\nobject during initialization.  This should be a valid listeners config object as specified in the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching multiple handlers at once.</p></p>\n\n<br><p><b><u>DOM events from ExtJs <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a></u></b></p>\n\n\n<br><p>While <i>some</i> ExtJs Component classes export selected DOM events (e.g. \"click\", \"mouseover\" etc), this\n\n\n<p>is usually only done when extra value can be added. For example the <a href=\"#!/api/Ext.DataView\" rel=\"Ext.DataView\" class=\"docClass\">DataView</a>'s\n<b><code><a href=\"#!/api/Ext.DataView-event-click\" rel=\"Ext.DataView-event-click\" class=\"docClass\">click</a></code></b> event passing the node clicked on. To access DOM\nevents directly from a Component's HTMLElement, listeners must be added to the <i><a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a></i> after the Component\nhas been rendered. A plugin can simplify this step:</p>\n\n<pre><code>// Plugin is configured with a listeners config object.\n// The Component is appended to the argument list of all handler functions.\nExt.DomObserver = <a href=\"#!/api/Ext-method-extend\" rel=\"Ext-method-extend\" class=\"docClass\">Ext.extend</a>(Object, {\n    constructor: function(config) {\n        this.listeners = config.listeners ? config.listeners : config;\n    },\n\n    // Component passes itself into plugin&#39;s init method\n    init: function(c) {\n        var p, l = this.listeners;\n        for (p in l) {\n            if (<a href=\"#!/api/Ext-method-isFunction\" rel=\"Ext-method-isFunction\" class=\"docClass\">Ext.isFunction</a>(l[p])) {\n                l[p] = this.createHandler(l[p], c);\n            } else {\n                l[p].fn = this.createHandler(l[p].fn, c);\n            }\n        }\n\n        // Add the listeners to the Element immediately following the render call\n        c.render = c.render.<a href=\"#!/api/Function-method-createSequence\" rel=\"Function-method-createSequence\" class=\"docClass\">createSequence</a>(function() {\n            var e = c.getEl();\n            if (e) {\n                e.on(l);\n            }\n        });\n    },\n\n    createHandler: function(fn, c) {\n        return function(e) {\n            fn.call(this, e, c);\n        };\n    }\n});\n\nvar combo = new <a href=\"#!/api/Ext.form.ComboBox\" rel=\"Ext.form.ComboBox\" class=\"docClass\">Ext.form.ComboBox</a>({\n\n    // Collapse combo when its element is clicked on\n    plugins: [ new Ext.DomObserver({\n        click: function(evt, comp) {\n            comp.collapse();\n        }\n    })],\n    store: myStore,\n    typeAhead: true,\n    mode: 'local',\n    triggerAction: 'all'\n});\n</code></pre>\n\n\n<p></p></p>\n</div></div></div><div id='cfg-margins' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-margins' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-margins' class='name expandable'>margins</a><span> : Object</span></div><div class='description'><div class='short'>Note: this config is only used when this BoxComponent is rendered\nby a Container which has been configured to use the...</div><div class='long'><p><b>Note</b>: this config is only used when this BoxComponent is rendered\nby a Container which has been configured to use the <b><a href=\"#!/api/Ext.layout.BorderLayout\" rel=\"Ext.layout.BorderLayout\" class=\"docClass\">BorderLayout</a></b>\nor one of the two <b><a href=\"#!/api/Ext.layout.BoxLayout\" rel=\"Ext.layout.BoxLayout\" class=\"docClass\">BoxLayout</a> subclasses.</b></p>\n\n\n<p>An object containing margins to apply to this BoxComponent in the\nformat:</p>\n\n\n<pre><code>{\n    top: (top margin),\n    right: (right margin),\n    bottom: (bottom margin),\n    left: (left margin)\n}</code></pre>\n\n\n<p>May also be a string containing space-separated, numeric margin values. The order of the\nsides associated with each value matches the way CSS processes margin values:</p>\n\n\n<p><div class=\"mdetail-params\"><ul>\n<li>If there is only one value, it applies to all sides.</li>\n<li>If there are two values, the top and bottom borders are set to the first value and the\nright and left are set to the second.</li>\n<li>If there are three values, the top is set to the first value, the left and right are set\nto the second, and the bottom is set to the third.</li>\n<li>If there are four values, they apply to the top, right, bottom, and left, respectively.</li>\n</ul></div></p>\n\n\n<p>Defaults to:</p>\n\n\n<pre><code>{top:0, right:0, bottom:0, left:0}\n</code></pre>\n\n</div></div></div><div id='cfg-menu' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-menu' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-menu' class='name expandable'>menu</a><span> : Mixed</span></div><div class='description'><div class='short'>Standard menu attribute consisting of a reference to a menu object, a menu id or a menu config blob (defaults to unde...</div><div class='long'><p>Standard menu attribute consisting of a reference to a menu object, a menu id or a menu config blob (defaults to undefined).</p>\n</div></div></div><div id='cfg-menuAlign' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-menuAlign' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-menuAlign' class='name expandable'>menuAlign</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The position to align the menu to (see Ext.Element.alignTo for more details, defaults to 'tl-bl?'). ...</div><div class='long'><p>The position to align the menu to (see <a href=\"#!/api/Ext.Element-method-alignTo\" rel=\"Ext.Element-method-alignTo\" class=\"docClass\">Ext.Element.alignTo</a> for more details, defaults to 'tl-bl?').</p>\n<p>Defaults to: <code>'tl-bl?'</code></p></div></div></div><div id='cfg-minWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-minWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-minWidth' class='name expandable'>minWidth</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The minimum width for this button (used to give a set of buttons a common width). ...</div><div class='long'><p>The minimum width for this button (used to give a set of buttons a common width).\nSee also <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>.<tt><a href=\"#!/api/Ext.Panel-cfg-minButtonWidth\" rel=\"Ext.Panel-cfg-minButtonWidth\" class=\"docClass\">minButtonWidth</a></tt>.</p>\n</div></div></div><div id='cfg-overCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-overCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-overCls' class='name expandable'>overCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An optional extra CSS class that will be added to this component's Element when the mouse moves\nover the Element, and...</div><div class='long'><p>An optional extra CSS class that will be added to this component's Element when the mouse moves\nover the Element, and removed when the mouse moves out. (defaults to '').  This can be\nuseful for adding customized 'active' or 'hover' styles to the component or any of its children using standard CSS rules.</p>\n</div></div></div><div id='cfg-overflowText' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-overflowText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-overflowText' class='name expandable'>overflowText</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>If used in a Toolbar, the\ntext to be used if this item is shown in the overflow menu. ...</div><div class='long'><p>If used in a <a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Toolbar</a>, the\ntext to be used if this item is shown in the overflow menu. See also\n<a href=\"#!/api/Ext.Toolbar.Item\" rel=\"Ext.Toolbar.Item\" class=\"docClass\">Ext.Toolbar.Item</a>.<code><a href=\"#!/api/Ext.Toolbar.Item-cfg-overflowText\" rel=\"Ext.Toolbar.Item-cfg-overflowText\" class=\"docClass\">overflowText</a></code>.</p>\n</div></div></div><div id='cfg-pageX' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-pageX' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-pageX' class='name not-expandable'>pageX</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The page level x coordinate for this component if contained within a positioning container.</p>\n</div><div class='long'><p>The page level x coordinate for this component if contained within a positioning container.</p>\n</div></div></div><div id='cfg-pageY' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-pageY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-pageY' class='name not-expandable'>pageY</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The page level y coordinate for this component if contained within a positioning container.</p>\n</div><div class='long'><p>The page level y coordinate for this component if contained within a positioning container.</p>\n</div></div></div><div id='cfg-plugins' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-plugins' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-plugins' class='name expandable'>plugins</a><span> : Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An object or array of objects that will provide custom functionality for this component. ...</div><div class='long'><p>An object or array of objects that will provide custom functionality for this component.  The only\nrequirement for a valid plugin is that it contain an init method that accepts a reference of type <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.\nWhen a component is created, if any plugins are available, the component will call the init method on each\nplugin, passing a reference to itself.  Each plugin can then call methods or respond to events on the\ncomponent as needed to provide its functionality.</p>\n</div></div></div><div id='cfg-pressed' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-pressed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-pressed' class='name not-expandable'>pressed</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True to start pressed (only if enableToggle = true)</p>\n</div><div class='long'><p>True to start pressed (only if enableToggle = true)</p>\n</div></div></div><div id='cfg-ptype' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-ptype' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-ptype' class='name expandable'>ptype</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The registered ptype to create. ...</div><div class='long'><p>The registered <tt>ptype</tt> to create. This config option is not used when passing\na config object into a constructor. This config option is used only when\nlazy instantiation is being used, and a Plugin is being\nspecified not as a fully instantiated Component, but as a <i>Component config\nobject</i>. The <tt>ptype</tt> will be looked up at render time up to determine what\ntype of Plugin to create.<br><br>\nIf you create your own Plugins, you may register them using\n<a href=\"#!/api/Ext.ComponentMgr-method-registerPlugin\" rel=\"Ext.ComponentMgr-method-registerPlugin\" class=\"docClass\">Ext.ComponentMgr.registerPlugin</a> in order to be able to\ntake advantage of lazy instantiation and rendering.</p>\n</div></div></div><div id='cfg-ref' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-ref' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-ref' class='name expandable'>ref</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A path specification, relative to the Component's ownerCt\nspecifying into which ancestor Container to place a named r...</div><div class='long'><p>A path specification, relative to the Component's <code><a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a></code>\nspecifying into which ancestor Container to place a named reference to this Component.</p>\n\n\n<p>The ancestor axis can be traversed by using '/' characters in the path.\nFor example, to put a reference to a Toolbar Button into <i>the Panel which owns the Toolbar</i>:</p>\n\n\n<pre><code>var myGrid = new <a href=\"#!/api/Ext.grid.EditorGridPanel\" rel=\"Ext.grid.EditorGridPanel\" class=\"docClass\">Ext.grid.EditorGridPanel</a>({\n    title: 'My EditorGridPanel',\n    store: myStore,\n    colModel: myColModel,\n    tbar: [{\n        text: 'Save',\n        handler: saveChanges,\n        disabled: true,\n        ref: '../saveButton'\n    }],\n    listeners: {\n        afteredit: function() {\n//          The button reference is in the GridPanel\n            myGrid.saveButton.enable();\n        }\n    }\n});\n</code></pre>\n\n\n<p>In the code above, if the <code>ref</code> had been <code>'saveButton'</code>\nthe reference would have been placed into the Toolbar. Each '/' in the <code>ref</code>\nmoves up one level from the Component's <code><a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a></code>.</p>\n\n\n<p>Also see the <code><a href=\"#!/api/Ext.Component-event-added\" rel=\"Ext.Component-event-added\" class=\"docClass\">added</a></code> and <code><a href=\"#!/api/Ext.Component-event-removed\" rel=\"Ext.Component-event-removed\" class=\"docClass\">removed</a></code> events.</p>\n\n</div></div></div><div id='cfg-region' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-region' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-region' class='name expandable'>region</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Note: this config is only used when this BoxComponent is rendered\nby a Container which has been configured to use the...</div><div class='long'><p><b>Note</b>: this config is only used when this BoxComponent is rendered\nby a Container which has been configured to use the <b><a href=\"#!/api/Ext.layout.BorderLayout\" rel=\"Ext.layout.BorderLayout\" class=\"docClass\">BorderLayout</a></b>\nlayout manager (e.g. specifying <tt>layout:'border'</tt>).</p>\n\n\n<br>\n\n\n<p>See <a href=\"#!/api/Ext.layout.BorderLayout\" rel=\"Ext.layout.BorderLayout\" class=\"docClass\">Ext.layout.BorderLayout</a> also.</p>\n\n</div></div></div><div id='cfg-renderTo' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-renderTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-renderTo' class='name expandable'>renderTo</a><span> : Mixed</span></div><div class='description'><div class='short'>Specify the id of the element, a DOM element or an existing Element that this component\nwill be rendered into. ...</div><div class='long'><p>Specify the id of the element, a DOM element or an existing Element that this component\nwill be rendered into.</p>\n\n\n<div><ul>\n<li><b>Notes</b> : <ul>\n<div class=\"sub-desc\">Do <u>not</u> use this option if the Component is to be a child item of\na <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Container</a>. It is the responsibility of the\n<a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Container</a>'s <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout manager</a>\nto render and manage its child items.</div>\n<div class=\"sub-desc\">When using this config, a call to render() is not required.</div>\n</ul></li>\n</ul></div>\n\n\n<p>See <tt><a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">render</a></tt> also.</p>\n\n</div></div></div><div id='cfg-repeat' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-repeat' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-repeat' class='name expandable'>repeat</a><span> : Boolean/Object</span></div><div class='description'><div class='short'>True to repeat fire the click event while the mouse is down. ...</div><div class='long'><p>True to repeat fire the click event while the mouse is down. This can also be\na <a href=\"#!/api/Ext.util.ClickRepeater\" rel=\"Ext.util.ClickRepeater\" class=\"docClass\">ClickRepeater</a> config object (defaults to false).</p>\n</div></div></div><div id='cfg-scale' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-scale' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-scale' class='name expandable'>scale</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>(Optional) The size of the Button. ...</div><div class='long'><p>(Optional) The size of the Button. Three values are allowed:</p>\n\n\n<ul class=\"mdetail-params\">\n<li>'small'<div class=\"sub-desc\">Results in the button element being 16px high.</div></li>\n<li>'medium'<div class=\"sub-desc\">Results in the button element being 24px high.</div></li>\n<li>'large'<div class=\"sub-desc\">Results in the button element being 32px high.</div></li>\n</ul>\n\n\n<p>Defaults to <b><tt>'small'</tt></b>.</p>\n\n<p>Defaults to: <code>'small'</code></p></div></div></div><div id='cfg-scope' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-scope' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-scope' class='name expandable'>scope</a><span> : Object</span></div><div class='description'><div class='short'>The scope (this reference) in which the\nhandler and toggleHandler is\nexecuted. ...</div><div class='long'><p>The scope (<tt><b>this</b></tt> reference) in which the\n<code><a href=\"#!/api/Ext.Button-cfg-handler\" rel=\"Ext.Button-cfg-handler\" class=\"docClass\">handler</a></code> and <code><a href=\"#!/api/Ext.Button-cfg-toggleHandler\" rel=\"Ext.Button-cfg-toggleHandler\" class=\"docClass\">toggleHandler</a></code> is\nexecuted. Defaults to this Button.</p>\n</div></div></div><div id='cfg-stateEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-stateEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-stateEvents' class='name expandable'>stateEvents</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An array of events that, when fired, should trigger this component to\nsave its state (defaults to none). ...</div><div class='long'><p>An array of events that, when fired, should trigger this component to\nsave its state (defaults to none). <code>stateEvents</code> may be any type\nof event supported by this component, including browser or custom events\n(e.g., <tt>['click', 'customerchange']</tt>).</p>\n\n\n<p>See <code><a href=\"#!/api/Ext.Component-cfg-stateful\" rel=\"Ext.Component-cfg-stateful\" class=\"docClass\">stateful</a></code> for an explanation of saving and\nrestoring Component state.</p>\n\n</div></div></div><div id='cfg-stateId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-stateId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-stateId' class='name expandable'>stateId</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The unique id for this component to use for state management purposes\n(defaults to the component id if one was set, o...</div><div class='long'><p>The unique id for this component to use for state management purposes\n(defaults to the component id if one was set, otherwise null if the\ncomponent is using a generated id).</p>\n\n<p>See <code><a href=\"#!/api/Ext.Component-cfg-stateful\" rel=\"Ext.Component-cfg-stateful\" class=\"docClass\">stateful</a></code> for an explanation of saving and\nrestoring Component state.</p>\n\n</div></div></div><div id='cfg-stateful' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-stateful' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-stateful' class='name expandable'>stateful</a><span> : Boolean</span></div><div class='description'><div class='short'>A flag which causes the Component to attempt to restore the state of\ninternal properties from a saved state on startup. ...</div><div class='long'><p>A flag which causes the Component to attempt to restore the state of\ninternal properties from a saved state on startup. The component must have\neither a <code><a href=\"#!/api/Ext.Component-cfg-stateId\" rel=\"Ext.Component-cfg-stateId\" class=\"docClass\">stateId</a></code> or <code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code> assigned\nfor state to be managed. Auto-generated ids are not guaranteed to be stable\nacross page loads and cannot be relied upon to save and restore the same\nstate for a component.<p>\n<p>For state saving to work, the state manager's provider must have been\nset to an implementation of <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> which overrides the\n<a href=\"#!/api/Ext.state.Provider-method-set\" rel=\"Ext.state.Provider-method-set\" class=\"docClass\">set</a> and <a href=\"#!/api/Ext.state.Provider-method-get\" rel=\"Ext.state.Provider-method-get\" class=\"docClass\">get</a>\nmethods to save and recall name/value pairs. A built-in implementation,\n<a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a> is available.</p>\n<p>To set the state provider for the current page:</p>\n<pre><code><a href=\"#!/api/Ext.state.Manager-method-setProvider\" rel=\"Ext.state.Manager-method-setProvider\" class=\"docClass\">Ext.state.Manager.setProvider</a>(new <a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a>({\n    expires: new Date(new Date().getTime()+(1000*60*60*24*7)), //7 days from now\n}));\n</code></pre>\n<p>A stateful Component attempts to save state when one of the events\nlisted in the <code><a href=\"#!/api/Ext.Component-cfg-stateEvents\" rel=\"Ext.Component-cfg-stateEvents\" class=\"docClass\">stateEvents</a></code> configuration fires.</p>\n<p>To save state, a stateful Component first serializes its state by\ncalling <b><code>getState</code></b>. By default, this function does\nnothing. The developer must provide an implementation which returns an\nobject hash which represents the Component's restorable state.</p>\n<p>The value yielded by getState is passed to <a href=\"#!/api/Ext.state.Manager-method-set\" rel=\"Ext.state.Manager-method-set\" class=\"docClass\">Ext.state.Manager.set</a>\nwhich uses the configured <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> to save the object\nkeyed by the Component's <code>stateId</code>, or, if that is not\nspecified, its <code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code>.</p>\n<p>During construction, a stateful Component attempts to <i>restore</i>\nits state by calling <a href=\"#!/api/Ext.state.Manager-method-get\" rel=\"Ext.state.Manager-method-get\" class=\"docClass\">Ext.state.Manager.get</a> passing the\n<code><a href=\"#!/api/Ext.Component-cfg-stateId\" rel=\"Ext.Component-cfg-stateId\" class=\"docClass\">stateId</a></code>, or, if that is not specified, the\n<code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code>.</p>\n<p>The resulting object is passed to <b><code>applyState</code></b>.\nThe default implementation of <code>applyState</code> simply copies\nproperties into the object, but a developer may override this to support\nmore behaviour.</p>\n<p>You can perform extra processing on state save and restore by attaching\nhandlers to the <a href=\"#!/api/Ext.Component-event-beforestaterestore\" rel=\"Ext.Component-event-beforestaterestore\" class=\"docClass\">beforestaterestore</a>, <a href=\"#!/api/Ext.Component-event-staterestore\" rel=\"Ext.Component-event-staterestore\" class=\"docClass\">staterestore</a>,\n<a href=\"#!/api/Ext.Component-event-beforestatesave\" rel=\"Ext.Component-event-beforestatesave\" class=\"docClass\">beforestatesave</a> and <a href=\"#!/api/Ext.Component-event-statesave\" rel=\"Ext.Component-event-statesave\" class=\"docClass\">statesave</a> events.</p>\n\n</p></p></div></div></div><div id='cfg-style' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-style' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-style' class='name expandable'>style</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A custom style specification to be applied to this component's Element. ...</div><div class='long'><p>A custom style specification to be applied to this component's Element.  Should be a valid argument to\n<a href=\"#!/api/Ext.Element-method-applyStyles\" rel=\"Ext.Element-method-applyStyles\" class=\"docClass\">Ext.Element.applyStyles</a>.</p>\n\n<pre><code>new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({\n    title: 'Some Title',\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    width: 400, height: 300,\n    layout: 'form',\n    items: [{\n        xtype: 'textarea',\n        style: {\n            width: '95%',\n            marginBottom: '10px'\n        }\n    },\n        new <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a>({\n            text: 'Send',\n            minWidth: '100',\n            style: {\n                marginBottom: '10px'\n            }\n        })\n    ]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-tabIndex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-tabIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-tabIndex' class='name not-expandable'>tabIndex</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Set a DOM tabIndex for this button (defaults to undefined)</p>\n</div><div class='long'><p>Set a DOM tabIndex for this button (defaults to undefined)</p>\n</div></div></div><div id='cfg-tabTip' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-tabTip' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-tabTip' class='name expandable'>tabTip</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Note: this config is only used when this BoxComponent is a child item of a TabPanel. ...</div><div class='long'><p><b>Note</b>: this config is only used when this BoxComponent is a child item of a TabPanel.</p>\n\n\n<p>A string to be used as innerHTML (html tags are accepted) to show in a tooltip when mousing over\nthe associated tab selector element. <a href=\"#!/api/Ext.QuickTips\" rel=\"Ext.QuickTips\" class=\"docClass\">Ext.QuickTips</a>.init()\nmust be called in order for the tips to render.</p>\n</div></div></div><div id='cfg-text' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-text' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-text' class='name not-expandable'>text</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>The button text to be used as innerHTML (html tags are accepted)</p>\n</div><div class='long'><p>The button text to be used as innerHTML (html tags are accepted)</p>\n</div></div></div><div id='cfg-toggleGroup' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-toggleGroup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-toggleGroup' class='name not-expandable'>toggleGroup</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>The group this toggle button is a member of (only 1 per group can be pressed)</p>\n</div><div class='long'><p>The group this toggle button is a member of (only 1 per group can be pressed)</p>\n</div></div></div><div id='cfg-toggleHandler' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-toggleHandler' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-toggleHandler' class='name expandable'>toggleHandler</a><span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'>Function called when a Button with enableToggle set to true is clicked. ...</div><div class='long'><p>Function called when a Button with <a href=\"#!/api/Ext.Button-cfg-enableToggle\" rel=\"Ext.Button-cfg-enableToggle\" class=\"docClass\">enableToggle</a> set to true is clicked. Two arguments are passed:<ul class=\"mdetail-params\">\n<li><b>button</b> : <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a><div class=\"sub-desc\">this Button object</div></li>\n<li><b>state</b> : Boolean<div class=\"sub-desc\">The next state of the Button, true means pressed.</div></li>\n</ul></p>\n</div></div></div><div id='cfg-tooltip' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-tooltip' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-tooltip' class='name not-expandable'>tooltip</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object</span></div><div class='description'><div class='short'><p>The tooltip for the button - can be a string to be used as innerHTML (html tags are accepted) or QuickTips config object</p>\n</div><div class='long'><p>The tooltip for the button - can be a string to be used as innerHTML (html tags are accepted) or QuickTips config object</p>\n</div></div></div><div id='cfg-tooltipType' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-tooltipType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-tooltipType' class='name expandable'>tooltipType</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The type of tooltip to use. ...</div><div class='long'><p>The type of tooltip to use. Either 'qtip' (default) for QuickTips or 'title' for title attribute.</p>\n<p>Defaults to: <code>'qtip'</code></p></div></div></div><div id='cfg-type' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-cfg-type' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-cfg-type' class='name expandable'>type</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>submit, reset or button - defaults to 'button' ...</div><div class='long'><p>submit, reset or button - defaults to 'button'</p>\n<p>Defaults to: <code>'button'</code></p></div></div></div><div id='cfg-width' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-width' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-width' class='name expandable'>width</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The width of this component in pixels (defaults to auto). ...</div><div class='long'><p>The width of this component in pixels (defaults to auto).\n<b>Note</b> to express this dimension as a percentage or offset see Ext.Component.anchor.</p>\n</div></div></div><div id='cfg-x' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-x' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-x' class='name not-expandable'>x</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The local x (left) coordinate for this component if contained within a positioning container.</p>\n</div><div class='long'><p>The local x (left) coordinate for this component if contained within a positioning container.</p>\n</div></div></div><div id='cfg-xtype' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-xtype' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-xtype' class='name expandable'>xtype</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The registered xtype to create. ...</div><div class='long'><p>The registered <tt>xtype</tt> to create. This config option is not used when passing\na config object into a constructor. This config option is used only when\nlazy instantiation is being used, and a child item of a Container is being\nspecified not as a fully instantiated Component, but as a <i>Component config\nobject</i>. The <tt>xtype</tt> will be looked up at render time up to determine what\ntype of child Component to create.<br><br>\nThe predefined xtypes are listed <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">here</a>.</p>\n\n<br><br>\n\n\n<p>If you subclass Components to create your own Components, you may register\nthem using <a href=\"#!/api/Ext.ComponentMgr-method-registerType\" rel=\"Ext.ComponentMgr-method-registerType\" class=\"docClass\">Ext.ComponentMgr.registerType</a> in order to be able to\ntake advantage of lazy instantiation and rendering.</p>\n</div></div></div><div id='cfg-y' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-y' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-y' class='name not-expandable'>y</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The local y (top) coordinate for this component if contained within a positioning container.</p>\n</div><div class='long'><p>The local y (top) coordinate for this component if contained within a positioning container.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-boxReady' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-property-boxReady' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-property-boxReady' class='name expandable'>boxReady</a><span> : Boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private, set in afterRender to signify that the component has been rendered ...</div><div class='long'><p>private, set in afterRender to signify that the component has been rendered</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-btnEl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-property-btnEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-property-btnEl' class='name expandable'>btnEl</a><span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span></div><div class='description'><div class='short'>An Element encapsulating the Button's clickable element. ...</div><div class='long'><p>An <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Element</a> encapsulating the Button's clickable element. By default,\nthis references a <tt>&lt;button&gt;</tt> element. Read only.</p>\n</div></div></div><div id='property-deferHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-property-deferHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-property-deferHeight' class='name expandable'>deferHeight</a><span> : Boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private, used to defer height settings to subclasses ...</div><div class='long'><p>private, used to defer height settings to subclasses</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-disabled' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-property-disabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-property-disabled' class='name expandable'>disabled</a><span> : Boolean</span></div><div class='description'><div class='short'>Read-only. ...</div><div class='long'><p>Read-only. True if this button is disabled</p>\n<p>Defaults to: <code>false</code></p><p>Overrides: <a href='#!/api/Ext.Component-property-disabled' rel='Ext.Component-property-disabled' class='docClass'>Ext.Component.disabled</a></p></div></div></div><div id='property-el' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-el' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-el' class='name expandable'>el</a><span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span></div><div class='description'><div class='short'>The Ext.Element which encapsulates this Component. ...</div><div class='long'><p>The <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> which encapsulates this Component. Read-only.</p>\n\n\n<p>This will <i>usually</i> be a &lt;DIV> element created by the class's onRender method, but\nthat may be overridden using the <code><a href=\"#!/api/Ext.Component-cfg-autoEl\" rel=\"Ext.Component-cfg-autoEl\" class=\"docClass\">autoEl</a></code> config.</p>\n\n\n<br><p><b>Note</b>: this element will not be available until this Component has been rendered.</p><br>\n\n\n<p>To add listeners for <b>DOM events</b> to this Component (as opposed to listeners\nfor this Component's own Observable events), see the <a href=\"#!/api/Ext.util.Observable-cfg-listeners\" rel=\"Ext.util.Observable-cfg-listeners\" class=\"docClass\">listeners</a>\nconfig for a suggestion, or use a render listener directly:</p>\n\n\n<pre><code>new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({\n    title: 'The Clickable Panel',\n    listeners: {\n        render: function(p) {\n            // Append the Panel to the click handler&#39;s argument list.\n            p.getEl().on('click', handlePanelClick.createDelegate(null, [p], true));\n        },\n        single: true  // Remove the listener after first invocation\n    }\n});\n</code></pre>\n\n\n<p>See also <tt><a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">getEl</a></tt></p>\n\n</div></div></div><div id='property-hidden' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-property-hidden' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-property-hidden' class='name expandable'>hidden</a><span> : Boolean</span></div><div class='description'><div class='short'>Read-only. ...</div><div class='long'><p>Read-only. True if this button is hidden</p>\n<p>Defaults to: <code>false</code></p><p>Overrides: <a href='#!/api/Ext.Component-property-hidden' rel='Ext.Component-property-hidden' class='docClass'>Ext.Component.hidden</a></p></div></div></div><div id='property-initialConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-initialConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-initialConfig' class='name expandable'>initialConfig</a><span> : Object</span></div><div class='description'><div class='short'>This Component's initial configuration specification. ...</div><div class='long'><p>This Component's initial configuration specification. Read-only.</p>\n</div></div></div><div id='property-menu' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-property-menu' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-property-menu' class='name not-expandable'>menu</a><span> : Menu</span></div><div class='description'><div class='short'><p>The <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Menu</a> object associated with this Button when configured with the <a href=\"#!/api/Ext.Button-cfg-menu\" rel=\"Ext.Button-cfg-menu\" class=\"docClass\">menu</a> config option.</p>\n</div><div class='long'><p>The <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Menu</a> object associated with this Button when configured with the <a href=\"#!/api/Ext.Button-cfg-menu\" rel=\"Ext.Button-cfg-menu\" class=\"docClass\">menu</a> config option.</p>\n</div></div></div><div id='property-menuClassTarget' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-property-menuClassTarget' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-property-menuClassTarget' class='name expandable'>menuClassTarget</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Defaults to: <code>'tr:nth(2)'</code></p></div></div></div><div id='property-ownerCt' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-ownerCt' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-ownerCt' class='name expandable'>ownerCt</a><span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span></div><div class='description'><div class='short'>This Component's owner Container (defaults to undefined, and is set automatically when\nthis Component is added to a C...</div><div class='long'><p>This Component's owner <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Container</a> (defaults to undefined, and is set automatically when\nthis Component is added to a Container).  Read-only.</p>\n\n<p><b>Note</b>: to access items within the Container see <tt><a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a></tt>.</p>\n\n</div></div></div><div id='property-pressed' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-property-pressed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-property-pressed' class='name expandable'>pressed</a><span> : Boolean</span></div><div class='description'><div class='short'>Read-only. ...</div><div class='long'><p>Read-only. True if this button is pressed (only if enableToggle = true)</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-refOwner' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-refOwner' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-refOwner' class='name expandable'>refOwner</a><span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span></div><div class='description'><div class='short'>The ancestor Container into which the ref reference was inserted if this Component\nis a child of a Container, and has...</div><div class='long'><p>The ancestor Container into which the <a href=\"#!/api/Ext.Component-cfg-ref\" rel=\"Ext.Component-cfg-ref\" class=\"docClass\">ref</a> reference was inserted if this Component\nis a child of a Container, and has been configured with a <code>ref</code>.</p>\n</div></div></div><div id='property-rendered' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-rendered' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-rendered' class='name expandable'>rendered</a><span> : Boolean</span></div><div class='description'><div class='short'>True if this component has been rendered. ...</div><div class='long'><p>True if this component has been rendered. Read-only.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-template' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-property-template' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-property-template' class='name expandable'>template</a><span> : <a href=\"#!/api/Ext.Template\" rel=\"Ext.Template\" class=\"docClass\">Ext.Template</a></span></div><div class='description'><div class='short'>(Optional)\n\nA Template used to create the Button's DOM structure. ...</div><div class='long'><p>(Optional)</p>\n\n<p>A <a href=\"#!/api/Ext.Template\" rel=\"Ext.Template\" class=\"docClass\">Template</a> used to create the Button's DOM structure.</p>\n\n\n<p>Instances, or subclasses which need a different DOM structure may provide a different\ntemplate layout in conjunction with an implementation of <a href=\"#!/api/Ext.Button-method-getTemplateArgs\" rel=\"Ext.Button-method-getTemplateArgs\" class=\"docClass\">getTemplateArgs</a>.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.Button-method-constructor' class='name expandable'>Ext.Button</a>( <span class='pre'>config</span> ) : <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a></div><div class='description'><div class='short'>Create a new button ...</div><div class='long'><p>Create a new button</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>The config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a></span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.BoxComponent-method-constructor' rel='Ext.BoxComponent-method-constructor' class='docClass'>Ext.BoxComponent.constructor</a></p></div></div></div><div id='method-addClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-addClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-addClass' class='name expandable'>addClass</a>( <span class='pre'>cls</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Adds a CSS class to the component's underlying element. ...</div><div class='long'><p>Adds a CSS class to the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cls</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>The CSS class name to add</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-addEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addEvents' class='name expandable'>addEvents</a>( <span class='pre'>o, Optional</span> )</div><div class='description'><div class='short'>Adds the specified events to the list of events which this Observable may fire. ...</div><div class='long'><p>Adds the specified events to the list of events which this Observable may fire.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either an object with event names as properties with a value of <code>true</code>\nor the first event name string if multiple event names are being passed as separate parameters.</p>\n</div></li><li><span class='pre'>Optional</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>. Event name if multiple event names are being passed as separate parameters.\nUsage:</p>\n\n<pre><code>this.addEvents('storeloaded', 'storecleared');\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-addListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addListener' class='name expandable'>addListener</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object. ...</div><div class='long'><p>Appends an event handler to this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to listen for.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.\nproperties. This may contain any of the following properties:<ul>\n<li><b>scope</b> : Object<div class=\"sub-desc\">The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></div></li>\n<li><b>delay</b> : Number<div class=\"sub-desc\">The number of milliseconds to delay the invocation of the handler after the event fires.</div></li>\n<li><b>single</b> : Boolean<div class=\"sub-desc\">True to add a handler to handle just the next firing of the event, and then remove itself.</div></li>\n<li><b>buffer</b> : Number<div class=\"sub-desc\">Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed\nby the specified number of milliseconds. If the event fires again within that time, the original\nhandler is <em>not</em> invoked, but the new handler is scheduled in its place.</div></li>\n<li><b>target</b> : Observable<div class=\"sub-desc\">Only call the handler if the event was fired on the target Observable, <i>not</i>\nif the event was bubbled up from a child Observable.</div></li>\n</ul><br></p>\n\n<p>\n<b>Combining Options</b><br>\nUsing the options argument, it is possible to combine different types of listeners:<br>\n<br>\nA delayed, one-time listener.\n<pre><code>myDataView.on('click', this.onClick, this, {\nsingle: true,\ndelay: 100\n});</code></pre>\n<p>\n<b>Attaching multiple handlers in 1 call</b><br>\nThe method also allows for a single argument to be passed which is a config object containing properties\nwhich specify multiple handlers.\n<p>\n<pre><code>myGridPanel.on({\n'click' : {\n    fn: this.onClick,\n    scope: this,\n    delay: 100\n},\n'mouseover' : {\n    fn: this.onMouseOver,\n    scope: this\n},\n'mouseout' : {\n    fn: this.onMouseOut,\n    scope: this\n}\n});</code></pre>\n<p>\nOr a shorthand syntax:<br>\n<pre><code>myGridPanel.on({\n'click' : this.onClick,\n'mouseover' : this.onMouseOver,\n'mouseout' : this.onMouseOut,\n scope: this\n});</code></pre>\n\n</p></p></p></p></div></li></ul></div></div></div><div id='method-adjustPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-adjustPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-adjustPosition' class='name expandable'>adjustPosition</a>( <span class='pre'>x, y</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>y</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-adjustSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-adjustSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-adjustSize' class='name expandable'>adjustSize</a>( <span class='pre'>w, h</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>w</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>h</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-afterRender' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-afterRender' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-afterRender' class='name expandable'>afterRender</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Overrides: <a href='#!/api/Ext.BoxComponent-method-afterRender' rel='Ext.BoxComponent-method-afterRender' class='docClass'>Ext.BoxComponent.afterRender</a></p></div></div></div><div id='method-applyToMarkup' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-applyToMarkup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-applyToMarkup' class='name expandable'>applyToMarkup</a>( <span class='pre'>el</span> )</div><div class='description'><div class='short'>Apply this component to existing markup that is valid. ...</div><div class='long'><p>Apply this component to existing markup that is valid. With this function, no call to render() is required.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-beforeDestroy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-beforeDestroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-beforeDestroy' class='name expandable'>beforeDestroy</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-blur' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-blur' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-blur' class='name expandable'>blur</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-bubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-bubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-bubble' class='name expandable'>bubble</a>( <span class='pre'>fn, [scope], [args]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Bubbles up the component/container heirarchy, calling the specified function with each component. ...</div><div class='long'><p>Bubbles up the component/container heirarchy, calling the specified function with each component. The scope (<i>this</i>) of\nfunction call will be the scope provided or the current component. The arguments to the function\nwill be the args provided or the current component. If the function returns false at any point,\nthe bubble is stopped.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope of the function (defaults to current node)</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> (optional)<div class='sub-desc'><p>The args to call the function with (default to passing the current component)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-clearTip' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-clearTip' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-clearTip' class='name expandable'>clearTip</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-cloneConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-cloneConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-cloneConfig' class='name expandable'>cloneConfig</a>( <span class='pre'>overrides</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Clone the current component using the original config values passed into this instance by default. ...</div><div class='long'><p>Clone the current component using the original config values passed into this instance by default.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>overrides</span> : Object<div class='sub-desc'><p>A new config containing any properties to override in the cloned version.\nAn id property can be passed on this object, otherwise one will be generated to avoid duplicates.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>clone The cloned copy of this component</p>\n</div></li></ul></div></div></div><div id='method-destroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-destroy' class='name expandable'>destroy</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Destroys this component by purging any event listeners, removing the component's element from the DOM,\nremoving the c...</div><div class='long'><p>Destroys this component by purging any event listeners, removing the component's element from the DOM,\nremoving the component from its <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a> (if applicable) and unregistering it from\n<a href=\"#!/api/Ext.ComponentMgr\" rel=\"Ext.ComponentMgr\" class=\"docClass\">Ext.ComponentMgr</a>.  Destruction is generally handled automatically by the framework and this method\nshould usually not need to be called directly.</p>\n</div></div></div><div id='method-disable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-disable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-disable' class='name expandable'>disable</a>( <span class='pre'>silent</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Disable this component and fire the 'disable' event. ...</div><div class='long'><p>Disable this component and fire the 'disable' event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>silent</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-doAutoWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-doAutoWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-doAutoWidth' class='name expandable'>doAutoWidth</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-doToggle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-doToggle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-doToggle' class='name expandable'>doToggle</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-enable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-enable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-enable' class='name expandable'>enable</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Enable this component and fire the 'enable' event. ...</div><div class='long'><p>Enable this component and fire the 'enable' event.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-enableBubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-enableBubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-enableBubble' class='name expandable'>enableBubble</a>( <span class='pre'>events</span> )</div><div class='description'><div class='short'>Enables events fired by this Observable to bubble up an owner hierarchy by calling\nthis.getBubbleTarget() if present. ...</div><div class='long'><p>Enables events fired by this Observable to bubble up an owner hierarchy by calling\n<code>this.getBubbleTarget()</code> if present. There is no implementation in the Observable base class.</p>\n\n\n<p>This is commonly used by Ext.Components to bubble events to owner Containers. See Ext.Component.getBubbleTarget. The default\nimplementation in <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> returns the Component's immediate owner. But if a known target is required, this can be overridden to\naccess the required target more quickly.</p>\n\n\n<p>Example:</p>\n\n\n<pre><code><a href=\"#!/api/Ext-method-override\" rel=\"Ext-method-override\" class=\"docClass\">Ext.override</a>(<a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a>, {\n    //  Add functionality to Field&#39;s initComponent to enable the change event to bubble\n    initComponent : Ext.form.Field.prototype.initComponent.createSequence(function() {\n        this.enableBubble('change');\n    }),\n\n    //  We know that we want Field&#39;s events to bubble directly to the FormPanel.\n    getBubbleTarget : function() {\n        if (!this.formPanel) {\n            this.formPanel = this.findParentByType('form');\n        }\n        return this.formPanel;\n    }\n});\n\nvar myForm = new Ext.formPanel({\n    title: 'User Details',\n    items: [{\n        ...\n    }],\n    listeners: {\n        change: function() {\n            // Title goes red if form has been modified.\n            myForm.header.setStyle('color', 'red');\n        }\n    }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The event name to bubble, or an Array of event names.</p>\n</div></li></ul></div></div></div><div id='method-findParentBy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-findParentBy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-findParentBy' class='name expandable'>findParentBy</a>( <span class='pre'>fn</span> ) : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></div><div class='description'><div class='short'>Find a container above this component at any level by a custom function. ...</div><div class='long'><p>Find a container above this component at any level by a custom function. If the passed function returns\ntrue, the container will be returned.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The custom function to call with the arguments (container, this component).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span><div class='sub-desc'><p>The first Container for which the custom function returns true</p>\n</div></li></ul></div></div></div><div id='method-findParentByType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-findParentByType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-findParentByType' class='name expandable'>findParentByType</a>( <span class='pre'>xtype, [shallow]</span> ) : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></div><div class='description'><div class='short'>Find a container above this component at any level by xtype or class ...</div><div class='long'><p>Find a container above this component at any level by xtype or class</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xtype</span> : String/Ext.Component/Class<div class='sub-desc'><p>The xtype to check for this Component. Note that the the component can either be an instance\nor a component class:</p>\n</div></li><li><span class='pre'>shallow</span> : Boolean (optional)<div class='sub-desc'><p>False to check whether this Component is descended from the xtype (this is\nthe default), or true to check whether this Component is directly of the specified xtype.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span><div class='sub-desc'><p>The first Container which matches the given xtype or class</p>\n</div></li></ul></div></div></div><div id='method-fireEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-fireEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-fireEvent' class='name expandable'>fireEvent</a>( <span class='pre'>eventName, args</span> ) : Boolean</div><div class='description'><div class='short'>Fires the specified event with the passed parameters (minus the event name). ...</div><div class='long'><p>Fires the specified event with the passed parameters (minus the event name).</p>\n\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>)\nby calling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : Object...<div class='sub-desc'><p>Variable number of parameters are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul></div></div></div><div id='method-focus' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-focus' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-focus' class='name expandable'>focus</a>( <span class='pre'>[selectText], [delay]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Try to focus this component. ...</div><div class='long'><p>Try to focus this component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selectText</span> : Boolean (optional)<div class='sub-desc'><p>If applicable, true to also select the text in this component</p>\n</div></li><li><span class='pre'>delay</span> : Boolean/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>Delay the focus this number of milliseconds (true for 10 milliseconds)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.Component-method-focus' rel='Ext.Component-method-focus' class='docClass'>Ext.Component.focus</a></p></div></div></div><div id='method-getBox' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getBox' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getBox' class='name expandable'>getBox</a>( <span class='pre'>[local]</span> ) : Object</div><div class='description'><div class='short'>Gets the current box measurements of the component's underlying element. ...</div><div class='long'><p>Gets the current box measurements of the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>local</span> : Boolean (optional)<div class='sub-desc'><p>If true the element's left and top are returned instead of page XY (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>box An object in the format {x, y, width, height}</p>\n</div></li></ul></div></div></div><div id='method-getBubbleTarget' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getBubbleTarget' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getBubbleTarget' class='name expandable'>getBubbleTarget</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></div><div class='description'><div class='short'>Provides the link for Observable's fireEvent method to bubble up the ownership hierarchy. ...</div><div class='long'><p>Provides the link for Observable's fireEvent method to bubble up the ownership hierarchy.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span><div class='sub-desc'><p>the Container which owns this Component.</p>\n</div></li></ul></div></div></div><div id='method-getClickEl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-getClickEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-getClickEl' class='name expandable'>getClickEl</a>( <span class='pre'>e, isUp</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>isUp</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getEl' class='name expandable'>getEl</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Returns the Ext.Element which encapsulates this Component. ...</div><div class='long'><p>Returns the <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> which encapsulates this Component.</p>\n\n\n<p>This will <i>usually</i> be a &lt;DIV> element created by the class's onRender method, but\nthat may be overridden using the <a href=\"#!/api/Ext.Component-cfg-autoEl\" rel=\"Ext.Component-cfg-autoEl\" class=\"docClass\">autoEl</a> config.</p>\n\n\n<br><p><b>Note</b>: this element will not be available until this Component has been rendered.</p><br>\n\n\n<p>To add listeners for <b>DOM events</b> to this Component (as opposed to listeners\nfor this Component's own Observable events), see the <a href=\"#!/api/Ext.Component-cfg-listeners\" rel=\"Ext.Component-cfg-listeners\" class=\"docClass\">listeners</a> config for a suggestion,\nor use a render listener directly:</p>\n\n\n<pre><code>new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({\n    title: 'The Clickable Panel',\n    listeners: {\n        render: function(p) {\n            // Append the Panel to the click handler&#39;s argument list.\n            p.getEl().on('click', handlePanelClick.createDelegate(null, [p], true));\n        },\n        single: true  // Remove the listener after first invocation\n    }\n});\n</code></pre>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element which encapsulates this Component.</p>\n</div></li></ul></div></div></div><div id='method-getHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getHeight' class='name expandable'>getHeight</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the current height of the component's underlying element. ...</div><div class='long'><p>Gets the current height of the component's underlying element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getId' class='name expandable'>getId</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the id of this component or automatically generates and\nreturns an id if an id is not defined yet:\n\n'ext-comp...</div><div class='long'><p>Returns the <code>id</code> of this component or automatically generates and\nreturns an <code>id</code> if an <code>id</code> is not defined yet:</p>\n\n<pre><code>'ext-comp-' + (++<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.AUTO_ID)\n</code></pre>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>id</p>\n</div></li></ul></div></div></div><div id='method-getItemId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getItemId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getItemId' class='name expandable'>getItemId</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the itemId of this component. ...</div><div class='long'><p>Returns the <code><a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a></code> of this component.  If an\n<code><a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a></code> was not assigned through configuration the\n<code>id</code> is returned using <code><a href=\"#!/api/Ext.Component-method-getId\" rel=\"Ext.Component-method-getId\" class=\"docClass\">getId</a></code>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getMenuClass' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-getMenuClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-getMenuClass' class='name expandable'>getMenuClass</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>protected ...</div><div class='long'><p>protected</p>\n</div></div></div><div id='method-getOuterSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getOuterSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getOuterSize' class='name expandable'>getOuterSize</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Gets the current size of the component's underlying element, including space taken by its margins. ...</div><div class='long'><p>Gets the current size of the component's underlying element, including space taken by its margins.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>An object containing the element's size {width: (element width + left/right margins), height: (element height + top/bottom margins)}</p>\n</div></li></ul></div></div></div><div id='method-getPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getPosition' class='name expandable'>getPosition</a>( <span class='pre'>[local]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Gets the current XY position of the component's underlying element. ...</div><div class='long'><p>Gets the current XY position of the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>local</span> : Boolean (optional)<div class='sub-desc'><p>If true the element's left and top are returned instead of page XY (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The XY position of the element (e.g., [100, 200])</p>\n</div></li></ul></div></div></div><div id='method-getPressed' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-getPressed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-getPressed' class='name expandable'>getPressed</a>( <span class='pre'>group</span> ) : Object</div><div class='description'><div class='short'>Gets the pressed button in the passed group or null ...</div><div class='long'><p>Gets the pressed button in the passed group or null</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>group</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Button</p>\n</div></li></ul></div></div></div><div id='method-getResizeEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getResizeEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getResizeEl' class='name expandable'>getResizeEl</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Returns the outermost Element of this Component which defines the Components overall size. ...</div><div class='long'><p>Returns the outermost Element of this Component which defines the Components overall size.</p>\n\n\n<p><i>Usually</i> this will return the same Element as <code><a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">getEl</a></code>,\nbut in some cases, a Component may have some more wrapping Elements around its main\nactive Element.</p>\n\n\n<p>An example is a ComboBox. It is encased in a <i>wrapping</i> Element which\ncontains both the <code>&lt;input></code> Element (which is what would be returned\nby its <code><a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">getEl</a></code> method, <i>and</i> the trigger button Element.\nThis Element is returned as the <code>resizeEl</code>.\n\n</p><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element which is to be resized by size managing layouts.</p>\n</div></li></ul></div></div></div><div id='method-getSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getSize' class='name expandable'>getSize</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Gets the current size of the component's underlying element. ...</div><div class='long'><p>Gets the current size of the component's underlying element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>An object containing the element's size {width: (element width), height: (element height)}</p>\n</div></li></ul></div></div></div><div id='method-getTemplateArgs' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-getTemplateArgs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-getTemplateArgs' class='name expandable'>getTemplateArgs</a>( <span class='pre'></span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>This method returns an Array which provides substitution parameters for the Template used\nto create this Button's DOM...</div><div class='long'><p>This method returns an Array which provides substitution parameters for the <a href=\"#!/api/Ext.Button-property-template\" rel=\"Ext.Button-property-template\" class=\"docClass\">Template</a> used\nto create this Button's DOM structure.</p>\n\n\n<p>Instances or subclasses which use a different Template to create a different DOM structure may need to provide their\nown implementation of this method.</p>\n\n\n<p>The default implementation which provides data for the default <a href=\"#!/api/Ext.Button-property-template\" rel=\"Ext.Button-property-template\" class=\"docClass\">template</a> returns an Array containing the\nfollowing items:</p>\n\n\n<div class=\"mdetail-params\"><ul>\n<li>The &lt;button&gt;'s <a href=\"#!/api/Ext.Button-cfg-type\" rel=\"Ext.Button-cfg-type\" class=\"docClass\">type</a></li>\n<li>A CSS class name applied to the Button's main &lt;tbody&gt; element which determines the button's scale and icon alignment.</li>\n<li>A CSS class to determine the presence and position of an arrow icon. (<code>'x-btn-arrow'</code> or <code>'x-btn-arrow-bottom'</code> or <code>''</code>)</li>\n<li>The <a href=\"#!/api/Ext.Button-cfg-cls\" rel=\"Ext.Button-cfg-cls\" class=\"docClass\">cls</a> CSS class name applied to the button's wrapping &lt;table&gt; element.</li>\n<li>The Component id which is applied to the button's wrapping &lt;table&gt; element.</li>\n</ul></div>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>Substitution data for a Template.</p>\n</div></li></ul></div></div></div><div id='method-getText' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-getText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-getText' class='name expandable'>getText</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Gets the text for this Button ...</div><div class='long'><p>Gets the text for this Button</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The button text</p>\n</div></li></ul></div></div></div><div id='method-getWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getWidth' class='name expandable'>getWidth</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the current width of the component's underlying element. ...</div><div class='long'><p>Gets the current width of the component's underlying element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getXType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getXType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getXType' class='name expandable'>getXType</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Gets the xtype for this component as registered with Ext.ComponentMgr. ...</div><div class='long'><p>Gets the xtype for this component as registered with <a href=\"#!/api/Ext.ComponentMgr\" rel=\"Ext.ComponentMgr\" class=\"docClass\">Ext.ComponentMgr</a>. For a list of all\navailable xtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header. Example usage:</p>\n\n<pre><code>var t = new <a href=\"#!/api/Ext.form.TextField\" rel=\"Ext.form.TextField\" class=\"docClass\">Ext.form.TextField</a>();\nalert(t.getXType());  // alerts 'textfield'\n</code></pre>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The xtype</p>\n</div></li></ul></div></div></div><div id='method-getXTypes' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getXTypes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getXTypes' class='name expandable'>getXTypes</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns this Component's xtype hierarchy as a slash-delimited string. ...</div><div class='long'><p>Returns this Component's xtype hierarchy as a slash-delimited string. For a list of all\navailable xtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header.</p>\n\n\n<p><b>If using your own subclasses, be aware that a Component must register its own xtype\nto participate in determination of inherited xtypes.</b></p>\n\n\n<p>Example usage:</p>\n\n\n<pre><code>var t = new <a href=\"#!/api/Ext.form.TextField\" rel=\"Ext.form.TextField\" class=\"docClass\">Ext.form.TextField</a>();\nalert(t.getXTypes());  // alerts 'component/box/field/textfield'\n</code></pre>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The xtype hierarchy string</p>\n</div></li></ul></div></div></div><div id='method-hasListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-hasListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-hasListener' class='name expandable'>hasListener</a>( <span class='pre'>eventName</span> ) : Boolean</div><div class='description'><div class='short'>Checks to see if this object has any listeners for a specified event ...</div><div class='long'><p>Checks to see if this object has any listeners for a specified event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the event is being listened for, else false</p>\n</div></li></ul></div></div></div><div id='method-hasVisibleMenu' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-hasVisibleMenu' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-hasVisibleMenu' class='name expandable'>hasVisibleMenu</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the button has a menu and it is visible ...</div><div class='long'><p>Returns true if the button has a menu and it is visible</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-hide' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-hide' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-hide' class='name expandable'>hide</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Hide this component. ...</div><div class='long'><p>Hide this component.  Listen to the '<a href=\"#!/api/Ext.Component-event-beforehide\" rel=\"Ext.Component-event-beforehide\" class=\"docClass\">beforehide</a>' event and return\n<tt>false</tt> to cancel hiding the component.  Fires the '<a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a>'\nevent after hiding the component. Note this method is called internally if\nthe component is configured to be <code><a href=\"#!/api/Ext.Component-cfg-hidden\" rel=\"Ext.Component-cfg-hidden\" class=\"docClass\">hidden</a></code>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-hideMenu' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-hideMenu' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-hideMenu' class='name expandable'>hideMenu</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Hide this button's menu (if it has one) ...</div><div class='long'><p>Hide this button's menu (if it has one)</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-initButtonEl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-initButtonEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-initButtonEl' class='name expandable'>initButtonEl</a>( <span class='pre'>btn, btnEl</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>btn</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>btnEl</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initComponent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-initComponent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-initComponent' class='name expandable'>initComponent</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-initRef' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-initRef' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-initRef' class='name expandable'>initRef</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Method to establish a reference to a component. ...</div><div class='long'><p>Method to establish a reference to a component.</p>\n</div></div></div><div id='method-isMenuTriggerOut' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-isMenuTriggerOut' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-isMenuTriggerOut' class='name expandable'>isMenuTriggerOut</a>( <span class='pre'>e, internal</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>internal</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isMenuTriggerOver' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-isMenuTriggerOver' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-isMenuTriggerOver' class='name expandable'>isMenuTriggerOver</a>( <span class='pre'>e, internal</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>internal</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isVisible' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-isVisible' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-isVisible' class='name expandable'>isVisible</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this component is visible. ...</div><div class='long'><p>Returns true if this component is visible.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if this component is visible, false otherwise.</p>\n</div></li></ul></div></div></div><div id='method-isXType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-isXType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-isXType' class='name expandable'>isXType</a>( <span class='pre'>xtype, [shallow]</span> ) : Boolean</div><div class='description'><div class='short'>Tests whether or not this Component is of a specific xtype. ...</div><div class='long'><p>Tests whether or not this Component is of a specific xtype. This can test whether this Component is descended\nfrom the xtype (default) or whether it is directly of the xtype specified (shallow = true).</p>\n\n\n<p><b>If using your own subclasses, be aware that a Component must register its own xtype\nto participate in determination of inherited xtypes.</b></p>\n\n\n<p>For a list of all available xtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header.</p>\n\n\n<p>Example usage:</p>\n\n\n<pre><code>var t = new <a href=\"#!/api/Ext.form.TextField\" rel=\"Ext.form.TextField\" class=\"docClass\">Ext.form.TextField</a>();\nvar isText = t.isXType('textfield');        // true\nvar isBoxSubclass = t.isXType('box');       // true, descended from BoxComponent\nvar isBoxInstance = t.isXType('box', true); // false, not a direct BoxComponent instance\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xtype</span> : String/Ext.Component/Class<div class='sub-desc'><p>The xtype to check for this Component. Note that the the component can either be an instance\nor a component class:</p>\n\n<pre><code>var c = new <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>();\nconsole.log(c.isXType(c));\nconsole.log(c.isXType(<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>));\n</code></pre>\n\n</div></li><li><span class='pre'>shallow</span> : Boolean (optional)<div class='sub-desc'><p>False to check whether this Component is descended from the xtype (this is\nthe default), or true to check whether this Component is directly of the specified xtype.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if this component descends from the specified xtype, false otherwise.</p>\n</div></li></ul></div></div></div><div id='method-mon' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-mon' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-mon' class='name expandable'>mon</a>( <span class='pre'>item, ename, fn, scope, opt</span> )</div><div class='description'><div class='short'>Adds listeners to any Observable object (or Elements) which are automatically removed when this Component\nis destroyed. ...</div><div class='long'><p>Adds listeners to any Observable object (or Elements) which are automatically removed when this Component\nis destroyed. Usage:</p>\n\n\n<p><code></p>\n\n<pre>myGridPanel.mon(myGridPanel.getSelectionModel(), 'selectionchange', handleSelectionChange, null, {buffer: 50});\n</pre>\n\n\n<p></code></p>\n\n<p>or:</p>\n\n\n<p><code></p>\n\n<pre>myGridPanel.mon(myGridPanel.getSelectionModel(), {\n    selectionchange: handleSelectionChange,\n    buffer: 50\n});\n</pre>\n\n\n<p></code></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : Observable|Element<div class='sub-desc'><p>The item to which to add a listener/listeners.</p>\n</div></li><li><span class='pre'>ename</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The event name, or an object containing event name properties.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the handler function.</p>\n</div></li><li><span class='pre'>scope</span> : Object<div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the scope (<code>this</code> reference) in which the handler function is executed.</p>\n</div></li><li><span class='pre'>opt</span> : Object<div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> options.</p>\n</div></li></ul></div></div></div><div id='method-monitorMouseOver' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-monitorMouseOver' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-monitorMouseOver' class='name expandable'>monitorMouseOver</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-mun' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-mun' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-mun' class='name expandable'>mun</a>( <span class='pre'>item, ename, fn, scope</span> )</div><div class='description'><div class='short'>Removes listeners that were added by the mon method. ...</div><div class='long'><p>Removes listeners that were added by the <a href=\"#!/api/Ext.Component-method-mon\" rel=\"Ext.Component-method-mon\" class=\"docClass\">mon</a> method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : Observable|Element<div class='sub-desc'><p>The item from which to remove a listener/listeners.</p>\n</div></li><li><span class='pre'>ename</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The event name, or an object containing event name properties.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the handler function.</p>\n</div></li><li><span class='pre'>scope</span> : Object<div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the scope (<code>this</code> reference) in which the handler function is executed.</p>\n</div></li></ul></div></div></div><div id='method-nextSibling' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-nextSibling' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-nextSibling' class='name expandable'>nextSibling</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Returns the next component in the owning container ...</div><div class='long'><p>Returns the next component in the owning container</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></p>\n</div></li></ul></div></div></div><div id='method-on' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-on' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-on' class='name expandable'>on</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object (shorthand for addListener.) ...</div><div class='long'><p>Appends an event handler to this object (shorthand for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event to listen for</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n</div></li></ul></div></div></div><div id='method-onAdded' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-onAdded' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-onAdded' class='name expandable'>onAdded</a>( <span class='pre'>container, pos</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Method to manage awareness of when components are added to their\nrespective Container, firing an added event. ...</div><div class='long'><p>Method to manage awareness of when components are added to their\nrespective Container, firing an added event.\nReferences are established at add time rather than at render time.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>container</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'><p>Container which holds the component</p>\n</div></li><li><span class='pre'>pos</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">number</a><div class='sub-desc'><p>Position at which the component was added</p>\n</div></li></ul></div></div></div><div id='method-onBlur' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-onBlur' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-onBlur' class='name expandable'>onBlur</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onClick' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-onClick' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-onClick' class='name expandable'>onClick</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onDestroy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-onDestroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-onDestroy' class='name expandable'>onDestroy</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-onDisable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-onDisable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-onDisable' class='name expandable'>onDisable</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-onDisableChange' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-onDisableChange' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-onDisableChange' class='name expandable'>onDisableChange</a>( <span class='pre'>disabled</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>disabled</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onEnable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-onEnable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-onEnable' class='name expandable'>onEnable</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-onFocus' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-onFocus' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-onFocus' class='name expandable'>onFocus</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onMenuHide' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-onMenuHide' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-onMenuHide' class='name expandable'>onMenuHide</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onMenuShow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-onMenuShow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-onMenuShow' class='name expandable'>onMenuShow</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onMouseDown' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-onMouseDown' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-onMouseDown' class='name expandable'>onMouseDown</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onMouseOut' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-onMouseOut' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-onMouseOut' class='name expandable'>onMouseOut</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onMouseOver' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-onMouseOver' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-onMouseOver' class='name expandable'>onMouseOver</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onMouseUp' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-onMouseUp' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-onMouseUp' class='name expandable'>onMouseUp</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-onPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-onPosition' class='name expandable'>onPosition</a>( <span class='pre'>x, y</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>// protected\nCalled after the component is moved, this method is empty by default but can be implemented by any\nsubcl...</div><div class='long'><p>// protected\nCalled after the component is moved, this method is empty by default but can be implemented by any\nsubclass that needs to perform custom logic after a move occurs.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new x position</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new y position</p>\n</div></li></ul></div></div></div><div id='method-onRemoved' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-onRemoved' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-onRemoved' class='name expandable'>onRemoved</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Method to manage awareness of when components are removed from their\nrespective Container, firing an removed event. ...</div><div class='long'><p>Method to manage awareness of when components are removed from their\nrespective Container, firing an removed event. References are properly\ncleaned up after removing a component from its owning container.</p>\n</div></div></div><div id='method-onRender' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-onRender' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-onRender' class='name expandable'>onRender</a>( <span class='pre'>ct, position</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ct</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>position</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onRepeatClick' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-onRepeatClick' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-onRepeatClick' class='name expandable'>onRepeatClick</a>( <span class='pre'>repeat, e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>repeat</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onResize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-onResize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-onResize' class='name expandable'>onResize</a>( <span class='pre'>adjWidth, adjHeight, rawWidth, rawHeight</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>// protected\nCalled after the component is resized, this method is empty by default but can be implemented by any\nsub...</div><div class='long'><p>// protected\nCalled after the component is resized, this method is empty by default but can be implemented by any\nsubclass that needs to perform custom logic after a resize occurs.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>adjWidth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The box-adjusted width that was set</p>\n</div></li><li><span class='pre'>adjHeight</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The box-adjusted height that was set</p>\n</div></li><li><span class='pre'>rawWidth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The width that was originally specified</p>\n</div></li><li><span class='pre'>rawHeight</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The height that was originally specified</p>\n</div></li></ul></div></div></div><div id='method-previousSibling' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-previousSibling' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-previousSibling' class='name expandable'>previousSibling</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Returns the previous component in the owning container ...</div><div class='long'><p>Returns the previous component in the owning container</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></p>\n</div></li></ul></div></div></div><div id='method-purgeListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-purgeListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-purgeListeners' class='name expandable'>purgeListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all listeners for this object ...</div><div class='long'><p>Removes all listeners for this object</p>\n</div></div></div><div id='method-relayEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-relayEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-relayEvents' class='name expandable'>relayEvents</a>( <span class='pre'>o, events</span> )</div><div class='description'><div class='short'>Relays selected events from the specified Observable as if the events were fired by this. ...</div><div class='long'><p>Relays selected events from the specified Observable as if the events were fired by <tt><b>this</b></tt>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The Observable whose events this object is to relay.</p>\n</div></li><li><span class='pre'>events</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Array of event names to relay.</p>\n</div></li></ul></div></div></div><div id='method-removeClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-removeClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-removeClass' class='name expandable'>removeClass</a>( <span class='pre'>cls</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Removes a CSS class from the component's underlying element. ...</div><div class='long'><p>Removes a CSS class from the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cls</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>The CSS class name to remove</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler. ...</div><div class='long'><p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-render' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-render' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-render' class='name expandable'>render</a>( <span class='pre'>[container], [position]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Render this Component into the passed HTML element. ...</div><div class='long'><p>Render this Component into the passed HTML element.</p>\n\n\n<p><b>If you are using a <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Container</a> object to house this Component, then\ndo not use the render method.</b></p>\n\n\n<p>A Container's child Components are rendered by that Container's\n<a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a> manager when the Container is first rendered.</p>\n\n\n<p>Certain layout managers allow dynamic addition of child components. Those that do\ninclude <a href=\"#!/api/Ext.layout.CardLayout\" rel=\"Ext.layout.CardLayout\" class=\"docClass\">Ext.layout.CardLayout</a>, <a href=\"#!/api/Ext.layout.AnchorLayout\" rel=\"Ext.layout.AnchorLayout\" class=\"docClass\">Ext.layout.AnchorLayout</a>,\n<a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>, <a href=\"#!/api/Ext.layout.TableLayout\" rel=\"Ext.layout.TableLayout\" class=\"docClass\">Ext.layout.TableLayout</a>.</p>\n\n\n<p>If the Container is already rendered when a new child Component is added, you may need to call\nthe Container's <a href=\"#!/api/Ext.Container-method-doLayout\" rel=\"Ext.Container-method-doLayout\" class=\"docClass\">doLayout</a> to refresh the view which causes any\nunrendered child Components to be rendered. This is required so that you can add multiple\nchild components if needed while only refreshing the layout once.</p>\n\n\n<p>When creating complex UIs, it is important to remember that sizing and positioning\nof child items is the responsibility of the Container's <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a> manager.\nIf you expect child items to be sized in response to user interactions, you must\nconfigure the Container with a layout manager which creates and manages the type of layout you\nhave in mind.</p>\n\n\n<p><b>Omitting the Container's <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a> config means that a basic\nlayout manager is used which does nothing but render child components sequentially into the\nContainer. No sizing or positioning will be performed in this situation.</b></p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>container</span> : Element/HTMLElement/String (optional)<div class='sub-desc'><p>The element this Component should be\nrendered into. If it is being created from existing markup, this should be omitted.</p>\n</div></li><li><span class='pre'>position</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The element ID or DOM node index within the container <b>before</b>\nwhich this component will be inserted (defaults to appending to the end of the container)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-restoreClick' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-restoreClick' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-restoreClick' class='name expandable'>restoreClick</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-resumeEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-resumeEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-resumeEvents' class='name expandable'>resumeEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resume firing events. ...</div><div class='long'><p>Resume firing events. (see <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>)\nIf events were suspended using the <tt><b>queueSuspended</b></tt> parameter, then all\nevents fired during event suspension will be sent to any listeners now.</p>\n</div></div></div><div id='method-setAutoScroll' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setAutoScroll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setAutoScroll' class='name expandable'>setAutoScroll</a>( <span class='pre'>scroll</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the overflow on the content element of the component. ...</div><div class='long'><p>Sets the overflow on the content element of the component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>scroll</span> : Boolean<div class='sub-desc'><p>True to allow the Component to auto scroll.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setButtonClass' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-setButtonClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-setButtonClass' class='name expandable'>setButtonClass</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-setDisabled' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-setDisabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-setDisabled' class='name expandable'>setDisabled</a>( <span class='pre'>disabled</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Convenience function for setting disabled/enabled by boolean. ...</div><div class='long'><p>Convenience function for setting disabled/enabled by boolean.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>disabled</span> : Boolean<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setHandler' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-setHandler' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-setHandler' class='name expandable'>setHandler</a>( <span class='pre'>handler, [scope]</span> ) : <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Assigns this Button's click handler ...</div><div class='long'><p>Assigns this Button's click handler</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call when the button is clicked</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the handler function is executed.\nDefaults to this Button.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setHeight' class='name expandable'>setHeight</a>( <span class='pre'>height</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the height of the component. ...</div><div class='long'><p>Sets the height of the component.  This method fires the <a href=\"#!/api/Ext.BoxComponent-event-resize\" rel=\"Ext.BoxComponent-event-resize\" class=\"docClass\">resize</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>height</span> : Mixed<div class='sub-desc'><p>The new height to set. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new height in the <a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS height style.</li>\n<li><i>undefined</i> to leave the height unchanged.</li>\n</ul></div></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setIcon' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-setIcon' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-setIcon' class='name expandable'>setIcon</a>( <span class='pre'>icon</span> ) : <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the background image (inline style) of the button. ...</div><div class='long'><p>Sets the background image (inline style) of the button.  This method also changes\nthe value of the icon config internally.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>icon</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The path to an image to display in the button</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setIconClass' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-setIconClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-setIconClass' class='name expandable'>setIconClass</a>( <span class='pre'>cls</span> ) : <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the CSS class that provides a background image to use as the button's icon. ...</div><div class='long'><p>Sets the CSS class that provides a background image to use as the button's icon.  This method also changes\nthe value of the iconCls config internally.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cls</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The CSS class providing the icon image</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setPagePosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setPagePosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setPagePosition' class='name expandable'>setPagePosition</a>( <span class='pre'>x, y</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the page XY position of the component. ...</div><div class='long'><p>Sets the page XY position of the component.  To set the left and top instead, use <a href=\"#!/api/Ext.BoxComponent-method-setPosition\" rel=\"Ext.BoxComponent-method-setPosition\" class=\"docClass\">setPosition</a>.\nThis method fires the <a href=\"#!/api/Ext.BoxComponent-event-move\" rel=\"Ext.BoxComponent-event-move\" class=\"docClass\">move</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new x position</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new y position</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setPosition' class='name expandable'>setPosition</a>( <span class='pre'>left, top</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the left and top of the component. ...</div><div class='long'><p>Sets the left and top of the component.  To set the page XY position instead, use <a href=\"#!/api/Ext.BoxComponent-method-setPagePosition\" rel=\"Ext.BoxComponent-method-setPagePosition\" class=\"docClass\">setPagePosition</a>.\nThis method fires the <a href=\"#!/api/Ext.BoxComponent-event-move\" rel=\"Ext.BoxComponent-event-move\" class=\"docClass\">move</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>left</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new left</p>\n</div></li><li><span class='pre'>top</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new top</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setSize' class='name expandable'>setSize</a>( <span class='pre'>width, height</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the width and height of this BoxComponent. ...</div><div class='long'><p>Sets the width and height of this BoxComponent. This method fires the <a href=\"#!/api/Ext.BoxComponent-event-resize\" rel=\"Ext.BoxComponent-event-resize\" class=\"docClass\">resize</a> event. This method can accept\neither width and height as separate arguments, or you can pass a size object like <code>{width:10, height:20}</code>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>width</span> : Mixed<div class='sub-desc'><p>The new width to set. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new width in the <a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">Ext.Element.defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS width style.</li>\n<li>A size object in the format <code>{width: widthValue, height: heightValue}</code>.</li>\n<li><code>undefined</code> to leave the width unchanged.</li>\n</ul></div></p>\n</div></li><li><span class='pre'>height</span> : Mixed<div class='sub-desc'><p>The new height to set (not required if a size object is passed as the first arg).\nThis may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new height in the <a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">Ext.Element.defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS height style. Animation may <b>not</b> be used.</li>\n<li><code>undefined</code> to leave the height unchanged.</li>\n</ul></div></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setText' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-setText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-setText' class='name expandable'>setText</a>( <span class='pre'>text</span> ) : <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets this Button's text ...</div><div class='long'><p>Sets this Button's text</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>text</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The button text</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setTooltip' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-setTooltip' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-setTooltip' class='name expandable'>setTooltip</a>( <span class='pre'>tooltip</span> ) : <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the tooltip for this Button. ...</div><div class='long'><p>Sets the tooltip for this Button.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tooltip</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object<div class='sub-desc'><p>. This may be:<div class=\"mdesc-details\"><ul>\n<li><b>String</b> : A string to be used as innerHTML (html tags are accepted) to show in a tooltip</li>\n<li><b>Object</b> : A configuration object for <a href=\"#!/api/Ext.QuickTips-method-register\" rel=\"Ext.QuickTips-method-register\" class=\"docClass\">Ext.QuickTips.register</a>.</li>\n</ul></div></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setVisible' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-setVisible' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-setVisible' class='name expandable'>setVisible</a>( <span class='pre'>visible</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Convenience function to hide or show this component by boolean. ...</div><div class='long'><p>Convenience function to hide or show this component by boolean.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>visible</span> : Boolean<div class='sub-desc'><p>True to show, false to hide</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setWidth' class='name expandable'>setWidth</a>( <span class='pre'>width</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the width of the component. ...</div><div class='long'><p>Sets the width of the component.  This method fires the <a href=\"#!/api/Ext.BoxComponent-event-resize\" rel=\"Ext.BoxComponent-event-resize\" class=\"docClass\">resize</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>width</span> : Mixed<div class='sub-desc'><p>The new width to set. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new width in the <a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS width style.</li>\n</ul></div></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-show' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-show' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-show' class='name expandable'>show</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Show this component. ...</div><div class='long'><p>Show this component.  Listen to the '<a href=\"#!/api/Ext.Component-event-beforeshow\" rel=\"Ext.Component-event-beforeshow\" class=\"docClass\">beforeshow</a>' event and return\n<tt>false</tt> to cancel showing the component.  Fires the '<a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a>'\nevent after showing the component.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-showMenu' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-showMenu' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-showMenu' class='name expandable'>showMenu</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Show this button's menu (if it has one) ...</div><div class='long'><p>Show this button's menu (if it has one)</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-suspendEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-suspendEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-suspendEvents' class='name expandable'>suspendEvents</a>( <span class='pre'>queueSuspended</span> )</div><div class='description'><div class='short'>Suspend the firing of all events. ...</div><div class='long'><p>Suspend the firing of all events. (see <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queueSuspended</span> : Boolean<div class='sub-desc'><p>Pass as true to queue up suspended events to be fired\nafter the <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> call instead of discarding all suspended events;</p>\n</div></li></ul></div></div></div><div id='method-syncSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-syncSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-syncSize' class='name expandable'>syncSize</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Force the component's size to recalculate based on the underlying element's current height and width. ...</div><div class='long'><p>Force the component's size to recalculate based on the underlying element's current height and width.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-toggle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-method-toggle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-method-toggle' class='name expandable'>toggle</a>( <span class='pre'>[state], [supressEvent]</span> ) : <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>If a state it passed, it becomes the pressed state otherwise the current state is toggled. ...</div><div class='long'><p>If a state it passed, it becomes the pressed state otherwise the current state is toggled.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>state</span> : Boolean (optional)<div class='sub-desc'><p>Force a particular state</p>\n</div></li><li><span class='pre'>supressEvent</span> : Boolean (optional)<div class='sub-desc'><p>True to stop events being fired when calling this method.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-un' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-un' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-un' class='name expandable'>un</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler (shorthand for removeListener.) ...</div><div class='long'><p>Removes an event handler (shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeListener\" rel=\"Ext.util.Observable-method-removeListener\" class=\"docClass\">removeListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-update' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-update' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-update' class='name expandable'>update</a>( <span class='pre'>htmlOrData, loadScripts, callback</span> )</div><div class='description'><div class='short'>Update the content area of a component. ...</div><div class='long'><p>Update the content area of a component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>htmlOrData</span> : Mixed<div class='sub-desc'><p>If this component has been configured with a template via the tpl config\nthen it will use this argument as data to populate the template.\nIf this component was not configured with a template, the components\ncontent area will be updated via <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> update</p>\n</div></li><li><span class='pre'>loadScripts</span> : Boolean<div class='sub-desc'><p>(optional) Only legitimate when using the html configuration. Defaults to false</p>\n</div></li><li><span class='pre'>callback</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>(optional) Only legitimate when using the html configuration. Callback to execute when scripts have finished loading</p>\n</div></li></ul></div></div></div><div id='method-updateBox' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-updateBox' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-updateBox' class='name expandable'>updateBox</a>( <span class='pre'>box</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the current box measurements of the component's underlying element. ...</div><div class='long'><p>Sets the current box measurements of the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>box</span> : Object<div class='sub-desc'><p>An object in the format {x, y, width, height}</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-event'>Events</h3><div class='subsection'><div id='event-added' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-added' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-added' class='name expandable'>added</a>( <span class='pre'>this, ownerCt, index</span> )</div><div class='description'><div class='short'>Fires when a component is added to an Ext.Container ...</div><div class='long'><p>Fires when a component is added to an <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>ownerCt</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'><p>Container which holds the component</p>\n</div></li><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">number</a><div class='sub-desc'><p>Position at which the component was added</p>\n</div></li></ul></div></div></div><div id='event-afterrender' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-afterrender' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-afterrender' class='name expandable'>afterrender</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component rendering is finished. ...</div><div class='long'><p>Fires after the component rendering is finished.</p>\n\n\n<p>The afterrender event is fired after this Component has been <a href=\"#!/api/Ext.Component-property-rendered\" rel=\"Ext.Component-property-rendered\" class=\"docClass\">rendered</a>, been postprocesed\nby any afterRender method defined for the Component, and, if <a href=\"#!/api/Ext.Component-cfg-stateful\" rel=\"Ext.Component-cfg-stateful\" class=\"docClass\">stateful</a>, after state\nhas been restored.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-beforedestroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforedestroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforedestroy' class='name expandable'>beforedestroy</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires before the component is destroyed. ...</div><div class='long'><p>Fires before the component is <a href=\"#!/api/Ext.Component-event-destroy\" rel=\"Ext.Component-event-destroy\" class=\"docClass\">destroy</a>ed. Return false from an event handler to stop the <a href=\"#!/api/Ext.Component-event-destroy\" rel=\"Ext.Component-event-destroy\" class=\"docClass\">destroy</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-beforehide' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforehide' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforehide' class='name expandable'>beforehide</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires before the component is hidden by calling the hide method. ...</div><div class='long'><p>Fires before the component is hidden by calling the <a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a> method.\nReturn false from an event handler to stop the hide.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-beforerender' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforerender' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforerender' class='name expandable'>beforerender</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires before the component is rendered. ...</div><div class='long'><p>Fires before the component is <a href=\"#!/api/Ext.Component-property-rendered\" rel=\"Ext.Component-property-rendered\" class=\"docClass\">rendered</a>. Return false from an\nevent handler to stop the <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">render</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-beforeshow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforeshow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforeshow' class='name expandable'>beforeshow</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires before the component is shown by calling the show method. ...</div><div class='long'><p>Fires before the component is shown by calling the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method.\nReturn false from an event handler to stop the show.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-beforestaterestore' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforestaterestore' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforestaterestore' class='name expandable'>beforestaterestore</a>( <span class='pre'>this, state</span> )</div><div class='description'><div class='short'>Fires before the state of the component is restored. ...</div><div class='long'><p>Fires before the state of the component is restored. Return false from an event handler to stop the restore.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : Object<div class='sub-desc'><p>The hash of state values returned from the StateProvider. If this\nevent is not vetoed, then the state object is passed to <b><tt>applyState</tt></b>. By default,\nthat simply copies property values into this Component. The method maybe overriden to\nprovide custom state restoration.</p>\n</div></li></ul></div></div></div><div id='event-beforestatesave' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforestatesave' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforestatesave' class='name expandable'>beforestatesave</a>( <span class='pre'>this, state</span> )</div><div class='description'><div class='short'>Fires before the state of the component is saved to the configured state provider. ...</div><div class='long'><p>Fires before the state of the component is saved to the configured state provider. Return false to stop the save.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : Object<div class='sub-desc'><p>The hash of state values. This is determined by calling\n<b><tt>getState()</tt></b> on the Component. This method must be provided by the\ndeveloper to return whetever representation of state is required, by default, <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>\nhas a null implementation.</p>\n</div></li></ul></div></div></div><div id='event-click' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-event-click' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-event-click' class='name expandable'>click</a>( <span class='pre'>this, e</span> )</div><div class='description'><div class='short'>Fires when this button is clicked ...</div><div class='long'><p>Fires when this button is clicked</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Button<div class='sub-desc'>\n</div></li><li><span class='pre'>e</span> : EventObject<div class='sub-desc'><p>The click event</p>\n</div></li></ul></div></div></div><div id='event-destroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-destroy' class='name expandable'>destroy</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is destroyed. ...</div><div class='long'><p>Fires after the component is <a href=\"#!/api/Ext.Component-event-destroy\" rel=\"Ext.Component-event-destroy\" class=\"docClass\">destroy</a>ed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-disable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-disable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-disable' class='name expandable'>disable</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is disabled. ...</div><div class='long'><p>Fires after the component is disabled.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-enable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-enable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-enable' class='name expandable'>enable</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is enabled. ...</div><div class='long'><p>Fires after the component is enabled.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-hide' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-hide' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-hide' class='name expandable'>hide</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is hidden. ...</div><div class='long'><p>Fires after the component is hidden.\nFires after the component is hidden when calling the <a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a> method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-menuhide' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-event-menuhide' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-event-menuhide' class='name expandable'>menuhide</a>( <span class='pre'>this, menu</span> )</div><div class='description'><div class='short'>If this button has a menu, this event fires when it is hidden ...</div><div class='long'><p>If this button has a menu, this event fires when it is hidden</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Button<div class='sub-desc'>\n</div></li><li><span class='pre'>menu</span> : Menu<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-menushow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-event-menushow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-event-menushow' class='name expandable'>menushow</a>( <span class='pre'>this, menu</span> )</div><div class='description'><div class='short'>If this button has a menu, this event fires when it is shown ...</div><div class='long'><p>If this button has a menu, this event fires when it is shown</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Button<div class='sub-desc'>\n</div></li><li><span class='pre'>menu</span> : Menu<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-menutriggerout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-event-menutriggerout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-event-menutriggerout' class='name expandable'>menutriggerout</a>( <span class='pre'>this, menu, e</span> )</div><div class='description'><div class='short'>If this button has a menu, this event fires when the mouse leaves the menu triggering element ...</div><div class='long'><p>If this button has a menu, this event fires when the mouse leaves the menu triggering element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Button<div class='sub-desc'>\n</div></li><li><span class='pre'>menu</span> : Menu<div class='sub-desc'>\n</div></li><li><span class='pre'>e</span> : EventObject<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-menutriggerover' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-event-menutriggerover' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-event-menutriggerover' class='name expandable'>menutriggerover</a>( <span class='pre'>this, menu, e</span> )</div><div class='description'><div class='short'>If this button has a menu, this event fires when the mouse enters the menu triggering element ...</div><div class='long'><p>If this button has a menu, this event fires when the mouse enters the menu triggering element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Button<div class='sub-desc'>\n</div></li><li><span class='pre'>menu</span> : Menu<div class='sub-desc'>\n</div></li><li><span class='pre'>e</span> : EventObject<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-mouseout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-event-mouseout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-event-mouseout' class='name expandable'>mouseout</a>( <span class='pre'>this, e</span> )</div><div class='description'><div class='short'>Fires when the mouse exits the button ...</div><div class='long'><p>Fires when the mouse exits the button</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Button<div class='sub-desc'>\n</div></li><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>The event object</p>\n</div></li></ul></div></div></div><div id='event-mouseover' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-event-mouseover' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-event-mouseover' class='name expandable'>mouseover</a>( <span class='pre'>this, e</span> )</div><div class='description'><div class='short'>Fires when the mouse hovers over the button ...</div><div class='long'><p>Fires when the mouse hovers over the button</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Button<div class='sub-desc'>\n</div></li><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>The event object</p>\n</div></li></ul></div></div></div><div id='event-move' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-event-move' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-event-move' class='name expandable'>move</a>( <span class='pre'>this, x, y</span> )</div><div class='description'><div class='short'>Fires after the component is moved. ...</div><div class='long'><p>Fires after the component is moved.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new x position</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new y position</p>\n</div></li></ul></div></div></div><div id='event-removed' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-removed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-removed' class='name expandable'>removed</a>( <span class='pre'>this, ownerCt</span> )</div><div class='description'><div class='short'>Fires when a component is removed from an Ext.Container ...</div><div class='long'><p>Fires when a component is removed from an <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>ownerCt</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'><p>Container which holds the component</p>\n</div></li></ul></div></div></div><div id='event-render' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-render' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-render' class='name expandable'>render</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component markup is rendered. ...</div><div class='long'><p>Fires after the component markup is <a href=\"#!/api/Ext.Component-property-rendered\" rel=\"Ext.Component-property-rendered\" class=\"docClass\">rendered</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-resize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-event-resize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-event-resize' class='name expandable'>resize</a>( <span class='pre'>this, adjWidth, adjHeight, rawWidth, rawHeight</span> )</div><div class='description'><div class='short'>Fires after the component is resized. ...</div><div class='long'><p>Fires after the component is resized.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>adjWidth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The box-adjusted width that was set</p>\n</div></li><li><span class='pre'>adjHeight</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The box-adjusted height that was set</p>\n</div></li><li><span class='pre'>rawWidth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The width that was originally specified</p>\n</div></li><li><span class='pre'>rawHeight</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The height that was originally specified</p>\n</div></li></ul></div></div></div><div id='event-show' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-show' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-show' class='name expandable'>show</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is shown when calling the show method. ...</div><div class='long'><p>Fires after the component is shown when calling the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-staterestore' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-staterestore' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-staterestore' class='name expandable'>staterestore</a>( <span class='pre'>this, state</span> )</div><div class='description'><div class='short'>Fires after the state of the component is restored. ...</div><div class='long'><p>Fires after the state of the component is restored.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : Object<div class='sub-desc'><p>The hash of state values returned from the StateProvider. This is passed\nto <b><tt>applyState</tt></b>. By default, that simply copies property values into this\nComponent. The method maybe overriden to provide custom state restoration.</p>\n</div></li></ul></div></div></div><div id='event-statesave' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-statesave' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-statesave' class='name expandable'>statesave</a>( <span class='pre'>this, state</span> )</div><div class='description'><div class='short'>Fires after the state of the component is saved to the configured state provider. ...</div><div class='long'><p>Fires after the state of the component is saved to the configured state provider.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : Object<div class='sub-desc'><p>The hash of state values. This is determined by calling\n<b><tt>getState()</tt></b> on the Component. This method must be provided by the\ndeveloper to return whetever representation of state is required, by default, <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>\nhas a null implementation.</p>\n</div></li></ul></div></div></div><div id='event-toggle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Button'>Ext.Button</span><br/><a href='source/Button.html#Ext-Button-event-toggle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Button-event-toggle' class='name expandable'>toggle</a>( <span class='pre'>this, pressed</span> )</div><div class='description'><div class='short'>Fires when the 'pressed' state of this button changes (only if enableToggle = true) ...</div><div class='long'><p>Fires when the 'pressed' state of this button changes (only if enableToggle = true)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : Button<div class='sub-desc'>\n</div></li><li><span class='pre'>pressed</span> : Boolean<div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":["Ext.util.Observable","Ext.Component","Ext.BoxComponent"],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[],"event":[],"css_mixin":[]},"files":[{"href":"Button.html#Ext-Button","filename":"Button.js"}],"linenr":1,"members":{"property":[{"tagname":"property","owner":"Ext.BoxComponent","meta":{"private":true},"name":"boxReady","id":"property-boxReady"},{"tagname":"property","owner":"Ext.Button","meta":{},"name":"btnEl","id":"property-btnEl"},{"tagname":"property","owner":"Ext.BoxComponent","meta":{"private":true},"name":"deferHeight","id":"property-deferHeight"},{"tagname":"property","owner":"Ext.Button","meta":{},"name":"disabled","id":"property-disabled"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"el","id":"property-el"},{"tagname":"property","owner":"Ext.Button","meta":{},"name":"hidden","id":"property-hidden"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"initialConfig","id":"property-initialConfig"},{"tagname":"property","owner":"Ext.Button","meta":{},"name":"menu","id":"property-menu"},{"tagname":"property","owner":"Ext.Button","meta":{"private":true},"name":"menuClassTarget","id":"property-menuClassTarget"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"ownerCt","id":"property-ownerCt"},{"tagname":"property","owner":"Ext.Button","meta":{},"name":"pressed","id":"property-pressed"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"refOwner","id":"property-refOwner"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"rendered","id":"property-rendered"},{"tagname":"property","owner":"Ext.Button","meta":{},"name":"template","id":"property-template"}],"cfg":[{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"allowDepress","id":"cfg-allowDepress"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"allowDomMove","id":"cfg-allowDomMove"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"anchor","id":"cfg-anchor"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"applyTo","id":"cfg-applyTo"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"arrowAlign","id":"cfg-arrowAlign"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"autoHeight","id":"cfg-autoHeight"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"autoScroll","id":"cfg-autoScroll"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"autoShow","id":"cfg-autoShow"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"autoWidth","id":"cfg-autoWidth"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"boxMaxHeight","id":"cfg-boxMaxHeight"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"boxMaxWidth","id":"cfg-boxMaxWidth"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"boxMinHeight","id":"cfg-boxMinHeight"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"boxMinWidth","id":"cfg-boxMinWidth"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"bubbleEvents","id":"cfg-bubbleEvents"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"buttonSelector","id":"cfg-buttonSelector"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"clearCls","id":"cfg-clearCls"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"clickEvent","id":"cfg-clickEvent"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"cls","id":"cfg-cls"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"ctCls","id":"cfg-ctCls"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"disabled","id":"cfg-disabled"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"disabledClass","id":"cfg-disabledClass"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"enableToggle","id":"cfg-enableToggle"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"fieldLabel","id":"cfg-fieldLabel"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"flex","id":"cfg-flex"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"handleMouseEvents","id":"cfg-handleMouseEvents"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"handler","id":"cfg-handler"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"height","id":"cfg-height"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"hidden","id":"cfg-hidden"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"hideLabel","id":"cfg-hideLabel"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"hideMode","id":"cfg-hideMode"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"hideParent","id":"cfg-hideParent"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"icon","id":"cfg-icon"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"iconAlign","id":"cfg-iconAlign"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"iconCls","id":"cfg-iconCls"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"id","id":"cfg-id"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"itemCls","id":"cfg-itemCls"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"itemId","id":"cfg-itemId"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"labelSeparator","id":"cfg-labelSeparator"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"labelStyle","id":"cfg-labelStyle"},{"tagname":"cfg","owner":"Ext.util.Observable","meta":{},"name":"listeners","id":"cfg-listeners"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"margins","id":"cfg-margins"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"menu","id":"cfg-menu"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"menuAlign","id":"cfg-menuAlign"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"minWidth","id":"cfg-minWidth"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"overCls","id":"cfg-overCls"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"overflowText","id":"cfg-overflowText"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"pageX","id":"cfg-pageX"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"pageY","id":"cfg-pageY"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"plugins","id":"cfg-plugins"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"pressed","id":"cfg-pressed"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"ptype","id":"cfg-ptype"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"ref","id":"cfg-ref"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"region","id":"cfg-region"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"renderTo","id":"cfg-renderTo"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"repeat","id":"cfg-repeat"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"scale","id":"cfg-scale"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"scope","id":"cfg-scope"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"stateEvents","id":"cfg-stateEvents"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"stateId","id":"cfg-stateId"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"stateful","id":"cfg-stateful"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"style","id":"cfg-style"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"tabIndex","id":"cfg-tabIndex"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"tabTip","id":"cfg-tabTip"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"text","id":"cfg-text"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"toggleGroup","id":"cfg-toggleGroup"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"toggleHandler","id":"cfg-toggleHandler"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"tooltip","id":"cfg-tooltip"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"tooltipType","id":"cfg-tooltipType"},{"tagname":"cfg","owner":"Ext.Button","meta":{},"name":"type","id":"cfg-type"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"width","id":"cfg-width"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"x","id":"cfg-x"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"xtype","id":"cfg-xtype"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"y","id":"cfg-y"}],"css_var":[],"method":[{"tagname":"method","owner":"Ext.Button","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"addClass","id":"method-addClass"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addEvents","id":"method-addEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addListener","id":"method-addListener"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"private":true},"name":"adjustPosition","id":"method-adjustPosition"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"private":true},"name":"adjustSize","id":"method-adjustSize"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"afterRender","id":"method-afterRender"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"applyToMarkup","id":"method-applyToMarkup"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"beforeDestroy","id":"method-beforeDestroy"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"blur","id":"method-blur"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"bubble","id":"method-bubble"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"clearTip","id":"method-clearTip"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"cloneConfig","id":"method-cloneConfig"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"destroy","id":"method-destroy"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"disable","id":"method-disable"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"doAutoWidth","id":"method-doAutoWidth"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"doToggle","id":"method-doToggle"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"enable","id":"method-enable"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"enableBubble","id":"method-enableBubble"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"findParentBy","id":"method-findParentBy"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"findParentByType","id":"method-findParentByType"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"fireEvent","id":"method-fireEvent"},{"tagname":"method","owner":"Ext.Button","meta":{"chainable":true},"name":"focus","id":"method-focus"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getBox","id":"method-getBox"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getBubbleTarget","id":"method-getBubbleTarget"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"getClickEl","id":"method-getClickEl"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getEl","id":"method-getEl"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getHeight","id":"method-getHeight"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getId","id":"method-getId"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getItemId","id":"method-getItemId"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"getMenuClass","id":"method-getMenuClass"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getOuterSize","id":"method-getOuterSize"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getPosition","id":"method-getPosition"},{"tagname":"method","owner":"Ext.Button","meta":{},"name":"getPressed","id":"method-getPressed"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getResizeEl","id":"method-getResizeEl"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getSize","id":"method-getSize"},{"tagname":"method","owner":"Ext.Button","meta":{},"name":"getTemplateArgs","id":"method-getTemplateArgs"},{"tagname":"method","owner":"Ext.Button","meta":{},"name":"getText","id":"method-getText"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getWidth","id":"method-getWidth"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getXType","id":"method-getXType"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getXTypes","id":"method-getXTypes"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"hasListener","id":"method-hasListener"},{"tagname":"method","owner":"Ext.Button","meta":{},"name":"hasVisibleMenu","id":"method-hasVisibleMenu"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"hide","id":"method-hide"},{"tagname":"method","owner":"Ext.Button","meta":{"chainable":true},"name":"hideMenu","id":"method-hideMenu"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"initButtonEl","id":"method-initButtonEl"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"private":true},"name":"initComponent","id":"method-initComponent"},{"tagname":"method","owner":"Ext.Component","meta":{"private":true},"name":"initRef","id":"method-initRef"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"isMenuTriggerOut","id":"method-isMenuTriggerOut"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"isMenuTriggerOver","id":"method-isMenuTriggerOver"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"isVisible","id":"method-isVisible"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"isXType","id":"method-isXType"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"mon","id":"method-mon"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"monitorMouseOver","id":"method-monitorMouseOver"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"mun","id":"method-mun"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"nextSibling","id":"method-nextSibling"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"on","id":"method-on"},{"tagname":"method","owner":"Ext.Component","meta":{"private":true},"name":"onAdded","id":"method-onAdded"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"onBlur","id":"method-onBlur"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"onClick","id":"method-onClick"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"onDestroy","id":"method-onDestroy"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"onDisable","id":"method-onDisable"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"onDisableChange","id":"method-onDisableChange"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"onEnable","id":"method-onEnable"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"onFocus","id":"method-onFocus"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"onMenuHide","id":"method-onMenuHide"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"onMenuShow","id":"method-onMenuShow"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"onMouseDown","id":"method-onMouseDown"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"onMouseOut","id":"method-onMouseOut"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"onMouseOver","id":"method-onMouseOver"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"onMouseUp","id":"method-onMouseUp"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"private":true},"name":"onPosition","id":"method-onPosition"},{"tagname":"method","owner":"Ext.Component","meta":{"private":true},"name":"onRemoved","id":"method-onRemoved"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"onRender","id":"method-onRender"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"onRepeatClick","id":"method-onRepeatClick"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"private":true},"name":"onResize","id":"method-onResize"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"previousSibling","id":"method-previousSibling"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"purgeListeners","id":"method-purgeListeners"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"relayEvents","id":"method-relayEvents"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"removeClass","id":"method-removeClass"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"removeListener","id":"method-removeListener"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"render","id":"method-render"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"restoreClick","id":"method-restoreClick"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"resumeEvents","id":"method-resumeEvents"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setAutoScroll","id":"method-setAutoScroll"},{"tagname":"method","owner":"Ext.Button","meta":{"private":true},"name":"setButtonClass","id":"method-setButtonClass"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"setDisabled","id":"method-setDisabled"},{"tagname":"method","owner":"Ext.Button","meta":{"chainable":true},"name":"setHandler","id":"method-setHandler"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setHeight","id":"method-setHeight"},{"tagname":"method","owner":"Ext.Button","meta":{"chainable":true},"name":"setIcon","id":"method-setIcon"},{"tagname":"method","owner":"Ext.Button","meta":{"chainable":true},"name":"setIconClass","id":"method-setIconClass"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setPagePosition","id":"method-setPagePosition"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setPosition","id":"method-setPosition"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setSize","id":"method-setSize"},{"tagname":"method","owner":"Ext.Button","meta":{"chainable":true},"name":"setText","id":"method-setText"},{"tagname":"method","owner":"Ext.Button","meta":{"chainable":true},"name":"setTooltip","id":"method-setTooltip"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"setVisible","id":"method-setVisible"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setWidth","id":"method-setWidth"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"show","id":"method-show"},{"tagname":"method","owner":"Ext.Button","meta":{"chainable":true},"name":"showMenu","id":"method-showMenu"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"suspendEvents","id":"method-suspendEvents"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"syncSize","id":"method-syncSize"},{"tagname":"method","owner":"Ext.Button","meta":{"chainable":true},"name":"toggle","id":"method-toggle"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"un","id":"method-un"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"update","id":"method-update"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"updateBox","id":"method-updateBox"}],"event":[{"tagname":"event","owner":"Ext.Component","meta":{},"name":"added","id":"event-added"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"afterrender","id":"event-afterrender"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforedestroy","id":"event-beforedestroy"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforehide","id":"event-beforehide"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforerender","id":"event-beforerender"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforeshow","id":"event-beforeshow"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforestaterestore","id":"event-beforestaterestore"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforestatesave","id":"event-beforestatesave"},{"tagname":"event","owner":"Ext.Button","meta":{},"name":"click","id":"event-click"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"destroy","id":"event-destroy"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"disable","id":"event-disable"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"enable","id":"event-enable"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"hide","id":"event-hide"},{"tagname":"event","owner":"Ext.Button","meta":{},"name":"menuhide","id":"event-menuhide"},{"tagname":"event","owner":"Ext.Button","meta":{},"name":"menushow","id":"event-menushow"},{"tagname":"event","owner":"Ext.Button","meta":{},"name":"menutriggerout","id":"event-menutriggerout"},{"tagname":"event","owner":"Ext.Button","meta":{},"name":"menutriggerover","id":"event-menutriggerover"},{"tagname":"event","owner":"Ext.Button","meta":{},"name":"mouseout","id":"event-mouseout"},{"tagname":"event","owner":"Ext.Button","meta":{},"name":"mouseover","id":"event-mouseover"},{"tagname":"event","owner":"Ext.BoxComponent","meta":{},"name":"move","id":"event-move"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"removed","id":"event-removed"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"render","id":"event-render"},{"tagname":"event","owner":"Ext.BoxComponent","meta":{},"name":"resize","id":"event-resize"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"show","id":"event-show"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"staterestore","id":"event-staterestore"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"statesave","id":"event-statesave"},{"tagname":"event","owner":"Ext.Button","meta":{},"name":"toggle","id":"event-toggle"}],"css_mixin":[]},"inheritable":null,"private":null,"component":true,"name":"Ext.Button","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.Button","mixins":[],"mixedInto":[]});