/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.IceGrid.AdaptiveLoadBalancingPolicy;
import com.zeroc.IceGrid.OrderedLoadBalancingPolicy;
import com.zeroc.IceGrid.RandomLoadBalancingPolicy;
import com.zeroc.IceGrid.ReplicaGroupDescriptor;
import com.zeroc.IceGrid.RoundRobinLoadBalancingPolicy;
import com.zeroc.IceGridGUI.Application.Editable;
import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Application.ReplicaGroupEditor;
import com.zeroc.IceGridGUI.Application.ReplicaGroups;
import com.zeroc.IceGridGUI.Application.TreeNode;
import com.zeroc.IceGridGUI.Utils;
import com.zeroc.IceGridGUI.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class ReplicaGroup
extends TreeNode {
    private ReplicaGroupDescriptor _descriptor;
    private final boolean _ephemeral;
    private final Editable _editable;
    private ReplicaGroupEditor _editor;
    private static DefaultTreeCellRenderer _cellRenderer;

    public static ReplicaGroupDescriptor copyDescriptor(ReplicaGroupDescriptor d) {
        return d.clone();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _cellRenderer.setLeafIcon(Utils.getIcon("/icons/16x16/replica_group.png"));
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    @Override
    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        boolean bl = actions[13] = !this._ephemeral;
        if (((TreeNode)this._parent).getAvailableActions()[14]) {
            actions[14] = true;
        }
        actions[15] = true;
        if (!this._ephemeral) {
            actions[16] = true;
            actions[17] = true;
        }
        return actions;
    }

    @Override
    public void copy() {
        this.getCoordinator().setClipboard(ReplicaGroup.copyDescriptor(this._descriptor));
        this.getCoordinator().getActionsForMenu().get(14).setEnabled(true);
    }

    @Override
    public void paste() {
        ((TreeNode)this._parent).paste();
    }

    @Override
    public void destroy() {
        ReplicaGroups replicaGroups = (ReplicaGroups)this._parent;
        replicaGroups.removeChild(this);
        if (!this._ephemeral) {
            replicaGroups.removeDescriptor(this._descriptor);
            replicaGroups.getEditable().removeElement(this._id, this._editable, ReplicaGroup.class);
            this.getRoot().updated();
        }
    }

    @Override
    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = (ReplicaGroupEditor)this.getRoot().getEditor(ReplicaGroupEditor.class, this);
        }
        this._editor.show(this);
        return this._editor;
    }

    @Override
    protected Editor createEditor() {
        return new ReplicaGroupEditor();
    }

    @Override
    public boolean isEphemeral() {
        return this._ephemeral;
    }

    @Override
    Object getDescriptor() {
        return this._descriptor;
    }

    Object saveDescriptor() {
        return this._descriptor.clone();
    }

    void restoreDescriptor(Object savedDescriptor) {
        ReplicaGroupDescriptor clone = (ReplicaGroupDescriptor)savedDescriptor;
        this._descriptor.id = clone.id;
        this._descriptor.description = clone.description;
        this._descriptor.objects = clone.objects;
        this._descriptor.loadBalancing = clone.loadBalancing;
        this._descriptor.proxyOptions = clone.proxyOptions;
    }

    void commit() {
        this._editable.commit();
    }

    Editable getEditable() {
        return this._editable;
    }

    ReplicaGroup(boolean brandNew, TreeNode parent, ReplicaGroupDescriptor descriptor) {
        super(parent, descriptor.id);
        this._ephemeral = false;
        this._editable = new Editable(brandNew);
        this.rebuild(descriptor);
    }

    ReplicaGroup(TreeNode parent, ReplicaGroupDescriptor descriptor) {
        super(parent, descriptor.id);
        this._ephemeral = true;
        this._editable = null;
        this.rebuild(descriptor);
    }

    @Override
    void write(XMLWriter writer) throws IOException {
        if (!this._ephemeral) {
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            attributes.add(ReplicaGroup.createAttribute("id", this._descriptor.id));
            if (this._descriptor.proxyOptions.length() > 0) {
                attributes.add(ReplicaGroup.createAttribute("proxy-options", this._descriptor.proxyOptions));
            }
            if (this._descriptor.loadBalancing == null && this._descriptor.description.length() == 0 && this._descriptor.objects.isEmpty()) {
                writer.writeElement("replica-group", attributes);
            } else {
                writer.writeStartTag("replica-group", attributes);
                if (this._descriptor.description.length() > 0) {
                    writer.writeElement("description", this._descriptor.description);
                }
                assert (this._descriptor.loadBalancing != null);
                attributes.clear();
                if (this._descriptor.loadBalancing instanceof RandomLoadBalancingPolicy) {
                    attributes.add(ReplicaGroup.createAttribute("type", "random"));
                } else if (this._descriptor.loadBalancing instanceof OrderedLoadBalancingPolicy) {
                    attributes.add(ReplicaGroup.createAttribute("type", "ordered"));
                } else if (this._descriptor.loadBalancing instanceof RoundRobinLoadBalancingPolicy) {
                    attributes.add(ReplicaGroup.createAttribute("type", "round-robin"));
                } else if (this._descriptor.loadBalancing instanceof AdaptiveLoadBalancingPolicy) {
                    attributes.add(ReplicaGroup.createAttribute("type", "adaptive"));
                    AdaptiveLoadBalancingPolicy policy = (AdaptiveLoadBalancingPolicy)this._descriptor.loadBalancing;
                    attributes.add(ReplicaGroup.createAttribute("load-sample", policy.loadSample));
                }
                attributes.add(ReplicaGroup.createAttribute("n-replicas", this._descriptor.loadBalancing.nReplicas));
                writer.writeElement("load-balancing", attributes);
                ReplicaGroup.writeObjects("object", writer, this._descriptor.objects, null);
                writer.writeEndTag("replica-group");
            }
        }
    }

    void rebuild(ReplicaGroupDescriptor descriptor) {
        this._descriptor = descriptor;
    }
}

