"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decorateNavigateToItems = decorateNavigateToItems;
const utils_1 = require("../utils");
const svelte2tsx_1 = require("svelte2tsx");
function decorateNavigateToItems(ls, snapshotManager) {
    const getNavigateToItems = ls.getNavigateToItems;
    ls.getNavigateToItems = (...args) => {
        const navigationToItems = getNavigateToItems(...args);
        return navigationToItems
            .map((item) => {
            if (!(0, utils_1.isSvelteFilePath)(item.fileName)) {
                return item;
            }
            if (item.name.startsWith('__sveltets_') ||
                item.name === svelte2tsx_1.internalHelpers.renderName ||
                item.name.startsWith('$$')) {
                return;
            }
            const snapshot = snapshotManager.get(item.fileName);
            if (!snapshot || !(0, utils_1.isNoTextSpanInGeneratedCode)(snapshot.getText(), item.textSpan)) {
                return;
            }
            let textSpan = snapshot.getOriginalTextSpan(item.textSpan);
            if (!textSpan) {
                if ((0, utils_1.isGeneratedSvelteComponentName)(item.name)) {
                    textSpan = { start: 0, length: 1 };
                }
                else {
                    return;
                }
            }
            const containerName = item.containerName === svelte2tsx_1.internalHelpers.renderName || !item.containerName
                ? isInScript(textSpan.start, snapshot.getOriginalText())
                    ? 'script'
                    : ''
                : item.containerName;
            return {
                ...item,
                containerName,
                textSpan
            };
        })
            .filter(utils_1.isNotNullOrUndefined);
    };
}
function isInScript(offset, originalText) {
    const text = originalText.slice(0, offset);
    const lastScriptTag = text.lastIndexOf('<script');
    const lastCloseTag = text.lastIndexOf('</script>');
    return lastScriptTag > lastCloseTag;
}
//# sourceMappingURL=navigate-to-items.js.map