---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: GitLabプロジェクトでコミットまたはマージリクエストを取り消す方法。
title: 変更を取り消す
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

コードにはミスがつきものです。バージョン管理を使用すれば、ミスを取り消して修正できます。

コミットをリバートすると、存在する問題をプロジェクトの履歴から消去するのではなく、問題のある変更を元に戻す新しいコミット（リバートコミット）が作成されます。コミットをリバートすると、以前のコミットが存在した場所のギャップではなく、明白な監査証跡が提供されます。コミットのリバートでは、プロジェクトのアクセス制御とプロセスに従って、以下を実行します:

- 元のコミットで追加された行を削除する。
- 元のコミットで削除された行を復元する。
- 元のコミットで変更された行を以前の状態に復元する。

リバートするのはコミットだけではありません。問題のある変更が複数のコミットにまたがる場合は、コミットごとにリバートするのではなく、マージリクエストからすべての変更をリバートすることを検討してください。このアプローチにより、より明白な監査証跡が提供されます。

## マージリクエストをリバートする {#revert-a-merge-request}

マージリクエストをマージした後、マージリクエスト内のすべての変更をリバートできます。

前提要件: 

- マージリクエストの編集、リポジトリへのコードの追加を許可するプロジェクトのロールが必要です。
- プロジェクトで[マージ方法](methods/_index.md#fast-forward-merge)として**Merge Commit**（マージコミット）を使用する必要があり、これはプロジェクトの**設定** > **マージリクエスト**で設定します。

  [GitLab 16.9以降](https://gitlab.com/gitlab-org/gitlab/-/issues/22236)では、以下の場合に、GitLab UIから早送りコミットをリバートできます:

  - コミットがスカッシュされている、または
  - マージリクエストに単一のコミットが含まれている。

マージリクエスト`Example`をリバートするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択します。
1. セカンダリメニューから**マージ済み**を選択し、マージリクエストを選択します（ここでは`Example`）。
1. マージリクエストのレポート領域までスクロールし、**マージしたユーザー**の情報を示すレポートを見つけます。
1. **revert**を選択します。
1. **ブランチでRevert**で、変更をリバートするブランチを選択します。
1. マージリクエストなしですぐにリバートするには:
   1. **Start a new merge request**（新しいマージリクエストを作成）をクリアします。
   1. **revert**を選択すると、`Example`のリバートが完了します。
1. すぐにリバートせずに、新しいマージリクエストでリバートを確認するには、**Start a new merge request**（新しいマージリクエストを開始）を選択した後、以下を実行します:
   1. リバートするマージリクエストのフィールドに入力し、**マージリクエストを作成**を選択します。
   1. マージリクエストがマージされると、`Example`のリバートが完了します。

`Example`マージリクエストをリバートすると、**revert**のオプションは表示されなくなります。

## コミットをリバートする {#revert-a-commit}

リポジトリ内のコミットは、次のいずれかにリバートできます:

- 現在のブランチ。
- 新しいマージリクエスト。

前提要件: 

- プロジェクトのロールは、マージリクエストを編集し、コードをリポジトリに追加する権限を持っている必要があります。
- この場合、**revert**オプションは表示されないため、コミットがまだリバートされていない必要があります。

これを行うには、次の手順を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. コミットを含むマージリクエストがわかっている場合:
   1. **コード** > **マージリクエスト**を選択し、該当のマージリクエストを選択します。
   1. **コミット**を選択し、リバートするコミットのタイトルを選択します。これにより、マージリクエストのコンテキストにコミットが表示されます。
   1. GitLabは、**コミットを表示中`00001111`**というメッセージをセカンダリメニューの下に表示します。`00001111`はコミットのハッシュです。コミットハッシュを選択して、コミットのページを表示します。
1. コミットの元のマージリクエストが不明な場合:
   1. **コード** > **コミット**を選択します。
   1. コミットのタイトルを選択し、コミットに関する完全な情報を表示します。
1. 右上隅で、**オプション**を選択し、**revert**を選択します。
1. **ブランチでRevert**で、変更をリバートするブランチを選択します。
1. マージリクエストなしですぐにリバートするには:
   1. **Start a new merge request**（新しいマージリクエストを作成）をクリアします。
   1. **revert**を選択します。
1. すぐにリバートせずに、新しいマージリクエストでリバートを確認するには、**Start a new merge request**（新しいマージリクエストを開始）を選択した後、以下を実行します:
   1. リバートするマージリクエストのフィールドに入力し、**マージリクエストを作成**を選択します。
   1. マージリクエストがマージされると、コミットのリバートが完了します。

### マージコミットを別の親コミットにリバートする {#revert-a-merge-commit-to-a-different-parent-commit}

マージコミットをリバートすると、マージ先のブランチ（多くの場合、`main`）が常に最初の親になります。マージコミットを別の親にリバートするには、コマンドラインからコミットをリバートする必要があります。[Gitを使用した変更のリバートと取り消し](../../../topics/git/undo.md#revert-a-merge-commit-to-a-different-parent)を参照してください。

## リポジトリからテキストを削除する {#redact-text-from-repository}

{{< history >}}

- GitLab 17.1で`rewrite_history_ui`[フラグ](../../../administration/feature_flags/_index.md)とともに導入されました。デフォルトでは無効になっています。GitLabチームのメンバーは、こちらの機密情報イシューで詳細情報を確認できます: `https://gitlab.com/gitlab-org/gitlab/-/issues/450701`
- GitLab 17.2のGitLab.comの機密情報イシュー`https://gitlab.com/gitlab-org/gitlab/-/issues/462999`で有効になりました。
- GitLab 17.3のGitLab Self-ManagedおよびGitLab Dedicatedの機密情報イシュー`https://gitlab.com/gitlab-org/gitlab/-/issues/462999`で有効になりました。
- GitLab 17.9で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/472018)になりました。機能フラグ`rewrite_history_ui`は削除されました。

{{< /history >}}

誤ってコミットされた機密情報や社外秘の情報を完全に削除し、リポジトリの履歴からアクセスできないようにします。文字列のリストを`***REMOVED***`に置き換えます。

{{< alert type="warning" >}}

この操作は元に戻せません。履歴を書き換え、ハウスキーピングを実行すると、変更は永続的になります。リポジトリからテキストを削除する場合は、次の影響に注意してください:

{{< /alert >}}

- 開いたマージリクエストはマージに失敗し、手動によるリベースが必要になる場合があります。
- これは破壊的な操作です。既存のローカルクローンは、更新されたリポジトリとの互換性がないため、再度クローンする必要があります。
- 古いコミットSHAを参照するパイプラインが破損し、再設定が必要になる場合があります。
- 古いコミット履歴に基づく履歴タグとブランチが正しく機能しない場合があります。
- コミットへの署名は、書き換えプロセス中に削除されます。
- コミットハッシュは更新されます。そのコンテンツが削除操作によって更新されるためです。

GitLabの削除機能は、公開されたシークレットを削除しますが、同時に以下のことも行います:

- Gitの履歴状態を破損させます。
- すべてのデベロッパーに、削除後にリポジトリを再クローンすることを要求します。
- コミットハッシュに依存する次のような機能が破損します:
  - マージリクエストを開く。
  - 以前のコミットにリンクする。404エラーが発生します。

リポジトリの整合性を高めるために、代わりに次のことを行う必要があります:

- 公開されたシークレットを失効またはローテーションします。
- [GitLabのシークレット検出機能](../../application_security/secret_detection/_index.md)を実装します。

このアプローチは次のことを可能にします:

- 将来のシークレット漏洩を積極的に防止する。
- セキュリティコンプライアンスを確保しながら、Gitの履歴を保持する。

詳細については、[シークレットプッシュ保護](../../application_security/secret_detection/secret_push_protection/_index.md)を参照してください。

代替手段として、リポジトリから特定のファイルを完全に削除するには、[blobを削除する](../repository/repository_size.md#remove-blobs)を参照してください。

前提要件: 

- プロジェクトのオーナーロールを持っている必要があります。

リポジトリからテキストを削除するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **リポジトリ**を選択します。
1. **リポジトリの保守**を展開します。
1. **テキストを削除する**を選択します。
1. ドロワーで、削除するテキストを入力します。正規表現とglobパターンを使用できます。
1. **一致する文字列を削除します**を選択します。
1. 確認ダイアログで、プロジェクトパスを入力します。
1. **はい、一致する文字列を削除します**を選択します。
1. 左側のサイドバーで、**設定** > **一般**を選択します。
1. **高度な設定**を展開します。
1. **ハウスキーピングを実行**を選択します。操作が完了するまで、少なくとも30分待ちます。
1. 同じ**設定** > **一般** > **高度な設定**セクションで、**到達不能オブジェクトを排除する**を選択します。この操作が完了するまで約5〜10分かかります。

{{< alert type="note" >}}

機密情報を含むプロジェクトがフォークされている場合、ハウスキーピングタスクは、この削除処理を完了できなくなり、[フォークされたデータを含む特別なオブジェクトプールリポジトリの整合性が維持](../../../administration/housekeeping.md#object-pool-repositories)されなくなる可能性があります。サポートが必要な場合は、GitLabサポートにお問い合わせください。

{{< /alert >}}

## 関連トピック {#related-topics}

- [公式`git revert`ドキュメント](https://git-scm.com/docs/git-revert)
- [Gitを使用して変更を取り消す](../../../topics/git/undo.md)
- コミットAPIを使用して[コミットをリバートする](../../../api/commits.md#revert-a-commit)
- 変更履歴が[リバートされたコミットを処理する](../changelogs.md#reverted-commit-handling)方法
