---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'チュートリアル: アイデア管理用のプロジェクトをセットアップする'
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

<!-- vale gitlab_base.FutureTense = NO -->

アイデアマネジメントとは、組織またはコミュニティ内のアイデアの収集、組織化、評価、および実装を指します。アイデアは、従業員、顧客、パートナーなど、さまざまなステークホルダーから生まれる可能性があります。

個別のアイデアバックログにより、チームは潜在的な概念や提案を完全に具体化する前に、把握して優先順位を付けることができます。この個別のバックログを持つことで、rawなアイデアを効率的に管理できます。洗練されていない、または検証されていない概念でメインのバックログが煩雑になるのを防ぎます。

このチュートリアルでは、アイデアマネジメントのためにGitLabプロジェクトを設定する方法を学びます。

プロジェクトでアイデアマネジメントのためにGitLabを設定するには:

1. [プロジェクトを作成する](#create-a-project)
1. [アイデアワークフローを定義する](#define-the-idea-workflow)
1. [基準をドキュメント化する](#document-your-criteria)
1. [スコープ付きラベルを作成する](#create-scoped-labels)
1. [アイデアのステータスボードを作成する](#create-an-idea-status-board)
1. [ステークホルダーがアイデアを送信して投票する](#stakeholders-submit-and-vote-on-ideas)
1. [新しいアイデアをトリアージする](#triage-new-ideas)

## はじめる前 {#before-you-begin}

- このチュートリアルで既存のプロジェクトを使用している場合は、プロジェクトのレポーターロール以上を持っていることを確認してください。
- 以下の手順に従い、後でプロジェクトの親グループを作成することにした場合、ラベルを最大限に活用するには、プロジェクトラベルをグループラベルにプロモートする必要があります。

## プロジェクトを作成する {#create-a-project}

プロジェクトには、アイデアを追跡するために使用されるイシューが含まれています。

空のプロジェクトを作成するには: 

1. 左側のサイドバーの上部で、**新規作成**（{{< icon name="plus" >}}）を選択し、**新規プロジェクト/リポジトリ**を選択します。
1. **空のプロジェクトの作成**を選択します。
1. プロジェクトの詳細を入力します。
   - **プロジェクト名**に、`Idea management tutorial`と入力します。
1. **プロジェクトを作成**を選択します。

## アイデアのワークフローを定義する {#define-the-idea-workflow}

次に、アイデアが従う**status workflow**（ステータスワークフロー）を決定する必要があります。アイデアのステータスを伝えることは、ステークホルダーとの正しい期待値を設定するのに役立ちます。

このチュートリアルでは、次のステータスワークフローを決定したと仮定します:

- `In Review`
- `Backlog`
- `In Progress`
- `Complete`
- `Rejected`

## 基準をドキュメント化する {#document-your-criteria}

ステータスワークフローに同意したら、チームメンバーがいつでもアクセスできる場所にすべて書き留めます。

たとえば、プロジェクトの[Wiki](../../user/project/wiki/_index.md)に追加するか、[GitLab Pages](../../user/project/pages/_index.md)で公開されている会社のハンドブックに追加します。

<!-- Idea for expanding this tutorial:
     Add steps for [creating a wiki page](../../user/project/wiki/_index.md#create-a-new-wiki-page). -->

## スコープ付きラベルを作成する {#create-scoped-labels}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

次に、ステータスワークフローを表すために、アイデアに追加するラベルを作成します。

これに最適なツールは、相互に排他的な属性を設定するために使用できる[スコープ付きラベル](../../user/project/labels.md#scoped-labels)です。

[以前](#define-the-idea-workflow)に組み立てたステータスのリストを確認して、一致するスコープ付きラベルを作成します。

スコープ付きラベルの名前のダブルコロン（`::`）は、同じスコープの2つのラベルが一緒に使用されるのを防ぎます。たとえば、`status::backlog`ラベルを、すでに`status::in review`があるイシューに追加すると、前のラベルが削除されます。

{{< alert type="note" >}}

スコープ付きラベルは、PremiumおよびUltimateプランで利用できます。Freeプランを使用している場合は、代わりに通常のラベルを使用できます。ただし、それらは相互に排他的ではありません。

{{< /alert >}}

各ラベルを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**管理** > **ラベル**を選択します。
1. **新しいラベル**を選択します。
1. **タイトル**フィールドに、ラベルの名前を入力します。`status::in review`で始まる。
1. オプション。使用可能な色から選択するか、**背景色**フィールドに特定の色を表す16進数のカラー値を入力して、色を選択します。
1. **ラベルを作成**を作成を選択します。

これらの手順を繰り返して、必要なすべてのラベルを作成します:

- `status::backlog`
- `status::in progress`
- `status::complete`
- `status::rejected`

## アイデアのステータスボードを作成する {#create-an-idea-status-board}

受信アイデアに備えて、ラベルでアイデアを整理する[イシューボード](../../user/project/issue_board.md)を作成します。これを使用して、カードをさまざまなリストにドラッグすることで、イシューをすばやく作成し、ラベルを追加します。

イシューボードを設定するには:

1. 左側のサイドバーで、**検索または移動先**を選択し、**Idea management tutorial**（アイデア管理チュートリアル）プロジェクトを見つけます。
1. 左側のサイドバーで、**Plan** > **イシューボード**を選択します。
1. イシューボードページの上部左隅にあるドロップダウンリストで、現在のボード名を選択します。
1. **新しいボードを作成する**を選択します。
1. **Title field**（タイトルフィールド）に、`Idea status workflow`を入力します。
1. **オープンリストを表示する**チェックボックスを選択したまま、**クローズドリストを表示する**チェックボックスをオフにします。
1. **ボードを作成する**を選択します。空のボードが表示されるはずです。
1. `status::in review`ラベルのリストを作成します:
   1. イシューボードページの左上隅で、**Create list**（リストを作成）を選択します。
   1. 表示される列で、**値**ドロップダウンリストから、`status::in review`ラベルを選択します。
   1. **ボードに追加**を選択します。
1. ラベル`status::backlog`、`status::in progress`、`status::complete`、および`status::rejected`について、前の手順を繰り返します。

今のところ、ボード内のリストは空であるはずです。次に、それらにいくつかのイシューを入力します。

![アイデアステータスボード](img/blank_idea_board_v16_10.png)

## ステークホルダーがアイデアを送信して投票する {#stakeholders-submit-and-vote-on-ideas}

アイデア管理プロジェクトをステークホルダーと共有し、アイデアをドキュメント化するように依頼してください。

ステークホルダーを招待するには:

1. 左側のサイドバーで、**管理** > **メンバー**を選択します。
1. **メンバーを招待**を選択します。
1. ステークホルダーのメールアドレスを入力します。
1. **レポーター**ロールを選択します。

ステークホルダーは、プロジェクトにアクセスして新しいアイデアを作成できるようになりました:

1. 左側のサイドバーで、**Plan** > **イシュー**を選択します。
1. 右上にある**新規イシュー**を選択します
1. タイトルと説明を入力します。
1. **イシューの作成**を選択します。

ステークホルダーは、既存のアイデアに賛成票を投じて、アイデアに関心があることを示すこともできます:

1. 左側のサイドバーで、**Plan** > **イシュー**を選択します。
1. イシューを選択します。
1. イシューの説明の下にある**Thumbs up**（賛成） [絵文字リアクション](../../user/emoji_reactions.md)を選択します。

## 新しいアイデアをトリアージする {#triage-new-ideas}

**オープン**リストからラベルリストの1つにイシューをドラッグして、ワークフローステータスを設定してみてください。

![入力された例のイシューを含むアイデアイシューボード](img/populated_idea_board_v16_10.png)

## 次の手順 {#next-steps}

その後、次のことができるようになります:

- ステークホルダーからすべての重要な詳細を収集するために、[イシューテンプレート](../../user/project/description_templates.md)を作成します。
- [コメントとスレッド](../../user/discussions/_index.md)を使用して、アイデアに関する詳細情報を収集します。
- チームのバックログにあるイシューを、アイデアプロジェクトのイシューに[関連付け](../../user/project/issues/related_issues.md)ます。
